/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.iso;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFile;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;

public class UmdIsoVirtualFile
extends AbstractVirtualFile {
    protected final UmdIsoFile file;
    protected final boolean sectorBlockMode;
    protected final UmdIsoReader iso;

    public UmdIsoVirtualFile(UmdIsoFile file, boolean sectorBlockMode, UmdIsoReader iso) {
        super(file);
        this.file = file;
        this.sectorBlockMode = sectorBlockMode;
        this.iso = iso;
    }

    @Override
    public boolean isSectorBlockMode() {
        return this.sectorBlockMode;
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        int result;
        block5 : switch (command) {
            case 0x1010005: {
                if (inputPointer.isAddressGood() && inputLength >= 4) {
                    int offset = inputPointer.getValue32();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("ioIoctl umd file seek set %d", offset));
                    }
                    this.setPosition(offset);
                    result = 0;
                    break;
                }
                result = -2147483137;
                break;
            }
            case 0x1020001: {
                if (outputPointer.isAddressGood() && outputLength == 2048) {
                    try {
                        byte[] primaryVolumeSector = this.iso.readSector(UmdIsoReader.startSector);
                        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(outputPointer.getAddress(), outputLength, 1);
                        for (int i = 0; i < outputLength; ++i) {
                            memoryWriter.writeNext(primaryVolumeSector[i] & 0xFF);
                        }
                        memoryWriter.flush();
                        result = 0;
                    }
                    catch (IOException e) {
                        log.error((Object)"ioIoctl", (Throwable)e);
                        result = -2147352272;
                    }
                    break;
                }
                result = -2147418090;
                break;
            }
            case 0x1020002: {
                if (outputPointer.isAddressGood() && outputLength <= 2048) {
                    try {
                        byte[] primaryVolumeSector = this.iso.readSector(UmdIsoReader.startSector);
                        ByteBuffer primaryVolume = ByteBuffer.wrap(primaryVolumeSector);
                        primaryVolume.position(140);
                        int pathTableLocation = Utilities.readWord(primaryVolume);
                        byte[] pathTableSector = this.iso.readSector(pathTableLocation);
                        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(outputPointer.getAddress(), outputLength, 1);
                        for (int i = 0; i < outputLength; ++i) {
                            memoryWriter.writeNext(pathTableSector[i] & 0xFF);
                        }
                        memoryWriter.flush();
                        result = 0;
                    }
                    catch (IOException e) {
                        log.error((Object)"ioIoctl", (Throwable)e);
                        result = -2147352272;
                    }
                    break;
                }
                result = -2147418090;
                break;
            }
            case 16908291: {
                if (outputPointer.isAddressGood() && outputLength == 4) {
                    outputPointer.setValue32(2048);
                    result = 0;
                    break;
                }
                result = -2147418090;
                break;
            }
            case 16908292: {
                if (outputPointer.isAddressGood() && outputLength >= 4) {
                    try {
                        int fPointer = (int)this.file.getFilePointer();
                        outputPointer.setValue32(fPointer);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("ioIoctl umd file get file pointer %d", fPointer));
                        }
                        result = 0;
                    }
                    catch (IOException e) {
                        log.error((Object)"ioIoctl", (Throwable)e);
                        result = -2147352272;
                    }
                    break;
                }
                result = -2147483137;
                break;
            }
            case 16908294: {
                if (outputPointer.isAddressGood() && outputLength >= 4) {
                    int startSector = 0;
                    startSector = this.file.getStartSector();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("ioIoctl umd file get start sector %d", startSector));
                    }
                    outputPointer.setValue32(startSector);
                    result = 0;
                    break;
                }
                result = -2147483137;
                break;
            }
            case 16908295: {
                if (outputPointer.isAddressGood() && outputLength >= 8) {
                    long length = this.length();
                    outputPointer.setValue64(length);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("ioIoctl get file size %d", length));
                    }
                    result = 0;
                    break;
                }
                result = -2147483137;
                break;
            }
            case 16973832: {
                if (inputPointer.isAddressGood() && inputLength >= 4) {
                    int length = inputPointer.getValue32();
                    if (length > 0) {
                        if (outputPointer.isAddressGood() && outputLength >= length) {
                            try {
                                Utilities.readFully(this.file, outputPointer.getAddress(), length);
                                this.setPosition(this.getPosition() + (long)length);
                                result = length;
                            }
                            catch (IOException e) {
                                log.error((Object)"ioIoctl", (Throwable)e);
                                result = -2147352272;
                            }
                            break;
                        }
                        result = -2147483137;
                        break;
                    }
                    result = -2147483137;
                    break;
                }
                result = -2147483137;
                break;
            }
            case 32702467: {
                if (inputPointer.isAddressGood() && inputLength >= 4) {
                    int numberOfSectors = inputPointer.getValue32();
                    if (numberOfSectors > 0) {
                        if (outputPointer.isAddressGood() && outputLength >= numberOfSectors) {
                            try {
                                int length = numberOfSectors * 2048;
                                Utilities.readFully(this.file, outputPointer.getAddress(), length);
                                this.setPosition(this.getPosition() + (long)length);
                                result = length / 2048;
                            }
                            catch (IOException e) {
                                log.error((Object)"ioIoctl", (Throwable)e);
                                result = -2147352272;
                            }
                            break;
                        }
                        result = -2147418090;
                        break;
                    }
                    result = -2147418090;
                    break;
                }
                result = -2147418090;
                break;
            }
            case 32571558: {
                if (inputPointer.isAddressGood() && inputLength >= 16) {
                    long offset = inputPointer.getValue64(0);
                    int whence = inputPointer.getValue32(12);
                    if (this.isSectorBlockMode()) {
                        offset *= 2048L;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("ioIoctl UMD file seek offset %d, whence %d", offset, whence));
                    }
                    switch (whence) {
                        case 0: {
                            this.setPosition(offset);
                            result = 0;
                            break block5;
                        }
                        case 1: {
                            this.setPosition(this.getPosition() + offset);
                            result = 0;
                            break block5;
                        }
                        case 2: {
                            this.setPosition(this.length() + offset);
                            result = 0;
                            break block5;
                        }
                    }
                    log.error((Object)String.format("ioIoctl - unhandled whence %d", whence));
                    result = -2147483137;
                    break;
                }
                result = -2147483137;
                break;
            }
            default: {
                result = super.ioIoctl(command, inputPointer, inputLength, outputPointer, outputLength);
            }
        }
        return result;
    }
}

