/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelMppInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MsgPipeManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelMppInfo> msgMap;
    private MsgPipeSendWaitStateChecker msgPipeSendWaitStateChecker;
    private MsgPipeReceiveWaitStateChecker msgPipeReceiveWaitStateChecker;
    private static final int PSP_MPP_ATTR_SEND_FIFO = 0;
    private static final int PSP_MPP_ATTR_SEND_PRIORITY = 256;
    private static final int PSP_MPP_ATTR_RECEIVE_FIFO = 0;
    private static final int PSP_MPP_ATTR_RECEIVE_PRIORITY = 4096;
    private static final int PSP_MPP_ATTR_SEND = 256;
    private static final int PSP_MPP_ATTR_RECEIVE = 4096;
    private static final int PSP_MPP_ATTR_ADDR_HIGH = 16384;
    protected static final int PSP_MPP_WAIT_MODE_COMPLETE = 0;
    protected static final int PSP_MPP_WAIT_MODE_PARTIAL = 1;
    public static final MsgPipeManager singleton = new MsgPipeManager();

    public void reset() {
        this.msgMap = new HashMap();
        this.msgPipeSendWaitStateChecker = new MsgPipeSendWaitStateChecker();
        this.msgPipeReceiveWaitStateChecker = new MsgPipeReceiveWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelMppInfo info;
        if (thread.isWaitingForType(8) && (info = this.msgMap.get(thread.wait.MsgPipe_id)) != null) {
            if (thread.wait.MsgPipe_isSend) {
                --info.numSendWaitThreads;
                if (info.numSendWaitThreads < 0) {
                    log.warn((Object)("removing waiting thread " + Integer.toHexString(thread.uid) + ", MsgPipe " + Integer.toHexString(info.uid) + " numSendWaitThreads underflowed"));
                    info.numSendWaitThreads = 0;
                }
            } else {
                --info.numReceiveWaitThreads;
                if (info.numReceiveWaitThreads < 0) {
                    log.warn((Object)("removing waiting thread " + Integer.toHexString(thread.uid) + ", MsgPipe " + Integer.toHexString(info.uid) + " numReceiveWaitThreads underflowed"));
                    info.numReceiveWaitThreads = 0;
                }
            }
            return true;
        }
        return false;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352152;
        } else {
            log.warn((Object)"MsgPipe deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352150;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it!");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        this.removeWaitingThread(thread);
    }

    private void onMsgPipeDeletedCancelled(int msgpid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingForType(8) || thread.wait.MsgPipe_id != msgpid) continue;
            thread.cpuContext._v0 = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onMsgPipeDeleted(int msgpid) {
        this.onMsgPipeDeletedCancelled(msgpid, -2147352139);
    }

    private void onMsgPipeCancelled(int msgpid) {
        this.onMsgPipeDeletedCancelled(msgpid, -2147352151);
    }

    private void onMsgPipeSendModified(SceKernelMppInfo info) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        Memory mem = Memory.getInstance();
        boolean reschedule = false;
        if ((info.attr & 0x100) == 0) {
            Iterator<SceKernelThreadInfo> it = threadMan.iterator();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(8) || !thread.wait.MsgPipe_isSend || thread.wait.MsgPipe_id != info.uid || !this.trySendMsgPipe(mem, info, thread.wait.MsgPipe_address, thread.wait.MsgPipe_size, thread.wait.MsgPipe_waitMode, thread.wait.MsgPipe_resultSize_addr)) continue;
                --info.numSendWaitThreads;
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
            }
        } else if ((info.attr & 0x100) == 256) {
            Iterator<SceKernelThreadInfo> it = threadMan.iteratorByPriority();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(8) || !thread.wait.MsgPipe_isSend || thread.wait.MsgPipe_id != info.uid || !this.trySendMsgPipe(mem, info, thread.wait.MsgPipe_address, thread.wait.MsgPipe_size, thread.wait.MsgPipe_waitMode, thread.wait.MsgPipe_resultSize_addr)) continue;
                --info.numSendWaitThreads;
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
            }
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onMsgPipeReceiveModified(SceKernelMppInfo info) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        Memory mem = Memory.getInstance();
        boolean reschedule = false;
        if ((info.attr & 0x1000) == 0) {
            Iterator<SceKernelThreadInfo> it = threadMan.iterator();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(8) || thread.wait.MsgPipe_isSend || thread.wait.MsgPipe_id != info.uid || !this.tryReceiveMsgPipe(mem, info, thread.wait.MsgPipe_address, thread.wait.MsgPipe_size, thread.wait.MsgPipe_waitMode, thread.wait.MsgPipe_resultSize_addr)) continue;
                --info.numReceiveWaitThreads;
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
            }
        } else if ((info.attr & 0x1000) == 4096) {
            Iterator<SceKernelThreadInfo> it = threadMan.iteratorByPriority();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(8) || thread.wait.MsgPipe_isSend || thread.wait.MsgPipe_id != info.uid || !this.tryReceiveMsgPipe(mem, info, thread.wait.MsgPipe_address, thread.wait.MsgPipe_size, thread.wait.MsgPipe_waitMode, thread.wait.MsgPipe_resultSize_addr)) continue;
                --info.numReceiveWaitThreads;
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
            }
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private boolean trySendMsgPipe(Memory mem, SceKernelMppInfo info, int addr, int size, int waitMode, int resultSize_addr) {
        if (size > 0) {
            int availableSize = info.availableWriteSize();
            if (availableSize == 0) {
                return false;
            }
            if (size > availableSize) {
                if (waitMode == 0) {
                    return false;
                }
                size = availableSize;
            }
        }
        info.append(mem, addr, size);
        if (Memory.isAddressGood(resultSize_addr)) {
            mem.write32(resultSize_addr, size);
        }
        return true;
    }

    private boolean tryReceiveMsgPipe(Memory mem, SceKernelMppInfo info, int addr, int size, int waitMode, int resultSize_addr) {
        if (size > 0) {
            int availableSize = info.availableReadSize();
            if (availableSize == 0) {
                return false;
            }
            if (size > availableSize) {
                if (waitMode == 0) {
                    return false;
                }
                size = availableSize;
            }
        }
        if (Memory.isAddressGood(resultSize_addr)) {
            mem.write32(resultSize_addr, size);
        }
        info.consume(mem, addr, size);
        return true;
    }

    public int sceKernelCreateMsgPipe(int name_addr, int partitionid, int attr, int size, int opt_addr) {
        SceKernelMppInfo info;
        Memory mem = Processor.memory;
        String name = Utilities.readStringZ(name_addr);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCreateMsgPipe(name=" + name + ", partition=" + partitionid + ", attr=0x" + Integer.toHexString(attr) + ", size=0x" + Integer.toHexString(size) + ", opt=0x" + Integer.toHexString(opt_addr) + ")"));
        }
        if (Memory.isAddressGood(opt_addr)) {
            int optsize = mem.read32(opt_addr);
            log.warn((Object)("sceKernelCreateMsgPipe option at 0x" + Integer.toHexString(opt_addr) + " (size=" + optsize + ")"));
        }
        int memType = 0;
        if ((attr & 0x4000) == 16384) {
            memType = 1;
        }
        if ((info = SceKernelMppInfo.tryCreateMpp(name, partitionid, attr, size, memType)) == null) {
            return -2147352176;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCreateMsgPipe '" + name + "' assigned uid " + Integer.toHexString(info.uid)));
        }
        this.msgMap.put(info.uid, info);
        return info.uid;
    }

    public int sceKernelDeleteMsgPipe(int uid) {
        SceKernelMppInfo info;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelDeleteMsgPipe(uid=0x" + Integer.toHexString(uid) + ")"));
        }
        if ((info = this.msgMap.remove(uid)) == null) {
            log.warn((Object)("sceKernelDeleteMsgPipe unknown uid=0x" + Integer.toHexString(uid)));
            return -2147352162;
        }
        info.deleteSysMemInfo();
        this.onMsgPipeDeleted(uid);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int hleKernelSendMsgPipe(int uid, int msg_addr, int size, int waitMode, int resultSize_addr, int timeout_addr, boolean doCallbacks, boolean poll) {
        SceKernelMppInfo info;
        Memory mem = Processor.memory;
        if (log.isDebugEnabled()) {
            String waitType = "";
            waitType = poll ? "poll" : (timeout_addr == 0 ? "forever" : mem.read32(timeout_addr) + " ms");
            if (doCallbacks) {
                waitType = waitType + " + CB";
            }
            log.debug((Object)("hleKernelSendMsgPipe(uid=0x" + Integer.toHexString(uid) + ", msg=0x" + Integer.toHexString(msg_addr) + " ,size=0x" + Integer.toHexString(size) + " ,waitMode=0x" + Integer.toHexString(waitMode) + " ,resultSize_addr=0x" + Integer.toHexString(resultSize_addr) + " ,timeout=0x" + Integer.toHexString(timeout_addr) + ")" + " " + waitType));
        }
        if ((info = this.msgMap.get(uid)) == null) {
            log.warn((Object)("hleKernelSendMsgPipe unknown uid=0x" + Integer.toHexString(uid)));
            return -2147352162;
        }
        if (size > info.bufSize) {
            log.warn((Object)("hleKernelSendMsgPipe illegal size 0x" + Integer.toHexString(size) + " max 0x" + Integer.toHexString(info.bufSize)));
            return -2147352132;
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (!this.trySendMsgPipe(mem, info, msg_addr, size, waitMode, resultSize_addr)) {
            if (poll) {
                log.warn((Object)("hleKernelSendMsgPipe illegal size 0x" + Integer.toHexString(size) + " max 0x" + Integer.toHexString(info.freeSize) + " (pipe needs consuming)"));
                return -2147352141;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("hleKernelSendMsgPipe - '" + info.name + "' waiting for " + size + " bytes to become available"));
            }
            ++info.numSendWaitThreads;
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            currentThread.wait.MsgPipe_isSend = true;
            currentThread.wait.MsgPipe_id = uid;
            currentThread.wait.MsgPipe_address = msg_addr;
            currentThread.wait.MsgPipe_size = size;
            threadMan.hleKernelThreadEnterWaitState(8, uid, this.msgPipeSendWaitStateChecker, timeout_addr, doCallbacks);
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("hleKernelSendMsgPipe - '" + info.name + "' fast check succeeded"));
        }
        this.onMsgPipeReceiveModified(info);
        return 0;
    }

    public int sceKernelSendMsgPipe(int uid, int msg_addr, int size, int waitMode, int resultSize_addr, int timeout_addr) {
        return this.hleKernelSendMsgPipe(uid, msg_addr, size, waitMode, resultSize_addr, timeout_addr, false, false);
    }

    public int sceKernelSendMsgPipeCB(int uid, int msg_addr, int size, int waitMode, int resultSize_addr, int timeout_addr) {
        return this.hleKernelSendMsgPipe(uid, msg_addr, size, waitMode, resultSize_addr, timeout_addr, true, false);
    }

    public int sceKernelTrySendMsgPipe(int uid, int msg_addr, int size, int waitMode, int resultSize_addr) {
        return this.hleKernelSendMsgPipe(uid, msg_addr, size, waitMode, resultSize_addr, 0, false, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int hleKernelReceiveMsgPipe(int uid, int msg_addr, int size, int waitMode, int resultSize_addr, int timeout_addr, boolean doCallbacks, boolean poll) {
        SceKernelMppInfo info;
        Memory mem = Processor.memory;
        if (log.isDebugEnabled()) {
            String waitType = "";
            waitType = poll ? "poll" : (timeout_addr == 0 ? "forever" : mem.read32(timeout_addr) + " ms");
            if (doCallbacks) {
                waitType = waitType + " + CB";
            }
            log.debug((Object)("hleKernelReceiveMsgPipe(uid=0x" + Integer.toHexString(uid) + ", msg=0x" + Integer.toHexString(msg_addr) + ", size=0x" + Integer.toHexString(size) + " ,waitMode=0x" + Integer.toHexString(waitMode) + ", resultSize_addr=0x" + Integer.toHexString(resultSize_addr) + ", timeout=0x" + Integer.toHexString(timeout_addr) + ")" + " " + waitType));
        }
        if ((info = this.msgMap.get(uid)) == null) {
            log.warn((Object)("hleKernelReceiveMsgPipe unknown uid=0x" + Integer.toHexString(uid)));
            return -2147352162;
        }
        if (size > info.bufSize) {
            log.warn((Object)("hleKernelReceiveMsgPipe illegal size 0x" + Integer.toHexString(size) + " max 0x" + Integer.toHexString(info.bufSize)));
            return -2147352132;
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (!this.tryReceiveMsgPipe(mem, info, msg_addr, size, waitMode, resultSize_addr)) {
            if (poll) {
                if (!log.isDebugEnabled()) return -2147352140;
                log.debug((Object)("hleKernelReceiveMsgPipe trying to read more than is available size 0x" + Integer.toHexString(size) + " available 0x" + Integer.toHexString(info.bufSize - info.freeSize)));
                return -2147352140;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("hleKernelReceiveMsgPipe - '" + info.name + "' waiting for " + size + " bytes to become available"));
            }
            ++info.numReceiveWaitThreads;
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            currentThread.wait.MsgPipe_isSend = false;
            currentThread.wait.MsgPipe_id = uid;
            currentThread.wait.MsgPipe_address = msg_addr;
            currentThread.wait.MsgPipe_size = size;
            currentThread.wait.MsgPipe_resultSize_addr = resultSize_addr;
            threadMan.hleKernelThreadEnterWaitState(8, uid, this.msgPipeReceiveWaitStateChecker, timeout_addr, doCallbacks);
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("hleKernelReceiveMsgPipe - '" + info.name + "' fast check succeeded"));
        }
        this.onMsgPipeSendModified(info);
        return 0;
    }

    public int sceKernelReceiveMsgPipe(int uid, int msg_addr, int size, int waitMode, int resultSize_addr, int timeout_addr) {
        return this.hleKernelReceiveMsgPipe(uid, msg_addr, size, waitMode, resultSize_addr, timeout_addr, false, false);
    }

    public int sceKernelReceiveMsgPipeCB(int uid, int msg_addr, int size, int waitMode, int resultSize_addr, int timeout_addr) {
        return this.hleKernelReceiveMsgPipe(uid, msg_addr, size, waitMode, resultSize_addr, timeout_addr, true, false);
    }

    public int sceKernelTryReceiveMsgPipe(int uid, int msg_addr, int size, int waitMode, int resultSize_addr) {
        return this.hleKernelReceiveMsgPipe(uid, msg_addr, size, waitMode, resultSize_addr, 0, false, true);
    }

    public int sceKernelCancelMsgPipe(int uid, int send_addr, int recv_addr) {
        SceKernelMppInfo info;
        Memory mem = Emulator.getMemory();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCancelMsgPipe(uid=0x" + Integer.toHexString(uid) + ", send=0x" + Integer.toHexString(send_addr) + ", recv=0x" + Integer.toHexString(recv_addr) + ")"));
        }
        if ((info = this.msgMap.get(uid)) == null) {
            log.warn((Object)("sceKernelCancelMsgPipe unknown uid=0x" + Integer.toHexString(uid)));
            return -2147352162;
        }
        if (Memory.isAddressGood(send_addr)) {
            mem.write32(send_addr, info.numSendWaitThreads);
        }
        if (Memory.isAddressGood(recv_addr)) {
            mem.write32(recv_addr, info.numReceiveWaitThreads);
        }
        info.numSendWaitThreads = 0;
        info.numReceiveWaitThreads = 0;
        this.onMsgPipeCancelled(uid);
        return 0;
    }

    public int sceKernelReferMsgPipeStatus(int uid, int info_addr) {
        SceKernelMppInfo info;
        Memory mem = Processor.memory;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelReferMsgPipeStatus(uid=0x" + Integer.toHexString(uid) + ",info=0x" + Integer.toHexString(info_addr) + ")"));
        }
        if ((info = this.msgMap.get(uid)) == null) {
            log.warn((Object)("sceKernelReferMsgPipeStatus unknown uid=0x" + Integer.toHexString(uid)));
            return -2147352162;
        }
        info.write(mem, info_addr);
        return 0;
    }

    private MsgPipeManager() {
    }

    private class MsgPipeReceiveWaitStateChecker
    implements IWaitStateChecker {
        private MsgPipeReceiveWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelMppInfo info = (SceKernelMppInfo)MsgPipeManager.this.msgMap.get(wait.MsgPipe_id);
            if (info == null) {
                thread.cpuContext._v0 = -2147352162;
                return false;
            }
            Memory mem = Memory.getInstance();
            if (MsgPipeManager.this.tryReceiveMsgPipe(mem, info, wait.MsgPipe_address, wait.MsgPipe_size, wait.MsgPipe_waitMode, wait.MsgPipe_resultSize_addr)) {
                --info.numReceiveWaitThreads;
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }

    private class MsgPipeSendWaitStateChecker
    implements IWaitStateChecker {
        private MsgPipeSendWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelMppInfo info = (SceKernelMppInfo)MsgPipeManager.this.msgMap.get(wait.MsgPipe_id);
            if (info == null) {
                thread.cpuContext._v0 = -2147352162;
                return false;
            }
            Memory mem = Memory.getInstance();
            if (MsgPipeManager.this.trySendMsgPipe(mem, info, thread.wait.MsgPipe_address, thread.wait.MsgPipe_size, thread.wait.MsgPipe_waitMode, thread.wait.MsgPipe_resultSize_addr)) {
                --info.numSendWaitThreads;
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }
}

