/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelSemaInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.util.Utilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SemaManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelSemaInfo> semaMap;
    private SemaWaitStateChecker semaWaitStateChecker;
    private static final int PSP_SEMA_ATTR_FIFO = 0;
    private static final int PSP_SEMA_ATTR_PRIORITY = 256;
    public static final SemaManager singleton = new SemaManager();

    public void reset() {
        this.semaMap = new HashMap();
        this.semaWaitStateChecker = new SemaWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelSemaInfo sema = this.semaMap.get(thread.wait.Semaphore_id);
        if (sema != null) {
            --sema.numWaitThreads;
            if (sema.numWaitThreads < 0) {
                log.warn((Object)("removing waiting thread " + Integer.toHexString(thread.uid) + ", sema " + Integer.toHexString(sema.uid) + " numWaitThreads underflowed"));
                sema.numWaitThreads = 0;
            }
            return true;
        }
        return false;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352152;
        } else {
            log.warn((Object)"Sema deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352150;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it!");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(3)) {
            this.removeWaitingThread(thread);
        }
    }

    private void onSemaphoreDeletedCancelled(int semaid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingForType(3) || thread.wait.Semaphore_id != semaid) continue;
            thread.cpuContext._v0 = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onSemaphoreDeleted(int semaid) {
        this.onSemaphoreDeletedCancelled(semaid, -2147352139);
    }

    private void onSemaphoreCancelled(int semaid) {
        this.onSemaphoreDeletedCancelled(semaid, -2147352151);
    }

    private void onSemaphoreModified(SceKernelSemaInfo sema) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        if ((sema.attr & 0x100) == 0) {
            Iterator<SceKernelThreadInfo> it = threadMan.iterator();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(3) || thread.wait.Semaphore_id != sema.uid || !this.tryWaitSemaphore(sema, thread.wait.Semaphore_signal)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("onSemaphoreModified waking thread 0x" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "'"));
                }
                --sema.numWaitThreads;
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
                if (sema.currentCount != 0) continue;
                break;
            }
        } else if ((sema.attr & 0x100) == 256) {
            Iterator<SceKernelThreadInfo> it = threadMan.iteratorByPriority();
            while (it.hasNext()) {
                SceKernelThreadInfo thread = it.next();
                if (!thread.isWaitingForType(3) || thread.wait.Semaphore_id != sema.uid || !this.tryWaitSemaphore(sema, thread.wait.Semaphore_signal)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("onSemaphoreModified waking thread 0x" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "'"));
                }
                --sema.numWaitThreads;
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
                if (sema.currentCount != 0) continue;
                break;
            }
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private boolean tryWaitSemaphore(SceKernelSemaInfo sema, int signal) {
        boolean success = false;
        if (sema.currentCount >= signal) {
            sema.currentCount -= signal;
            success = true;
        }
        return success;
    }

    public SceKernelSemaInfo hleKernelCreateSema(String name, int attr, int initVal, int maxVal, int option) {
        if (Memory.isAddressGood(option)) {
            int optsize = Memory.getInstance().read32(option);
            log.warn((Object)("sceKernelCreateSema option at 0x" + Integer.toHexString(option) + " (size=" + optsize + ")"));
        }
        SceKernelSemaInfo sema = new SceKernelSemaInfo(name, attr, initVal, maxVal);
        this.semaMap.put(sema.uid, sema);
        return sema;
    }

    public int hleKernelWaitSema(SceKernelSemaInfo sema, int signal, int timeout_addr, boolean doCallbacks) {
        if (!this.tryWaitSemaphore(sema, signal)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("hleKernelWaitSema - '" + sema.name + "' fast check failed"));
            }
            ++sema.numWaitThreads;
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            currentThread.wait.Semaphore_id = sema.uid;
            currentThread.wait.Semaphore_signal = signal;
            threadMan.hleKernelThreadEnterWaitState(3, sema.uid, this.semaWaitStateChecker, timeout_addr, doCallbacks);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("hleKernelWaitSema - '" + sema.name + "' fast check succeeded"));
        }
        return 0;
    }

    private int hleKernelWaitSema(int semaid, int signal, int timeout_addr, boolean doCallbacks) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("hleKernelWaitSema(id=0x" + Integer.toHexString(semaid) + ",signal=" + signal + ",timeout=0x" + Integer.toHexString(timeout_addr) + ") callbacks=" + doCallbacks));
        }
        if (signal <= 0) {
            log.warn((Object)("hleKernelWaitSema - bad signal " + signal));
            return -2147352131;
        }
        if (!Modules.ThreadManForUserModule.isDispatchThreadEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"hleKernelWaitSema called when dispatch thread disabled");
            }
            return -2147352153;
        }
        SceUidManager.checkUidPurpose(semaid, "ThreadMan-sema", true);
        SceKernelSemaInfo sema = this.semaMap.get(semaid);
        if (sema == null) {
            if (semaid == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleKernelWaitSema - unknown uid 0x%X", semaid));
                }
            } else if (log.isEnabledFor((Priority)Level.WARN)) {
                log.warn((Object)String.format("hleKernelWaitSema - unknown uid 0x%X", semaid));
            }
            return -2147352167;
        }
        if (signal > sema.maxCount) {
            return -2147352131;
        }
        return this.hleKernelWaitSema(sema, signal, timeout_addr, doCallbacks);
    }

    public int hleKernelPollSema(SceKernelSemaInfo sema, int signal) {
        if (sema.currentCount - signal < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelPollSema id=0x%X('%s'), signal=%d", sema.uid, sema.name, signal));
            }
            return -2147352147;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelPollSema id=0x%X('%s'), signal=%d", sema.uid, sema.name, signal));
        }
        sema.currentCount -= signal;
        return 0;
    }

    public int hleKernelSignalSema(SceKernelSemaInfo sema, int signal) {
        sema.currentCount += signal;
        if (sema.currentCount > sema.maxCount) {
            sema.currentCount = sema.maxCount;
        }
        this.onSemaphoreModified(sema);
        return 0;
    }

    public int sceKernelCreateSema(int name_addr, int attr, int initVal, int maxVal, int option) {
        String name;
        if (name_addr == 0) {
            log.info((Object)"sceKernelCreateSema name address is 0! Assuming empty name");
            name = "";
        } else {
            name = Utilities.readStringNZ(name_addr, 32);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCreateSema name= " + name + " attr= 0x" + Integer.toHexString(attr) + " initVal= " + initVal + " maxVal= " + maxVal + " option= 0x" + Integer.toHexString(option)));
        }
        SceKernelSemaInfo sema = this.hleKernelCreateSema(name, attr, initVal, maxVal, option);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCreateSema name= " + name + " created with uid=0x" + Integer.toHexString(sema.uid)));
        }
        return sema.uid;
    }

    public int sceKernelDeleteSema(int semaid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelDeleteSema id=0x" + Integer.toHexString(semaid)));
        }
        SceUidManager.checkUidPurpose(semaid, "ThreadMan-sema", true);
        SceKernelSemaInfo sema = this.semaMap.remove(semaid);
        if (sema == null) {
            log.warn((Object)("sceKernelDeleteSema - unknown uid 0x" + Integer.toHexString(semaid)));
            return -2147352167;
        }
        this.onSemaphoreDeleted(semaid);
        return 0;
    }

    public int sceKernelWaitSema(int semaid, int signal, int timeout_addr) {
        return this.hleKernelWaitSema(semaid, signal, timeout_addr, false);
    }

    public int sceKernelWaitSemaCB(int semaid, int signal, int timeout_addr) {
        return this.hleKernelWaitSema(semaid, signal, timeout_addr, true);
    }

    public int sceKernelSignalSema(int semaid, int signal) {
        SceUidManager.checkUidPurpose(semaid, "ThreadMan-sema", true);
        SceKernelSemaInfo sema = this.semaMap.get(semaid);
        if (sema == null) {
            if (semaid == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceKernelSignalSema - unknown uid 0x%X", semaid));
                }
            } else if (log.isEnabledFor((Priority)Level.WARN)) {
                log.warn((Object)String.format("sceKernelSignalSema - unknown uid 0x%X", semaid));
            }
            return -2147352167;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelSignalSema id=0x" + Integer.toHexString(semaid) + " name='" + sema.name + "' signal=" + signal));
        }
        return this.hleKernelSignalSema(sema, signal);
    }

    public int sceKernelPollSema(int semaid, int signal) {
        if (signal <= 0) {
            log.warn((Object)String.format("sceKernelPollSema id=0x%X, signal=%d: bad signal", semaid, signal));
            return -2147352131;
        }
        SceUidManager.checkUidPurpose(semaid, "ThreadMan-sema", true);
        SceKernelSemaInfo sema = this.semaMap.get(semaid);
        if (sema == null) {
            log.warn((Object)String.format("sceKernelPollSema id=0x%X, signal=%d: unknown uid", semaid, signal));
            return -2147352167;
        }
        return this.hleKernelPollSema(sema, signal);
    }

    public int sceKernelCancelSema(int semaid, int newcount, int numWaitThreadAddr) {
        Memory mem = Memory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCancelSema semaid=0x" + Integer.toHexString(semaid) + " newcount=" + newcount + " numWaitThreadAddr=0x" + Integer.toHexString(numWaitThreadAddr)));
        }
        if (newcount <= 0 && newcount != -1) {
            return -2147352131;
        }
        SceUidManager.checkUidPurpose(semaid, "ThreadMan-sema", true);
        SceKernelSemaInfo sema = this.semaMap.get(semaid);
        if (sema == null) {
            log.warn((Object)("sceKernelCancelSema - unknown uid 0x" + Integer.toHexString(semaid)));
            return -2147352167;
        }
        if (Memory.isAddressGood(numWaitThreadAddr)) {
            mem.write32(numWaitThreadAddr, sema.numWaitThreads);
        }
        sema.numWaitThreads = 0;
        sema.currentCount = newcount == -1 ? sema.initCount : newcount;
        this.onSemaphoreCancelled(semaid);
        return 0;
    }

    public int sceKernelReferSemaStatus(int semaid, int addr) {
        Memory mem = Memory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelReferSemaStatus id= 0x" + Integer.toHexString(semaid) + " addr= 0x" + Integer.toHexString(addr)));
        }
        SceUidManager.checkUidPurpose(semaid, "ThreadMan-sema", true);
        SceKernelSemaInfo sema = this.semaMap.get(semaid);
        if (sema == null) {
            log.warn((Object)("sceKernelReferSemaStatus - unknown uid 0x" + Integer.toHexString(semaid)));
            return -2147352167;
        }
        sema.write(mem, addr);
        return 0;
    }

    private SemaManager() {
    }

    private class SemaWaitStateChecker
    implements IWaitStateChecker {
        private SemaWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelSemaInfo sema = (SceKernelSemaInfo)SemaManager.this.semaMap.get(wait.Semaphore_id);
            if (sema == null) {
                thread.cpuContext._v0 = -2147352167;
                return false;
            }
            if (SemaManager.this.tryWaitSemaphore(sema, wait.Semaphore_signal)) {
                --sema.numWaitThreads;
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }
}

