/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.TimeZone;
import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceMpegAu;
import jpcsp.HLE.kernel.types.SceMpegRingbuffer;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.IoFileMgrForUser;
import jpcsp.HLE.modules150.sceDisplay;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.connector.MpegCodec;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.graphics.VideoEngine;
import jpcsp.media.MediaEngine;
import jpcsp.media.PacketChannel;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Debug;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

@HLELogging
public class sceMpeg
extends HLEModule {
    public static Logger log = Modules.getLogger("sceMpeg");
    public static boolean useMpegCodec = false;
    public static boolean enableMediaEngine = false;
    public static final int PSMF_MAGIC = 1179472720;
    public static final int PSMF_VERSION_0012 = 842084400;
    public static final int PSMF_VERSION_0013 = 0x33313030;
    public static final int PSMF_VERSION_0014 = 875638832;
    public static final int PSMF_VERSION_0015 = 892416048;
    public static final int PSMF_MAGIC_OFFSET = 0;
    public static final int PSMF_STREAM_VERSION_OFFSET = 4;
    public static final int PSMF_STREAM_OFFSET_OFFSET = 8;
    public static final int PSMF_STREAM_SIZE_OFFSET = 12;
    public static final int PSMF_FIRST_TIMESTAMP_OFFSET = 86;
    public static final int PSMF_LAST_TIMESTAMP_OFFSET = 92;
    public static final int PSMF_FRAME_WIDTH_OFFSET = 142;
    public static final int PSMF_FRAME_HEIGHT_OFFSET = 143;
    protected static final int MPEG_MEMSIZE = 65536;
    public static final int atracDecodeDelay = 3000;
    public static final int avcDecodeDelay = 5400;
    public static final int mpegDecodeErrorDelay = 100;
    public static final int mpegTimestampPerSecond = 90000;
    public static final int videoTimestampStep = 3003;
    public static final int audioTimestampStep = 4180;
    public static final int audioFirstTimestamp = 90000;
    public static final int videoFirstTimestamp = 90000;
    public static final long UNKNOWN_TIMESTAMP = -1L;
    public static final int MPEG_HEADER_BUFFER_MINIMUM_SIZE = 2048;
    protected int mpegHandle;
    protected SceMpegRingbuffer mpegRingbuffer;
    protected AfterRingbufferPutCallback afterRingbufferPutCallback;
    protected TPointer mpegRingbufferAddr;
    protected int mpegStreamSize;
    protected SceMpegAu mpegAtracAu;
    protected SceMpegAu mpegAvcAu;
    protected long lastAtracSystemTime;
    protected long lastAvcSystemTime;
    protected int avcAuAddr;
    protected int atracAuAddr;
    protected boolean endOfAudioReached;
    protected boolean endOfVideoReached;
    protected long mpegLastTimestamp;
    protected long mpegFirstTimestamp;
    protected Date mpegFirstDate;
    protected Date mpegLastDate;
    protected int videoFrameCount;
    protected int audioFrameCount;
    protected int videoPixelMode;
    protected int avcDetailFrameWidth;
    protected int avcDetailFrameHeight;
    protected int defaultFrameWidth;
    protected boolean isCurrentMpegAnalyzed;
    protected byte[] completeMpegHeader;
    protected int partialMpegHeaderLength;
    protected MpegHeaderIoListener headerIoListener;
    public int maxAheadTimestamp = 40000;
    protected static final int MPEG_AVC_ES_SIZE = 2048;
    protected static final int MPEG_ATRAC_ES_SIZE = 2112;
    public static final int MPEG_ATRAC_ES_OUTPUT_SIZE = 8192;
    protected static final int MPEG_PCM_ES_SIZE = 320;
    protected static final int MPEG_PCM_ES_OUTPUT_SIZE = 320;
    protected static final int MPEG_DATA_ES_SIZE = 655360;
    protected static final int MPEG_DATA_ES_OUTPUT_SIZE = 655360;
    public static final int MPEG_VERSION_0012 = 0;
    public static final int MPEG_VERSION_0013 = 1;
    public static final int MPEG_VERSION_0014 = 2;
    public static final int MPEG_VERSION_0015 = 3;
    protected int mpegVersion;
    protected int mpegRawVersion;
    protected int mpegMagic;
    protected int mpegOffset;
    protected int mpegStreamAddr;
    public static final int MPEG_AVC_STREAM = 0;
    public static final int MPEG_ATRAC_STREAM = 1;
    public static final int MPEG_PCM_STREAM = 2;
    public static final int MPEG_DATA_STREAM = 3;
    public static final int MPEG_AUDIO_STREAM = 15;
    protected static final int MPEG_AU_MODE_DECODE = 0;
    protected static final int MPEG_AU_MODE_SKIP = 1;
    protected HashMap<Integer, Integer> atracStreamsMap;
    protected HashMap<Integer, Integer> avcStreamsMap;
    protected HashMap<Integer, Integer> pcmStreamsMap;
    protected HashMap<Integer, Integer> dataStreamsMap;
    protected boolean isAtracRegistered = false;
    protected boolean isAvcRegistered = false;
    protected boolean isPcmRegistered = false;
    protected boolean isDataRegistered = false;
    protected boolean ignoreAtrac = false;
    protected boolean ignoreAvc = false;
    protected boolean ignorePcm = false;
    protected int registeredVideoChannel = -1;
    protected int registeredAudioChannel = -1;
    protected static final int MPEG_AVC_DECODE_SUCCESS = 1;
    protected static final int MPEG_AVC_DECODE_ERROR_FATAL = -8;
    protected int avcDecodeResult;
    protected int avcFrameStatus;
    protected MpegCodec mpegCodec;
    protected MediaEngine me;
    protected PacketChannel meChannel;
    protected HashMap<Integer, byte[]> encodedVideoFramesYCbCr;
    protected byte[] audioDecodeBuffer;
    protected boolean[] allocatedEsBuffers;
    protected HashMap<Integer, StreamInfo> streamMap;
    protected static final String streamPurpose = "sceMpeg-Stream";
    private MpegRingbufferPutIoListener ringbufferPutIoListener;
    private boolean insideRingbufferPut;
    protected static final int mpegAudioChannels = 2;

    @Override
    public String getName() {
        return "sceMpeg";
    }

    @Override
    public void start() {
        this.setSettingsListener("emu.useConnector", new EnableConnectorSettingsListener());
        this.setSettingsListener("emu.useMediaEngine", new EnableMediaEngineSettingsListener());
        this.mpegHandle = 0;
        this.isCurrentMpegAnalyzed = false;
        this.mpegRingbuffer = null;
        this.mpegRingbufferAddr = null;
        this.avcAuAddr = 0;
        this.atracAuAddr = 0;
        this.atracStreamsMap = new HashMap();
        this.avcStreamsMap = new HashMap();
        this.pcmStreamsMap = new HashMap();
        this.dataStreamsMap = new HashMap();
        this.mpegAtracAu = new SceMpegAu();
        this.mpegAvcAu = new SceMpegAu();
        this.afterRingbufferPutCallback = new AfterRingbufferPutCallback();
        if (sceMpeg.isEnableConnector()) {
            this.mpegCodec = new MpegCodec();
        }
        if (sceMpeg.checkMediaEngineState()) {
            this.me = new MediaEngine();
            this.meChannel = null;
        }
        this.encodedVideoFramesYCbCr = new HashMap();
        this.audioDecodeBuffer = new byte[8192];
        this.allocatedEsBuffers = new boolean[2];
        this.streamMap = new HashMap();
        if (this.headerIoListener == null) {
            this.headerIoListener = new MpegHeaderIoListener();
            Modules.IoFileMgrForUserModule.registerIoListener(this.headerIoListener);
        }
        super.start();
    }

    @Override
    public void stop() {
        Modules.IoFileMgrForUserModule.unregisterIoListener(this.headerIoListener);
        this.headerIoListener = null;
        super.stop();
    }

    protected void hleMpegRingbufferPostPut() {
        CpuState cpu = Emulator.getProcessor().cpu;
        int packetsAdded = cpu._v0;
        this.mpegRingbuffer.read(this.mpegRingbufferAddr);
        if (packetsAdded > 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("hleMpegRingbufferPostPut:%s", Utilities.getMemoryDump(this.mpegRingbuffer.data, packetsAdded * this.mpegRingbuffer.packetSize, 4, 16)));
            }
            int addr = this.mpegRingbuffer.data;
            int length = packetsAdded * this.mpegRingbuffer.packetSize;
            this.hleAddVideoData(addr, length);
            if (packetsAdded > this.mpegRingbuffer.packetsFree) {
                log.warn((Object)String.format("sceMpegRingbufferPut clamping packetsAdded old=%d, new=%d", packetsAdded, this.mpegRingbuffer.packetsFree));
                packetsAdded = this.mpegRingbuffer.packetsFree;
            }
            this.mpegRingbuffer.packetsRead += packetsAdded;
            this.mpegRingbuffer.packetsWritten += packetsAdded;
            this.mpegRingbuffer.packetsFree -= packetsAdded;
            this.mpegRingbuffer.write(this.mpegRingbufferAddr);
        }
        this.insideRingbufferPut = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegRingbufferPut packetsAdded=%d, packetsRead=%d", packetsAdded, this.mpegRingbuffer.packetsRead));
        }
        cpu._v0 = packetsAdded;
    }

    public void hleAddVideoData(int addr, int length) {
        if (length > 0) {
            if (sceMpeg.checkMediaEngineState()) {
                if (this.meChannel == null) {
                    this.me.init(addr, Math.max(length, this.mpegStreamSize), 0);
                    this.meChannel = new PacketChannel();
                }
                this.meChannel.write(addr, length);
            } else if (sceMpeg.isEnableConnector()) {
                this.mpegCodec.writeVideo(addr, length);
            }
        }
    }

    public void hleSetTotalStreamSize(int totalStreamSize) {
        if (this.meChannel != null) {
            this.meChannel.setTotalStreamSize(totalStreamSize);
        }
    }

    public void hleSetChannelBufferLength(int bufferLength) {
        if (this.meChannel != null) {
            this.meChannel.setBufferLength(bufferLength);
        }
    }

    public void hleSetFirstTimestamp(int firstTimestamp) {
        if (sceMpeg.checkMediaEngineState() && this.me != null) {
            this.me.setFirstTimestamp(firstTimestamp);
        }
    }

    public void hleCreateRingbuffer() {
        if (this.mpegRingbuffer == null) {
            this.mpegRingbuffer = new SceMpegRingbuffer(0, 0, 0, 0, 0);
            this.mpegRingbuffer.packetsRead = 1;
            this.mpegRingbufferAddr = null;
        }
    }

    public int getRegisteredAudioChannel() {
        if (this.registeredAudioChannel >= 0) {
            return this.registeredAudioChannel;
        }
        int audioChannel = -1;
        for (Integer streamNumber : this.atracStreamsMap.values()) {
            if (audioChannel >= 0 && streamNumber >= audioChannel) continue;
            audioChannel = streamNumber;
        }
        return audioChannel;
    }

    public int getRegisteredVideoChannel() {
        if (this.registeredVideoChannel >= 0) {
            return this.registeredVideoChannel;
        }
        int videoChannel = -1;
        for (Integer streamNumber : this.avcStreamsMap.values()) {
            if (videoChannel >= 0 && streamNumber >= videoChannel) continue;
            videoChannel = streamNumber;
        }
        return videoChannel;
    }

    public void setRegisteredVideoChannel(int registeredVideoChannel) {
        if (this.registeredVideoChannel != registeredVideoChannel) {
            this.registeredVideoChannel = registeredVideoChannel;
            if (sceMpeg.checkMediaEngineState()) {
                this.me.changeVideoChannel(registeredVideoChannel);
            }
        }
    }

    public void setRegisteredAudioChannel(int registeredAudioChannel) {
        this.registeredAudioChannel = registeredAudioChannel;
    }

    public int hleMpegGetAvcAu(TPointer auAddr, int firstTimestamp, int noMoreDataError) {
        int result = 0;
        if (sceMpeg.checkMediaEngineState()) {
            Emulator.getClock().pause();
            this.me.setFirstTimestamp(firstTimestamp);
            if (this.me.getContainer() == null) {
                this.me.init(this.meChannel, true, true, this.getRegisteredVideoChannel(), this.getRegisteredAudioChannel());
            }
            if (!this.me.readVideoAu(this.mpegAvcAu, 2)) {
                if (this.mpegLastTimestamp <= 0L || this.mpegAvcAu.pts >= this.mpegLastTimestamp) {
                    this.endOfVideoReached = true;
                }
                if (this.mpegAvcAu.pts != this.mpegLastTimestamp) {
                    result = noMoreDataError;
                }
            } else {
                this.endOfVideoReached = false;
            }
            Emulator.getClock().resume();
        } else if (sceMpeg.isEnableConnector()) {
            if (!this.mpegCodec.readVideoAu(this.mpegAvcAu, this.videoFrameCount)) {
                this.mpegAvcAu.pts += 3003L;
            }
            this.updateAvcDts();
        }
        this.mpegAvcAu.write(auAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleMpegGetAvcAu returning 0x%08X, AvcAu=%s", result, this.mpegAvcAu.toString()));
        }
        if (result != 0) {
            sceMpeg.delayThread(100);
        }
        return result;
    }

    public int hleMpegGetAtracAu(TPointer auAddr, int firstTimestamp) {
        int result = 0;
        if (sceMpeg.checkMediaEngineState()) {
            Emulator.getClock().pause();
            this.me.setFirstTimestamp(firstTimestamp);
            if (this.me.getContainer() == null) {
                this.me.init(this.meChannel, true, true, this.getRegisteredVideoChannel(), this.getRegisteredAudioChannel());
            }
            this.endOfAudioReached = !this.me.readAudioAu(this.mpegAtracAu, 2);
            Emulator.getClock().resume();
        } else if (!sceMpeg.isEnableConnector() || this.mpegCodec.readAudioAu(this.mpegAtracAu, this.audioFrameCount)) {
            // empty if block
        }
        this.mpegAtracAu.write(auAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleMpegGetAtracAu returning 0x%08X, AtracAu=%s", result, this.mpegAtracAu.toString()));
        }
        if (result != 0) {
            sceMpeg.delayThread(100);
        }
        return result;
    }

    public int hleMpegAtracDecode(TPointer bufferAddr, int bufferSize) {
        long startTime = Emulator.getClock().microTime();
        if (sceMpeg.checkMediaEngineState()) {
            Emulator.getClock().pause();
            int bytes = 0;
            if (this.me.stepAudio(bufferSize, 2)) {
                bytes = this.me.getCurrentAudioSamples(this.audioDecodeBuffer);
                Memory.getInstance().copyToMemory(bufferAddr.getAddress(), ByteBuffer.wrap(this.audioDecodeBuffer, 0, bytes), bytes);
            }
            bufferAddr.clear(bytes, bufferSize - bytes);
            Emulator.getClock().resume();
        } else if (sceMpeg.isEnableConnector() && this.mpegCodec.readAudioFrame(bufferAddr.getAddress(), this.audioFrameCount)) {
            this.mpegAtracAu.pts = this.mpegCodec.getMpegAtracCurrentTimestamp();
        } else {
            bufferAddr.clear(bufferSize);
        }
        sceMpeg.delayThread(startTime, 3000);
        return 0;
    }

    public static boolean isEnableConnector() {
        return useMpegCodec;
    }

    private static void setEnableConnector(boolean useConnector) {
        useMpegCodec = useConnector;
        if (useConnector) {
            log.info((Object)"Using JPCSP connector");
        }
    }

    public static boolean checkMediaEngineState() {
        return enableMediaEngine;
    }

    private static void setEnableMediaEngine(boolean enableMediaEngine) {
        sceMpeg.enableMediaEngine = enableMediaEngine;
        if (enableMediaEngine) {
            log.info((Object)"Media Engine enabled");
        }
    }

    protected Date convertTimestampToDate(long timestamp) {
        long millis = timestamp / 90L;
        return new Date(millis);
    }

    protected StreamInfo getStreamInfo(int uid) {
        return this.streamMap.get(uid);
    }

    protected int getMpegHandle(int mpegAddr) {
        if (Memory.isAddressGood(mpegAddr)) {
            return Processor.memory.read32(mpegAddr);
        }
        return -1;
    }

    public int checkMpegHandle(int mpeg) {
        if (this.getMpegHandle(mpeg) != this.mpegHandle) {
            log.warn((Object)String.format("checkMpegHandler bad mpeg handle 0x%08X", mpeg));
            throw new SceKernelErrorException(-1);
        }
        return mpeg;
    }

    protected void writeTimestamp(Memory mem, int address, long ts) {
        mem.write32(address, (int)(ts >> 32 & 1L));
        mem.write32(address + 4, (int)ts);
    }

    protected boolean isCurrentMpegAnalyzed() {
        return this.isCurrentMpegAnalyzed;
    }

    public void setCurrentMpegAnalyzed(boolean status) {
        this.isCurrentMpegAnalyzed = status;
    }

    private void unregisterRingbufferPutIoListener() {
        if (this.ringbufferPutIoListener != null) {
            Modules.IoFileMgrForUserModule.unregisterIoListener(this.ringbufferPutIoListener);
            this.ringbufferPutIoListener = null;
        }
    }

    private static boolean isMpegData(int startCode) {
        return startCode == 442;
    }

    private static boolean isMpegData(Memory mem, int addr) {
        int startCode = Utilities.endianSwap32(mem.read32(addr));
        return sceMpeg.isMpegData(startCode);
    }

    private static int getByte(byte[] data, int offset) {
        return data[offset] & 0xFF;
    }

    private static int getStartCode(byte[] data, int offset) {
        return sceMpeg.getByte(data, offset) << 24 | sceMpeg.getByte(data, offset + 1) << 16 | sceMpeg.getByte(data, offset + 2) << 8 | sceMpeg.getByte(data, offset + 3);
    }

    private static boolean isMpegData(byte[] data) {
        int startCode = sceMpeg.getStartCode(data, 0);
        return sceMpeg.isMpegData(startCode);
    }

    private static long getPackTimestamp(byte[] data, int offset) {
        int b;
        long timestamp = 0L;
        offset += 4;
        if (((b = sceMpeg.getByte(data, offset++)) & 0xC0) == 64) {
            timestamp = (long)(b >> 3 & 7) << 30;
            timestamp |= (long)((b & 3) << 28);
            b = sceMpeg.getByte(data, offset++);
            timestamp |= (long)(b << 20);
            b = sceMpeg.getByte(data, offset++);
            timestamp |= (long)(b >> 3 << 15);
            timestamp |= (long)((b & 3) << 13);
            b = sceMpeg.getByte(data, offset++);
            timestamp |= (long)(b << 5);
            b = sceMpeg.getByte(data, offset++);
            timestamp |= (long)(b >> 3);
        } else if ((b & 0xF0) == 2) {
            timestamp = (long)(b >> 1 & 7) << 30;
            b = sceMpeg.getByte(data, offset++);
            timestamp |= (long)(b << 22);
            b = sceMpeg.getByte(data, offset++);
            timestamp |= (long)(b >> 1 << 15);
            b = sceMpeg.getByte(data, offset++);
            timestamp |= (long)(b << 7);
            b = sceMpeg.getByte(data, offset++);
            timestamp |= (long)(b >> 1);
        }
        return timestamp;
    }

    protected void onRingbufferPutIoRead(SeekableDataInput dataInput, IVirtualFile vFile, int readAddress, int bytesRead) {
        if (!this.isCurrentMpegAnalyzed() && this.insideRingbufferPut) {
            Memory mem;
            block30: {
                mem = Memory.getInstance();
                if (vFile != null) {
                    long currentPosition = vFile.getPosition();
                    if (currentPosition - (long)bytesRead >= 2048L) {
                        vFile.ioLseek(currentPosition - (long)bytesRead - 2048L);
                        byte[] header = new byte[2048];
                        if (vFile.ioRead(header, 0, 2048) == 2048) {
                            int tmpAddress = this.mpegRingbuffer.dataUpperBound - header.length;
                            IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(tmpAddress, header.length, 1);
                            for (int i = 0; i < header.length; ++i) {
                                memoryWriter.writeNext(header[i] & 0xFF);
                            }
                            memoryWriter.flush();
                            if (mem.read32(tmpAddress + 0) == 1179472720) {
                                this.analyseMpeg(tmpAddress);
                            }
                            if (this.isCurrentMpegAnalyzed()) {
                                this.unregisterRingbufferPutIoListener();
                            }
                        }
                        vFile.ioLseek(currentPosition);
                    }
                } else if (dataInput instanceof UmdIsoFile) {
                    UmdIsoFile umdIsoFile = (UmdIsoFile)dataInput;
                    int headerSectorNumber = umdIsoFile.getCurrentSectorNumber();
                    headerSectorNumber -= bytesRead / 2048;
                    --headerSectorNumber;
                    UmdIsoReader umdIsoReader = Modules.IoFileMgrForUserModule.getIsoReader();
                    if (umdIsoReader != null) {
                        try {
                            byte[] headerSector = umdIsoReader.readSector(headerSectorNumber);
                            int tmpAddress = this.mpegRingbuffer.dataUpperBound - headerSector.length;
                            IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(tmpAddress, headerSector.length, 1);
                            for (int i = 0; i < headerSector.length; ++i) {
                                memoryWriter.writeNext(headerSector[i] & 0xFF);
                            }
                            memoryWriter.flush();
                            if (mem.read32(tmpAddress + 0) == 1179472720) {
                                this.analyseMpeg(tmpAddress);
                            }
                            if (this.isCurrentMpegAnalyzed()) {
                                this.unregisterRingbufferPutIoListener();
                            }
                        }
                        catch (IOException e) {
                            if (!log.isDebugEnabled()) break block30;
                            log.debug((Object)"onIoRead", (Throwable)e);
                        }
                    }
                }
            }
            if (!this.isCurrentMpegAnalyzed() && bytesRead >= 4 && sceMpeg.isMpegData(mem, readAddress)) {
                byte[] buffer = new byte[2048];
                if (vFile != null) {
                    int length;
                    long currentPosition = vFile.getPosition();
                    long startMpegPosition = currentPosition - (long)bytesRead;
                    long endMpegPosition = currentPosition;
                    long previousTimestamp = 0L;
                    while ((length = vFile.ioRead(buffer, 0, buffer.length)) >= buffer.length && sceMpeg.isMpegData(buffer)) {
                        long timestamp = sceMpeg.getPackTimestamp(buffer, 0);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("onRingbufferPutIoRead timestamp %d at offset 0x%X", timestamp, endMpegPosition));
                        }
                        if (timestamp < previousTimestamp) break;
                        endMpegPosition += (long)buffer.length;
                        previousTimestamp = timestamp;
                    }
                    this.mpegStreamSize = (int)(endMpegPosition - startMpegPosition);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("onRingbufferPutIoRead estimated Mpeg stream size 0x%X (startPosition=0x%X, currentPosition=0x%X, endMpegPosition=0x%X)", this.mpegStreamSize, startMpegPosition, currentPosition, endMpegPosition));
                    }
                    this.setCurrentMpegAnalyzed(true);
                    this.unregisterRingbufferPutIoListener();
                    vFile.ioLseek(currentPosition);
                    if (sceMpeg.checkMediaEngineState()) {
                        this.me.setStreamFile(dataInput, vFile, readAddress, startMpegPosition, this.mpegStreamSize);
                    }
                } else {
                    try {
                        long currentPosition = dataInput.getFilePointer();
                        long startMpegPosition = currentPosition - (long)bytesRead;
                        long endMpegPosition = currentPosition;
                        long previousTimestamp = 0L;
                        while (true) {
                            try {
                                dataInput.readFully(buffer);
                            }
                            catch (IOException e) {
                                break;
                            }
                            if (!sceMpeg.isMpegData(buffer)) break;
                            long timestamp = sceMpeg.getPackTimestamp(buffer, 0);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)String.format("onRingbufferPutIoRead timestamp %d at offset 0x%X", timestamp, endMpegPosition));
                            }
                            if (timestamp < previousTimestamp) break;
                            endMpegPosition += (long)buffer.length;
                            previousTimestamp = timestamp;
                        }
                        this.mpegStreamSize = (int)(endMpegPosition - startMpegPosition);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("onRingbufferPutIoRead estimated Mpeg stream size 0x%X (startPosition=0x%X, currentPosition=0x%X, endMpegPosition=0x%X)", this.mpegStreamSize, startMpegPosition, currentPosition, endMpegPosition));
                        }
                        this.setCurrentMpegAnalyzed(true);
                        this.unregisterRingbufferPutIoListener();
                        dataInput.seek(currentPosition);
                        if (sceMpeg.checkMediaEngineState()) {
                            this.me.setStreamFile(dataInput, vFile, readAddress, startMpegPosition, this.mpegStreamSize);
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)"onRingbufferPutIoRead", (Throwable)e);
                    }
                }
            }
        }
    }

    protected void onHeaderIoRead(int data_addr, int bytesRead, long position, SeekableDataInput dataInput, IVirtualFile vFile) {
        Memory mem;
        if (bytesRead >= 16 && bytesRead < 2048 && (mem = Memory.getInstance()).read32(data_addr + 0) == 1179472720) {
            try {
                long currentPosition = dataInput.getFilePointer();
                dataInput.seek(position);
                this.completeMpegHeader = new byte[2048];
                this.partialMpegHeaderLength = bytesRead;
                dataInput.readFully(this.completeMpegHeader);
                dataInput.seek(currentPosition);
            }
            catch (IOException e) {
                log.error((Object)"onHeaderIoRead", (Throwable)e);
            }
        }
    }

    private static boolean memcmp(int address, byte[] buffer, int size) {
        if (buffer == null || size < 0) {
            return false;
        }
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, size, 1);
        for (int i = 0; i < size; ++i) {
            int b = memoryReader.readNext();
            if (Utilities.read8(buffer, i) == b) continue;
            return false;
        }
        return true;
    }

    public static int getMpegVersion(int mpegRawVersion) {
        switch (mpegRawVersion) {
            case 842084400: {
                return 0;
            }
            case 0x33313030: {
                return 1;
            }
            case 875638832: {
                return 2;
            }
            case 892416048: {
                return 3;
            }
        }
        return -1;
    }

    protected void analyseMpeg(int bufferAddr) {
        Memory mem = Memory.getInstance();
        this.mpegStreamAddr = bufferAddr;
        this.mpegMagic = mem.read32(bufferAddr + 0);
        this.mpegRawVersion = mem.read32(bufferAddr + 4);
        this.mpegVersion = sceMpeg.getMpegVersion(this.mpegRawVersion);
        this.mpegOffset = Utilities.endianSwap32(mem.read32(bufferAddr + 8));
        this.mpegStreamSize = Utilities.endianSwap32(mem.read32(bufferAddr + 12));
        this.mpegFirstTimestamp = Utilities.endianSwap32(Utilities.readUnaligned32(mem, bufferAddr + 86));
        this.mpegLastTimestamp = Utilities.endianSwap32(Utilities.readUnaligned32(mem, bufferAddr + 92));
        this.avcDetailFrameWidth = mem.read8(bufferAddr + 142) * 16;
        this.avcDetailFrameHeight = mem.read8(bufferAddr + 143) * 16;
        if ((this.mpegFirstTimestamp != 90000L || this.mpegFirstTimestamp > this.mpegLastTimestamp || this.mpegLastTimestamp <= 0L) && sceMpeg.memcmp(bufferAddr, this.completeMpegHeader, this.partialMpegHeaderLength)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using complete MPEG header from IoListener");
                if (log.isTraceEnabled()) {
                    log.trace((Object)Utilities.getMemoryDump(this.completeMpegHeader, 0, 2048));
                }
            }
            this.mpegFirstTimestamp = Utilities.endianSwap32(Utilities.readUnaligned32(this.completeMpegHeader, 86));
            this.mpegLastTimestamp = Utilities.endianSwap32(Utilities.readUnaligned32(this.completeMpegHeader, 92));
            this.avcDetailFrameWidth = Utilities.read8(this.completeMpegHeader, 142) * 16;
            this.avcDetailFrameHeight = Utilities.read8(this.completeMpegHeader, 143) * 16;
        }
        this.mpegFirstDate = this.convertTimestampToDate(this.mpegFirstTimestamp);
        this.mpegLastDate = this.convertTimestampToDate(this.mpegLastTimestamp);
        this.avcDecodeResult = 1;
        this.avcFrameStatus = 0;
        if (this.mpegRingbuffer != null && !this.isCurrentMpegAnalyzed()) {
            this.mpegRingbuffer.reset();
            this.mpegRingbuffer.write(this.mpegRingbufferAddr);
        }
        this.mpegAtracAu.dts = -1L;
        this.mpegAtracAu.pts = 0L;
        this.mpegAvcAu.dts = 0L;
        this.mpegAvcAu.pts = 0L;
        this.videoFrameCount = 0;
        this.audioFrameCount = 0;
        this.endOfAudioReached = false;
        this.endOfVideoReached = false;
        if (!this.isCurrentMpegAnalyzed() && this.mpegStreamSize > 0 && this.mpegOffset > 0 && this.mpegOffset <= this.mpegStreamSize) {
            if (sceMpeg.checkMediaEngineState()) {
                this.me.init(bufferAddr, this.mpegStreamSize, this.mpegOffset);
                this.meChannel = new PacketChannel();
                this.meChannel.write(bufferAddr, 2048);
            } else if (sceMpeg.isEnableConnector()) {
                this.mpegCodec.init(this.mpegVersion, this.mpegStreamSize, this.mpegLastTimestamp);
                this.mpegCodec.writeVideo(bufferAddr, 2048);
            }
            this.setCurrentMpegAnalyzed(true);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Stream offset: %d, Stream size: 0x%X", this.mpegOffset, this.mpegStreamSize));
            log.debug((Object)String.format("First timestamp: %d, Last timestamp: %d", this.mpegFirstTimestamp, this.mpegLastTimestamp));
            if (log.isTraceEnabled()) {
                log.trace((Object)Utilities.getMemoryDump(bufferAddr, 2048));
            }
        }
    }

    public static int getMaxAheadTimestamp(int packets) {
        return Math.max(40000, packets * 700);
    }

    private void generateFakeMPEGVideo(int dest_addr, int frameWidth) {
        sceMpeg.generateFakeImage(dest_addr, frameWidth, this.avcDetailFrameWidth, this.avcDetailFrameHeight, this.videoPixelMode);
    }

    public static void generateFakeImage(int dest_addr, int frameWidth, int imageWidth, int imageHeight, int pixelMode) {
        Memory mem = Memory.getInstance();
        Random random = new Random();
        int pixelSize = 3;
        int bytesPerPixel = sceDisplay.getPixelFormatBytes(pixelMode);
        for (int y = 0; y < imageHeight - 3 + 1; y += 3) {
            int address = dest_addr + y * frameWidth * bytesPerPixel;
            int width = Math.min(imageWidth, frameWidth);
            for (int x = 0; x < width; x += 3) {
                int j;
                int i;
                int n = random.nextInt(256);
                int color = 0xFF000000 | n << 16 | n << 8 | n;
                int pixelColor = Debug.getPixelColor(color, pixelMode);
                if (bytesPerPixel == 4) {
                    for (i = 0; i < 3; ++i) {
                        for (j = 0; j < 3; ++j) {
                            mem.write32(address + (i * frameWidth + j) * 4, pixelColor);
                        }
                    }
                } else if (bytesPerPixel == 2) {
                    for (i = 0; i < 3; ++i) {
                        for (j = 0; j < 3; ++j) {
                            mem.write16(address + (i * frameWidth + j) * 2, (short)pixelColor);
                        }
                    }
                }
                address += 3 * bytesPerPixel;
            }
        }
    }

    public static void delayThread(long startMicros, int delayMicros) {
        long now = Emulator.getClock().microTime();
        int threadDelayMicros = delayMicros - (int)(now - startMicros);
        sceMpeg.delayThread(threadDelayMicros);
    }

    public static void delayThread(int delayMicros) {
        if (delayMicros > 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(delayMicros, false);
        } else {
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        }
    }

    protected void updateAvcDts() {
        this.mpegAvcAu.dts = this.mpegAvcAu.pts - 3003L;
    }

    protected void finishMpeg() {
        if (sceMpeg.checkMediaEngineState()) {
            this.me.finish();
            if (this.meChannel != null) {
                this.meChannel.clear();
                this.meChannel = null;
            }
        } else if (sceMpeg.isEnableConnector()) {
            this.mpegCodec.finish();
        }
        if (this.mpegRingbuffer != null) {
            this.mpegRingbuffer.reset();
            this.mpegRingbuffer.write(this.mpegRingbufferAddr);
        }
        this.setCurrentMpegAnalyzed(false);
        this.unregisterRingbufferPutIoListener();
        VideoEngine.getInstance().resetVideoTextures();
        this.atracStreamsMap.clear();
        this.pcmStreamsMap.clear();
        this.avcStreamsMap.clear();
        this.dataStreamsMap.clear();
        this.registeredVideoChannel = -1;
        this.registeredAudioChannel = -1;
        this.mpegStreamSize = 0;
        this.mpegAtracAu.dts = -1L;
        this.mpegAtracAu.pts = 0L;
        this.mpegAvcAu.dts = 0L;
        this.mpegAvcAu.pts = 0L;
        this.videoFrameCount = 0;
        this.audioFrameCount = 0;
        this.endOfAudioReached = false;
        this.endOfVideoReached = false;
    }

    @HLEFunction(nid=570392804, version=150, checkInsideInterrupt=true)
    public int sceMpegQueryStreamOffset(@CheckArgument(value="checkMpegHandle") int mpeg, TPointer bufferAddr, TPointer32 offsetAddr) {
        this.analyseMpeg(bufferAddr.getAddress());
        if (this.mpegMagic != 1179472720) {
            log.warn((Object)("sceMpegQueryStreamOffset bad magic " + String.format("0x%08X", this.mpegMagic)));
            offsetAddr.setValue(0);
            return -2141126146;
        }
        if (this.mpegVersion < 0) {
            log.warn((Object)("sceMpegQueryStreamOffset bad version " + String.format("0x%08X", this.mpegRawVersion)));
            offsetAddr.setValue(0);
            return -2141126654;
        }
        if ((this.mpegOffset & 0x7FF) != 0 || this.mpegOffset == 0) {
            log.warn((Object)("sceMpegQueryStreamOffset bad offset " + String.format("0x%08X", this.mpegOffset)));
            offsetAddr.setValue(0);
            return -2141126146;
        }
        offsetAddr.setValue(this.mpegOffset);
        return 0;
    }

    @HLEFunction(nid=1629396497, version=150, checkInsideInterrupt=true)
    public int sceMpegQueryStreamSize(TPointer bufferAddr, TPointer32 sizeAddr) {
        this.analyseMpeg(bufferAddr.getAddress());
        if (this.mpegMagic != 1179472720) {
            log.warn((Object)String.format("sceMpegQueryStreamSize bad magic 0x%08X", this.mpegMagic));
            return -1;
        }
        if ((this.mpegStreamSize & 0x7FF) != 0) {
            sizeAddr.setValue(0);
            return -2141126146;
        }
        sizeAddr.setValue(this.mpegStreamSize);
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=1747607963, version=150, checkInsideInterrupt=true)
    public int sceMpegInit() {
        if (sceMpeg.checkMediaEngineState()) {
            this.meChannel = null;
        }
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=-2025446186, version=150, checkInsideInterrupt=true)
    public int sceMpegFinish() {
        this.finishMpeg();
        return 0;
    }

    @HLEFunction(nid=-1053629905, version=150, checkInsideInterrupt=true)
    public int sceMpegQueryMemSize(int mode) {
        return 65536;
    }

    @HLEFunction(nid=-658116319, version=150, checkInsideInterrupt=true)
    public int sceMpegCreate(TPointer mpeg, TPointer data, int size, @CanBeNull TPointer ringbufferAddr, int frameWidth, int mode, int ddrtop) {
        Memory mem = Processor.memory;
        if (size < 65536) {
            log.warn((Object)("sceMpegCreate bad size " + size));
            return -2141126622;
        }
        if (ringbufferAddr.isNotNull()) {
            this.mpegRingbuffer = SceMpegRingbuffer.fromMem(mem, ringbufferAddr.getAddress());
            this.mpegRingbuffer.packetsFree = this.mpegRingbuffer.packetSize == 0 ? 0 : (this.mpegRingbuffer.dataUpperBound - this.mpegRingbuffer.data) / this.mpegRingbuffer.packetSize;
            this.mpegRingbuffer.mpeg = mpeg.getAddress();
            this.mpegRingbuffer.write(mem, ringbufferAddr.getAddress());
        }
        this.mpegHandle = data.getAddress() + 48;
        mpeg.setValue32(this.mpegHandle);
        Utilities.writeStringZ(mem, this.mpegHandle, "LIBMPEG.001");
        mem.write32(this.mpegHandle + 12, -1);
        mem.write32(this.mpegHandle + 16, ringbufferAddr.getAddress());
        if (this.mpegRingbuffer != null) {
            mem.write32(this.mpegHandle + 20, this.mpegRingbuffer.dataUpperBound);
        }
        this.mpegRingbufferAddr = ringbufferAddr;
        this.videoFrameCount = 0;
        this.audioFrameCount = 0;
        this.videoPixelMode = 3;
        this.defaultFrameWidth = frameWidth;
        this.insideRingbufferPut = false;
        return 0;
    }

    @HLEFunction(nid=1617577545, version=150, checkInsideInterrupt=true)
    public int sceMpegDelete(@CheckArgument(value="checkMpegHandle") int mpeg) {
        this.finishMpeg();
        return 0;
    }

    @HLEFunction(nid=1112936227, version=150, checkInsideInterrupt=true)
    public int sceMpegRegistStream(@CheckArgument(value="checkMpegHandle") int mpeg, int stream_type, int stream_num) {
        StreamInfo info = new StreamInfo(stream_type);
        int uid = info.getUid();
        switch (stream_type) {
            case 0: {
                this.isAvcRegistered = true;
                this.avcStreamsMap.put(uid, stream_num);
                break;
            }
            case 1: 
            case 15: {
                this.isAtracRegistered = true;
                this.atracStreamsMap.put(uid, stream_num);
                break;
            }
            case 2: {
                this.isPcmRegistered = true;
                this.pcmStreamsMap.put(uid, stream_num);
                break;
            }
            case 3: {
                this.isDataRegistered = true;
                this.dataStreamsMap.put(uid, stream_num);
                break;
            }
            default: {
                log.warn((Object)("sceMpegRegistStream unknown stream type=" + stream_type));
            }
        }
        return uid;
    }

    @HLEFunction(nid=1494895266, version=150, checkInsideInterrupt=true)
    public int sceMpegUnRegistStream(@CheckArgument(value="checkMpegHandle") int mpeg, int streamUid) {
        StreamInfo info = this.getStreamInfo(streamUid);
        if (info == null) {
            log.warn((Object)("sceMpegUnRegistStream unknown stream=0x" + Integer.toHexString(streamUid)));
            return -1;
        }
        switch (info.getType()) {
            case 0: {
                this.isAvcRegistered = false;
                this.avcStreamsMap.remove(streamUid);
                break;
            }
            case 1: 
            case 15: {
                this.isAtracRegistered = false;
                this.atracStreamsMap.remove(streamUid);
                break;
            }
            case 2: {
                this.isPcmRegistered = false;
                this.pcmStreamsMap.remove(streamUid);
                break;
            }
            case 3: {
                this.isDataRegistered = false;
                this.dataStreamsMap.remove(streamUid);
                break;
            }
            default: {
                log.warn((Object)("sceMpegUnRegistStream unknown stream=0x" + Integer.toHexString(streamUid)));
            }
        }
        info.release();
        this.setCurrentMpegAnalyzed(false);
        return 0;
    }

    @HLEFunction(nid=-1484730498, version=150, checkInsideInterrupt=true)
    public int sceMpegMallocAvcEsBuf(@CheckArgument(value="checkMpegHandle") int mpeg) {
        int esBufferId = 0;
        for (int i = 0; i < this.allocatedEsBuffers.length; ++i) {
            if (this.allocatedEsBuffers[i]) continue;
            esBufferId = i + 1;
            this.allocatedEsBuffers[i] = true;
            break;
        }
        return esBufferId;
    }

    @HLEFunction(nid=-826773327, version=150, checkInsideInterrupt=true)
    public int sceMpegFreeAvcEsBuf(@CheckArgument(value="checkMpegHandle") int mpeg, int esBuf) {
        if (esBuf == 0) {
            log.warn((Object)("sceMpegFreeAvcEsBuf(mpeg=0x" + Integer.toHexString(mpeg) + ", esBuf=0x" + Integer.toHexString(esBuf) + ") bad esBuf handle"));
            return -2141126146;
        }
        if (esBuf >= 1 && esBuf <= this.allocatedEsBuffers.length) {
            this.allocatedEsBuffers[esBuf - 1] = false;
        }
        return 0;
    }

    @HLEFunction(nid=-119753095, version=150, checkInsideInterrupt=true)
    public int sceMpegQueryAtracEsSize(@CheckArgument(value="checkMpegHandle") int mpeg, @CanBeNull TPointer32 esSizeAddr, @CanBeNull TPointer32 outSizeAddr) {
        esSizeAddr.setValue(2112);
        outSizeAddr.setValue(8192);
        return 0;
    }

    @HLEFunction(nid=-1070795083, version=150, checkInsideInterrupt=true)
    public int sceMpegQueryPcmEsSize(@CheckArgument(value="checkMpegHandle") int mpeg, TPointer32 esSizeAddr, TPointer32 outSizeAddr) {
        esSizeAddr.setValue(320);
        outSizeAddr.setValue(320);
        return 0;
    }

    @HLEFunction(nid=377159070, version=150, checkInsideInterrupt=true)
    public int sceMpegInitAu(@CheckArgument(value="checkMpegHandle") int mpeg, int buffer_addr, TPointer auAddr) {
        if (buffer_addr >= 1 && buffer_addr <= this.allocatedEsBuffers.length && this.allocatedEsBuffers[buffer_addr - 1]) {
            this.mpegAvcAu.esBuffer = buffer_addr;
            this.mpegAvcAu.esSize = 2048;
            this.mpegAvcAu.write(auAddr.getMemory(), auAddr.getAddress());
        } else {
            this.mpegAtracAu.esBuffer = buffer_addr;
            this.mpegAtracAu.esSize = 2112;
            this.mpegAtracAu.write(auAddr.getMemory(), auAddr.getAddress());
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=591759022, version=150, checkInsideInterrupt=true)
    public int sceMpegChangeGetAvcAuMode(int mpeg, int stream_addr, int mode) {
        return 0;
    }

    @HLEFunction(nid=-1647331350, version=150, checkInsideInterrupt=true)
    public int sceMpegChangeGetAuMode(int mpeg, int streamUid, int mode) {
        block12: {
            block11: {
                StreamInfo info = this.getStreamInfo(streamUid);
                if (info == null) break block11;
                switch (info.getType()) {
                    case 0: {
                        if (mode == 0) {
                            this.ignoreAvc = false;
                            break;
                        }
                        if (mode == 1) {
                            this.ignoreAvc = true;
                            break;
                        }
                        break block12;
                    }
                    case 1: 
                    case 15: {
                        if (mode == 0) {
                            this.ignoreAtrac = false;
                            break;
                        }
                        if (mode == 1) {
                            this.ignoreAtrac = true;
                            break;
                        }
                        break block12;
                    }
                    case 2: {
                        if (mode == 0) {
                            this.ignorePcm = false;
                            break;
                        }
                        if (mode == 1) {
                            this.ignorePcm = true;
                            break;
                        }
                        break block12;
                    }
                    default: {
                        log.warn((Object)("sceMpegChangeGetAuMode unknown stream=0x" + Integer.toHexString(streamUid)));
                        break;
                    }
                }
                break block12;
            }
            log.warn((Object)("sceMpegChangeGetAuMode unknown stream=0x" + Integer.toHexString(streamUid)));
        }
        return 0;
    }

    @HLEFunction(nid=-31168728, version=150, checkInsideInterrupt=true)
    public int sceMpegGetAvcAu(@CheckArgument(value="checkMpegHandle") int mpeg, int streamUid, TPointer auAddr, @CanBeNull TPointer32 attrAddr) {
        if (this.mpegRingbuffer != null) {
            this.mpegRingbuffer.read(this.mpegRingbufferAddr);
        }
        if (this.mpegRingbuffer.packetsRead == 0 || !sceMpeg.checkMediaEngineState() && this.mpegRingbuffer.isEmpty()) {
            sceMpeg.delayThread(100);
            return -2141093887;
        }
        if (Memory.isAddressGood(streamUid)) {
            log.warn((Object)"sceMpegGetAvcAu didn't get a fake stream");
            return -2141126397;
        }
        if (!this.streamMap.containsKey(streamUid)) {
            log.warn((Object)String.format("sceMpegGetAvcAu bad stream 0x%X", streamUid));
            return -1;
        }
        if (this.mpegAvcAu.pts > this.mpegAtracAu.pts + (long)this.maxAheadTimestamp && this.isAtracRegistered) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMpegGetAvcAu video ahead of audio: %d - %d", this.mpegAvcAu.pts, this.mpegAtracAu.pts));
            }
            sceMpeg.delayThread(100);
            return -2141093887;
        }
        int result = 0;
        if (!this.ignoreAvc) {
            result = this.hleMpegGetAvcAu(auAddr, 90000, -2141093887);
        }
        attrAddr.setValue(1);
        return result;
    }

    @HLEFunction(nid=-1944190339, version=150, checkInsideInterrupt=true)
    public int sceMpegGetPcmAu(@CheckArgument(value="checkMpegHandle") int mpeg, int streamUid, TPointer auAddr, @CanBeNull TPointer32 attrAddr) {
        if (this.mpegRingbuffer != null) {
            this.mpegRingbuffer.read(this.mpegRingbufferAddr);
        }
        if (this.mpegRingbuffer.packetsRead == 0 || !sceMpeg.checkMediaEngineState() && this.mpegRingbuffer.isEmpty()) {
            sceMpeg.delayThread(100);
            return -2141093887;
        }
        if (Memory.isAddressGood(streamUid)) {
            log.warn((Object)"sceMpegGetPcmAu didn't get a fake stream");
            return -2141126397;
        }
        if (!this.streamMap.containsKey(streamUid)) {
            log.warn((Object)String.format("sceMpegGetPcmAu bad streamUid 0x%08X", streamUid));
            return -1;
        }
        int result = 0;
        if (!this.ignorePcm) {
            if (sceMpeg.checkMediaEngineState()) {
                Emulator.getClock().pause();
                this.me.setFirstTimestamp(90000);
                if (this.me.getContainer() == null) {
                    this.me.init(this.meChannel, true, true, this.getRegisteredVideoChannel(), this.getRegisteredAudioChannel());
                }
                if (!this.me.readAudioAu(this.mpegAtracAu, 2)) {
                    result = -2141093887;
                }
                Emulator.getClock().resume();
            } else if (!sceMpeg.isEnableConnector() || this.mpegCodec.readAudioAu(this.mpegAtracAu, this.audioFrameCount)) {
                // empty if block
            }
            this.mpegAtracAu.write(auAddr);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMpegGetPcmAu returning AtracAu=%s", this.mpegAtracAu.toString()));
            }
        }
        int attr = 128;
        attrAddr.setValue(attr |= 2);
        if (result != 0) {
            sceMpeg.delayThread(100);
        }
        return result;
    }

    @HLEFunction(nid=-506559577, version=150, checkInsideInterrupt=true)
    public int sceMpegGetAtracAu(@CheckArgument(value="checkMpegHandle") int mpeg, int streamUid, TPointer auAddr, @CanBeNull TPointer32 attrAddr) {
        if (this.mpegRingbuffer != null) {
            this.mpegRingbuffer.read(this.mpegRingbufferAddr);
        }
        if (this.mpegRingbuffer.packetsRead == 0 || !sceMpeg.checkMediaEngineState() && this.mpegRingbuffer.isEmpty()) {
            log.debug((Object)"sceMpegGetAtracAu ringbuffer empty");
            sceMpeg.delayThread(100);
            return -2141093887;
        }
        if (Memory.isAddressGood(streamUid)) {
            log.warn((Object)"sceMpegGetAtracAu didn't get a fake stream");
            return -2141126397;
        }
        if (!this.streamMap.containsKey(streamUid)) {
            log.warn((Object)("sceMpegGetAtracAu bad address " + String.format("0x%08X 0x%08X", streamUid, auAddr)));
            return -1;
        }
        if (this.endOfAudioReached && this.endOfVideoReached) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"sceMpegGetAtracAu end of audio and video reached");
            }
            if (this.mpegRingbuffer.packetsFree < this.mpegRingbuffer.packets) {
                this.mpegRingbuffer.packetsFree = this.mpegRingbuffer.packets;
                this.mpegRingbuffer.write(this.mpegRingbufferAddr);
            }
            return -2141093887;
        }
        if (this.mpegAtracAu.pts > this.mpegAvcAu.pts + (long)this.maxAheadTimestamp && this.isAvcRegistered && !this.endOfAudioReached) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMpegGetAtracAu audio ahead of video: %d - %d", this.mpegAtracAu.pts, this.mpegAvcAu.pts));
            }
            sceMpeg.delayThread(100);
            return -2141093887;
        }
        int result = 0;
        if (!this.ignoreAtrac) {
            result = this.hleMpegGetAtracAu(auAddr, 90000);
        }
        attrAddr.setValue(0);
        return result;
    }

    @HLEFunction(nid=1343161385, version=150, checkInsideInterrupt=true)
    public int sceMpegFlushStream(int mpeg, int stream_addr) {
        this.finishMpeg();
        return 0;
    }

    @HLEFunction(nid=1887139369, version=150, checkInsideInterrupt=true)
    public int sceMpegFlushAllStream(int mpeg) {
        if (this.videoFrameCount > 0 || this.audioFrameCount > 0) {
            this.finishMpeg();
        }
        return 0;
    }

    @HLEFunction(nid=238825117, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecode(@CheckArgument(value="checkMpegHandle") int mpeg, TPointer32 auAddr, int frameWidth, TPointer32 bufferAddr, TPointer32 initAddr) {
        if (frameWidth == 0) {
            frameWidth = this.defaultFrameWidth == 0 ? this.avcDetailFrameWidth : this.defaultFrameWidth;
        }
        if (this.mpegRingbuffer != null && this.mpegRingbufferAddr != null) {
            this.mpegRingbuffer.read(this.mpegRingbufferAddr);
        }
        if (this.mpegRingbuffer == null) {
            log.warn((Object)"sceMpegAvcDecode ringbuffer not created");
            return -1;
        }
        if (this.mpegRingbuffer.packetsRead == 0 || !sceMpeg.checkMediaEngineState() && this.mpegRingbuffer.isEmpty()) {
            log.debug((Object)"sceMpegAvcDecode ringbuffer empty");
            return -2141028350;
        }
        int au = auAddr.getValue();
        int buffer = bufferAddr.getValue();
        int init = initAddr.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegAvcDecode *au=0x%08X, *buffer=0x%08X, init=%d", au, buffer, init));
        }
        int width = Math.min(480, frameWidth);
        int height = 272;
        VideoEngine.getInstance().addVideoTexture(buffer, buffer + 272 * frameWidth * sceDisplay.getPixelFormatBytes(this.videoPixelMode));
        long startTime = Emulator.getClock().microTime();
        int packetsInRingbuffer = this.mpegRingbuffer.packets - this.mpegRingbuffer.packetsFree;
        int processedPackets = this.mpegRingbuffer.packetsRead - packetsInRingbuffer;
        int processedSize = processedPackets * this.mpegRingbuffer.packetSize;
        int packetsConsumed = 3;
        if (this.mpegStreamSize > 0 && this.mpegLastTimestamp > 0L) {
            int processedSizeBasedOnTimestamp = (int)((float)this.mpegAvcAu.pts / (float)this.mpegLastTimestamp * (float)this.mpegStreamSize);
            if (processedSizeBasedOnTimestamp < processedSize) {
                packetsConsumed = 0;
            } else {
                packetsConsumed = (processedSizeBasedOnTimestamp - processedSize) / this.mpegRingbuffer.packetSize;
                if (packetsConsumed > 10) {
                    packetsConsumed = 10;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMpegAvcDecode consumed %d %d/%d %d", processedSizeBasedOnTimestamp, processedSize, this.mpegStreamSize, packetsConsumed));
            }
        }
        if (sceMpeg.checkMediaEngineState()) {
            Emulator.getClock().pause();
            if (this.me.stepVideo(2)) {
                this.me.writeVideoImage(buffer, frameWidth, this.videoPixelMode);
                packetsConsumed = this.meChannel.getReadLength() / this.mpegRingbuffer.packetSize;
                if (this.mpegRingbuffer.packetsFree + packetsConsumed >= this.mpegRingbuffer.packets && this.mpegLastTimestamp > 0L && this.mpegAvcAu.pts < this.mpegLastTimestamp) {
                    packetsConsumed = this.mpegRingbuffer.packets - this.mpegRingbuffer.packetsFree - 2;
                }
                this.meChannel.setReadLength(this.meChannel.getReadLength() - packetsConsumed * this.mpegRingbuffer.packetSize);
            } else {
                packetsConsumed = this.mpegRingbuffer.packets - this.mpegRingbuffer.packetsFree;
            }
            Emulator.getClock().resume();
            this.avcFrameStatus = 1;
        } else if (sceMpeg.isEnableConnector() && this.mpegCodec.readVideoFrame(buffer, frameWidth, width, 272, this.videoPixelMode, this.videoFrameCount)) {
            packetsConsumed = this.mpegCodec.getPacketsConsumed();
            this.avcFrameStatus = 1;
        } else {
            String displayedString;
            this.mpegAvcAu.pts += 3003L;
            this.updateAvcDts();
            this.generateFakeMPEGVideo(buffer, frameWidth);
            if (sceMpeg.isEnableConnector()) {
                this.mpegCodec.postFakedVideo(buffer, frameWidth, this.videoPixelMode);
            }
            Date currentDate = this.convertTimestampToDate(this.mpegAvcAu.pts);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("currentDate: %s", currentDate.toString()));
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            Debug.printFramebuffer(buffer, frameWidth, 10, this.avcDetailFrameHeight - 22, -1, -16777216, this.videoPixelMode, 1, " Enable the Media Engine to see the MPEG Video. ");
            if (this.mpegLastDate != null) {
                displayedString = String.format(" %s / %s ", dateFormat.format(currentDate), dateFormat.format(this.mpegLastDate));
                Debug.printFramebuffer(buffer, frameWidth, 10, 10, -1, -16777216, this.videoPixelMode, 2, displayedString);
            }
            displayedString = this.mpegStreamSize > 0 ? String.format(" %d/%d (%.0f%%) ", processedSize, this.mpegStreamSize, Float.valueOf((float)processedSize * 100.0f / (float)this.mpegStreamSize)) : String.format(" %d ", processedSize);
            Debug.printFramebuffer(buffer, frameWidth, 10, 30, -1, -16777216, this.videoPixelMode, 2, displayedString);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMpegAvcDecode currentTimestamp=%d", this.mpegAvcAu.pts));
            }
            this.avcFrameStatus = 1;
        }
        ++this.videoFrameCount;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegAvcDecode currentTimestamp=%d", this.mpegAvcAu.pts));
        }
        if (this.mpegRingbuffer.packetsFree < this.mpegRingbuffer.packets && packetsConsumed > 0) {
            this.mpegRingbuffer.packetsFree = Math.min(this.mpegRingbuffer.packets, this.mpegRingbuffer.packetsFree + packetsConsumed);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMpegAvcDecode consumed %d packets, remaining %d packets", packetsConsumed, this.mpegRingbuffer.packets - this.mpegRingbuffer.packetsFree));
            }
            if (this.mpegRingbufferAddr != null) {
                this.mpegRingbuffer.write(this.mpegRingbufferAddr);
            }
        }
        this.avcDecodeResult = 1;
        initAddr.setValue(this.avcFrameStatus);
        sceMpeg.delayThread(startTime, 5400);
        return 0;
    }

    @HLEFunction(nid=258742487, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecodeDetail(@CheckArgument(value="checkMpegHandle") int mpeg, TPointer detailPointer) {
        detailPointer.setValue32(0, this.avcDecodeResult);
        detailPointer.setValue32(4, this.videoFrameCount);
        detailPointer.setValue32(8, this.avcDetailFrameWidth);
        detailPointer.setValue32(12, this.avcDetailFrameHeight);
        detailPointer.setValue32(16, 0);
        detailPointer.setValue32(20, 0);
        detailPointer.setValue32(24, 0);
        detailPointer.setValue32(28, 0);
        detailPointer.setValue32(32, this.avcFrameStatus);
        return 0;
    }

    @HLEFunction(nid=-1591971802, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecodeMode(@CheckArgument(value="checkMpegHandle") int mpeg, TPointer32 modeAddr) {
        int mode = modeAddr.getValue(0);
        int pixelMode = modeAddr.getValue(4);
        if (pixelMode >= 0 && pixelMode <= 3) {
            this.videoPixelMode = pixelMode;
        } else {
            log.warn((Object)("sceMpegAvcDecodeMode mode=0x" + mode + " pixel mode=" + pixelMode + ": unknown mode"));
        }
        return 0;
    }

    @HLEFunction(nid=1947192529, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecodeStop(@CheckArgument(value="checkMpegHandle") int mpeg, int frameWidth, TPointer bufferAddr, TPointer32 statusAddr) {
        statusAddr.setValue(0);
        return 0;
    }

    @HLEFunction(nid=1165085796, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecodeFlush(int mpeg) {
        if (this.videoFrameCount > 0 || this.audioFrameCount > 0) {
            this.finishMpeg();
        }
        return 0;
    }

    @HLEFunction(nid=555353468, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcQueryYCbCrSize(@CheckArgument(value="checkMpegHandle") int mpeg, int mode, int width, int height, TPointer32 resultAddr) {
        if ((width & 0xF) != 0 || (height & 0xF) != 0 || width > 480 || height > 272) {
            log.warn((Object)("sceMpegAvcQueryYCbCrSize invalid size width=" + width + ", height=" + height));
            return -2141126146;
        }
        int size = width / 2 * (height / 2) * 6 + 128;
        resultAddr.setValue(size);
        return 0;
    }

    @HLEFunction(nid=1729600283, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcInitYCbCr(@CheckArgument(value="checkMpegHandle") int mpeg, int mode, int width, int height, int ycbcr_addr) {
        this.encodedVideoFramesYCbCr.remove(ycbcr_addr);
        return 0;
    }

    @HLEFunction(nid=-253030107, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecodeYCbCr(@CheckArgument(value="checkMpegHandle") int mpeg, TPointer auAddr, TPointer32 bufferAddr, TPointer32 initAddr) {
        if (this.mpegRingbuffer != null) {
            this.mpegRingbuffer.read(this.mpegRingbufferAddr);
        }
        if (this.mpegRingbuffer == null) {
            log.warn((Object)"sceMpegAvcDecodeYCbCr ringbuffer not created");
            return -1;
        }
        if (this.mpegRingbuffer.packetsRead == 0 || !sceMpeg.checkMediaEngineState() && this.mpegRingbuffer.isEmpty()) {
            log.debug((Object)"sceMpegAvcDecodeYCbCr ringbuffer empty");
            return -2141028350;
        }
        long startTime = Emulator.getClock().microTime();
        int packetsInRingbuffer = this.mpegRingbuffer.packets - this.mpegRingbuffer.packetsFree;
        int processedPackets = this.mpegRingbuffer.packetsRead - packetsInRingbuffer;
        int processedSize = processedPackets * this.mpegRingbuffer.packetSize;
        int packetsConsumed = 3;
        if (this.mpegStreamSize > 0 && this.mpegLastTimestamp > 0L) {
            int processedSizeBasedOnTimestamp = (int)((float)this.mpegAvcAu.pts / (float)this.mpegLastTimestamp * (float)this.mpegStreamSize);
            if (processedSizeBasedOnTimestamp < processedSize) {
                packetsConsumed = 0;
            } else {
                packetsConsumed = (processedSizeBasedOnTimestamp - processedSize) / this.mpegRingbuffer.packetSize;
                if (packetsConsumed > 10) {
                    packetsConsumed = 10;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMpegAvcDecodeYCbCr consumed %d %d/%d %d", processedSizeBasedOnTimestamp, processedSize, this.mpegStreamSize, packetsConsumed));
            }
        }
        if (sceMpeg.checkMediaEngineState()) {
            if (this.me.stepVideo(2)) {
                packetsConsumed = this.meChannel.getReadLength() / this.mpegRingbuffer.packetSize;
                this.meChannel.setReadLength(this.meChannel.getReadLength() - packetsConsumed * this.mpegRingbuffer.packetSize);
            } else {
                packetsConsumed = this.mpegRingbuffer.packets - this.mpegRingbuffer.packetsFree;
            }
            this.avcFrameStatus = 1;
        } else if (sceMpeg.isEnableConnector()) {
            byte[] encodedVideoFrame = this.mpegCodec.readEncodedVideoFrame(this.videoFrameCount);
            if (encodedVideoFrame != null) {
                int buffer = bufferAddr.getValue();
                this.encodedVideoFramesYCbCr.put(buffer, encodedVideoFrame);
            }
            packetsConsumed = 0;
            this.avcFrameStatus = 1;
        } else {
            this.mpegAvcAu.pts += 3003L;
            this.updateAvcDts();
            packetsConsumed = 0;
            this.avcFrameStatus = 1;
        }
        ++this.videoFrameCount;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegAvcDecodeYCbCr currentTimestamp=%d", this.mpegAvcAu.pts));
        }
        if (this.mpegRingbuffer.packetsFree < this.mpegRingbuffer.packets && packetsConsumed > 0) {
            this.mpegRingbuffer.packetsFree = Math.min(this.mpegRingbuffer.packets, this.mpegRingbuffer.packetsFree + packetsConsumed);
            this.mpegRingbuffer.write(this.mpegRingbufferAddr);
        }
        this.avcDecodeResult = 1;
        initAddr.setValue(this.avcFrameStatus);
        sceMpeg.delayThread(startTime, 5400);
        return 0;
    }

    @HLEFunction(nid=-225244004, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecodeStopYCbCr(@CheckArgument(value="checkMpegHandle") int mpeg, TPointer bufferAddr, TPointer32 statusAddr) {
        statusAddr.setValue(0);
        return 0;
    }

    @HLEFunction(nid=834470514, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcCsc(@CheckArgument(value="checkMpegHandle") int mpeg, TPointer sourceAddr, TPointer32 rangeAddr, int frameWidth, TPointer destAddr) {
        if (frameWidth == 0) {
            frameWidth = this.defaultFrameWidth == 0 ? this.avcDetailFrameWidth : this.defaultFrameWidth;
        }
        if (this.mpegRingbuffer != null) {
            this.mpegRingbuffer.read(this.mpegRingbufferAddr);
        }
        if (this.mpegRingbuffer == null) {
            log.warn((Object)"sceMpegAvcCsc ringbuffer not created");
            return -1;
        }
        if (this.mpegRingbuffer.packetsRead == 0 || !sceMpeg.checkMediaEngineState() && this.mpegRingbuffer.isEmpty()) {
            log.debug((Object)"sceMpegAvcCsc ringbuffer empty");
            return -2141028350;
        }
        int rangeWidthStart = rangeAddr.getValue(0);
        int rangeHeightStart = rangeAddr.getValue(4);
        int rangeWidthEnd = rangeAddr.getValue(8);
        int rangeHeightEnd = rangeAddr.getValue(12);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegAvcCsc range - x=%d, y=%d, xLen=%d, yLen=%d", rangeWidthStart, rangeHeightStart, rangeWidthEnd, rangeHeightEnd));
        }
        VideoEngine.getInstance().addVideoTexture(destAddr.getAddress(), destAddr.getAddress() + (rangeHeightStart + rangeHeightEnd) * frameWidth * sceDisplay.getPixelFormatBytes(this.videoPixelMode));
        if (sceMpeg.checkMediaEngineState()) {
            if (this.me.getContainer() != null) {
                this.me.writeVideoImageWithRange(destAddr.getAddress(), frameWidth, this.videoPixelMode, rangeWidthStart, rangeHeightStart, rangeWidthEnd, rangeHeightEnd);
            }
        } else {
            long startTime = Emulator.getClock().microTime();
            int packetsInRingbuffer = this.mpegRingbuffer.packets - this.mpegRingbuffer.packetsFree;
            int processedPackets = this.mpegRingbuffer.packetsRead - packetsInRingbuffer;
            int processedSize = processedPackets * this.mpegRingbuffer.packetSize;
            int packetsConsumed = 3;
            if (this.mpegStreamSize > 0 && this.mpegLastTimestamp > 0L) {
                int processedSizeBasedOnTimestamp = (int)((float)this.mpegAvcAu.pts / (float)this.mpegLastTimestamp * (float)this.mpegStreamSize);
                if (processedSizeBasedOnTimestamp < processedSize) {
                    packetsConsumed = 0;
                } else {
                    packetsConsumed = (processedSizeBasedOnTimestamp - processedSize) / this.mpegRingbuffer.packetSize;
                    if (packetsConsumed > 10) {
                        packetsConsumed = 10;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceMpegAvcCsc consumed %d %d/%d %d", processedSizeBasedOnTimestamp, processedSize, this.mpegStreamSize, packetsConsumed));
                }
            }
            if (sceMpeg.isEnableConnector() && this.encodedVideoFramesYCbCr.containsKey(sourceAddr.getAddress())) {
                byte[] encodedVideoFrame = this.encodedVideoFramesYCbCr.get(sourceAddr.getAddress());
                this.mpegCodec.decodeVideoFrame(encodedVideoFrame, destAddr.getAddress(), frameWidth, rangeWidthEnd, rangeHeightEnd, this.videoPixelMode, this.videoFrameCount);
                packetsConsumed = this.mpegCodec.getPacketsConsumed();
            } else {
                String displayedString;
                this.generateFakeMPEGVideo(destAddr.getAddress(), frameWidth);
                if (sceMpeg.isEnableConnector()) {
                    this.mpegCodec.postFakedVideo(destAddr.getAddress(), frameWidth, this.videoPixelMode);
                }
                Date currentDate = this.convertTimestampToDate(this.mpegAvcAu.pts);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("currentDate: %s", currentDate.toString()));
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                Debug.printFramebuffer(destAddr.getAddress(), frameWidth, 10, 250, -1, -16777216, this.videoPixelMode, 1, " This is a faked MPEG video (in YCbCr mode). ");
                if (this.mpegLastDate != null) {
                    displayedString = String.format(" %s / %s ", dateFormat.format(currentDate), dateFormat.format(this.mpegLastDate));
                    Debug.printFramebuffer(destAddr.getAddress(), frameWidth, 10, 10, -1, -16777216, this.videoPixelMode, 2, displayedString);
                }
                displayedString = this.mpegStreamSize > 0 ? String.format(" %d/%d (%.0f%%) ", processedSize, this.mpegStreamSize, Float.valueOf((float)processedSize * 100.0f / (float)this.mpegStreamSize)) : String.format(" %d ", processedSize);
                Debug.printFramebuffer(destAddr.getAddress(), frameWidth, 10, 30, -1, -16777216, this.videoPixelMode, 2, displayedString);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceMpegAvcCsc currentTimestamp=%d", this.mpegAvcAu.pts));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMpegAvcCsc currentTimestamp=%d", this.mpegAvcAu.pts));
            }
            if (this.mpegRingbuffer.packetsFree < this.mpegRingbuffer.packets && packetsConsumed > 0) {
                this.mpegRingbuffer.packetsFree = Math.min(this.mpegRingbuffer.packets, this.mpegRingbuffer.packetsFree + packetsConsumed);
                this.mpegRingbuffer.write(this.mpegRingbufferAddr);
            }
            sceMpeg.delayThread(startTime, 5400);
        }
        return 0;
    }

    @HLEFunction(nid=-2146679585, version=150, checkInsideInterrupt=true)
    public int sceMpegAtracDecode(@CheckArgument(value="checkMpegHandle") int mpeg, TPointer auAddr, TPointer bufferAddr, int init) {
        this.mpegAtracAu.pts += 4180L;
        int result = this.hleMpegAtracDecode(bufferAddr, 8192);
        ++this.audioFrameCount;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegAtracDecode currentTimestamp=%d", this.mpegAtracAu.pts));
        }
        return result;
    }

    protected int getPacketsFromSize(int size) {
        int packets = size / 2152;
        return packets;
    }

    private int getSizeFromPackets(int packets) {
        int size = packets * 104 + packets * 2048;
        return size;
    }

    @HLEFunction(nid=-677208250, version=150, checkInsideInterrupt=true)
    public int sceMpegRingbufferQueryMemSize(int packets) {
        return this.getSizeFromPackets(packets);
    }

    @HLEFunction(nid=925458136, version=150, checkInsideInterrupt=true)
    public int sceMpegRingbufferConstruct(TPointer ringbufferAddr, int packets, TPointer data, int size, @CanBeNull TPointer callbackAddr, int callbackArgs) {
        if (size < this.getSizeFromPackets(packets)) {
            log.warn((Object)String.format("sceMpegRingbufferConstruct insufficient space: size=%d, packets=%d", size, packets));
            return -2141126622;
        }
        SceMpegRingbuffer ringbuffer = new SceMpegRingbuffer(packets, data.getAddress(), size, callbackAddr.getAddress(), callbackArgs);
        ringbuffer.write(ringbufferAddr);
        this.maxAheadTimestamp = sceMpeg.getMaxAheadTimestamp(packets);
        return 0;
    }

    @HLEFunction(nid=322993939, version=150, checkInsideInterrupt=true)
    public int sceMpegRingbufferDestruct(TPointer ringbufferAddr) {
        if (this.mpegRingbuffer != null) {
            this.mpegRingbuffer.read(ringbufferAddr);
            this.mpegRingbuffer.reset();
            this.mpegRingbuffer.write(ringbufferAddr);
            this.mpegRingbuffer = null;
            this.mpegRingbufferAddr = null;
        }
        return 0;
    }

    @HLEFunction(nid=-1304386146, version=150, checkInsideInterrupt=true)
    public int sceMpegRingbufferPut(TPointer ringbufferAddr, int numPackets, int available) {
        this.mpegRingbufferAddr = ringbufferAddr;
        if (numPackets < 0) {
            return 0;
        }
        int numberPackets = Math.min(available, numPackets);
        if (numberPackets <= 0) {
            return 0;
        }
        if (!this.isCurrentMpegAnalyzed() && this.ringbufferPutIoListener == null) {
            this.ringbufferPutIoListener = new MpegRingbufferPutIoListener();
            Modules.IoFileMgrForUserModule.registerIoListener(this.ringbufferPutIoListener);
        }
        this.mpegRingbuffer.read(this.mpegRingbufferAddr);
        this.insideRingbufferPut = true;
        Modules.ThreadManForUserModule.executeCallback(null, this.mpegRingbuffer.callback_addr, this.afterRingbufferPutCallback, false, this.mpegRingbuffer.data, numberPackets, this.mpegRingbuffer.callback_args);
        return Emulator.getProcessor().cpu._v0;
    }

    @HLEFunction(nid=-1242112889, version=150, checkInsideInterrupt=true)
    public int sceMpegRingbufferAvailableSize(TPointer ringbufferAddr) {
        this.mpegRingbufferAddr = ringbufferAddr;
        this.mpegRingbuffer.read(this.mpegRingbufferAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegRingbufferAvailableSize returning %d", this.mpegRingbuffer.packetsFree));
        }
        return this.mpegRingbuffer.packetsFree;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1010280358, version=150, checkInsideInterrupt=true)
    public int sceMpegNextAvcRpAu(int p1, int p2, int p3, int p4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=26701908, version=150)
    public int sceMpegGetUserdataAu(@CheckArgument(value="checkMpegHandle") int mpeg, int streamUid, TPointer auAddr, @CanBeNull TPointer32 resultAddr) {
        resultAddr.setValue(0, 0);
        resultAddr.setValue(4, 0);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1000564276, version=150)
    public int sceMpegQueryUserdataEsSize(@CheckArgument(value="checkMpegHandle") int mpeg, TPointer32 esSizeAddr, TPointer32 outSizeAddr) {
        esSizeAddr.setValue(655360);
        outSizeAddr.setValue(655360);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=89698421, version=150)
    public int sceMpegAvcCopyYCbCr(@CheckArgument(value="checkMpegHandle") int mpeg, TPointer sourceAddr, TPointer YCbCrAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=301554929, version=150)
    public int sceMpegGetAvcNalAu() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1843409713, version=150)
    public int sceMpegGetAvcEsAu() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1865499664, version=150)
    public int sceMpegAvcDecodeGetDecodeSEI() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1425107626, version=150)
    public int sceMpegAvcDecodeDetailIndex() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-818591838, version=150)
    public int sceMpegAvcDecodeDetail2() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-169350607, version=150)
    public int sceMpegAvcConvertToYuv420(int mpeg, TPointer bufferOutput, TPointer unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-775009968, version=150)
    public int sceMpegAvcCscMode() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-608827816, version=150)
    public int sceMpegFlushAu() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-380094218, version=150)
    public int sceMpegAvcCscInfo() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=298497113, version=150)
    public int sceMpeg_11CAB459() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1300819544, version=150)
    public int sceMpeg_B27711A8() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-723685771, version=150)
    public int sceMpeg_D4DD6E75() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1018831150, version=150)
    public int sceMpeg_C345DED2() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1735483886, version=150)
    public int sceMpeg_988E9E12() {
        return 0;
    }

    public class AfterRingbufferPutCallback
    implements IAction {
        @Override
        public void execute() {
            sceMpeg.this.hleMpegRingbufferPostPut();
        }
    }

    private static class MpegHeaderIoListener
    implements IoFileMgrForUser.IIoListener {
        private MpegHeaderIoListener() {
        }

        @Override
        public void sceIoSync(int result, int device_addr, String device, int unknown) {
        }

        @Override
        public void sceIoPollAsync(int result, int uid, int res_addr) {
        }

        @Override
        public void sceIoWaitAsync(int result, int uid, int res_addr) {
        }

        @Override
        public void sceIoOpen(int result, int filename_addr, String filename, int flags, int permissions, String mode) {
        }

        @Override
        public void sceIoClose(int result, int uid) {
        }

        @Override
        public void sceIoWrite(int result, int uid, int data_addr, int size, int bytesWritten) {
        }

        @Override
        public void sceIoRead(int result, int uid, int data_addr, int size, int bytesRead, long position, SeekableDataInput dataInput, IVirtualFile vFile) {
            Modules.sceMpegModule.onHeaderIoRead(data_addr, bytesRead, position, dataInput, vFile);
        }

        @Override
        public void sceIoCancel(int result, int uid) {
        }

        @Override
        public void sceIoSeek32(int result, int uid, int offset, int whence) {
        }

        @Override
        public void sceIoSeek64(long result, int uid, long offset, int whence) {
        }

        @Override
        public void sceIoMkdir(int result, int path_addr, String path, int permissions) {
        }

        @Override
        public void sceIoRmdir(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoChdir(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoDopen(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoDread(int result, int uid, int dirent_addr) {
        }

        @Override
        public void sceIoDclose(int result, int uid) {
        }

        @Override
        public void sceIoDevctl(int result, int device_addr, String device, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        }

        @Override
        public void sceIoIoctl(int result, int uid, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        }

        @Override
        public void sceIoAssign(int result, int dev1_addr, String dev1, int dev2_addr, String dev2, int dev3_addr, String dev3, int mode, int unk1, int unk2) {
        }

        @Override
        public void sceIoGetStat(int result, int path_addr, String path, int stat_addr) {
        }

        @Override
        public void sceIoRemove(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoChstat(int result, int path_addr, String path, int stat_addr, int bits) {
        }

        @Override
        public void sceIoRename(int result, int path_addr, String path, int new_path_addr, String newpath) {
        }
    }

    private static class MpegRingbufferPutIoListener
    implements IoFileMgrForUser.IIoListener {
        private MpegRingbufferPutIoListener() {
        }

        @Override
        public void sceIoSync(int result, int device_addr, String device, int unknown) {
        }

        @Override
        public void sceIoPollAsync(int result, int uid, int res_addr) {
        }

        @Override
        public void sceIoWaitAsync(int result, int uid, int res_addr) {
        }

        @Override
        public void sceIoOpen(int result, int filename_addr, String filename, int flags, int permissions, String mode) {
        }

        @Override
        public void sceIoClose(int result, int uid) {
        }

        @Override
        public void sceIoWrite(int result, int uid, int data_addr, int size, int bytesWritten) {
        }

        @Override
        public void sceIoRead(int result, int uid, int data_addr, int size, int bytesRead, long position, SeekableDataInput dataInput, IVirtualFile vFile) {
            Modules.sceMpegModule.onRingbufferPutIoRead(dataInput, vFile, data_addr, bytesRead);
        }

        @Override
        public void sceIoCancel(int result, int uid) {
        }

        @Override
        public void sceIoSeek32(int result, int uid, int offset, int whence) {
        }

        @Override
        public void sceIoSeek64(long result, int uid, long offset, int whence) {
        }

        @Override
        public void sceIoMkdir(int result, int path_addr, String path, int permissions) {
        }

        @Override
        public void sceIoRmdir(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoChdir(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoDopen(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoDread(int result, int uid, int dirent_addr) {
        }

        @Override
        public void sceIoDclose(int result, int uid) {
        }

        @Override
        public void sceIoDevctl(int result, int device_addr, String device, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        }

        @Override
        public void sceIoIoctl(int result, int uid, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        }

        @Override
        public void sceIoAssign(int result, int dev1_addr, String dev1, int dev2_addr, String dev2, int dev3_addr, String dev3, int mode, int unk1, int unk2) {
        }

        @Override
        public void sceIoGetStat(int result, int path_addr, String path, int stat_addr) {
        }

        @Override
        public void sceIoRemove(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoChstat(int result, int path_addr, String path, int stat_addr, int bits) {
        }

        @Override
        public void sceIoRename(int result, int path_addr, String path, int new_path_addr, String newpath) {
        }
    }

    private class StreamInfo {
        private int uid;
        private int type;

        public StreamInfo(int type) {
            this.type = type;
            this.uid = SceUidManager.getNewUid(sceMpeg.streamPurpose);
            sceMpeg.this.streamMap.put(this.uid, this);
        }

        public int getUid() {
            return this.uid;
        }

        public int getType() {
            return this.type;
        }

        public void release() {
            SceUidManager.releaseUid(this.uid, sceMpeg.streamPurpose);
            sceMpeg.this.streamMap.remove(this.uid);
            this.uid = -1;
            this.type = -1;
        }
    }

    private class EnableMediaEngineSettingsListener
    extends AbstractBoolSettingsListener {
        private EnableMediaEngineSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceMpeg.setEnableMediaEngine(value);
        }
    }

    private class EnableConnectorSettingsListener
    extends AbstractBoolSettingsListener {
        private EnableConnectorSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceMpeg.setEnableConnector(value);
        }
    }
}

