/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.sceMpeg;
import jpcsp.Memory;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

@HLELogging
public class scePsmf
extends HLEModule {
    public static Logger log = Modules.getLogger("scePsmf");
    private HashMap<Integer, PSMFHeader> psmfHeaderMap;

    @Override
    public String getName() {
        return "scePsmf";
    }

    @Override
    public void start() {
        this.psmfHeaderMap = new HashMap();
        super.start();
    }

    public TPointer32 checkPsmf(TPointer32 psmf) {
        int headerAddress = psmf.getValue(24);
        if (!this.psmfHeaderMap.containsKey(headerAddress)) {
            throw new SceKernelErrorException(-2141106139);
        }
        return psmf;
    }

    public TPointer32 checkPsmfWithEPMap(TPointer32 psmf) {
        PSMFHeader header = this.getPsmfHeader(psmf = this.checkPsmf(psmf));
        if (!header.hasEPMap()) {
            throw new SceKernelErrorException(-2141106139);
        }
        return psmf;
    }

    private PSMFHeader getPsmfHeader(TPointer32 psmf) {
        int headerAddress = psmf.getValue(24);
        return this.psmfHeaderMap.get(headerAddress);
    }

    @HLELogging(level="info")
    @HLEFunction(nid=-1037270233, version=150, checkInsideInterrupt=true)
    public int scePsmfSetPsmf(TPointer32 psmf, TPointer bufferAddr) {
        Modules.sceMpegModule.setCurrentMpegAnalyzed(false);
        PSMFHeader header = new PSMFHeader(bufferAddr.getAddress());
        this.psmfHeaderMap.put(header.getHeaderOffset(), header);
        psmf.setValue(0, header.getVersion());
        psmf.setValue(4, header.getHeaderSize());
        psmf.setValue(8, header.getStreamSize());
        psmf.setValue(12, 0);
        psmf.setValue(16, 0);
        psmf.setValue(20, header.getCurrentStreamNumber());
        psmf.setValue(24, header.getHeaderOffset());
        return 0;
    }

    @HLEFunction(nid=-941933989, version=150, checkInsideInterrupt=true)
    public int scePsmfGetCurrentStreamType(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 typeAddr, TPointer32 channelAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        typeAddr.setValue(header.getCurrentStreamType());
        channelAddr.setValue(header.getCurrentStreamChannel());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfGetCurrentStreamType returning type=%d, channel=%d", typeAddr.getValue(), channelAddr.getValue()));
        }
        return 0;
    }

    @HLEFunction(nid=673449320, version=150, checkInsideInterrupt=true)
    public int scePsmfGetCurrentStreamNumber(@CheckArgument(value="checkPsmf") TPointer32 psmf) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        return header.getCurrentStreamNumber();
    }

    @HLEFunction(nid=510496787, version=150, checkInsideInterrupt=true)
    public int scePsmfSpecifyStreamWithStreamType(@CheckArgument(value="checkPsmf") TPointer32 psmf, int type, int ch) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (!header.setStreamWithType(type, ch)) {
            return -2141105920;
        }
        return 0;
    }

    @HLEFunction(nid=1271512544, version=150, checkInsideInterrupt=true)
    public int scePsmfSpecifyStream(@CheckArgument(value="checkPsmf") TPointer32 psmf, int streamNum) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        header.setStreamNum(streamNum);
        return 0;
    }

    @HLEFunction(nid=1993584314, version=150, checkInsideInterrupt=true)
    public int scePsmfGetPresentationStartTime(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 startTimeAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        int startTime = header.getPresentationStartTime();
        startTimeAddr.setValue(startTime);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfGetPresentationStartTime startTime=%d", startTime));
        }
        return 0;
    }

    @HLEFunction(nid=-1114971944, version=150, checkInsideInterrupt=true)
    public int scePsmfGetPresentationEndTime(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 endTimeAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        int endTime = header.getPresentationEndTime();
        endTimeAddr.setValue(endTime);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfGetPresentationEndTime endTime=%d", endTime));
        }
        return 0;
    }

    @HLEFunction(nid=-353531443, version=150, checkInsideInterrupt=true)
    public int scePsmfGetNumberOfStreams(@CheckArgument(value="checkPsmf") TPointer32 psmf) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        return header.getNumberOfStreams();
    }

    @HLEFunction(nid=1955710008, version=150, checkInsideInterrupt=true)
    public int scePsmfGetNumberOfEPentries(@CheckArgument(value="checkPsmf") TPointer32 psmf) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        return header.getEPMapEntriesNum();
    }

    @HLEFunction(nid=195368165, version=150, checkInsideInterrupt=true)
    public int scePsmfGetVideoInfo(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 videoInfoAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        videoInfoAddr.setValue(0, header.getVideoWidth());
        videoInfoAddr.setValue(4, header.getvideoHeigth());
        return 0;
    }

    @HLEFunction(nid=-1472237293, version=150, checkInsideInterrupt=true)
    public int scePsmfGetAudioInfo(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 audioInfoAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        audioInfoAddr.setValue(0, header.getAudioChannelConfig());
        audioInfoAddr.setValue(4, header.getAudioSampleFrequency());
        return 0;
    }

    @HLEFunction(nid=-1759888752, version=150, checkInsideInterrupt=true)
    public int scePsmfCheckEPmap(@CheckArgument(value="checkPsmf") TPointer32 psmf) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        return header.hasEPMap() ? 0 : -2141106139;
    }

    @HLEFunction(nid=1315064372, version=150, checkInsideInterrupt=true)
    public int scePsmfGetEPWithId(@CheckArgument(value="checkPsmfWithEPMap") TPointer32 psmf, int id, TPointer32 outAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        PSMFEntry entry = header.getEPMapEntry(id);
        if (entry == null) {
            return -2141105920;
        }
        outAddr.setValue(0, entry.getEntryPTS());
        outAddr.setValue(4, entry.getEntryOffset());
        outAddr.setValue(8, entry.getEntryIndex());
        outAddr.setValue(12, entry.getEntryPicOffset());
        return 0;
    }

    @HLEFunction(nid=2081323715, version=150, checkInsideInterrupt=true)
    public int scePsmfGetEPWithTimestamp(@CheckArgument(value="checkPsmfWithEPMap") TPointer32 psmf, int ts, TPointer32 entryAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (ts < header.getPresentationStartTime()) {
            return -2141104896;
        }
        PSMFEntry entry = header.getEPMapEntryWithTimestamp(ts);
        if (entry == null) {
            return -1;
        }
        entryAddr.setValue(0, entry.getEntryPTS());
        entryAddr.setValue(4, entry.getEntryOffset());
        entryAddr.setValue(8, entry.getEntryIndex());
        entryAddr.setValue(12, entry.getEntryPicOffset());
        return 0;
    }

    @HLEFunction(nid=1598387477, version=150, checkInsideInterrupt=true)
    public int scePsmfGetEPidWithTimestamp(@CheckArgument(value="checkPsmfWithEPMap") TPointer32 psmf, int ts) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (ts < header.getPresentationStartTime()) {
            return -2141104896;
        }
        PSMFEntry entry = header.getEPMapEntryWithTimestamp(ts);
        if (entry == null) {
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfGetEPidWithTimestamp returning id 0x%X", entry.getId()));
        }
        return entry.getId();
    }

    @HLEFunction(nid=1534131393, version=150, checkInsideInterrupt=true)
    public int scePsmfQueryStreamOffset(TPointer bufferAddr, TPointer32 offsetAddr) {
        int offset = Utilities.endianSwap32(bufferAddr.getValue32(8));
        offsetAddr.setValue(offset);
        Modules.sceMpegModule.analyseMpeg(bufferAddr.getAddress());
        return 0;
    }

    @HLEFunction(nid=-1789670255, version=150, checkInsideInterrupt=true)
    public int scePsmfQueryStreamSize(TPointer bufferAddr, TPointer32 sizeAddr) {
        int size = Utilities.endianSwap32(bufferAddr.getValue32(12));
        sizeAddr.setValue(size);
        Modules.sceMpegModule.analyseMpeg(bufferAddr.getAddress());
        return 0;
    }

    @HLEFunction(nid=1758733096, version=150, checkInsideInterrupt=true)
    public int scePsmfGetNumberOfSpecificStreams(@CheckArgument(value="checkPsmf") TPointer32 psmf, int streamType) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        int streamNum = header.getSpecificStreamNum(streamType);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfGetNumberOfSpecificStreams returning %d", streamNum));
        }
        return streamNum;
    }

    @HLEFunction(nid=202509853, version=150, checkInsideInterrupt=true)
    public int scePsmfSpecifyStreamWithStreamTypeNumber(@CheckArgument(value="checkPsmf") TPointer32 psmf, int type, int typeNum) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (!header.setStreamWithTypeNum(type, typeNum)) {
            return -2141105920;
        }
        return 0;
    }

    @HLEFunction(nid=645096555, version=150, checkInsideInterrupt=true)
    public int scePsmfVerifyPsmf(TPointer bufferAddr) {
        int magic;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("scePsmfVerifyPsmf %s", Utilities.getMemoryDump(bufferAddr.getAddress(), 2048)));
        }
        if ((magic = bufferAddr.getValue32(0)) != 1179472720) {
            return -2141104895;
        }
        int rawVersion = bufferAddr.getValue32(4);
        int version = sceMpeg.getMpegVersion(rawVersion);
        if (version < 0) {
            return -2141104895;
        }
        return 0;
    }

    @HLEFunction(nid=-1215383063, version=150, checkInsideInterrupt=true)
    public int scePsmfGetHeaderSize(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 sizeAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        sizeAddr.setValue(header.getHeaderSize());
        return 0;
    }

    @HLEFunction(nid=-1511260543, version=150, checkInsideInterrupt=true)
    public int scePsmfGetStreamSize(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 sizeAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        sizeAddr.setValue(header.getStreamSize());
        return 0;
    }

    @HLEFunction(nid=-517457771, version=150, checkInsideInterrupt=true)
    public int scePsmfGetPsmfVersion(@CheckArgument(value="checkPsmf") TPointer32 psmf) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        return header.getVersion();
    }

    protected static class PSMFHeader {
        private static final int size = 2048;
        private static final int PSMF_VIDEO_STREAM_ID = 224;
        private static final int PSMF_AUDIO_STREAM_ID = 189;
        private static final int PSMF_AVC_STREAM = 0;
        private static final int PSMF_ATRAC_STREAM = 1;
        private static final int PSMF_PCM_STREAM = 2;
        private static final int PSMF_DATA_STREAM = 3;
        private static final int PSMF_AUDIO_STREAM = 15;
        private int streamOffset;
        private int streamSize;
        private int version;
        private int presentationStartTime;
        private int presentationEndTime;
        private int streamNum;
        private int audioSampleFrequency;
        private int audioChannelConfig;
        private int videoWidth;
        private int videoHeigth;
        private int EPMapEntriesNum;
        private int headerOffset;
        private int EPMapOffset;
        private HashMap<Integer, PSMFEntry> EPMap;
        private int currentEntryNumber;
        private List<PSMFStream> streams;
        private int currentStreamNumber = -1;
        private int currentVideoStreamNumber = -1;
        private int currentAudioStreamNumber = -1;

        public PSMFHeader(int addr) {
            int i;
            Memory mem = Memory.getInstance();
            if (mem.read32(addr) != 1179472720) {
                log.warn((Object)"Invalid PSMF detected!");
            }
            this.headerOffset = addr;
            this.version = mem.read32(addr + 4);
            this.streamOffset = Utilities.endianSwap32(mem.read32(addr + 8));
            this.streamSize = Utilities.endianSwap32(mem.read32(addr + 12));
            int streamDataTotalSize = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 80));
            this.presentationStartTime = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 86));
            this.presentationEndTime = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 92));
            int unk = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 96));
            int streamDataNextBlockSize = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 106));
            int streamDataNextInnerBlockSize = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 124));
            this.streamNum = Utilities.endianSwap16(mem.read16(addr + 128));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("PSMFHeader: streamDataTotalSize=%d, unk=0x%08X, streamDataNextBlockSize=%d, streamDataNextInnerBlockSize=%d, streamNum=%d", streamDataTotalSize, unk, streamDataNextBlockSize, streamDataNextInnerBlockSize, this.streamNum));
            }
            this.streams = new LinkedList<PSMFStream>();
            int numberOfStreams = 0;
            for (i = 0; i < this.streamNum; ++i) {
                PSMFStream stream = null;
                int currentStreamAddr = addr + 130 + i * 16;
                int streamID = mem.read8(currentStreamAddr);
                if ((streamID & 0xF0) == 224) {
                    stream = new PSMFStream(numberOfStreams);
                    stream.readMPEGVideoStreamParams(currentStreamAddr);
                } else if (streamID == 189) {
                    stream = new PSMFStream(numberOfStreams);
                    stream.readPrivateAudioStreamParams(currentStreamAddr);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Unknown stream found in header: 0x%02X", streamID));
                }
                if (stream == null) continue;
                this.streams.add(stream);
                ++numberOfStreams;
            }
            this.EPMap = new HashMap();
            for (i = 0; i < this.EPMapEntriesNum; ++i) {
                int id;
                int index = mem.read8(addr + this.EPMapOffset + i * 10);
                int picOffset = mem.read8(addr + this.EPMapOffset + 1 + i * 10);
                int pts = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + this.EPMapOffset + 2 + i * 10));
                int offset = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + this.EPMapOffset + 6 + i * 10));
                ++this.currentEntryNumber;
                PSMFEntry pEnt = new PSMFEntry(id, index, picOffset, pts, offset);
                this.EPMap.put(id, pEnt);
            }
        }

        public int getVersion() {
            return this.version;
        }

        public int getHeaderSize() {
            return 2048;
        }

        public int getHeaderOffset() {
            return this.headerOffset;
        }

        public int getStreamOffset() {
            return this.streamOffset;
        }

        public int getStreamSize() {
            return this.streamSize;
        }

        public int getPresentationStartTime() {
            return this.presentationStartTime;
        }

        public int getPresentationEndTime() {
            return this.presentationEndTime;
        }

        public int getVideoWidth() {
            return this.videoWidth;
        }

        public int getvideoHeigth() {
            return this.videoHeigth;
        }

        public int getAudioSampleFrequency() {
            return this.audioSampleFrequency;
        }

        public int getAudioChannelConfig() {
            return this.audioChannelConfig;
        }

        public int getEPMapOffset() {
            return this.EPMapOffset;
        }

        public int getEPMapEntriesNum() {
            return this.EPMapEntriesNum;
        }

        public boolean hasEPMap() {
            return this.getEPMapEntriesNum() > 0;
        }

        public PSMFEntry getEPMapEntry(int id) {
            return this.EPMap.get(id);
        }

        public PSMFEntry getEPMapEntryWithTimestamp(int ts) {
            PSMFEntry foundEntry = null;
            for (PSMFEntry entry : this.EPMap.values()) {
                if (foundEntry == null || entry.getEntryPTS() <= ts) {
                    foundEntry = entry;
                    continue;
                }
                if (entry.getEntryPTS() <= ts) continue;
                break;
            }
            return foundEntry;
        }

        public int getNumberOfStreams() {
            return this.streamNum;
        }

        public int getCurrentStreamNumber() {
            return this.currentStreamNumber;
        }

        public int getCurrentStreamType() {
            if (this.currentStreamNumber >= 0 && this.currentStreamNumber < this.streams.size()) {
                return this.streams.get(this.currentStreamNumber).getStreamType();
            }
            return -1;
        }

        public int getCurrentStreamChannel() {
            if (this.currentStreamNumber >= 0 && this.currentStreamNumber < this.streams.size()) {
                return this.streams.get(this.currentStreamNumber).getStreamChannel();
            }
            return -1;
        }

        public int getSpecificStreamNum(int type) {
            int num = 0;
            for (PSMFStream stream : this.streams) {
                if (!stream.isStreamOfType(type)) continue;
                ++num;
            }
            return num;
        }

        private void setVideoStreamNum(int id, int channel) {
            if (this.currentVideoStreamNumber != id) {
                Modules.sceMpegModule.setRegisteredVideoChannel(channel);
                this.currentVideoStreamNumber = id;
            }
        }

        private void setAudioStreamNum(int id, int channel) {
            if (this.currentAudioStreamNumber != id) {
                Modules.sceMpegModule.setRegisteredAudioChannel(channel);
                this.currentAudioStreamNumber = id;
            }
        }

        public void setStreamNum(int id) {
            this.currentStreamNumber = id;
            int type = this.getCurrentStreamType();
            int channel = this.getCurrentStreamChannel();
            switch (type) {
                case 0: {
                    this.setVideoStreamNum(id, channel);
                    break;
                }
                case 1: 
                case 2: {
                    this.setAudioStreamNum(id, channel);
                }
            }
        }

        private int getStreamNumber(int type, int typeNum, int channel) {
            for (PSMFStream stream : this.streams) {
                if (!stream.isStreamOfType(type)) continue;
                if (typeNum <= 0 && (channel < 0 || stream.getStreamChannel() == channel)) {
                    return stream.getStreamNumber();
                }
                --typeNum;
            }
            return -1;
        }

        public boolean setStreamWithType(int type, int channel) {
            int streamNumber = this.getStreamNumber(type, 0, channel);
            if (streamNumber < 0) {
                return false;
            }
            this.setStreamNum(streamNumber);
            return true;
        }

        public boolean setStreamWithTypeNum(int type, int typeNum) {
            int streamNumber = this.getStreamNumber(type, typeNum, -1);
            if (streamNumber < 0) {
                return false;
            }
            this.setStreamNum(streamNumber);
            return true;
        }

        protected class PSMFStream {
            private int streamType = -1;
            private int streamChannel = -1;
            private int streamNumber;

            public PSMFStream(int streamNumber) {
                this.streamNumber = streamNumber;
            }

            public int getStreamType() {
                return this.streamType;
            }

            public int getStreamChannel() {
                return this.streamChannel;
            }

            public int getStreamNumber() {
                return this.streamNumber;
            }

            public boolean isStreamOfType(int type) {
                if (this.streamType == type) {
                    return true;
                }
                if (type == 15) {
                    return this.streamType == 1 || this.streamType == 2;
                }
                return type == 3;
            }

            public void readMPEGVideoStreamParams(int addr) {
                Memory mem = Memory.getInstance();
                int streamID = mem.read8(addr);
                int privateStreamID = mem.read8(addr + 1);
                int unk1 = mem.read8(addr + 2);
                int unk2 = mem.read8(addr + 3);
                PSMFHeader.this.EPMapOffset = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 4));
                PSMFHeader.this.EPMapEntriesNum = Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr + 8));
                PSMFHeader.this.videoWidth = mem.read8(addr + 12) * 16;
                PSMFHeader.this.videoHeigth = mem.read8(addr + 13) * 16;
                log.info((Object)("Found PSMF MPEG video stream data: streamID=0x" + Integer.toHexString(streamID) + ", privateStreamID=0x" + Integer.toHexString(privateStreamID) + ", unk1=0x" + Integer.toHexString(unk1) + ", unk2=0x" + Integer.toHexString(unk2) + ", EPMapOffset=0x" + Integer.toHexString(PSMFHeader.this.EPMapOffset) + ", EPMapEntriesNum=" + PSMFHeader.this.EPMapEntriesNum + ", videoWidth=" + PSMFHeader.this.videoWidth + ", videoHeigth=" + PSMFHeader.this.videoHeigth));
                this.streamType = 0;
                this.streamChannel = streamID & 0xF;
            }

            public void readPrivateAudioStreamParams(int addr) {
                Memory mem = Memory.getInstance();
                int streamID = mem.read8(addr);
                int privateStreamID = mem.read8(addr + 1);
                int unk1 = mem.read8(addr + 2);
                int unk2 = mem.read8(addr + 3);
                PSMFHeader.this.audioChannelConfig = mem.read8(addr + 14);
                PSMFHeader.this.audioSampleFrequency = mem.read8(addr + 15);
                log.info((Object)("Found PSMF private audio stream data: streamID=0x" + Integer.toHexString(streamID) + ", privateStreamID=0x" + Integer.toHexString(privateStreamID) + ", unk1=0x" + Integer.toHexString(unk1) + ", unk2=0x" + Integer.toHexString(unk2) + ", audioChannelConfig=" + PSMFHeader.this.audioChannelConfig + ", audioSampleFrequency=" + PSMFHeader.this.audioSampleFrequency));
                this.streamType = (privateStreamID & 0xF0) == 0 ? 1 : 2;
                this.streamChannel = privateStreamID & 0xF;
            }
        }
    }

    protected static class PSMFEntry {
        private int EPIndex;
        private int EPPicOffset;
        private int EPPts;
        private int EPOffset;
        private int id;

        public PSMFEntry(int id, int index, int picOffset, int pts, int offset) {
            this.id = id;
            this.EPIndex = index;
            this.EPPicOffset = picOffset;
            this.EPPts = pts;
            this.EPOffset = offset;
        }

        public int getEntryIndex() {
            return this.EPIndex;
        }

        public int getEntryPicOffset() {
            return this.EPPicOffset;
        }

        public int getEntryPTS() {
            return this.EPPts;
        }

        public int getEntryOffset() {
            return this.EPOffset;
        }

        public int getId() {
            return this.id;
        }
    }
}

