/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules620;

import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.util.Utilities;

@HLELogging
public class ThreadManForUser
extends jpcsp.HLE.modules380.ThreadManForUser {
    protected static final int PSP_ATTR_ADDR_HIGH = 16384;

    public int checkStackSize(int size) {
        if (size < 512) {
            throw new SceKernelErrorException(-2147352172);
        }
        return size + 255 & 0xFFFFFF00;
    }

    @HLEFunction(nid=-1132401540, version=620, checkInsideInterrupt=true)
    public int sceKernelExtendThreadStack(CpuState cpu, @CheckArgument(value="checkStackSize") int size, TPointer entryAddr, int entryParameter) {
        SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
        int extendedStackAddr = thread.extendStack(size);
        AfterSceKernelExtendThreadStackAction afterAction = new AfterSceKernelExtendThreadStackAction(thread, cpu.pc, cpu._sp, cpu._ra);
        cpu._a0 = entryParameter;
        cpu._sp = extendedStackAddr + size;
        Modules.ThreadManForUserModule.callAddress(entryAddr.getAddress(), afterAction, false);
        return 0;
    }

    @HLEFunction(nid=-1917847977, version=620)
    public int ThreadManForUser_8DAFF657(PspString name, int partitionid, int attr, int blockSize, int numberBlocks, @CanBeNull TPointer optionsAddr) {
        int length;
        int type = 3;
        if ((attr & 0x4000) != 0) {
            type = 4;
        }
        int alignment = 4;
        if (optionsAddr.isNotNull() && (length = optionsAddr.getValue32(0)) >= 8) {
            alignment = optionsAddr.getValue32(4);
        }
        blockSize = Utilities.alignUp(blockSize, 3);
        int size = blockSize * numberBlocks;
        SysMemUserForUser.SysMemInfo info = Modules.SysMemUserForUserModule.malloc(partitionid, name.getString(), type, size, alignment);
        if (info == null) {
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("ThreadManForUser_8DAFF657 allocated addr 0x%08X, returning 0x%X", info.addr, info.uid));
        }
        return info.uid;
    }

    @HLEFunction(nid=851415950, version=620)
    public int ThreadManForUser_32BF938E(int uid) {
        SysMemUserForUser.SysMemInfo info = Modules.SysMemUserForUserModule.getSysMemInfo(uid);
        if (info == null) {
            return -1;
        }
        Memory.getInstance().memset(info.addr, (byte)0, info.size);
        Modules.SysMemUserForUserModule.free(info);
        return 0;
    }

    private static class AfterSceKernelExtendThreadStackAction
    implements IAction {
        private SceKernelThreadInfo thread;
        private int savedPc;
        private int savedSp;
        private int savedRa;

        public AfterSceKernelExtendThreadStackAction(SceKernelThreadInfo thread, int savedPc, int savedSp, int savedRa) {
            this.thread = thread;
            this.savedPc = savedPc;
            this.savedSp = savedSp;
            this.savedRa = savedRa;
        }

        @Override
        public void execute() {
            CpuState cpu = Emulator.getProcessor().cpu;
            if (jpcsp.HLE.modules150.ThreadManForUser.log.isDebugEnabled()) {
                jpcsp.HLE.modules150.ThreadManForUser.log.debug((Object)String.format("AfterSceKernelExtendThreadStackAction savedSp=0x%08X, savedRa=0x%08X", this.savedSp, this.savedRa));
            }
            cpu.pc = this.savedPc;
            cpu._sp = this.savedSp;
            cpu._ra = this.savedRa;
            this.thread.freeExtendedStack();
        }
    }
}

