/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import java.nio.Buffer;
import java.nio.IntBuffer;
import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.buffer.IREBufferManager;
import jpcsp.graphics.VertexInfo;
import jpcsp.graphics.VideoEngine;
import org.apache.log4j.Logger;

public class BaseRenderingEngineProxy
implements IRenderingEngine {
    protected static final Logger log = VideoEngine.log;
    protected IRenderingEngine re;
    protected IRenderingEngine proxy;
    protected GeContext context;
    protected static final float[] identityMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    public BaseRenderingEngineProxy(IRenderingEngine proxy) {
        this.proxy = proxy;
        this.re = this;
        proxy.setRenderingEngine(this);
    }

    @Override
    public void setRenderingEngine(IRenderingEngine re) {
        this.re = re;
        this.proxy.setRenderingEngine(re);
    }

    @Override
    public void setGeContext(GeContext context) {
        this.context = context;
        this.proxy.setGeContext(context);
    }

    @Override
    public void exit() {
        this.proxy.exit();
    }

    @Override
    public void endDirectRendering() {
        this.proxy.endDirectRendering();
    }

    @Override
    public void startDirectRendering(boolean textureEnabled, boolean depthWriteEnabled, boolean colorWriteEnabled, boolean setOrthoMatrix, boolean orthoInverted, int width, int height) {
        this.proxy.startDirectRendering(textureEnabled, depthWriteEnabled, colorWriteEnabled, setOrthoMatrix, orthoInverted, width, height);
    }

    @Override
    public void startDisplay() {
        this.proxy.startDisplay();
    }

    @Override
    public void endDisplay() {
        this.proxy.endDisplay();
    }

    @Override
    public void disableFlag(int flag) {
        this.proxy.disableFlag(flag);
    }

    @Override
    public void enableFlag(int flag) {
        this.proxy.enableFlag(flag);
    }

    @Override
    public void setBlendColor(float[] color) {
        this.proxy.setBlendColor(color);
    }

    @Override
    public void setBlendFunc(int src, int dst) {
        this.proxy.setBlendFunc(src, dst);
    }

    @Override
    public void setColorMask(int redMask, int greenMask, int blueMask, int alphaMask) {
        this.proxy.setColorMask(redMask, greenMask, blueMask, alphaMask);
    }

    @Override
    public void setColorMask(boolean redWriteEnabled, boolean greenWriteEnabled, boolean blueWriteEnabled, boolean alphaWriteEnabled) {
        this.proxy.setColorMask(redWriteEnabled, greenWriteEnabled, blueWriteEnabled, alphaWriteEnabled);
    }

    @Override
    public void setColorMaterial(boolean ambient, boolean diffuse, boolean specular) {
        this.proxy.setColorMaterial(ambient, diffuse, specular);
    }

    @Override
    public void setDepthFunc(int func) {
        this.proxy.setDepthFunc(func);
    }

    @Override
    public void setDepthMask(boolean depthWriteEnabled) {
        this.proxy.setDepthMask(depthWriteEnabled);
    }

    @Override
    public void setDepthRange(float zpos, float zscale, float near, float far) {
        this.proxy.setDepthRange(zpos, zscale, near, far);
    }

    @Override
    public void setLightAmbientColor(int light, float[] color) {
        this.proxy.setLightAmbientColor(light, color);
    }

    @Override
    public void setLightConstantAttenuation(int light, float constant) {
        this.proxy.setLightConstantAttenuation(light, constant);
    }

    @Override
    public void setLightDiffuseColor(int light, float[] color) {
        this.proxy.setLightDiffuseColor(light, color);
    }

    @Override
    public void setLightDirection(int light, float[] direction) {
        this.proxy.setLightDirection(light, direction);
    }

    @Override
    public void setLightLinearAttenuation(int light, float linear) {
        this.proxy.setLightLinearAttenuation(light, linear);
    }

    @Override
    public void setLightMode(int mode) {
        this.proxy.setLightMode(mode);
    }

    @Override
    public void setLightModelAmbientColor(float[] color) {
        this.proxy.setLightModelAmbientColor(color);
    }

    @Override
    public void setLightPosition(int light, float[] position) {
        this.proxy.setLightPosition(light, position);
    }

    @Override
    public void setLightQuadraticAttenuation(int light, float quadratic) {
        this.proxy.setLightQuadraticAttenuation(light, quadratic);
    }

    @Override
    public void setLightSpecularColor(int light, float[] color) {
        this.proxy.setLightSpecularColor(light, color);
    }

    @Override
    public void setLightSpotCutoff(int light, float cutoff) {
        this.proxy.setLightSpotCutoff(light, cutoff);
    }

    @Override
    public void setLightSpotExponent(int light, float exponent) {
        this.proxy.setLightSpotExponent(light, exponent);
    }

    @Override
    public void setLightType(int light, int type, int kind) {
        this.proxy.setLightType(light, type, kind);
    }

    @Override
    public void setLogicOp(int logicOp) {
        this.proxy.setLogicOp(logicOp);
    }

    @Override
    public void setMaterialAmbientColor(float[] color) {
        this.proxy.setMaterialAmbientColor(color);
    }

    @Override
    public void setMaterialDiffuseColor(float[] color) {
        this.proxy.setMaterialDiffuseColor(color);
    }

    @Override
    public void setMaterialEmissiveColor(float[] color) {
        this.proxy.setMaterialEmissiveColor(color);
    }

    @Override
    public void setMaterialSpecularColor(float[] color) {
        this.proxy.setMaterialSpecularColor(color);
    }

    @Override
    public void setMatrix(float[] values) {
        this.proxy.setMatrix(values);
    }

    @Override
    public void setMatrixMode(int type) {
        this.proxy.setMatrixMode(type);
    }

    @Override
    public void multMatrix(float[] values) {
        this.proxy.multMatrix(values);
    }

    @Override
    public void setModelMatrix(float[] values) {
        this.proxy.setModelMatrix(values);
    }

    @Override
    public void endModelViewMatrixUpdate() {
        this.proxy.endModelViewMatrixUpdate();
    }

    @Override
    public void setModelViewMatrix(float[] values) {
        this.proxy.setModelViewMatrix(values);
    }

    @Override
    public void setMorphWeight(int index, float value) {
        this.proxy.setMorphWeight(index, value);
    }

    @Override
    public void setPatchDiv(int s, int t) {
        this.proxy.setPatchDiv(s, t);
    }

    @Override
    public void setPatchPrim(int prim) {
        this.proxy.setPatchPrim(prim);
    }

    @Override
    public void setProjectionMatrix(float[] values) {
        this.proxy.setProjectionMatrix(values);
    }

    @Override
    public void setShadeModel(int model) {
        this.proxy.setShadeModel(model);
    }

    @Override
    public void setTextureEnvironmentMapping(int u, int v) {
        this.proxy.setTextureEnvironmentMapping(u, v);
    }

    @Override
    public void setTextureMatrix(float[] values) {
        this.proxy.setTextureMatrix(values);
    }

    @Override
    public void setTextureMipmapMaxLevel(int level) {
        this.proxy.setTextureMipmapMaxLevel(level);
    }

    @Override
    public void setTextureMipmapMinLevel(int level) {
        this.proxy.setTextureMipmapMinLevel(level);
    }

    @Override
    public void setTextureMipmapMinFilter(int filter) {
        this.proxy.setTextureMipmapMinFilter(filter);
    }

    @Override
    public void setTextureMipmapMagFilter(int filter) {
        this.proxy.setTextureMipmapMagFilter(filter);
    }

    @Override
    public void setTextureWrapMode(int s, int t) {
        this.proxy.setTextureWrapMode(s, t);
    }

    @Override
    public void setVertexColor(float[] color) {
        this.proxy.setVertexColor(color);
    }

    @Override
    public void setViewMatrix(float[] values) {
        this.proxy.setViewMatrix(values);
    }

    @Override
    public void setViewport(int x, int y, int width, int height) {
        this.proxy.setViewport(x, y, width, height);
    }

    @Override
    public void setUniform(int id, int value) {
        this.proxy.setUniform(id, value);
    }

    @Override
    public void setUniform(int id, int value1, int value2) {
        this.proxy.setUniform(id, value1, value2);
    }

    @Override
    public void setUniform(int id, float value) {
        this.proxy.setUniform(id, value);
    }

    @Override
    public void setUniform2(int id, int[] values) {
        this.proxy.setUniform2(id, values);
    }

    @Override
    public void setUniform3(int id, int[] values) {
        this.proxy.setUniform3(id, values);
    }

    @Override
    public void setUniform3(int id, float[] values) {
        this.proxy.setUniform3(id, values);
    }

    @Override
    public void setUniform4(int id, int[] values) {
        this.proxy.setUniform4(id, values);
    }

    @Override
    public void setUniform4(int id, float[] values) {
        this.proxy.setUniform4(id, values);
    }

    @Override
    public void setUniformMatrix4(int id, int count, float[] values) {
        this.proxy.setUniformMatrix4(id, count, values);
    }

    @Override
    public void setColorTestFunc(int func) {
        this.proxy.setColorTestFunc(func);
    }

    @Override
    public void setColorTestMask(int[] values) {
        this.proxy.setColorTestMask(values);
    }

    @Override
    public void setColorTestReference(int[] values) {
        this.proxy.setColorTestReference(values);
    }

    @Override
    public void setTextureFunc(int func, boolean alphaUsed, boolean colorDoubled) {
        this.proxy.setTextureFunc(func, alphaUsed, colorDoubled);
    }

    @Override
    public int setBones(int count, float[] values) {
        return this.proxy.setBones(count, values);
    }

    @Override
    public void setTextureMapMode(int mode, int proj) {
        this.proxy.setTextureMapMode(mode, proj);
    }

    @Override
    public void setTexEnv(int name, int param) {
        this.proxy.setTexEnv(name, param);
    }

    @Override
    public void setTexEnv(int name, float param) {
        this.proxy.setTexEnv(name, param);
    }

    @Override
    public void endClearMode() {
        this.proxy.endClearMode();
    }

    @Override
    public void startClearMode(boolean color, boolean stencil, boolean depth) {
        this.proxy.startClearMode(color, stencil, depth);
    }

    @Override
    public void attachShader(int program, int shader) {
        this.proxy.attachShader(program, shader);
    }

    @Override
    public boolean compilerShader(int shader, String source) {
        return this.proxy.compilerShader(shader, source);
    }

    @Override
    public int createProgram() {
        return this.proxy.createProgram();
    }

    @Override
    public void useProgram(int program) {
        this.proxy.useProgram(program);
    }

    @Override
    public int createShader(int type) {
        return this.proxy.createShader(type);
    }

    @Override
    public int getAttribLocation(int program, String name) {
        return this.proxy.getAttribLocation(program, name);
    }

    @Override
    public void bindAttribLocation(int program, int index, String name) {
        this.proxy.bindAttribLocation(program, index, name);
    }

    @Override
    public String getProgramInfoLog(int program) {
        return this.proxy.getProgramInfoLog(program);
    }

    @Override
    public String getShaderInfoLog(int shader) {
        return this.proxy.getShaderInfoLog(shader);
    }

    @Override
    public int getUniformLocation(int program, String name) {
        return this.proxy.getUniformLocation(program, name);
    }

    @Override
    public boolean linkProgram(int program) {
        return this.proxy.linkProgram(program);
    }

    @Override
    public boolean validateProgram(int program) {
        return this.proxy.validateProgram(program);
    }

    @Override
    public boolean isExtensionAvailable(String name) {
        return this.proxy.isExtensionAvailable(name);
    }

    @Override
    public void drawArrays(int type, int first, int count) {
        this.proxy.drawArrays(type, first, count);
    }

    @Override
    public void deleteBuffer(int buffer) {
        this.proxy.deleteBuffer(buffer);
    }

    @Override
    public int genBuffer() {
        return this.proxy.genBuffer();
    }

    @Override
    public void setBufferData(int target, int size, Buffer buffer, int usage) {
        this.proxy.setBufferData(target, size, buffer, usage);
    }

    @Override
    public void setBufferSubData(int target, int offset, int size, Buffer buffer) {
        this.proxy.setBufferSubData(target, offset, size, buffer);
    }

    @Override
    public void bindBuffer(int target, int buffer) {
        this.proxy.bindBuffer(target, buffer);
    }

    @Override
    public void enableClientState(int type) {
        this.proxy.enableClientState(type);
    }

    @Override
    public void enableVertexAttribArray(int id) {
        this.proxy.enableVertexAttribArray(id);
    }

    @Override
    public void disableClientState(int type) {
        this.proxy.disableClientState(type);
    }

    @Override
    public void disableVertexAttribArray(int id) {
        this.proxy.disableVertexAttribArray(id);
    }

    @Override
    public void setColorPointer(int size, int type, int stride, long offset) {
        this.proxy.setColorPointer(size, type, stride, offset);
    }

    @Override
    public void setColorPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        this.proxy.setColorPointer(size, type, stride, bufferSize, buffer);
    }

    @Override
    public void setNormalPointer(int type, int stride, long offset) {
        this.proxy.setNormalPointer(type, stride, offset);
    }

    @Override
    public void setNormalPointer(int type, int stride, int bufferSize, Buffer buffer) {
        this.proxy.setNormalPointer(type, stride, bufferSize, buffer);
    }

    @Override
    public void setTexCoordPointer(int size, int type, int stride, long offset) {
        this.proxy.setTexCoordPointer(size, type, stride, offset);
    }

    @Override
    public void setTexCoordPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        this.proxy.setTexCoordPointer(size, type, stride, bufferSize, buffer);
    }

    @Override
    public void setVertexPointer(int size, int type, int stride, long offset) {
        this.proxy.setVertexPointer(size, type, stride, offset);
    }

    @Override
    public void setVertexPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        this.proxy.setVertexPointer(size, type, stride, bufferSize, buffer);
    }

    @Override
    public void setVertexAttribPointer(int id, int size, int type, boolean normalized, int stride, long offset) {
        this.proxy.setVertexAttribPointer(id, size, type, normalized, stride, offset);
    }

    @Override
    public void setVertexAttribPointer(int id, int size, int type, boolean normalized, int stride, int bufferSize, Buffer buffer) {
        this.proxy.setVertexAttribPointer(id, size, type, normalized, stride, bufferSize, buffer);
    }

    @Override
    public void setPixelStore(int rowLength, int alignment) {
        this.proxy.setPixelStore(rowLength, alignment);
    }

    @Override
    public int genTexture() {
        return this.proxy.genTexture();
    }

    @Override
    public void bindTexture(int texture) {
        this.proxy.bindTexture(texture);
    }

    @Override
    public void deleteTexture(int texture) {
        this.proxy.deleteTexture(texture);
    }

    @Override
    public void setCompressedTexImage(int level, int internalFormat, int width, int height, int compressedSize, Buffer buffer) {
        this.proxy.setCompressedTexImage(level, internalFormat, width, height, compressedSize, buffer);
    }

    @Override
    public void setTexImage(int level, int internalFormat, int width, int height, int format, int type, int textureSize, Buffer buffer) {
        this.proxy.setTexImage(level, internalFormat, width, height, format, type, textureSize, buffer);
    }

    @Override
    public void setStencilOp(int fail, int zfail, int zpass) {
        this.proxy.setStencilOp(fail, zfail, zpass);
    }

    @Override
    public void setStencilFunc(int func, int ref, int mask) {
        this.proxy.setStencilFunc(func, ref, mask);
    }

    @Override
    public void setAlphaFunc(int func, int ref) {
        this.proxy.setAlphaFunc(func, ref);
    }

    @Override
    public void setBlendEquation(int mode) {
        this.proxy.setBlendEquation(mode);
    }

    @Override
    public void setFogColor(float[] color) {
        this.proxy.setFogColor(color);
    }

    @Override
    public void setFogDist(float start, float end) {
        this.proxy.setFogDist(start, end);
    }

    @Override
    public void setFrontFace(boolean cw) {
        this.proxy.setFrontFace(cw);
    }

    @Override
    public void setScissor(int x, int y, int width, int height) {
        this.proxy.setScissor(x, y, width, height);
    }

    @Override
    public void setTextureEnvColor(float[] color) {
        this.proxy.setTextureEnvColor(color);
    }

    @Override
    public void setFogHint() {
        this.proxy.setFogHint();
    }

    @Override
    public void setLineSmoothHint() {
        this.proxy.setLineSmoothHint();
    }

    @Override
    public void setMaterialShininess(float shininess) {
        this.proxy.setMaterialShininess(shininess);
    }

    @Override
    public void setTexSubImage(int level, int xOffset, int yOffset, int width, int height, int format, int type, int textureSize, Buffer buffer) {
        this.proxy.setTexSubImage(level, xOffset, yOffset, width, height, format, type, textureSize, buffer);
    }

    @Override
    public void beginQuery(int id) {
        this.proxy.beginQuery(id);
    }

    @Override
    public void endQuery() {
        this.proxy.endQuery();
    }

    @Override
    public int genQuery() {
        return this.proxy.genQuery();
    }

    @Override
    public void drawBoundingBox(float[][] values) {
        this.proxy.drawBoundingBox(values);
    }

    @Override
    public void endBoundingBox(VertexInfo vinfo) {
        this.proxy.endBoundingBox(vinfo);
    }

    @Override
    public void beginBoundingBox(int numberOfVertexBoundingBox) {
        this.proxy.beginBoundingBox(numberOfVertexBoundingBox);
    }

    @Override
    public boolean hasBoundingBox() {
        return this.proxy.hasBoundingBox();
    }

    @Override
    public boolean isBoundingBoxVisible() {
        return this.proxy.isBoundingBoxVisible();
    }

    @Override
    public int getQueryResult(int id) {
        return this.proxy.getQueryResult(id);
    }

    @Override
    public boolean getQueryResultAvailable(int id) {
        return this.proxy.getQueryResultAvailable(id);
    }

    @Override
    public void clear(float red, float green, float blue, float alpha) {
        this.proxy.clear(red, green, blue, alpha);
    }

    @Override
    public void copyTexSubImage(int level, int xOffset, int yOffset, int x, int y, int width, int height) {
        this.proxy.copyTexSubImage(level, xOffset, yOffset, x, y, width, height);
    }

    @Override
    public void getTexImage(int level, int format, int type, Buffer buffer) {
        this.proxy.getTexImage(level, format, type, buffer);
    }

    @Override
    public void setWeightPointer(int size, int type, int stride, long offset) {
        this.proxy.setWeightPointer(size, type, stride, offset);
    }

    @Override
    public void setWeightPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        this.proxy.setWeightPointer(size, type, stride, bufferSize, buffer);
    }

    @Override
    public IREBufferManager getBufferManager() {
        return this.proxy.getBufferManager();
    }

    @Override
    public boolean canAllNativeVertexInfo() {
        return this.proxy.canAllNativeVertexInfo();
    }

    @Override
    public boolean canNativeSpritesPrimitive() {
        return this.proxy.canNativeSpritesPrimitive();
    }

    @Override
    public void setVertexInfo(VertexInfo vinfo, boolean allNativeVertexInfo, boolean useVertexColor, boolean useTexture, int type) {
        this.proxy.setVertexInfo(vinfo, allNativeVertexInfo, useVertexColor, useTexture, type);
    }

    @Override
    public void setProgramParameter(int program, int parameter, int value) {
        this.proxy.setProgramParameter(program, parameter, value);
    }

    @Override
    public boolean isQueryAvailable() {
        return this.proxy.isQueryAvailable();
    }

    @Override
    public boolean isShaderAvailable() {
        return this.proxy.isShaderAvailable();
    }

    @Override
    public void bindBufferBase(int target, int bindingPoint, int buffer) {
        this.proxy.bindBufferBase(target, bindingPoint, buffer);
    }

    @Override
    public int getUniformBlockIndex(int program, String name) {
        return this.proxy.getUniformBlockIndex(program, name);
    }

    @Override
    public void setUniformBlockBinding(int program, int blockIndex, int bindingPoint) {
        this.proxy.setUniformBlockBinding(program, blockIndex, bindingPoint);
    }

    @Override
    public int getUniformIndex(int program, String name) {
        return this.proxy.getUniformIndex(program, name);
    }

    @Override
    public int[] getUniformIndices(int program, String[] names) {
        return this.proxy.getUniformIndices(program, names);
    }

    @Override
    public int getActiveUniformOffset(int program, int uniformIndex) {
        return this.proxy.getActiveUniformOffset(program, uniformIndex);
    }

    @Override
    public void bindFramebuffer(int target, int framebuffer) {
        this.proxy.bindFramebuffer(target, framebuffer);
    }

    @Override
    public void bindRenderbuffer(int renderbuffer) {
        this.proxy.bindRenderbuffer(renderbuffer);
    }

    @Override
    public void deleteFramebuffer(int framebuffer) {
        this.proxy.deleteFramebuffer(framebuffer);
    }

    @Override
    public void deleteRenderbuffer(int renderbuffer) {
        this.proxy.deleteRenderbuffer(renderbuffer);
    }

    @Override
    public int genFramebuffer() {
        return this.proxy.genFramebuffer();
    }

    @Override
    public int genRenderbuffer() {
        return this.proxy.genRenderbuffer();
    }

    @Override
    public boolean isFramebufferObjectAvailable() {
        return this.proxy.isFramebufferObjectAvailable();
    }

    @Override
    public void setFramebufferRenderbuffer(int target, int attachment, int renderbuffer) {
        this.proxy.setFramebufferRenderbuffer(target, attachment, renderbuffer);
    }

    @Override
    public void setFramebufferTexture(int target, int attachment, int texture, int level) {
        this.proxy.setFramebufferTexture(target, attachment, texture, level);
    }

    @Override
    public void setRenderbufferStorage(int internalFormat, int width, int height) {
        this.proxy.setRenderbufferStorage(internalFormat, width, height);
    }

    @Override
    public void bindVertexArray(int id) {
        this.proxy.bindVertexArray(id);
    }

    @Override
    public void deleteVertexArray(int id) {
        this.proxy.deleteVertexArray(id);
    }

    @Override
    public int genVertexArray() {
        return this.proxy.genVertexArray();
    }

    @Override
    public boolean isVertexArrayAvailable() {
        return this.proxy.isVertexArrayAvailable();
    }

    @Override
    public void multiDrawArrays(int primitive, IntBuffer first, IntBuffer count) {
        this.proxy.multiDrawArrays(primitive, first, count);
    }

    @Override
    public void drawArraysBurstMode(int primitive, int first, int count) {
        this.proxy.drawArraysBurstMode(primitive, first, count);
    }

    @Override
    public void setPixelTransfer(int parameter, int value) {
        this.proxy.setPixelTransfer(parameter, value);
    }

    @Override
    public void setPixelTransfer(int parameter, float value) {
        this.proxy.setPixelTransfer(parameter, value);
    }

    @Override
    public void setPixelTransfer(int parameter, boolean value) {
        this.proxy.setPixelTransfer(parameter, value);
    }

    @Override
    public void setPixelMap(int map, int mapSize, Buffer buffer) {
        this.proxy.setPixelMap(map, mapSize, buffer);
    }

    @Override
    public boolean canNativeClut(int textureAddress) {
        return this.proxy.canNativeClut(textureAddress);
    }

    @Override
    public void setActiveTexture(int index) {
        this.proxy.setActiveTexture(index);
    }

    @Override
    public void setTextureFormat(int pixelFormat, boolean swizzle) {
        this.proxy.setTextureFormat(pixelFormat, swizzle);
    }

    @Override
    public void bindActiveTexture(int index, int texture) {
        this.proxy.bindActiveTexture(index, texture);
    }

    @Override
    public float getMaxTextureAnisotropy() {
        return this.proxy.getMaxTextureAnisotropy();
    }

    @Override
    public void setTextureAnisotropy(float value) {
        this.proxy.setTextureAnisotropy(value);
    }

    @Override
    public String getShadingLanguageVersion() {
        return this.proxy.getShadingLanguageVersion();
    }

    @Override
    public void setBlendDFix(int sfix, float[] color) {
        this.proxy.setBlendDFix(sfix, color);
    }

    @Override
    public void setBlendSFix(int dfix, float[] color) {
        this.proxy.setBlendSFix(dfix, color);
    }

    @Override
    public void waitForRenderingCompletion() {
        this.proxy.waitForRenderingCompletion();
    }

    @Override
    public boolean canReadAllVertexInfo() {
        return this.proxy.canReadAllVertexInfo();
    }

    @Override
    public void readStencil(int x, int y, int width, int height, int bufferSize, Buffer buffer) {
        this.proxy.readStencil(x, y, width, height, bufferSize, buffer);
    }
}

