/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import jpcsp.graphics.RE.BaseRenderingEngineProxy;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;

public class StateProxy
extends BaseRenderingEngineProxy {
    protected boolean[] flags;
    protected float[][] matrix;
    protected static final int RE_BONES_MATRIX = 4;
    protected static final int matrix4Size = 16;
    public static final int maxProgramId = 5000;
    public static final int maxUniformId = 200;
    protected int[][] uniformInt;
    protected int[][][] uniformIntArray;
    protected float[][] uniformFloat;
    protected float[][][] uniformFloatArray;
    protected StateBoolean[] clientState;
    protected StateBoolean[] vertexAttribArray;
    protected boolean colorMaskRed;
    protected boolean colorMaskGreen;
    protected boolean colorMaskBlue;
    protected boolean colorMaskAlpha;
    protected int[] colorMask;
    protected boolean depthMask;
    protected int textureFunc;
    protected boolean textureFuncAlpha;
    protected boolean textureFuncColorDouble;
    protected boolean frontFace;
    protected int stencilFunc;
    protected int stencilFuncRef;
    protected int stencilFuncMask;
    protected int stencilOpFail;
    protected int stencilOpZFail;
    protected int stencilOpZPass;
    protected int depthFunc;
    protected int[] bindTexture;
    protected int[] bindBuffer;
    protected int useProgram;
    protected int textureMapMode;
    protected int textureProjMapMode;
    protected int viewportX;
    protected int viewportY;
    protected int viewportWidth;
    protected int viewportHeight;
    protected HashMap<Integer, int[]> bufferDataInt;
    protected HashMap<Integer, TextureState> textureStates;
    protected TextureState currentTextureState;
    protected int matrixMode;
    protected boolean fogHintSet;
    protected boolean lineSmoothHintSet;
    protected float[] texEnvf;
    protected int[] texEnvi;
    protected int pixelStoreRowLength;
    protected int pixelStoreAlignment;
    protected int scissorX;
    protected int scissorY;
    protected int scissorWidth;
    protected int scissorHeight;
    protected int blendEquation;
    protected int shadeModel;
    protected int alphaFunc;
    protected int alphaFuncRef;
    protected float depthRangeZpos;
    protected float depthRangeZscale;
    protected float depthRangeNear;
    protected float depthRangeFar;
    protected float[] vertexColor;
    protected float[][] lightAmbientColor;
    protected float[][] lightDiffuseColor;
    protected float[][] lightSpecularColor;
    protected float[] lightModelAmbientColor;
    protected int lightMode;
    protected float[] materialAmbientColor;
    protected float[] materialDiffuseColor;
    protected float[] materialSpecularColor;
    protected float[] materialEmissiveColor;
    protected StateBoolean colorMaterialAmbient;
    protected StateBoolean colorMaterialDiffuse;
    protected StateBoolean colorMaterialSpecular;
    protected int bindVertexArray;
    protected int activeTextureUnit;
    protected boolean useTextureAnisotropicFilter;
    protected int dfix;
    protected int sfix;

    public StateProxy(IRenderingEngine proxy) {
        super(proxy);
        this.init();
    }

    protected void init() {
        int i;
        this.flags = new boolean[25];
        this.uniformInt = new int[5000][200];
        this.uniformFloat = new float[5000][200];
        this.uniformIntArray = new int[5000][200][];
        this.uniformFloatArray = new float[5000][200][];
        for (i = 0; i < 5000; ++i) {
            for (int j = 0; j < 200; ++j) {
                this.uniformInt[i][j] = -1;
                this.uniformFloat[i][j] = -1.0f;
            }
        }
        this.matrix = new float[5][];
        this.matrix[0] = new float[16];
        this.matrix[1] = new float[16];
        this.matrix[2] = new float[16];
        this.matrix[3] = new float[16];
        this.matrix[4] = new float[128];
        this.clientState = new StateBoolean[4];
        for (i = 0; i < this.clientState.length; ++i) {
            this.clientState[i] = new StateBoolean();
        }
        this.vertexAttribArray = new StateBoolean[200];
        for (i = 0; i < this.vertexAttribArray.length; ++i) {
            this.vertexAttribArray[i] = new StateBoolean();
        }
        this.colorMask = new int[4];
        this.bufferDataInt = new HashMap();
        this.textureStates = new HashMap();
        this.currentTextureState = new TextureState();
        this.textureStates.put(0, this.currentTextureState);
        this.texEnvf = new float[17];
        this.texEnvi = new int[17];
        this.vertexColor = new float[4];
        this.bindBuffer = new int[2];
        this.lightAmbientColor = new float[4][4];
        this.lightSpecularColor = new float[4][4];
        this.lightDiffuseColor = new float[4][4];
        this.lightModelAmbientColor = new float[4];
        this.materialAmbientColor = new float[4];
        this.materialSpecularColor = new float[4];
        this.materialDiffuseColor = new float[4];
        this.materialEmissiveColor = new float[4];
        this.bindTexture = new int[4];
        this.colorMaterialAmbient = new StateBoolean();
        this.colorMaterialDiffuse = new StateBoolean();
        this.colorMaterialSpecular = new StateBoolean();
    }

    @Override
    public void startDisplay() {
        int i;
        for (i = 0; i < this.clientState.length; ++i) {
            this.clientState[i].setUndefined();
        }
        for (i = 0; i < this.flags.length; ++i) {
            this.flags[i] = true;
        }
        this.flags[9] = false;
        System.arraycopy(identityMatrix, 0, this.matrix[0], 0, 16);
        System.arraycopy(identityMatrix, 0, this.matrix[1], 0, 16);
        System.arraycopy(identityMatrix, 0, this.matrix[2], 0, 16);
        System.arraycopy(identityMatrix, 0, this.matrix[3], 0, 16);
        this.colorMaskRed = true;
        this.colorMaskGreen = true;
        this.colorMaskBlue = true;
        this.colorMaskAlpha = true;
        this.depthMask = true;
        this.textureFunc = -1;
        this.textureFuncAlpha = true;
        this.textureFuncColorDouble = false;
        this.frontFace = true;
        this.stencilFunc = -1;
        this.stencilFuncRef = -1;
        this.stencilFuncMask = -1;
        this.stencilOpFail = -1;
        this.stencilOpZFail = -1;
        this.stencilOpZPass = -1;
        this.depthFunc = -1;
        for (i = 0; i < this.bindTexture.length; ++i) {
            this.bindTexture[i] = -1;
        }
        this.currentTextureState = this.textureStates.get(0);
        for (i = 0; i < this.bindBuffer.length; ++i) {
            this.bindBuffer[i] = -1;
        }
        this.activeTextureUnit = 0;
        this.frontFace = false;
        this.useProgram = 0;
        this.textureMapMode = -1;
        this.textureProjMapMode = -1;
        this.viewportX = -1;
        this.viewportY = -1;
        this.viewportWidth = -1;
        this.viewportHeight = -1;
        this.matrixMode = -1;
        this.fogHintSet = false;
        this.lineSmoothHintSet = false;
        for (i = 0; i < this.texEnvi.length; ++i) {
            this.texEnvi[i] = -1;
        }
        for (i = 0; i < this.texEnvf.length; ++i) {
            this.texEnvf[i] = -1.0f;
        }
        this.texEnvf[2] = 1.0f;
        this.texEnvi[16] = 0;
        this.pixelStoreRowLength = -1;
        this.pixelStoreAlignment = -1;
        this.scissorX = -1;
        this.scissorY = -1;
        this.scissorWidth = -1;
        this.scissorHeight = -1;
        this.blendEquation = -1;
        this.shadeModel = -1;
        this.alphaFunc = -1;
        this.alphaFuncRef = -1;
        this.depthRangeZpos = 0.0f;
        this.depthRangeZscale = 0.0f;
        this.depthRangeNear = 0.0f;
        this.depthRangeFar = 0.0f;
        this.vertexColor[0] = -1.0f;
        for (i = 0; i < this.lightAmbientColor.length; ++i) {
            this.lightAmbientColor[i][0] = -1.0f;
            this.lightDiffuseColor[i][0] = -1.0f;
            this.lightSpecularColor[i][0] = -1.0f;
        }
        this.lightModelAmbientColor[0] = -1.0f;
        this.lightMode = -1;
        this.materialAmbientColor[0] = -10000.0f;
        this.materialDiffuseColor[0] = -1.0f;
        this.materialSpecularColor[0] = -1.0f;
        this.materialEmissiveColor[0] = -1.0f;
        this.colorMaterialAmbient.setUndefined();
        this.colorMaterialDiffuse.setUndefined();
        this.colorMaterialSpecular.setUndefined();
        this.bindVertexArray = 0;
        if (VideoEngine.getInstance().isUseTextureAnisotropicFilter() != this.useTextureAnisotropicFilter) {
            for (TextureState textureState : this.textureStates.values()) {
                textureState.textureMipmapMagFilter = -1;
            }
            this.useTextureAnisotropicFilter = VideoEngine.getInstance().isUseTextureAnisotropicFilter();
        }
        super.startDisplay();
    }

    @Override
    public void disableFlag(int flag) {
        if (this.flags[flag]) {
            super.disableFlag(flag);
            this.flags[flag] = false;
        }
    }

    @Override
    public void enableFlag(int flag) {
        if (!this.flags[flag]) {
            super.enableFlag(flag);
            this.flags[flag] = true;
        }
    }

    @Override
    public void setUniform(int id, int value) {
        if (id >= 0 && id <= 200 && this.uniformInt[this.useProgram][id] != value) {
            super.setUniform(id, value);
            this.uniformInt[this.useProgram][id] = value;
        }
    }

    @Override
    public void setUniform(int id, float value) {
        if (id >= 0 && id <= 200 && this.uniformFloat[this.useProgram][id] != value) {
            super.setUniform(id, value);
            this.uniformFloat[this.useProgram][id] = value;
        }
    }

    @Override
    public void setUniform(int id, int value1, int value2) {
        if (id >= 0 && id <= 200) {
            int[] oldValues = this.uniformIntArray[this.useProgram][id];
            if (oldValues == null || oldValues.length != 2) {
                super.setUniform(id, value1, value2);
                this.uniformIntArray[this.useProgram][id] = new int[]{value1, value2};
            } else if (oldValues[0] != value1 || oldValues[1] != value2) {
                super.setUniform(id, value1, value2);
                oldValues[0] = value1;
                oldValues[1] = value2;
            }
        }
    }

    @Override
    public void setUniform2(int id, int[] values) {
        if (id >= 0 && id <= 200) {
            int[] oldValues = this.uniformIntArray[this.useProgram][id];
            if (oldValues == null || oldValues.length != 2) {
                super.setUniform2(id, values);
                oldValues = new int[]{values[0], values[1]};
                this.uniformIntArray[this.useProgram][id] = oldValues;
            } else if (oldValues[0] != values[0] || oldValues[1] != values[1]) {
                super.setUniform2(id, values);
                oldValues[0] = values[0];
                oldValues[1] = values[1];
            }
        }
    }

    @Override
    public void setUniform3(int id, int[] values) {
        if (id >= 0 && id <= 200) {
            int[] oldValues = this.uniformIntArray[this.useProgram][id];
            if (oldValues == null || oldValues.length != 3) {
                super.setUniform3(id, values);
                oldValues = new int[]{values[0], values[1], values[2]};
                this.uniformIntArray[this.useProgram][id] = oldValues;
            } else if (oldValues[0] != values[0] || oldValues[1] != values[1] || oldValues[2] != values[2]) {
                super.setUniform3(id, values);
                oldValues[0] = values[0];
                oldValues[1] = values[1];
                oldValues[2] = values[2];
            }
        }
    }

    @Override
    public void setUniform4(int id, int[] values) {
        if (id >= 0 && id <= 200) {
            int[] oldValues = this.uniformIntArray[this.useProgram][id];
            if (oldValues == null || oldValues.length != 4) {
                super.setUniform4(id, values);
                oldValues = new int[]{values[0], values[1], values[2], values[3]};
                this.uniformIntArray[this.useProgram][id] = oldValues;
            } else if (oldValues[0] != values[0] || oldValues[1] != values[1] || oldValues[2] != values[2] || oldValues[3] != values[3]) {
                super.setUniform4(id, values);
                oldValues[0] = values[0];
                oldValues[1] = values[1];
                oldValues[2] = values[2];
                oldValues[3] = values[3];
            }
        }
    }

    @Override
    public void setUniformMatrix4(int id, int count, float[] values) {
        if (id >= 0 && id <= 200 && count > 0) {
            float[] oldValues = this.uniformFloatArray[this.useProgram][id];
            int length = count * 16;
            if (oldValues == null || oldValues.length < length) {
                super.setUniformMatrix4(id, count, values);
                oldValues = new float[length];
                System.arraycopy(values, 0, oldValues, 0, length);
                this.uniformFloatArray[this.useProgram][id] = oldValues;
            } else {
                boolean differ = false;
                for (int i = 0; i < length; ++i) {
                    if (oldValues[i] == values[i]) continue;
                    differ = true;
                    break;
                }
                if (differ) {
                    super.setUniformMatrix4(id, count, values);
                    System.arraycopy(values, 0, oldValues, 0, length);
                }
            }
        }
    }

    protected int matrixFirstUpdated(int id, float[] values) {
        if (values == null) {
            values = identityMatrix;
        }
        float[] oldValues = this.matrix[id];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == oldValues[i]) continue;
            System.arraycopy(values, i, oldValues, i, values.length - i);
            return i;
        }
        return values.length;
    }

    protected int matrixLastUpdated(int id, float[] values, int length) {
        float[] oldValues = this.matrix[id];
        if (values == null) {
            values = identityMatrix;
        }
        for (int i = length - 1; i >= 0; --i) {
            if (oldValues[i] == values[i]) continue;
            System.arraycopy(values, 0, oldValues, 0, i + 1);
            return i;
        }
        return 0;
    }

    protected boolean isIdentityMatrix(float[] values) {
        if (values == null) {
            return true;
        }
        if (values.length != identityMatrix.length) {
            return false;
        }
        for (int i = 0; i < identityMatrix.length; ++i) {
            if (values[i] == identityMatrix[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void disableClientState(int type) {
        StateBoolean state = this.clientState[type];
        if (!state.isFalse()) {
            super.disableClientState(type);
            state.setValue(false);
        }
    }

    @Override
    public void enableClientState(int type) {
        StateBoolean state = this.clientState[type];
        if (type == 3 || !state.isTrue()) {
            super.enableClientState(type);
            state.setValue(true);
        }
    }

    @Override
    public void disableVertexAttribArray(int id) {
        StateBoolean state;
        if (id >= 0 && id <= 200 && !(state = this.vertexAttribArray[id]).isFalse()) {
            super.disableVertexAttribArray(id);
            state.setValue(false);
        }
    }

    @Override
    public void enableVertexAttribArray(int id) {
        StateBoolean state;
        if (id >= 0 && id <= 200 && !(state = this.vertexAttribArray[id]).isTrue()) {
            super.enableVertexAttribArray(id);
            state.setValue(true);
        }
    }

    @Override
    public void setColorMask(boolean redWriteEnabled, boolean greenWriteEnabled, boolean blueWriteEnabled, boolean alphaWriteEnabled) {
        if (redWriteEnabled != this.colorMaskRed || greenWriteEnabled != this.colorMaskGreen || blueWriteEnabled != this.colorMaskBlue || alphaWriteEnabled != this.colorMaskAlpha) {
            super.setColorMask(redWriteEnabled, greenWriteEnabled, blueWriteEnabled, alphaWriteEnabled);
            this.colorMaskRed = redWriteEnabled;
            this.colorMaskGreen = greenWriteEnabled;
            this.colorMaskBlue = blueWriteEnabled;
            this.colorMaskAlpha = alphaWriteEnabled;
            this.colorMask[0] = -1;
            this.colorMask[1] = -1;
            this.colorMask[2] = -1;
            this.colorMask[3] = -1;
        }
    }

    @Override
    public void setColorMask(int redMask, int greenMask, int blueMask, int alphaMask) {
        if (redMask != this.colorMask[0] || greenMask != this.colorMask[1] || blueMask != this.colorMask[2] || alphaMask != this.colorMask[3]) {
            super.setColorMask(redMask, greenMask, blueMask, alphaMask);
            this.colorMask[0] = redMask;
            this.colorMask[1] = greenMask;
            this.colorMask[2] = blueMask;
            this.colorMask[3] = alphaMask;
        }
    }

    @Override
    public void setDepthMask(boolean depthWriteEnabled) {
        if (depthWriteEnabled != this.depthMask) {
            super.setDepthMask(depthWriteEnabled);
            this.depthMask = depthWriteEnabled;
        }
    }

    @Override
    public void setFrontFace(boolean cw) {
        if (cw != this.frontFace) {
            super.setFrontFace(cw);
            this.frontFace = cw;
        }
    }

    @Override
    public void setTextureFunc(int func, boolean alphaUsed, boolean colorDoubled) {
        if (func != this.textureFunc || alphaUsed != this.textureFuncAlpha || colorDoubled != this.textureFuncColorDouble) {
            super.setTextureFunc(func, alphaUsed, colorDoubled);
            this.textureFunc = func;
            this.textureFuncAlpha = alphaUsed;
            this.textureFuncColorDouble = colorDoubled;
        }
    }

    @Override
    public void setTextureMipmapMinFilter(int filter) {
        if (filter != this.currentTextureState.textureMipmapMinFilter) {
            super.setTextureMipmapMinFilter(filter);
            this.currentTextureState.textureMipmapMinFilter = filter;
        }
    }

    @Override
    public void setTextureMipmapMagFilter(int filter) {
        if (filter != this.currentTextureState.textureMipmapMagFilter) {
            super.setTextureMipmapMagFilter(filter);
            this.currentTextureState.textureMipmapMagFilter = filter;
        }
    }

    @Override
    public void setTextureMipmapMinLevel(int level) {
        if (level != this.currentTextureState.textureMipmapMinLevel) {
            super.setTextureMipmapMinLevel(level);
            this.currentTextureState.textureMipmapMinLevel = level;
        }
    }

    @Override
    public void setTextureMipmapMaxLevel(int level) {
        if (level != this.currentTextureState.textureMipmapMaxLevel) {
            super.setTextureMipmapMaxLevel(level);
            this.currentTextureState.textureMipmapMaxLevel = level;
        }
    }

    @Override
    public void setTextureWrapMode(int s, int t) {
        if (s != this.currentTextureState.textureWrapModeS || t != this.currentTextureState.textureWrapModeT) {
            super.setTextureWrapMode(s, t);
            this.currentTextureState.textureWrapModeS = s;
            this.currentTextureState.textureWrapModeT = t;
        }
    }

    @Override
    public void bindTexture(int texture) {
        if (texture != this.bindTexture[this.activeTextureUnit]) {
            super.bindTexture(texture);
            this.bindTexture[this.activeTextureUnit] = texture;
            this.currentTextureState = this.textureStates.get(texture);
            if (this.currentTextureState == null) {
                this.currentTextureState = new TextureState();
                this.textureStates.put(texture, this.currentTextureState);
            }
        }
    }

    @Override
    public void setDepthFunc(int func) {
        if (func != this.depthFunc) {
            super.setDepthFunc(func);
            this.depthFunc = func;
        }
    }

    @Override
    public void setStencilFunc(int func, int ref, int mask) {
        if (func != this.stencilFunc || ref != this.stencilFuncRef || mask != this.stencilFuncMask) {
            super.setStencilFunc(func, ref, mask);
            this.stencilFunc = func;
            this.stencilFuncRef = ref;
            this.stencilFuncMask = mask;
        }
    }

    @Override
    public void setStencilOp(int fail, int zfail, int zpass) {
        if (fail != this.stencilOpFail || zfail != this.stencilOpZFail || zpass != this.stencilOpZPass) {
            super.setStencilOp(fail, zfail, zpass);
            this.stencilOpFail = fail;
            this.stencilOpZFail = zfail;
            this.stencilOpZPass = zpass;
        }
    }

    @Override
    public void deleteTexture(int texture) {
        this.textureStates.remove(texture);
        for (int i = 0; i < this.bindTexture.length; ++i) {
            if (texture != this.bindTexture[i]) continue;
            this.bindTexture[i] = 0;
            if (i != this.activeTextureUnit) continue;
            this.currentTextureState = this.textureStates.get(this.bindTexture[this.activeTextureUnit]);
        }
        super.deleteTexture(texture);
    }

    @Override
    public void bindBuffer(int target, int buffer) {
        if (this.bindBuffer[target] != buffer) {
            super.bindBuffer(target, buffer);
            this.bindBuffer[target] = buffer;
        }
    }

    @Override
    public void deleteBuffer(int buffer) {
        for (int target = 0; target < this.bindBuffer.length; ++target) {
            if (buffer != this.bindBuffer[target]) continue;
            this.bindBuffer[target] = 0;
        }
        super.deleteBuffer(buffer);
    }

    @Override
    public void setViewport(int x, int y, int width, int height) {
        if (width >= 0 && height >= 0 && (x != this.viewportX || y != this.viewportY || width != this.viewportWidth || height != this.viewportHeight)) {
            super.setViewport(x, y, width, height);
            this.viewportX = x;
            this.viewportY = y;
            this.viewportWidth = width;
            this.viewportHeight = height;
        }
    }

    @Override
    public void useProgram(int program) {
        if (this.useProgram != program) {
            super.useProgram(program);
            this.useProgram = program;
        }
    }

    @Override
    public void setTextureMapMode(int mode, int proj) {
        if (mode != this.textureMapMode || proj != this.textureProjMapMode) {
            super.setTextureMapMode(mode, proj);
            this.textureMapMode = mode;
            this.textureProjMapMode = proj;
        }
    }

    private void setBufferData(int target, int size, IntBuffer buffer, int usage) {
        int[] oldData = this.bufferDataInt.get(this.bindBuffer[target]);
        int[] newData = new int[size / 4];
        int position = buffer.position();
        buffer.get(newData);
        buffer.position(position);
        boolean differ = true;
        boolean setBufferData = true;
        if (oldData != null && newData.length == oldData.length) {
            differ = false;
            setBufferData = false;
            int limit = buffer.limit();
            for (int i = 0; i < newData.length; ++i) {
                if (newData[i] == oldData[i]) continue;
                differ = true;
                int end = i + 1;
                for (int j = i + 1; j < newData.length; ++j) {
                    if (newData[j] != oldData[j]) continue;
                    end = j;
                    break;
                }
                buffer.position(i);
                super.setBufferSubData(target, i * 4, (end - i) * 4, buffer);
                buffer.limit(limit);
                i = end;
            }
        }
        if (setBufferData) {
            super.setBufferData(target, size, buffer, usage);
        }
        if (differ) {
            this.bufferDataInt.put(this.bindBuffer[target], newData);
        }
    }

    @Override
    public void setBufferData(int target, int size, Buffer buffer, int usage) {
        if (target == 1 && size <= 1024 && (size & 3) == 0 && buffer instanceof IntBuffer) {
            this.setBufferData(target, size, (IntBuffer)buffer, usage);
        } else if (target == 1 && size <= 1024 && (size & 3) == 0 && buffer instanceof ByteBuffer) {
            this.setBufferData(target, size, ((ByteBuffer)buffer).asIntBuffer(), usage);
        } else {
            super.setBufferData(target, size, buffer, usage);
        }
    }

    @Override
    public void setMatrixMode(int type) {
        if (type != this.matrixMode) {
            super.setMatrixMode(type);
            this.matrixMode = type;
        }
    }

    @Override
    public void setMatrix(float[] values) {
        if (this.matrixFirstUpdated(this.matrixMode, values) < 16) {
            if (this.isIdentityMatrix(values)) {
                super.setMatrix(null);
            } else {
                super.setMatrix(values);
            }
        }
    }

    @Override
    public void multMatrix(float[] values) {
        if (!this.isIdentityMatrix(values)) {
            super.multMatrix(values);
        }
    }

    @Override
    public void setFogHint() {
        if (!this.fogHintSet) {
            super.setFogHint();
            this.fogHintSet = true;
        }
    }

    @Override
    public void setLineSmoothHint() {
        if (!this.lineSmoothHintSet) {
            super.setLineSmoothHint();
            this.lineSmoothHintSet = true;
        }
    }

    @Override
    public void setTexEnv(int name, float param) {
        if (this.texEnvf[name] != param) {
            super.setTexEnv(name, param);
            this.texEnvf[name] = param;
        }
    }

    @Override
    public void setTexEnv(int name, int param) {
        if (this.texEnvi[name] != param) {
            super.setTexEnv(name, param);
            this.texEnvi[name] = param;
        }
    }

    @Override
    public void setPixelStore(int rowLength, int alignment) {
        if (this.pixelStoreRowLength != rowLength || this.pixelStoreAlignment != alignment) {
            super.setPixelStore(rowLength, alignment);
            this.pixelStoreRowLength = rowLength;
            this.pixelStoreAlignment = alignment;
        }
    }

    @Override
    public void setScissor(int x, int y, int width, int height) {
        if (x >= 0 && y >= 0 && width >= 0 && height >= 0 && (x != this.scissorX || y != this.scissorY || width != this.scissorWidth || height != this.scissorHeight)) {
            super.setScissor(x, y, width, height);
            this.scissorX = x;
            this.scissorY = y;
            this.scissorWidth = width;
            this.scissorHeight = height;
        }
    }

    @Override
    public void setBlendEquation(int mode) {
        if (this.blendEquation != mode) {
            super.setBlendEquation(mode);
            this.blendEquation = mode;
        }
    }

    @Override
    public void setShadeModel(int model) {
        if (this.shadeModel != model) {
            super.setShadeModel(model);
            this.shadeModel = model;
        }
    }

    @Override
    public void setAlphaFunc(int func, int ref) {
        if (this.alphaFunc != func || this.alphaFuncRef != ref) {
            super.setAlphaFunc(func, ref);
            this.alphaFunc = func;
            this.alphaFuncRef = ref;
        }
    }

    @Override
    public void setDepthRange(float zpos, float zscale, float near, float far) {
        if (this.depthRangeZpos != zpos || this.depthRangeZscale != zscale || this.depthRangeNear != near || this.depthRangeFar != far) {
            super.setDepthRange(zpos, zscale, near, far);
            this.depthRangeZpos = zpos;
            this.depthRangeZscale = zscale;
            this.depthRangeNear = near;
            this.depthRangeFar = far;
        }
    }

    @Override
    public void setVertexColor(float[] color) {
        if (this.vertexColor[0] != color[0] || this.vertexColor[1] != color[1] || this.vertexColor[2] != color[2] || this.vertexColor[3] != color[3]) {
            super.setVertexColor(color);
            this.vertexColor[0] = color[0];
            this.vertexColor[1] = color[1];
            this.vertexColor[2] = color[2];
            this.vertexColor[3] = color[3];
        }
    }

    @Override
    public void setLightAmbientColor(int light, float[] color) {
        float[] stateColor = this.lightAmbientColor[light];
        if (stateColor[0] != color[0] || stateColor[1] != color[1] || stateColor[2] != color[2] || stateColor[3] != color[3]) {
            super.setLightAmbientColor(light, color);
            stateColor[0] = color[0];
            stateColor[1] = color[1];
            stateColor[2] = color[2];
            stateColor[3] = color[3];
        }
    }

    @Override
    public void setLightDiffuseColor(int light, float[] color) {
        float[] stateColor = this.lightDiffuseColor[light];
        if (stateColor[0] != color[0] || stateColor[1] != color[1] || stateColor[2] != color[2] || stateColor[3] != color[3]) {
            super.setLightDiffuseColor(light, color);
            stateColor[0] = color[0];
            stateColor[1] = color[1];
            stateColor[2] = color[2];
            stateColor[3] = color[3];
        }
    }

    @Override
    public void setLightSpecularColor(int light, float[] color) {
        float[] stateColor = this.lightSpecularColor[light];
        if (stateColor[0] != color[0] || stateColor[1] != color[1] || stateColor[2] != color[2] || stateColor[3] != color[3]) {
            super.setLightSpecularColor(light, color);
            stateColor[0] = color[0];
            stateColor[1] = color[1];
            stateColor[2] = color[2];
            stateColor[3] = color[3];
        }
    }

    @Override
    public void setMaterialAmbientColor(float[] color) {
        if (this.materialAmbientColor[0] != color[0] || this.materialAmbientColor[1] != color[1] || this.materialAmbientColor[2] != color[2] || this.materialAmbientColor[3] != color[3]) {
            super.setMaterialAmbientColor(color);
            this.materialAmbientColor[0] = color[0];
            this.materialAmbientColor[1] = color[1];
            this.materialAmbientColor[2] = color[2];
            this.materialAmbientColor[3] = color[3];
        }
    }

    @Override
    public void setMaterialDiffuseColor(float[] color) {
        if (this.materialDiffuseColor[0] != color[0] || this.materialDiffuseColor[1] != color[1] || this.materialDiffuseColor[2] != color[2] || this.materialDiffuseColor[3] != color[3]) {
            super.setMaterialDiffuseColor(color);
            this.materialDiffuseColor[0] = color[0];
            this.materialDiffuseColor[1] = color[1];
            this.materialDiffuseColor[2] = color[2];
            this.materialDiffuseColor[3] = color[3];
        }
    }

    @Override
    public void setMaterialEmissiveColor(float[] color) {
        if (this.materialEmissiveColor[0] != color[0] || this.materialEmissiveColor[1] != color[1] || this.materialEmissiveColor[2] != color[2] || this.materialEmissiveColor[3] != color[3]) {
            super.setMaterialEmissiveColor(color);
            this.materialEmissiveColor[0] = color[0];
            this.materialEmissiveColor[1] = color[1];
            this.materialEmissiveColor[2] = color[2];
            this.materialEmissiveColor[3] = color[3];
        }
    }

    @Override
    public void setMaterialSpecularColor(float[] color) {
        if (this.materialSpecularColor[0] != color[0] || this.materialSpecularColor[1] != color[1] || this.materialSpecularColor[2] != color[2] || this.materialSpecularColor[3] != color[3]) {
            super.setMaterialSpecularColor(color);
            this.materialSpecularColor[0] = color[0];
            this.materialSpecularColor[1] = color[1];
            this.materialSpecularColor[2] = color[2];
            this.materialSpecularColor[3] = color[3];
        }
    }

    @Override
    public void setColorMaterial(boolean ambient, boolean diffuse, boolean specular) {
        if (!(this.colorMaterialAmbient.isValue(ambient) && this.colorMaterialDiffuse.isValue(diffuse) && this.colorMaterialSpecular.isValue(specular))) {
            super.setColorMaterial(ambient, diffuse, specular);
            this.colorMaterialAmbient.setValue(ambient);
            this.colorMaterialDiffuse.setValue(diffuse);
            this.colorMaterialSpecular.setValue(specular);
        }
    }

    private void invalidateMaterialColors() {
        if (this.flags[22]) {
            if (this.colorMaterialAmbient.isTrue()) {
                this.materialAmbientColor[0] = -1.0f;
            }
            if (this.colorMaterialDiffuse.isTrue()) {
                this.materialDiffuseColor[0] = -1.0f;
            }
            if (this.colorMaterialSpecular.isTrue()) {
                this.materialSpecularColor[0] = -1.0f;
            }
        }
    }

    @Override
    public void drawArrays(int type, int first, int count) {
        this.invalidateMaterialColors();
        super.drawArrays(type, first, count);
    }

    @Override
    public void setLightMode(int mode) {
        if (this.lightMode != mode) {
            super.setLightMode(mode);
            this.lightMode = mode;
        }
    }

    @Override
    public void setLightModelAmbientColor(float[] color) {
        if (this.lightModelAmbientColor[0] != color[0] || this.lightModelAmbientColor[1] != color[1] || this.lightModelAmbientColor[2] != color[2] || this.lightModelAmbientColor[3] != color[3]) {
            super.setLightModelAmbientColor(color);
            this.lightModelAmbientColor[0] = color[0];
            this.lightModelAmbientColor[1] = color[1];
            this.lightModelAmbientColor[2] = color[2];
            this.lightModelAmbientColor[3] = color[3];
        }
    }

    private void onVertexArrayChanged() {
        int i;
        for (i = 0; i < this.clientState.length; ++i) {
            this.clientState[i].setUndefined();
        }
        for (i = 0; i < this.vertexAttribArray.length; ++i) {
            this.vertexAttribArray[i].setUndefined();
        }
    }

    @Override
    public void bindVertexArray(int id) {
        if (id != this.bindVertexArray) {
            this.onVertexArrayChanged();
            super.bindVertexArray(id);
            this.bindVertexArray = id;
        }
    }

    @Override
    public void deleteVertexArray(int id) {
        if (id == this.bindVertexArray) {
            this.onVertexArrayChanged();
            this.bindVertexArray = 0;
        }
        super.deleteVertexArray(id);
    }

    @Override
    public void setActiveTexture(int index) {
        if (index != this.activeTextureUnit) {
            super.setActiveTexture(index);
            this.activeTextureUnit = index;
            this.currentTextureState = this.textureStates.get(this.bindTexture[this.activeTextureUnit]);
        }
    }

    @Override
    public void bindActiveTexture(int index, int texture) {
        if (texture != this.bindTexture[index]) {
            super.bindActiveTexture(index, texture);
            this.bindTexture[index] = texture;
            if (index == this.activeTextureUnit) {
                this.currentTextureState = this.textureStates.get(texture);
                if (this.currentTextureState == null) {
                    this.currentTextureState = new TextureState();
                    this.textureStates.put(texture, this.currentTextureState);
                }
            }
        }
    }

    @Override
    public void setTextureAnisotropy(float value) {
        if (value != this.currentTextureState.textureAnisotropy) {
            super.setTextureAnisotropy(value);
            this.currentTextureState.textureAnisotropy = value;
        }
    }

    @Override
    public void setBlendSFix(int sfix, float[] color) {
        if (this.sfix != sfix) {
            super.setBlendSFix(sfix, color);
            this.sfix = sfix;
        }
    }

    @Override
    public void setBlendDFix(int dfix, float[] color) {
        if (this.dfix != dfix) {
            super.setBlendDFix(dfix, color);
            this.dfix = dfix;
        }
    }

    protected static class TextureState {
        public int textureWrapModeS = 0;
        public int textureWrapModeT = 0;
        public int textureMipmapMinFilter = 6;
        public int textureMipmapMagFilter = 1;
        public int textureMipmapMinLevel = 0;
        public int textureMipmapMaxLevel = 1000;
        public float textureAnisotropy = 0.0f;

        protected TextureState() {
        }
    }

    protected static class StateBoolean {
        private boolean undefined = true;
        private boolean value;

        protected StateBoolean() {
        }

        public boolean isUndefined() {
            return this.undefined;
        }

        public void setUndefined() {
            this.undefined = true;
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
            this.undefined = false;
        }

        public boolean isTrue() {
            return !this.undefined && this.value;
        }

        public boolean isFalse() {
            return !this.undefined && !this.value;
        }

        public boolean isValue(boolean value) {
            return !this.undefined && this.value == value;
        }

        public String toString() {
            if (this.isUndefined()) {
                return "Undefined";
            }
            return Boolean.toString(this.getValue());
        }
    }
}

