/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import jpcsp.Memory;
import jpcsp.graphics.RE.BaseRenderingEngine;
import jpcsp.graphics.RE.software.BoundingBoxRenderer;
import jpcsp.graphics.RE.software.BufferVertexReader;
import jpcsp.graphics.RE.software.CachedTexture;
import jpcsp.graphics.RE.software.CachedTextureResampled;
import jpcsp.graphics.RE.software.IRenderer;
import jpcsp.graphics.RE.software.RendererExecutor;
import jpcsp.graphics.RE.software.SpriteRenderer;
import jpcsp.graphics.RE.software.TriangleRenderer;
import jpcsp.graphics.VertexInfo;
import jpcsp.graphics.VertexState;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.ImageReader;
import jpcsp.util.DurationStatistics;
import jpcsp.util.Utilities;

public class RESoftware
extends BaseRenderingEngine {
    private static final boolean useTextureCache = true;
    protected int genTextureId;
    protected int bindTexture;
    protected VertexState v1 = new VertexState();
    protected VertexState v2 = new VertexState();
    protected VertexState v3 = new VertexState();
    protected VertexState v4 = new VertexState();
    protected VertexState v5 = new VertexState();
    protected VertexState v6 = new VertexState();
    protected RendererExecutor rendererExecutor;
    protected HashMap<Integer, CachedTextureResampled> cachedTextures = new HashMap();
    protected int textureBufferWidth;
    protected static DurationStatistics drawArraysStatistics = new DurationStatistics("RESoftware drawArrays");
    public static DurationStatistics triangleRender3DStatistics = new DurationStatistics("RESoftware TriangleRender3D");
    public static DurationStatistics triangleRender2DStatistics = new DurationStatistics("RESoftware TriangleRender2D");
    public static DurationStatistics spriteRenderStatistics = new DurationStatistics("RESoftware SpriteRender");
    protected static DurationStatistics cachedTextureStatistics = new DurationStatistics("RESoftware CachedTexture");
    public static DurationStatistics textureResamplingStatistics = new DurationStatistics("RESftware Texture resampling");
    protected BoundingBoxRenderer boundingBoxRenderer;
    protected boolean boundingBoxVisible;
    protected BufferVertexReader bufferVertexReader;
    protected boolean useVertexTexture;

    public RESoftware() {
        log.info((Object)"Using SoftwareRenderer");
    }

    @Override
    public void exit() {
    }

    @Override
    public void startDirectRendering(boolean textureEnabled, boolean depthWriteEnabled, boolean colorWriteEnabled, boolean setOrthoMatrix, boolean orthoInverted, int width, int height) {
    }

    @Override
    public void endDirectRendering() {
    }

    @Override
    public void startDisplay() {
        this.context = VideoEngine.getInstance().getContext();
        this.rendererExecutor = RendererExecutor.getInstance();
    }

    @Override
    public void endDisplay() {
    }

    @Override
    public void enableFlag(int flag) {
    }

    @Override
    public void disableFlag(int flag) {
    }

    @Override
    public void setMorphWeight(int index, float value) {
    }

    @Override
    public void setPatchDiv(int s, int t) {
    }

    @Override
    public void setPatchPrim(int prim) {
    }

    @Override
    public void setMatrixMode(int type) {
    }

    @Override
    public void setMatrix(float[] values) {
    }

    @Override
    public void multMatrix(float[] values) {
    }

    @Override
    public void endModelViewMatrixUpdate() {
    }

    @Override
    public void setViewport(int x, int y, int width, int height) {
    }

    @Override
    public void setDepthRange(float zpos, float zscale, float near, float far) {
    }

    @Override
    public void setDepthFunc(int func) {
    }

    @Override
    public void setShadeModel(int model) {
    }

    @Override
    public void setMaterialEmissiveColor(float[] color) {
    }

    @Override
    public void setMaterialAmbientColor(float[] color) {
    }

    @Override
    public void setMaterialDiffuseColor(float[] color) {
    }

    @Override
    public void setMaterialSpecularColor(float[] color) {
    }

    @Override
    public void setMaterialShininess(float shininess) {
    }

    @Override
    public void setLightModelAmbientColor(float[] color) {
    }

    @Override
    public void setLightMode(int mode) {
    }

    @Override
    public void setLightPosition(int light, float[] position) {
    }

    @Override
    public void setLightDirection(int light, float[] direction) {
    }

    @Override
    public void setLightSpotExponent(int light, float exponent) {
    }

    @Override
    public void setLightSpotCutoff(int light, float cutoff) {
    }

    @Override
    public void setLightConstantAttenuation(int light, float constant) {
    }

    @Override
    public void setLightLinearAttenuation(int light, float linear) {
    }

    @Override
    public void setLightQuadraticAttenuation(int light, float quadratic) {
    }

    @Override
    public void setLightAmbientColor(int light, float[] color) {
    }

    @Override
    public void setLightDiffuseColor(int light, float[] color) {
    }

    @Override
    public void setLightSpecularColor(int light, float[] color) {
    }

    @Override
    public void setLightType(int light, int type, int kind) {
    }

    @Override
    public void setBlendFunc(int src, int dst) {
    }

    @Override
    public void setBlendColor(float[] color) {
    }

    @Override
    public void setLogicOp(int logicOp) {
    }

    @Override
    public void setDepthMask(boolean depthWriteEnabled) {
    }

    @Override
    public void setColorMask(int redMask, int greenMask, int blueMask, int alphaMask) {
    }

    @Override
    public void setColorMask(boolean redWriteEnabled, boolean greenWriteEnabled, boolean blueWriteEnabled, boolean alphaWriteEnabled) {
    }

    @Override
    public void setTextureWrapMode(int s, int t) {
    }

    @Override
    public void setTextureMipmapMinLevel(int level) {
    }

    @Override
    public void setTextureMipmapMaxLevel(int level) {
    }

    @Override
    public void setTextureMipmapMinFilter(int filter) {
    }

    @Override
    public void setTextureMipmapMagFilter(int filter) {
    }

    @Override
    public void setColorMaterial(boolean ambient, boolean diffuse, boolean specular) {
    }

    @Override
    public void setTextureMapMode(int mode, int proj) {
    }

    @Override
    public void setTextureEnvironmentMapping(int u, int v) {
    }

    @Override
    public void setUniform(int id, int value) {
    }

    @Override
    public void setUniform(int id, int value1, int value2) {
    }

    @Override
    public void setUniform(int id, float value) {
    }

    @Override
    public void setUniform2(int id, int[] values) {
    }

    @Override
    public void setUniform3(int id, int[] values) {
    }

    @Override
    public void setUniform3(int id, float[] values) {
    }

    @Override
    public void setUniform4(int id, int[] values) {
    }

    @Override
    public void setUniform4(int id, float[] values) {
    }

    @Override
    public void setUniformMatrix4(int id, int count, float[] values) {
    }

    @Override
    public void setColorTestFunc(int func) {
    }

    @Override
    public void setColorTestReference(int[] values) {
    }

    @Override
    public void setColorTestMask(int[] values) {
    }

    @Override
    public void setTextureFunc(int func, boolean alphaUsed, boolean colorDoubled) {
    }

    @Override
    public int setBones(int count, float[] values) {
        return count;
    }

    @Override
    public void setTexEnv(int name, int param) {
    }

    @Override
    public void setTexEnv(int name, float param) {
    }

    @Override
    public int createShader(int type) {
        return 0;
    }

    @Override
    public boolean compilerShader(int shader, String source) {
        return false;
    }

    @Override
    public int createProgram() {
        return 0;
    }

    @Override
    public void useProgram(int program) {
    }

    @Override
    public void attachShader(int program, int shader) {
    }

    @Override
    public boolean linkProgram(int program) {
        return false;
    }

    @Override
    public boolean validateProgram(int program) {
        return false;
    }

    @Override
    public int getUniformLocation(int program, String name) {
        return 0;
    }

    @Override
    public int getAttribLocation(int program, String name) {
        return 0;
    }

    @Override
    public void bindAttribLocation(int program, int index, String name) {
    }

    @Override
    public String getShaderInfoLog(int shader) {
        return null;
    }

    @Override
    public String getProgramInfoLog(int program) {
        return null;
    }

    @Override
    public boolean isExtensionAvailable(String name) {
        return false;
    }

    protected void render(IRenderer renderer) {
        if (renderer.prepare(this.context)) {
            this.rendererExecutor.render(renderer);
        }
    }

    protected void drawSprite(SpriteRenderer spriteRenderer, VertexState v1, VertexState v2) {
        spriteRenderer.setVertex(v1, v2);
        this.render(spriteRenderer);
    }

    protected CachedTextureResampled getCachedTexture() {
        CachedTextureResampled cachedTexture = this.cachedTextures.get(this.bindTexture);
        if (cachedTexture != null) {
            cachedTexture.setClut();
        }
        return cachedTexture;
    }

    protected void drawArraysSprites(int first, int count) {
        CachedTextureResampled cachedTexture = this.getCachedTexture();
        SpriteRenderer spriteRenderer = new SpriteRenderer(this.context, cachedTexture, this.useVertexTexture);
        boolean readTexture = this.context.textureFlag.isEnabled() && !this.context.clearMode;
        Memory mem = Memory.getInstance();
        for (int i = first; i < count - 1; i += 2) {
            int addr1 = this.context.vinfo.getAddress(mem, i);
            int addr2 = this.context.vinfo.getAddress(mem, i + 1);
            this.context.vinfo.readVertex(mem, addr1, this.v1, readTexture);
            this.context.vinfo.readVertex(mem, addr2, this.v2, readTexture);
            this.drawSprite(spriteRenderer, this.v1, this.v2);
        }
    }

    protected void drawTriangle(TriangleRenderer triangleRenderer, VertexState v1, VertexState v2, VertexState v3, boolean invertedFrontFace) {
        triangleRenderer.setVertex(v1, v2, v3);
        if (!triangleRenderer.isCulled(invertedFrontFace)) {
            this.render(triangleRenderer);
        }
    }

    protected boolean isSprite(VertexInfo vinfo, VertexState tv1, VertexState tv2, VertexState tv3, VertexState tv4) {
        if (!vinfo.transform2D) {
            return false;
        }
        if (!this.context.clearMode && this.context.cullFaceFlag.isEnabled()) {
            return false;
        }
        if (vinfo.normal != 0) {
            return false;
        }
        if (this.context.textureColorDoubled) {
            return false;
        }
        if (vinfo.color != 0 && !Utilities.sameColor(tv1.c, tv2.c, tv3.c, tv4.c)) {
            return false;
        }
        if (tv1.p[0] == tv2.p[0] && tv1.p[1] == tv3.p[1] && tv4.p[0] == tv3.p[0] && tv4.p[1] == tv2.p[1] && tv1.p[2] == tv2.p[2] && tv1.p[2] == tv3.p[2] && tv1.p[2] == tv3.p[2]) {
            if (vinfo.texture == 0) {
                return true;
            }
            if (tv1.t[0] == tv2.t[0] && tv1.t[1] == tv3.t[1] && tv4.t[0] == tv3.t[0] && tv4.t[1] == tv2.t[1]) {
                return true;
            }
        }
        if (tv1.p[1] == tv2.p[1] && tv1.p[0] == tv3.p[0] && tv4.p[1] == tv3.p[1] && tv4.p[0] == tv2.p[0] && tv1.p[2] == tv2.p[2] && tv1.p[2] == tv3.p[2] && tv1.p[2] == tv3.p[2]) {
            if (vinfo.texture == 0) {
                return true;
            }
            if (tv1.t[1] == tv2.t[1] && tv1.t[0] == tv3.t[0] && tv4.t[1] == tv3.t[1] && tv4.t[0] == tv2.t[0]) {
                return true;
            }
        }
        return false;
    }

    protected void resetBufferVertexReader() {
        this.bufferVertexReader = null;
    }

    protected void readVertex(Memory mem, int index, VertexState v, boolean readTexture) {
        if (this.bufferVertexReader == null) {
            int addr = this.context.vinfo.getAddress(mem, index);
            this.context.vinfo.readVertex(mem, addr, v, readTexture);
        } else {
            this.bufferVertexReader.readVertex(index, v);
        }
        if (this.context.vinfo.weight != 0) {
            VideoEngine.doSkinning(this.context.bone_uploaded_matrix, this.context.vinfo, v);
        }
    }

    protected void drawArraysTriangleStrips(int first, int count) {
        Memory mem = Memory.getInstance();
        CachedTextureResampled cachedTexture = this.getCachedTexture();
        TriangleRenderer triangleRenderer = new TriangleRenderer(this.context, cachedTexture, this.useVertexTexture);
        SpriteRenderer spriteRenderer = null;
        VertexState tv1 = null;
        VertexState tv2 = null;
        VertexState tv3 = null;
        VertexState tv4 = this.v1;
        boolean readTexture = this.context.textureFlag.isEnabled() && !this.context.clearMode;
        for (int i = 0; i < count; ++i) {
            this.readVertex(mem, first + i, tv4, readTexture);
            if (tv3 != null) {
                if (this.isSprite(this.context.vinfo, tv1, tv2, tv3, tv4)) {
                    if (spriteRenderer == null) {
                        spriteRenderer = new SpriteRenderer(this.context, cachedTexture, this.useVertexTexture);
                    }
                    this.drawSprite(spriteRenderer, tv1, tv4);
                    this.v5.copy(tv3);
                    this.v6.copy(tv4);
                    this.v1.copy(this.v5);
                    this.v2.copy(this.v6);
                    tv1 = this.v1;
                    tv2 = this.v2;
                    tv3 = null;
                    tv4 = this.v3;
                    continue;
                }
                this.drawTriangle(triangleRenderer, tv1, tv2, tv3, (i - 3 & 1) != 0);
                VertexState v = tv1;
                tv1 = tv2;
                tv2 = tv3;
                tv3 = tv4;
                tv4 = v;
                continue;
            }
            if (tv1 == null) {
                tv1 = tv4;
                tv4 = this.v2;
                continue;
            }
            if (tv2 == null) {
                tv2 = tv4;
                tv4 = this.v3;
                continue;
            }
            tv3 = tv4;
            tv4 = this.v4;
        }
        if (tv3 != null) {
            this.drawTriangle(triangleRenderer, tv1, tv2, tv3, (count & 1) == 0);
        }
    }

    protected void drawArraysTriangles(int first, int count) {
        Memory mem = Memory.getInstance();
        CachedTextureResampled cachedTexture = this.getCachedTexture();
        TriangleRenderer triangleRenderer = new TriangleRenderer(this.context, cachedTexture, this.useVertexTexture);
        boolean readTexture = this.context.textureFlag.isEnabled() && !this.context.clearMode;
        for (int i = 0; i < count; i += 3) {
            this.readVertex(mem, first + i, this.v1, readTexture);
            this.readVertex(mem, first + i + 1, this.v2, readTexture);
            this.readVertex(mem, first + i + 2, this.v3, readTexture);
            this.drawTriangle(triangleRenderer, this.v1, this.v2, this.v3, false);
        }
    }

    protected void drawArraysTriangleFan(int first, int count) {
        Memory mem = Memory.getInstance();
        CachedTextureResampled cachedTexture = this.getCachedTexture();
        TriangleRenderer triangleRenderer = new TriangleRenderer(this.context, cachedTexture, this.useVertexTexture);
        VertexState tv1 = null;
        VertexState tv2 = null;
        VertexState tv3 = this.v1;
        boolean readTexture = this.context.textureFlag.isEnabled() && !this.context.clearMode;
        for (int i = 0; i < count; ++i) {
            this.readVertex(mem, first + i, tv3, readTexture);
            if (tv2 != null) {
                this.drawTriangle(triangleRenderer, tv1, tv2, tv3, false);
                VertexState v = tv2;
                tv2 = tv3;
                tv3 = v;
                continue;
            }
            if (tv1 == null) {
                tv1 = tv3;
                tv3 = this.v2;
                continue;
            }
            tv2 = tv3;
            tv3 = this.v3;
        }
    }

    @Override
    public void drawArrays(int primitive, int first, int count) {
        drawArraysStatistics.start();
        switch (primitive) {
            case 6: {
                this.drawArraysSprites(first, count);
                break;
            }
            case 4: {
                this.drawArraysTriangleStrips(first, count);
                break;
            }
            case 3: {
                this.drawArraysTriangles(first, count);
                break;
            }
            case 5: {
                this.drawArraysTriangleFan(first, count);
            }
        }
        drawArraysStatistics.end();
    }

    @Override
    public int genBuffer() {
        return 0;
    }

    @Override
    public void deleteBuffer(int buffer) {
    }

    @Override
    public void setBufferData(int target, int size, Buffer buffer, int usage) {
    }

    @Override
    public void setBufferSubData(int target, int offset, int size, Buffer buffer) {
    }

    @Override
    public void bindBuffer(int target, int buffer) {
    }

    @Override
    public void enableClientState(int type) {
    }

    @Override
    public void disableClientState(int type) {
    }

    @Override
    public void enableVertexAttribArray(int id) {
    }

    @Override
    public void disableVertexAttribArray(int id) {
    }

    @Override
    public void setTexCoordPointer(int size, int type, int stride, long offset) {
    }

    @Override
    public void setTexCoordPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        if (this.bufferVertexReader == null) {
            this.bufferVertexReader = new BufferVertexReader();
        }
        this.bufferVertexReader.setTextureComponentInfo(size, type, stride, bufferSize, buffer);
    }

    @Override
    public void setColorPointer(int size, int type, int stride, long offset) {
    }

    @Override
    public void setColorPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        if (this.bufferVertexReader == null) {
            this.bufferVertexReader = new BufferVertexReader();
        }
        this.bufferVertexReader.setColorComponentInfo(size, type, stride, bufferSize, buffer);
    }

    @Override
    public void setVertexPointer(int size, int type, int stride, long offset) {
    }

    @Override
    public void setVertexPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        if (this.bufferVertexReader == null) {
            this.bufferVertexReader = new BufferVertexReader();
        }
        this.bufferVertexReader.setVertexComponentInfo(size, type, stride, bufferSize, buffer);
    }

    @Override
    public void setNormalPointer(int type, int stride, long offset) {
    }

    @Override
    public void setNormalPointer(int type, int stride, int bufferSize, Buffer buffer) {
        if (this.bufferVertexReader == null) {
            this.bufferVertexReader = new BufferVertexReader();
        }
        this.bufferVertexReader.setNormalComponentInfo(type, stride, bufferSize, buffer);
    }

    @Override
    public void setWeightPointer(int size, int type, int stride, long offset) {
    }

    @Override
    public void setWeightPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        if (this.bufferVertexReader == null) {
            this.bufferVertexReader = new BufferVertexReader();
        }
        this.bufferVertexReader.setWeightComponentInfo(size, type, stride, bufferSize, buffer);
    }

    @Override
    public void setVertexAttribPointer(int id, int size, int type, boolean normalized, int stride, long offset) {
    }

    @Override
    public void setVertexAttribPointer(int id, int size, int type, boolean normalized, int stride, int bufferSize, Buffer buffer) {
    }

    @Override
    public void setPixelStore(int rowLength, int alignment) {
        this.textureBufferWidth = rowLength;
    }

    @Override
    public int genTexture() {
        return this.genTextureId++;
    }

    @Override
    public void bindTexture(int texture) {
        this.bindTexture = texture;
    }

    @Override
    public void deleteTexture(int texture) {
        this.cachedTextures.remove(texture);
    }

    @Override
    public void setCompressedTexImage(int level, int internalFormat, int width, int height, int compressedSize, Buffer buffer) {
        cachedTextureStatistics.start();
        if (level == 0) {
            IMemoryReader imageReader = ImageReader.getImageReader(this.context.texture_base_pointer[level], width, height, this.context.texture_buffer_width[level], internalFormat, false, 0, 0, 0, 0, 0, 0, null, null);
            CachedTexture cachedTexture = CachedTexture.getCachedTexture(width, height, internalFormat, imageReader);
            CachedTextureResampled cachedTextureResampled = new CachedTextureResampled(cachedTexture);
            this.cachedTextures.put(this.bindTexture, cachedTextureResampled);
        }
        cachedTextureStatistics.end();
    }

    @Override
    public void setTexImage(int level, int internalFormat, int width, int height, int format, int type, int textureSize, Buffer buffer) {
        cachedTextureStatistics.start();
        if (level == 0) {
            CachedTexture cachedTexture = null;
            if (buffer instanceof IntBuffer) {
                cachedTexture = CachedTexture.getCachedTexture(this.textureBufferWidth, height, format, ((IntBuffer)buffer).array(), buffer.arrayOffset(), textureSize >> 2);
            } else if (buffer instanceof ShortBuffer) {
                cachedTexture = CachedTexture.getCachedTexture(this.textureBufferWidth, height, format, ((ShortBuffer)buffer).array(), buffer.arrayOffset(), textureSize >> 1);
            }
            CachedTextureResampled cachedTextureResampled = new CachedTextureResampled(cachedTexture);
            this.cachedTextures.put(this.bindTexture, cachedTextureResampled);
        }
        cachedTextureStatistics.end();
    }

    @Override
    public void setTexSubImage(int level, int xOffset, int yOffset, int width, int height, int format, int type, int textureSize, Buffer buffer) {
    }

    @Override
    public void getTexImage(int level, int format, int type, Buffer buffer) {
    }

    @Override
    public void copyTexSubImage(int level, int xOffset, int yOffset, int x, int y, int width, int height) {
    }

    @Override
    public void setStencilOp(int fail, int zfail, int zpass) {
    }

    @Override
    public void setStencilFunc(int func, int ref, int mask) {
    }

    @Override
    public void setAlphaFunc(int func, int ref) {
    }

    @Override
    public void setFogHint() {
    }

    @Override
    public void setFogColor(float[] color) {
    }

    @Override
    public void setFogDist(float start, float end) {
    }

    @Override
    public void setTextureEnvColor(float[] color) {
    }

    @Override
    public void setFrontFace(boolean cw) {
    }

    @Override
    public void setScissor(int x, int y, int width, int height) {
    }

    @Override
    public void setBlendEquation(int mode) {
    }

    @Override
    public void setLineSmoothHint() {
    }

    @Override
    public boolean hasBoundingBox() {
        return true;
    }

    @Override
    public void beginBoundingBox(int numberOfVertexBoundingBox) {
        this.boundingBoxRenderer = new BoundingBoxRenderer(this.context);
        this.boundingBoxVisible = true;
    }

    @Override
    public void drawBoundingBox(float[][] values) {
        if (this.boundingBoxVisible) {
            this.boundingBoxRenderer.drawBoundingBox(values);
            if (!this.boundingBoxRenderer.prepare(this.context)) {
                this.boundingBoxVisible = false;
            }
        }
    }

    @Override
    public void endBoundingBox(VertexInfo vinfo) {
    }

    @Override
    public boolean isBoundingBoxVisible() {
        return this.boundingBoxVisible;
    }

    @Override
    public int genQuery() {
        return 0;
    }

    @Override
    public void beginQuery(int id) {
    }

    @Override
    public void endQuery() {
    }

    @Override
    public boolean getQueryResultAvailable(int id) {
        return false;
    }

    @Override
    public int getQueryResult(int id) {
        return 0;
    }

    @Override
    public void clear(float red, float green, float blue, float alpha) {
    }

    @Override
    public boolean canAllNativeVertexInfo() {
        return true;
    }

    @Override
    public boolean canNativeSpritesPrimitive() {
        return true;
    }

    @Override
    public void setVertexInfo(VertexInfo vinfo, boolean allNativeVertexInfo, boolean useVertexColor, boolean useTexture, int type) {
        this.useVertexTexture = useTexture;
        this.resetBufferVertexReader();
    }

    @Override
    public void setProgramParameter(int program, int parameter, int value) {
    }

    @Override
    public boolean isQueryAvailable() {
        return false;
    }

    @Override
    public boolean isShaderAvailable() {
        return false;
    }

    @Override
    public int getUniformBlockIndex(int program, String name) {
        return 0;
    }

    @Override
    public void bindBufferBase(int target, int bindingPoint, int buffer) {
    }

    @Override
    public void setUniformBlockBinding(int program, int blockIndex, int bindingPoint) {
    }

    @Override
    public int getUniformIndex(int program, String name) {
        return 0;
    }

    @Override
    public int[] getUniformIndices(int program, String[] names) {
        return null;
    }

    @Override
    public int getActiveUniformOffset(int program, int uniformIndex) {
        return 0;
    }

    @Override
    public boolean isFramebufferObjectAvailable() {
        return false;
    }

    @Override
    public int genFramebuffer() {
        return 0;
    }

    @Override
    public int genRenderbuffer() {
        return 0;
    }

    @Override
    public void deleteFramebuffer(int framebuffer) {
    }

    @Override
    public void deleteRenderbuffer(int renderbuffer) {
    }

    @Override
    public void bindFramebuffer(int target, int framebuffer) {
    }

    @Override
    public void bindRenderbuffer(int renderbuffer) {
    }

    @Override
    public void setRenderbufferStorage(int internalFormat, int width, int height) {
    }

    @Override
    public void setFramebufferRenderbuffer(int target, int attachment, int renderbuffer) {
    }

    @Override
    public void setFramebufferTexture(int target, int attachment, int texture, int level) {
    }

    @Override
    public int genVertexArray() {
        return 0;
    }

    @Override
    public void bindVertexArray(int id) {
    }

    @Override
    public void deleteVertexArray(int id) {
    }

    @Override
    public boolean isVertexArrayAvailable() {
        return false;
    }

    @Override
    public void multiDrawArrays(int primitive, IntBuffer first, IntBuffer count) {
    }

    @Override
    public void drawArraysBurstMode(int primitive, int first, int count) {
    }

    @Override
    public void setPixelTransfer(int parameter, int value) {
    }

    @Override
    public void setPixelTransfer(int parameter, float value) {
    }

    @Override
    public void setPixelTransfer(int parameter, boolean value) {
    }

    @Override
    public void setPixelMap(int map, int mapSize, Buffer buffer) {
    }

    @Override
    public boolean canNativeClut(int textureAddress) {
        return VideoEngine.isVRAM(textureAddress);
    }

    @Override
    public void setActiveTexture(int index) {
    }

    @Override
    public void setTextureFormat(int pixelFormat, boolean swizzle) {
    }

    @Override
    public void bindActiveTexture(int index, int texture) {
    }

    @Override
    public void setTextureAnisotropy(float value) {
    }

    @Override
    public float getMaxTextureAnisotropy() {
        return 0.0f;
    }

    @Override
    public String getShadingLanguageVersion() {
        return null;
    }

    @Override
    public void setBlendSFix(int sfix, float[] color) {
    }

    @Override
    public void setBlendDFix(int dfix, float[] color) {
    }

    @Override
    public void startClearMode(boolean color, boolean stencil, boolean depth) {
    }

    @Override
    public void endClearMode() {
    }

    @Override
    public void waitForRenderingCompletion() {
        this.rendererExecutor.waitForRenderingCompletion();
    }

    @Override
    public boolean canReadAllVertexInfo() {
        return true;
    }

    @Override
    public void readStencil(int x, int y, int width, int height, int bufferSize, Buffer buffer) {
    }
}

