/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import jpcsp.Memory;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VertexCache;
import jpcsp.graphics.VertexInfoCompiler;
import jpcsp.graphics.VertexInfoReaderTemplate;
import jpcsp.graphics.VertexState;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public class VertexInfo {
    public static final int vtypeMask = 0x9DDFFF;
    public boolean transform2D;
    public int skinningWeightCount;
    public int morphingVertexCount;
    public int texture;
    public int color;
    public int normal;
    public int position;
    public int weight;
    public int index;
    public int vtype;
    public int ptr_vertex;
    public int ptr_index;
    public int vertexSize;
    public int oneVertexSize;
    public int textureOffset;
    public int colorOffset;
    public int normalOffset;
    public int positionOffset;
    public int alignmentSize;
    private static int[] size_mapping = new int[]{0, 1, 2, 4};
    private static int[] size_padding = new int[]{0, 0, 1, 3};
    private static int[] color_size_mapping = new int[]{0, 1, 1, 1, 2, 2, 2, 4};
    private static int[] color_size_padding = new int[]{0, 0, 0, 0, 1, 1, 1, 3};
    private float[] morph_weight = new float[8];
    private static String[] texture_info = new String[]{null, "GU_TEXTURE_8BIT", "GU_TEXTURE_16BIT", "GU_TEXTURE_32BITF"};
    private static String[] color_info = new String[]{null, "GU_COLOR_UNK2", "GU_COLOR_UNK3", "GU_COLOR_UNK4", "GU_COLOR_5650", "GU_COLOR_5551", "GU_COLOR_4444", "GU_COLOR_8888"};
    private static String[] normal_info = new String[]{null, "GU_NORMAL_8BIT", "GU_NORMAL_16BIT", "GU_NORMAL_32BITF"};
    private static String[] vertex_info = new String[]{null, "GU_VERTEX_8BIT", "GU_VERTEX_16BIT", "GU_VERTEX_32BITF"};
    private static String[] weight_info = new String[]{null, "GU_WEIGHT_8BIT", "GU_WEIGHT_16BIT", "GU_WEIGHT_32BITF"};
    private static String[] index_info = new String[]{null, "GU_INDEX_8BIT", "GU_INDEX_16BIT", "GU_INDEX_UNK3"};
    private static String[] transform_info = new String[]{"GU_TRANSFORM_3D", "GU_TRANSFORM_2D"};
    private VertexInfoReaderTemplate vertexInfoReader;
    public boolean readTexture;
    private int bufferId = -1;
    private int vertexArrayId = -1;
    private int[] cachedVertices;
    private int[] cachedIndices;
    private int cachedNumberOfVertex;
    private float[] cachedMorphWeights;
    private float[][] cachedBoneMatrix;
    private ByteBuffer cachedBuffer;
    private VertexCache vertexCache;

    public VertexInfo() {
    }

    public VertexInfo(VertexInfo vertexInfo) {
        this.vtype = vertexInfo.vtype;
        this.transform2D = vertexInfo.transform2D;
        this.skinningWeightCount = vertexInfo.skinningWeightCount;
        this.morphingVertexCount = vertexInfo.morphingVertexCount;
        this.texture = vertexInfo.texture;
        this.color = vertexInfo.color;
        this.normal = vertexInfo.normal;
        this.position = vertexInfo.position;
        this.weight = vertexInfo.weight;
        this.index = vertexInfo.index;
        this.ptr_vertex = vertexInfo.ptr_vertex;
        this.ptr_index = vertexInfo.ptr_index;
        this.vertexSize = vertexInfo.vertexSize;
        this.oneVertexSize = vertexInfo.oneVertexSize;
        this.textureOffset = vertexInfo.textureOffset;
        this.colorOffset = vertexInfo.colorOffset;
        this.normalOffset = vertexInfo.normalOffset;
        this.positionOffset = vertexInfo.positionOffset;
        this.alignmentSize = vertexInfo.alignmentSize;
        this.morph_weight = vertexInfo.morph_weight;
        this.cachedIndices = vertexInfo.cachedIndices;
        this.cachedVertices = vertexInfo.cachedVertices;
        this.vertexCache = vertexInfo.vertexCache;
    }

    public void processType(int param) {
        this.vtype = param & 0x9DDFFF;
        this.updateVertexInfoReader(this.texture != 0);
        this.vertexInfoReader.processType(this);
    }

    public static void processType(VertexInfo vinfo, int vtype) {
        vinfo.vtype = vtype & 0x9DDFFF;
        vinfo.texture = vtype >> 0 & 3;
        vinfo.color = vtype >> 2 & 7;
        vinfo.normal = vtype >> 5 & 3;
        vinfo.position = vtype >> 7 & 3;
        vinfo.weight = vtype >> 9 & 3;
        vinfo.index = vtype >> 11 & 3;
        vinfo.skinningWeightCount = (vtype >> 14 & 7) + 1;
        vinfo.morphingVertexCount = (vtype >> 18 & 7) + 1;
        vinfo.transform2D = (vtype >> 23 & 1) != 0;
        int vertexSize = 0;
        vertexSize += size_mapping[vinfo.weight] * vinfo.skinningWeightCount;
        vinfo.textureOffset = vertexSize = vertexSize + size_padding[vinfo.texture] & ~size_padding[vinfo.texture];
        vertexSize += size_mapping[vinfo.texture] * 2;
        vinfo.colorOffset = vertexSize = vertexSize + color_size_padding[vinfo.color] & ~color_size_padding[vinfo.color];
        vertexSize += color_size_mapping[vinfo.color];
        vinfo.normalOffset = vertexSize = vertexSize + size_padding[vinfo.normal] & ~size_padding[vinfo.normal];
        vertexSize += size_mapping[vinfo.normal] * 3;
        vinfo.positionOffset = vertexSize = vertexSize + size_padding[vinfo.position] & ~size_padding[vinfo.position];
        vertexSize += size_mapping[vinfo.position] * 3;
        vinfo.alignmentSize = Math.max(size_mapping[vinfo.weight], Math.max(color_size_mapping[vinfo.color], Math.max(size_mapping[vinfo.normal], Math.max(size_mapping[vinfo.texture], size_mapping[vinfo.position]))));
        vinfo.oneVertexSize = vertexSize = vertexSize + vinfo.alignmentSize - 1 & ~(vinfo.alignmentSize - 1);
        vinfo.vertexSize = vertexSize * vinfo.morphingVertexCount;
    }

    private void updateVertexInfoReader(boolean readTexture) {
        this.readTexture = readTexture;
        this.vertexInfoReader = VertexInfoCompiler.getInstance().getCompiledVertexInfoReader(this.vtype, readTexture);
    }

    public int getAddress(Memory mem, int i) {
        if (this.ptr_index != 0 && this.index != 0) {
            int addr = this.ptr_index + i * this.index;
            switch (this.index) {
                case 1: {
                    i = mem.read8(addr);
                    break;
                }
                case 2: {
                    i = mem.read16(addr);
                    break;
                }
                case 3: {
                    i = mem.read32(addr);
                }
            }
        }
        return this.ptr_vertex + i * this.vertexSize;
    }

    public void setMorphWeights(float[] mw) {
        this.morph_weight = mw;
        if (this.morphingVertexCount == 1) {
            this.morph_weight[0] = 1.0f;
        }
    }

    public VertexState readVertex(Memory mem, int addr, boolean readTexture) {
        VertexState v = new VertexState();
        this.readVertex(mem, addr, v, readTexture);
        return v;
    }

    public void readVertex(Memory mem, int addr, VertexState v, boolean readTexture) {
        if (this.texture == 0) {
            readTexture = false;
        }
        if (readTexture != this.readTexture) {
            this.updateVertexInfoReader(readTexture);
        }
        this.vertexInfoReader.readVertex(mem, addr, v, this.morph_weight);
    }

    public void setDirty() {
        this.cachedIndices = null;
        this.cachedVertices = null;
    }

    private boolean equals(int[] a, int[] b) {
        if (a == null) {
            if (b != null) {
                return false;
            }
        } else {
            if (b == null) {
                return false;
            }
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(VertexInfo vertexInfo, int numberOfVertex) {
        if (!this.vertexCache.vertexAlreadyChecked(vertexInfo)) {
            vertexInfo.readForCache(numberOfVertex);
            if (!this.equals(this.cachedVertices, vertexInfo.cachedVertices)) {
                return false;
            }
            if (!this.equals(this.cachedIndices, vertexInfo.cachedIndices)) {
                return false;
            }
            this.vertexCache.setVertexAlreadyChecked(vertexInfo);
        } else {
            if (this.index != 0 && this.cachedIndices == null) {
                return false;
            }
            if (this.ptr_vertex != 0 && this.cachedVertices == null) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(VertexInfo vertexInfo, int numberOfVertex, float[][] boneMatrix, int numberOfWeightsForBuffer) {
        int i;
        if (this.vtype != vertexInfo.vtype || this.cachedNumberOfVertex != numberOfVertex || this.ptr_index != vertexInfo.ptr_index) {
            return false;
        }
        if (this.morphingVertexCount > 1) {
            for (i = 0; i < this.morphingVertexCount; ++i) {
                if (this.cachedMorphWeights[i] == vertexInfo.morph_weight[i]) continue;
                return false;
            }
        }
        if (this.weight != 0 && numberOfWeightsForBuffer == 0) {
            for (i = 0; i < this.skinningWeightCount; ++i) {
                for (int j = 0; j < 12; ++j) {
                    if (this.cachedBoneMatrix[i][j] == boneMatrix[i][j]) continue;
                    return false;
                }
            }
        }
        if (VideoEngine.getInstance().useOptimisticVertexCache) {
            if (this.index != 0 && this.cachedIndices == null) {
                return false;
            }
            return this.ptr_vertex == 0 || this.cachedVertices != null;
        }
        return this.equals(vertexInfo, numberOfVertex);
    }

    public boolean bindVertex(IRenderingEngine re) {
        return this.bindVertex(re, false);
    }

    private boolean bindVertex(IRenderingEngine re, boolean bindBuffer) {
        boolean needSetDataPointers;
        if (this.vertexArrayId >= 0) {
            re.bindVertexArray(this.vertexArrayId);
            needSetDataPointers = false;
            if (bindBuffer) {
                re.bindBuffer(0, this.bufferId);
            }
        } else {
            re.bindBuffer(0, this.bufferId);
            needSetDataPointers = true;
        }
        return needSetDataPointers;
    }

    public boolean loadVertex(IRenderingEngine re, FloatBuffer buffer, int size) {
        boolean needSetDataPointers = false;
        if (this.vertexArrayId == -1 && re.isVertexArrayAvailable()) {
            this.vertexArrayId = re.genVertexArray();
            needSetDataPointers = true;
        }
        if (this.bufferId == -1) {
            this.bufferId = re.genBuffer();
            needSetDataPointers = true;
        }
        if (this.bindVertex(re, true)) {
            needSetDataPointers = true;
        }
        int bufferSize = size * VideoEngine.SIZEOF_FLOAT;
        if (this.cachedBuffer == null || this.cachedBuffer.capacity() < bufferSize) {
            this.cachedBuffer = ByteBuffer.allocateDirect(bufferSize).order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.cachedBuffer.clear();
        }
        int oldLimit = buffer.limit();
        buffer.limit(size);
        this.cachedBuffer.asFloatBuffer().put(buffer);
        buffer.limit(oldLimit);
        buffer.rewind();
        this.cachedBuffer.rewind();
        re.setBufferData(0, size * VideoEngine.SIZEOF_FLOAT, this.cachedBuffer, 3);
        return needSetDataPointers;
    }

    public void deleteVertex(IRenderingEngine re) {
        if (this.bufferId != -1) {
            re.deleteBuffer(this.bufferId);
            this.bufferId = -1;
        }
        if (this.vertexArrayId != -1) {
            re.deleteVertexArray(this.vertexArrayId);
            this.vertexArrayId = -1;
        }
        this.cachedMorphWeights = null;
        this.cachedBoneMatrix = null;
        this.cachedBuffer = null;
        this.cachedIndices = null;
        this.cachedVertices = null;
    }

    private void readForCache(int numberOfVertex) {
        int vertexArraySize;
        if (this.cachedIndices != null || this.cachedVertices != null) {
            return;
        }
        if (this.ptr_index != 0 && this.index != 0) {
            IMemoryReader memoryReader = null;
            switch (this.index) {
                case 1: {
                    memoryReader = MemoryReader.getMemoryReader(this.ptr_index, 1 * numberOfVertex, 1);
                    break;
                }
                case 2: {
                    memoryReader = MemoryReader.getMemoryReader(this.ptr_index, 2 * numberOfVertex, 2);
                    break;
                }
                case 3: {
                    memoryReader = MemoryReader.getMemoryReader(this.ptr_index, 4 * numberOfVertex, 4);
                }
            }
            int maxIndex = -1;
            if (memoryReader != null) {
                this.cachedIndices = new int[numberOfVertex];
                for (int i = 0; i < numberOfVertex; ++i) {
                    int index;
                    this.cachedIndices[i] = index = memoryReader.readNext();
                    if (index <= maxIndex) continue;
                    maxIndex = index;
                }
            }
            vertexArraySize = this.vertexSize * (maxIndex + 1);
        } else {
            vertexArraySize = this.vertexSize * numberOfVertex;
        }
        if (this.ptr_vertex != 0) {
            vertexArraySize = vertexArraySize + 3 & 0xFFFFFFFC;
            this.cachedVertices = new int[vertexArraySize >> 2];
            IMemoryReader verticesReader = MemoryReader.getMemoryReader(this.ptr_vertex, vertexArraySize, 4);
            for (int i = 0; i < this.cachedVertices.length; ++i) {
                this.cachedVertices[i] = verticesReader.readNext();
            }
        }
    }

    public void prepareForCache(VertexCache vertexCache, int numberOfVertex, float[][] boneMatrix, int numberOfWeightsForBuffer) {
        this.vertexCache = vertexCache;
        this.cachedNumberOfVertex = numberOfVertex;
        this.cachedMorphWeights = new float[this.morphingVertexCount];
        System.arraycopy(this.morph_weight, 0, this.cachedMorphWeights, 0, this.morphingVertexCount);
        if (this.weight != 0 && numberOfWeightsForBuffer == 0 && boneMatrix != null) {
            this.cachedBoneMatrix = new float[this.skinningWeightCount][];
            for (int i = 0; i < this.skinningWeightCount; ++i) {
                this.cachedBoneMatrix[i] = new float[12];
                System.arraycopy(boneMatrix[i], 0, this.cachedBoneMatrix[i], 0, 12);
            }
        } else {
            this.cachedBoneMatrix = null;
        }
        this.readForCache(numberOfVertex);
    }

    public void reuseCachedBuffer(VertexInfo vertexInfo) {
        if (vertexInfo != null && vertexInfo.cachedBuffer != null && (this.cachedBuffer == null || this.cachedBuffer.capacity() < vertexInfo.cachedBuffer.capacity())) {
            this.cachedBuffer = vertexInfo.cachedBuffer;
            vertexInfo.cachedBuffer = null;
        }
    }

    public static String toString(int texture, int color, int normal, int position, int weight, int skinningWeightCount, int morphingVertexCount, int index, boolean transform2D, int vertexSize) {
        StringBuilder sb = new StringBuilder();
        if (texture_info[texture] != null) {
            sb.append(texture_info[texture] + "|");
        }
        if (color_info[color] != null) {
            sb.append(color_info[color] + "|");
        }
        if (normal_info[normal] != null) {
            sb.append(normal_info[normal] + "|");
        }
        if (vertex_info[position] != null) {
            sb.append(vertex_info[position] + "|");
        }
        if (weight_info[weight] != null) {
            sb.append(weight_info[weight] + "|");
            sb.append("GU_WEIGHTS(" + skinningWeightCount + ")|");
        }
        if (morphingVertexCount > 1) {
            sb.append("GU_VERTICES(" + morphingVertexCount + ")|");
        }
        if (index_info[index] != null) {
            sb.append(index_info[index] + "|");
        }
        sb.append(transform_info[transform2D ? 1 : 0]);
        sb.append(" size=" + vertexSize);
        return sb.toString();
    }

    public String toString() {
        return VertexInfo.toString(this.texture, this.color, this.normal, this.position, this.weight, this.skinningWeightCount, this.morphingVertexCount, this.index, this.transform2D, this.vertexSize);
    }
}

