/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media;

public class MpegStream {
    private byte[] buffer;
    private int index;
    private int length;

    public MpegStream(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.index = offset;
        this.length = offset + length;
    }

    public int read8() {
        int b = this.buffer[this.index] & 0xFF;
        if (b == 0 && this.index >= 1 && this.buffer[this.index - 1] == 0 && this.index + 1 < this.length && this.buffer[this.index + 1] == 3) {
            ++this.index;
        }
        ++this.index;
        return b;
    }

    public int read16() {
        return this.read8() << 8 | this.read8();
    }

    public int read32() {
        return this.read8() << 24 | this.read8() << 16 | this.read8() << 8 | this.read8();
    }

    public int read(int n) {
        int value = 0;
        for (int i = 0; i < n; ++i) {
            value = value << 8 | this.read8();
        }
        return value;
    }

    public void skip(int n) {
        while (n > 0) {
            this.read8();
            --n;
        }
    }

    public boolean isEmpty() {
        return this.index >= this.length;
    }
}

