/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import java.io.File;
import java.io.IOException;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.Instructions;
import jpcsp.Allegrex.compiler.CodeBlock;
import jpcsp.Allegrex.compiler.CompilerClassLoader;
import jpcsp.Allegrex.compiler.CompilerContext;
import jpcsp.Allegrex.compiler.CompilerTypeManager;
import jpcsp.Allegrex.compiler.ICompiler;
import jpcsp.Allegrex.compiler.IExecutable;
import jpcsp.Allegrex.compiler.InterpretExecutable;
import jpcsp.Allegrex.compiler.RecompileExecutable;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeManager;
import jpcsp.Emulator;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemorySections;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.AbstractIntSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.CpuDurationStatistics;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Compiler
implements ICompiler {
    public static Logger log = Logger.getLogger((String)"compiler");
    private static Compiler instance;
    private static int resetCount;
    private CompilerClassLoader classLoader;
    public static CpuDurationStatistics compileDuration;
    private Document configuration;
    private NativeCodeManager nativeCodeManager;
    private boolean ignoreInvalidMemory = false;
    public int defaultMethodMaxInstructions = 3000;
    private static final int maxRecompileExecutable = 50;
    private CompilerTypeManager compilerTypeManager;

    private boolean isIgnoreInvalidMemory() {
        return this.ignoreInvalidMemory;
    }

    private void setIgnoreInvalidMemory(boolean enable) {
        this.ignoreInvalidMemory = enable;
    }

    public static Compiler getInstance() {
        if (instance == null) {
            instance = new Compiler();
        }
        return instance;
    }

    private Compiler() {
        this.Initialise();
    }

    public static void exit() {
        if (instance != null) {
            // empty if block
        }
    }

    public void reset() {
        ++resetCount;
        this.classLoader = new CompilerClassLoader(this);
        compileDuration.reset();
        this.nativeCodeManager.reset();
    }

    public void invalidateAll() {
        log.info((Object)"Compiler: invalidating all compiled classes");
        this.classLoader = new CompilerClassLoader(this);
    }

    public boolean checkSimpleInterpretedCodeBlock(CodeBlock codeBlock) {
        boolean isSimple = true;
        int insnCount = 0;
        Common.Instruction[] insns = new Common.Instruction[100];
        int[] opcodes = new int[100];
        int opcodeJrRa = 65011720;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(codeBlock.getStartAddress(), 4);
        int notSimpleFlags = 216;
        while (true) {
            int opcode;
            if (insnCount >= insns.length) {
                Common.Instruction[] newInsns = new Common.Instruction[insnCount + 100];
                System.arraycopy(insns, 0, newInsns, 0, insnCount);
                insns = newInsns;
                int[] newOpcodes = new int[newInsns.length];
                System.arraycopy(opcodes, 0, newOpcodes, 0, insnCount);
                opcodes = newOpcodes;
            }
            if ((opcode = memoryReader.readNext()) == opcodeJrRa) {
                Common.Instruction delaySlotInsn;
                int delaySlotOpcode = memoryReader.readNext();
                insns[insnCount] = delaySlotInsn = Decoder.instruction(delaySlotOpcode);
                opcodes[insnCount] = delaySlotOpcode;
                ++insnCount;
                break;
            }
            Common.Instruction insn = Decoder.instruction(opcode);
            if ((insn.getFlags() & notSimpleFlags) != 0) {
                isSimple = false;
                break;
            }
            insns[insnCount] = insn;
            opcodes[insnCount] = opcode;
            ++insnCount;
        }
        if (isSimple) {
            if (insnCount < insns.length) {
                Common.Instruction[] newInsns = new Common.Instruction[insnCount];
                System.arraycopy(insns, 0, newInsns, 0, insnCount);
                insns = newInsns;
                int[] newOpcodes = new int[insnCount];
                System.arraycopy(opcodes, 0, newOpcodes, 0, insnCount);
                opcodes = newOpcodes;
            }
            codeBlock.setInterpretedInstructions(insns);
            codeBlock.setInterpretedOpcodes(opcodes);
        } else {
            codeBlock.setInterpretedInstructions(null);
        }
        return isSimple;
    }

    public void invalidateCodeBlock(CodeBlock codeBlock) {
        IExecutable executable = codeBlock.getExecutable();
        if (executable != null) {
            if (codeBlock.getInstanceIndex() > 50) {
                codeBlock.setInterpreted(true);
                executable.setExecutable(new InterpretExecutable(codeBlock));
            } else {
                RecompileExecutable recompileExecutable = new RecompileExecutable(codeBlock);
                executable.setExecutable(recompileExecutable);
            }
        }
    }

    private void Initialise() {
        Settings.getInstance().registerSettingsListener("Compiler", "emu.ignoreInvalidMemoryAccess", new IgnoreInvalidMemoryAccessSettingsListerner());
        Settings.getInstance().registerSettingsListener("Compiler", "emu.compiler.methodMaxInstructions", new MethodMaxInstructionsSettingsListerner());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setCoalescing(true);
        this.configuration = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.configuration = documentBuilder.parse(new File("Compiler.xml"));
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e);
        }
        catch (SAXException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        this.nativeCodeManager = this.configuration != null ? new NativeCodeManager(this.configuration.getDocumentElement()) : new NativeCodeManager(null);
        this.compilerTypeManager = new CompilerTypeManager();
        this.reset();
    }

    public static int jumpTarget(int pc, int opcode) {
        return pc & 0xF0000000 | (opcode & 0x3FFFFFF) << 2;
    }

    public static int branchTarget(int pc, int opcode) {
        return pc + ((short)(opcode & 0xFFFF) << 2);
    }

    private IExecutable interpret(CompilerContext context, int startAddress, int instanceIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Compiler.interpret Block 0x" + Integer.toHexString(startAddress)));
        }
        CodeBlock codeBlock = new CodeBlock(startAddress &= 0x3FFFFFFF, instanceIndex);
        IExecutable executable = codeBlock.getInterpretedExecutable(context);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executable: " + executable));
        }
        return executable;
    }

    public static boolean isEndBlockInsn(int pc, int opcode, Common.Instruction insn) {
        if (insn.hasFlags(128)) {
            if (insn.hasFlags(40)) {
                if (insn == Instructions.BEQ) {
                    int rs = opcode >> 21 & 0x1F;
                    int rt = opcode >> 16 & 0x1F;
                    if (rs == rt) {
                        return true;
                    }
                } else {
                    log.error((Object)String.format("Unknown conditional instruction ending a block: %s", insn.disasm(pc, opcode)));
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private IExecutable analyse(CompilerContext context, int startAddress, boolean recursive, int instanceIndex) throws ClassFormatError {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Compiler.analyse Block 0x%08X", startAddress));
        }
        MemorySections memorySections = MemorySections.getInstance();
        CodeBlock codeBlock = new CodeBlock(startAddress &= 0x3FFFFFFF, instanceIndex);
        Stack<Integer> pendingBlockAddresses = new Stack<Integer>();
        pendingBlockAddresses.clear();
        pendingBlockAddresses.push(startAddress);
        while (!pendingBlockAddresses.isEmpty()) {
            int pc = (Integer)pendingBlockAddresses.pop();
            if (!Memory.isAddressGood(pc)) {
                if (this.isIgnoreInvalidMemory()) {
                    log.warn((Object)String.format("IGNORING: Trying to compile an invalid address 0x%08X", pc));
                } else {
                    log.error((Object)String.format("Trying to compile an invalid address 0x%08X", pc));
                }
                return null;
            }
            boolean isBranchTarget = true;
            int endPc = MemoryMap.END_RAM;
            if (context.analysedAddresses.contains(pc) && !context.analysedAddresses.contains(pc + 4)) {
                pc += 4;
            }
            if (context.analysedAddresses.contains(pc) && isBranchTarget) {
                codeBlock.setIsBranchTarget(pc);
                continue;
            }
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(pc, 4);
            while (!context.analysedAddresses.contains(pc) && pc <= endPc) {
                int opcode = memoryReader.readNext();
                Common.Instruction insn = Decoder.instruction(opcode);
                context.analysedAddresses.add(pc);
                int npc = pc + 4;
                int branchingTo = 0;
                boolean isBranching = false;
                boolean checkDynamicBranching = false;
                if (insn.hasFlags(8)) {
                    branchingTo = Compiler.branchTarget(npc, opcode);
                    isBranching = true;
                } else if (insn.hasFlags(16)) {
                    branchingTo = Compiler.jumpTarget(npc, opcode);
                    isBranching = true;
                    checkDynamicBranching = true;
                }
                if (Compiler.isEndBlockInsn(pc, opcode, insn)) {
                    endPc = npc;
                }
                if (insn.hasFlags(64)) {
                    if (recursive) {
                        context.blocksToBeAnalysed.push(branchingTo);
                    }
                } else if (isBranching && branchingTo != 0) {
                    if (checkDynamicBranching) {
                        if (!memorySections.canWrite(branchingTo, false)) {
                            pendingBlockAddresses.push(branchingTo);
                        }
                    } else {
                        pendingBlockAddresses.push(branchingTo);
                    }
                }
                codeBlock.addInstruction(pc, opcode, insn, isBranchTarget, isBranching, branchingTo);
                pc = npc;
                isBranchTarget = false;
            }
        }
        IExecutable executable = codeBlock.getExecutable(context);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Executable: " + executable));
        }
        return executable;
    }

    public void analyseRecursive(int startAddress, int instanceIndex) {
        if (RuntimeContext.hasCodeBlock(startAddress)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Compiler.analyse 0x" + Integer.toHexString(startAddress).toUpperCase() + " - already analysed"));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Compiler.analyse 0x" + Integer.toHexString(startAddress).toUpperCase()));
        }
        CompilerContext context = new CompilerContext(this.classLoader, instanceIndex);
        context.blocksToBeAnalysed.push(startAddress);
        while (!context.blocksToBeAnalysed.isEmpty()) {
            int blockStartAddress = context.blocksToBeAnalysed.pop();
            this.analyse(context, blockStartAddress, true, instanceIndex);
        }
    }

    @Override
    public IExecutable compile(String name) {
        return this.compile(CompilerContext.getClassAddress(name), CompilerContext.getClassInstanceIndex(name));
    }

    @Override
    public IExecutable compile(int address) {
        return this.compile(address, Compiler.getResetCount());
    }

    private CompilerContext retryCompilation(CompilerContext context, int instanceIndex, int retries, Throwable e) {
        int methodMaxInstructions = context.getMethodMaxInstructions() * 3 / 4;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Catched exception '%s' (can be ignored)", e.toString()));
            log.debug((Object)String.format("Retrying compilation again with maxInstruction=%d, retries left=%d...", methodMaxInstructions, retries - 1));
        }
        context = new CompilerContext(this.classLoader, instanceIndex);
        context.setMethodMaxInstructions(methodMaxInstructions);
        return context;
    }

    public IExecutable compile(int address, int instanceIndex) {
        if (!Memory.isAddressGood(address)) {
            if (this.isIgnoreInvalidMemory()) {
                log.warn((Object)String.format("IGNORING: Trying to compile an invalid address 0x%08X", address));
            } else {
                log.error((Object)String.format("Trying to compile an invalid address 0x%08X", address));
                Emulator.PauseEmu();
            }
            return null;
        }
        Emulator.getClock().pause();
        compileDuration.start();
        CompilerContext context = new CompilerContext(this.classLoader, instanceIndex);
        IExecutable executable = null;
        ClassFormatError error = null;
        RuntimeException exception = null;
        for (int retries = 2; retries > 0; --retries) {
            try {
                executable = this.analyse(context, address, false, instanceIndex);
                break;
            }
            catch (ClassFormatError e) {
                error = e;
                context = this.retryCompilation(context, instanceIndex, retries, e);
                continue;
            }
            catch (NullPointerException e) {
                log.error((Object)String.format("Catched exception '%s' while compiling 0x%08X (0x%08X-0x%08X)", e.toString(), address, context.getCodeBlock().getLowestAddress(), context.getCodeBlock().getHighestAddress()));
                break;
            }
            catch (RuntimeException e) {
                exception = e;
                context = this.retryCompilation(context, instanceIndex, retries, e);
            }
        }
        compileDuration.end();
        if (executable == null) {
            log.debug((Object)("Compilation failed with maxInstruction=" + context.getMethodMaxInstructions()));
            context = new CompilerContext(this.classLoader, instanceIndex);
            executable = this.interpret(context, address, instanceIndex);
            if (executable == null) {
                if (error != null) {
                    throw error;
                }
                if (exception != null) {
                    throw exception;
                }
            }
        } else if (error != null) {
            log.debug((Object)("Compilation was now correct with maxInstruction=" + context.getMethodMaxInstructions()));
        }
        Emulator.getClock().resume();
        return executable;
    }

    public CompilerClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(CompilerClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static int getResetCount() {
        return resetCount;
    }

    public static void setResetCount(int resetCount) {
        Compiler.resetCount = resetCount;
    }

    public NativeCodeManager getNativeCodeManager() {
        return this.nativeCodeManager;
    }

    public int getDefaultMethodMaxInstructions() {
        return this.defaultMethodMaxInstructions;
    }

    public void setDefaultMethodMaxInstructions(int defaultMethodMaxInstructions) {
        if (defaultMethodMaxInstructions > 0) {
            this.defaultMethodMaxInstructions = defaultMethodMaxInstructions;
            log.info((Object)String.format("Compiler MethodMaxInstructions: %d", defaultMethodMaxInstructions));
        }
    }

    public CompilerTypeManager getCompilerTypeManager() {
        return this.compilerTypeManager;
    }

    static {
        resetCount = 0;
        compileDuration = new CpuDurationStatistics("Compilation Time");
    }

    private class MethodMaxInstructionsSettingsListerner
    extends AbstractIntSettingsListener {
        private MethodMaxInstructionsSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(int value) {
            Compiler.this.setDefaultMethodMaxInstructions(value);
        }
    }

    private class IgnoreInvalidMemoryAccessSettingsListerner
    extends AbstractBoolSettingsListener {
        private IgnoreInvalidMemoryAccessSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            Compiler.this.setIgnoreInvalidMemory(value);
        }
    }
}

