/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import jpcsp.Allegrex.compiler.CodeBlock;
import jpcsp.Allegrex.compiler.CodeInstruction;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.SequenceCodeInstruction;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeManager;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeSequence;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import org.apache.log4j.Logger;

public class Profiler {
    public static Logger log = Logger.getLogger((String)"profiler");
    private static boolean profilerEnabled = false;
    private static final HashMap<Integer, Long> callCounts = new HashMap();
    private static final HashMap<Integer, Long> instructionCounts = new HashMap();
    private static final HashMap<Integer, Long> backBranchCounts = new HashMap();
    private static final Long zero = new Long(0L);
    private static final int detailedCodeBlockLogThreshold = 50;
    private static final int codeLogMaxLength = 700;
    private static final int backBranchMaxLength = 100;
    private static final int backBranchContextBefore = 5;
    private static final int backBranchContextAfter = 3;
    private static ProfilerEnabledSettingsListerner profilerEnabledSettingsListerner;

    public static void initialise() {
        if (profilerEnabledSettingsListerner == null) {
            profilerEnabledSettingsListerner = new ProfilerEnabledSettingsListerner();
            Settings.getInstance().registerSettingsListener("Profiler", "emu.profiler", profilerEnabledSettingsListerner);
        }
        Profiler.reset();
    }

    private static void setProfilerEnabled(boolean enabled) {
        profilerEnabled = enabled;
    }

    public static boolean isProfilerEnabled() {
        return profilerEnabled;
    }

    public static void reset() {
        if (!profilerEnabled) {
            return;
        }
        callCounts.clear();
        instructionCounts.clear();
        backBranchCounts.clear();
    }

    public static void exit() {
        if (!profilerEnabled) {
            return;
        }
        ArrayList<Integer> sortedBackBranches = new ArrayList<Integer>(backBranchCounts.keySet());
        Collections.sort(sortedBackBranches, new BackBranchComparator());
        ArrayList<CodeBlock> sortedCodeBlocks = new ArrayList<CodeBlock>(RuntimeContext.getCodeBlocks().values());
        Collections.sort(sortedCodeBlocks, new CodeBlockComparator());
        long allCycles = 0L;
        for (Long instructionCount : instructionCounts.values()) {
            allCycles += instructionCount.longValue();
        }
        int count = 0;
        log.info((Object)String.format("CodeBlocks profiling information (%,d total cycles):", allCycles));
        for (CodeBlock codeBlock : sortedCodeBlocks) {
            long callCount = Profiler.getCallCount(codeBlock);
            long instructionCount = Profiler.getInstructionCount(codeBlock);
            if (callCount == 0L && instructionCount == 0L) break;
            Profiler.logCodeBlock(codeBlock, allCycles, instructionCount, callCount, count, sortedBackBranches);
            ++count;
        }
    }

    private static void logCodeBlock(CodeBlock codeBlock, long allCycles, long instructionCount, long callCount, int count, List<Integer> sortedBackBranches) {
        String name = codeBlock.getClassName();
        NativeCodeManager nativeCodeManager = Compiler.getInstance().getNativeCodeManager();
        NativeCodeSequence nativeCodeSequence = nativeCodeManager.getCompiledNativeCodeBlock(codeBlock.getStartAddress());
        if (nativeCodeSequence != null) {
            name = String.format("%s (%s)", name, nativeCodeSequence.getName());
        }
        int lowestAddress = codeBlock.getLowestAddress();
        int highestAddress = codeBlock.getHighestAddress();
        int length = (highestAddress - lowestAddress) / 4 + 1;
        double percentage = 0.0;
        if (allCycles != 0L) {
            percentage = (double)instructionCount / (double)allCycles * 100.0;
        }
        log.info((Object)String.format("%s %,d instructions (%2.3f%%), %,d calls (%08X - %08X, length %d)", name, instructionCount, percentage, callCount, lowestAddress, highestAddress, length));
        if (count < 50 && codeBlock.getLength() <= 700) {
            Profiler.logCode(codeBlock);
        }
        for (int address : sortedBackBranches) {
            CodeInstruction codeInstruction;
            if (address < lowestAddress || address > highestAddress || (codeInstruction = codeBlock.getCodeInstruction(address)) == null) continue;
            int branchingToAddress = codeInstruction.getBranchingTo();
            int backBranchLength = (address - branchingToAddress) / 4 + 2;
            log.info((Object)String.format("  Back Branch %08X %,d times (length %d)", address, backBranchCounts.get(address), backBranchLength));
            if (count >= 50 || backBranchLength > 100) continue;
            Profiler.logCode(codeBlock, branchingToAddress, backBranchLength, 5, 3, address);
        }
    }

    private static void logCode(CodeBlock codeBlock) {
        Profiler.logCode(codeBlock, codeBlock.getLowestAddress(), codeBlock.getLength(), 0, 0, -1);
    }

    private static void logCode(SequenceCodeInstruction sequenceCodeInstruction, int highlightAddress) {
        for (CodeInstruction codeInstruction : sequenceCodeInstruction.getCodeSequence().getInstructions()) {
            Profiler.logCode(codeInstruction, highlightAddress);
        }
    }

    private static void logCode(CodeInstruction codeInstruction, int highlightAddress) {
        if (codeInstruction == null) {
            return;
        }
        int address = codeInstruction.getAddress();
        if (codeInstruction instanceof SequenceCodeInstruction) {
            Profiler.logCode((SequenceCodeInstruction)codeInstruction, highlightAddress);
        } else {
            int opcode = codeInstruction.getOpcode();
            String prefix = "   ";
            if (address == highlightAddress) {
                prefix = "-->";
            }
            String disasm = codeInstruction.getInsn() == null ? codeInstruction.toString() : codeInstruction.getInsn().disasm(address, opcode);
            log.info((Object)String.format("%s %08X:[%08X]: %s", prefix, address, opcode, disasm));
        }
    }

    private static void logCode(CodeBlock codeBlock, int startAddress, int length, int contextBefore, int contextAfter, int highlightAddress) {
        for (int i = -contextBefore; i < length + contextAfter; ++i) {
            int address = startAddress + i * 4;
            CodeInstruction codeInstruction = codeBlock.getCodeInstruction(address);
            if (highlightAddress >= 0 && address == startAddress) {
                Profiler.logCode(codeInstruction, startAddress);
                continue;
            }
            Profiler.logCode(codeInstruction, highlightAddress);
        }
    }

    private static long getCallCount(CodeBlock codeBlock) {
        Long callCount = callCounts.get(codeBlock.getStartAddress());
        if (callCount == null) {
            return 0L;
        }
        return callCount;
    }

    private static long getInstructionCount(CodeBlock codeBlock) {
        Long instructionCount = instructionCounts.get(codeBlock.getStartAddress());
        if (instructionCount == null) {
            return 0L;
        }
        return instructionCount;
    }

    public static void addCall(int address) {
        Long callCount = callCounts.get(address);
        if (callCount == null) {
            callCount = zero;
        }
        callCounts.put(address, callCount + 1L);
    }

    public static void addInstructionCount(int count, int address) {
        Long instructionCount = instructionCounts.get(address);
        if (instructionCount == null) {
            instructionCount = zero;
        }
        instructionCounts.put(address, instructionCount + (long)count);
    }

    public static void addBackBranch(int address) {
        Long backBranchCount = backBranchCounts.get(address);
        if (backBranchCount == null) {
            backBranchCount = zero;
        }
        backBranchCounts.put(address, backBranchCount + 1L);
    }

    private static class CodeBlockComparator
    implements Comparator<CodeBlock> {
        private CodeBlockComparator() {
        }

        @Override
        public int compare(CodeBlock codeBlock1, CodeBlock codeBlock2) {
            long callCount2;
            long instructionCallCount2;
            long instructionCallCount1 = Profiler.getInstructionCount(codeBlock1);
            if (instructionCallCount1 != (instructionCallCount2 = Profiler.getInstructionCount(codeBlock2))) {
                return instructionCallCount2 > instructionCallCount1 ? 1 : -1;
            }
            long callCount1 = Profiler.getCallCount(codeBlock1);
            if (callCount1 != (callCount2 = Profiler.getCallCount(codeBlock2))) {
                return callCount2 > callCount1 ? 1 : -1;
            }
            return codeBlock2.getStartAddress() - codeBlock1.getStartAddress();
        }
    }

    private static class BackBranchComparator
    implements Comparator<Integer> {
        private BackBranchComparator() {
        }

        @Override
        public int compare(Integer address1, Integer address2) {
            long count1 = (Long)backBranchCounts.get(address1);
            long count2 = (Long)backBranchCounts.get(address2);
            return count2 > count1 ? 1 : -1;
        }
    }

    private static class ProfilerEnabledSettingsListerner
    extends AbstractBoolSettingsListener {
        private ProfilerEnabledSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            Profiler.setProfilerEnabled(value);
        }
    }
}

