/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.nativeCode.INativeCodeSequence;
import jpcsp.Memory;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public abstract class AbstractNativeCodeSequence
implements INativeCodeSequence {
    protected static int[] toUpperCase = AbstractNativeCodeSequence.buildToUpperCase();
    protected static int[] toLowerCase = AbstractNativeCodeSequence.buildToLowerCase();

    static int[] buildToUpperCase() {
        int[] toUpperCase = new int[256];
        for (int c = 0; c < toUpperCase.length; ++c) {
            toUpperCase[c] = c >= 97 && c <= 122 ? c - 32 : c;
        }
        return toUpperCase;
    }

    static int[] buildToLowerCase() {
        int[] toLowerCase = new int[256];
        for (int c = 0; c < toLowerCase.length; ++c) {
            toLowerCase[c] = c >= 65 && c <= 90 ? c + 32 : c;
        }
        return toLowerCase;
    }

    protected static CpuState getCpu() {
        return RuntimeContext.cpu;
    }

    protected static Memory getMemory() {
        return RuntimeContext.memory;
    }

    protected static int getRegisterValue(int register) {
        return AbstractNativeCodeSequence.getCpu().getRegister(register);
    }

    protected static long getLong(int low, int high) {
        return (long)high << 32 | (long)low;
    }

    protected static int getGprA0() {
        return AbstractNativeCodeSequence.getCpu()._a0;
    }

    protected static int getGprA1() {
        return AbstractNativeCodeSequence.getCpu()._a1;
    }

    protected static int getGprA2() {
        return AbstractNativeCodeSequence.getCpu()._a2;
    }

    protected static int getGprA3() {
        return AbstractNativeCodeSequence.getCpu()._a3;
    }

    protected static int getGprT0() {
        return AbstractNativeCodeSequence.getCpu()._t0;
    }

    protected static int getGprT1() {
        return AbstractNativeCodeSequence.getCpu()._t1;
    }

    protected static int getGprT2() {
        return AbstractNativeCodeSequence.getCpu()._t2;
    }

    protected static int getGprT3() {
        return AbstractNativeCodeSequence.getCpu()._t3;
    }

    protected static int getStackParam0() {
        return AbstractNativeCodeSequence.getMemory().read32(AbstractNativeCodeSequence.getGprSp());
    }

    protected static int getStackParam1() {
        return AbstractNativeCodeSequence.getMemory().read32(AbstractNativeCodeSequence.getGprSp() + 4);
    }

    protected static int getStackParam2() {
        return AbstractNativeCodeSequence.getMemory().read32(AbstractNativeCodeSequence.getGprSp() + 8);
    }

    protected static int getGprSp() {
        return AbstractNativeCodeSequence.getCpu()._sp;
    }

    protected static void setGprV0(int v0) {
        AbstractNativeCodeSequence.getCpu()._v0 = v0;
    }

    protected static void setGprV0V1(long v0v1) {
        AbstractNativeCodeSequence.getCpu()._v0 = (int)v0v1;
        AbstractNativeCodeSequence.getCpu()._v1 = (int)(v0v1 >> 32);
    }

    protected static void setRegisterValue(int register, int value) {
        AbstractNativeCodeSequence.getCpu().setRegister(register, value);
    }

    static float[] getFpr() {
        return AbstractNativeCodeSequence.getCpu().fpr;
    }

    protected static float getFprF12() {
        return AbstractNativeCodeSequence.getFpr()[12];
    }

    protected static void setFprF0(float f0) {
        AbstractNativeCodeSequence.getFpr()[0] = f0;
    }

    protected static float getFRegisterValue(int register) {
        return AbstractNativeCodeSequence.getFpr()[register];
    }

    protected static int getStrlen(int srcAddr) {
        int value;
        int srcAddr3 = srcAddr & 3;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(srcAddr - srcAddr3, 4);
        if (memoryReader == null) {
            Compiler.log.warn((Object)"getStrlen: null MemoryReader");
            return 0;
        }
        int offset = 0;
        switch (srcAddr3) {
            case 1: {
                value = memoryReader.readNext();
                if ((value & 0xFF00) == 0) {
                    return 0;
                }
                if ((value & 0xFF0000) == 0) {
                    return 1;
                }
                if ((value & 0xFF000000) == 0) {
                    return 2;
                }
                offset = 3;
                break;
            }
            case 2: {
                value = memoryReader.readNext();
                if ((value & 0xFF0000) == 0) {
                    return 0;
                }
                if ((value & 0xFF000000) == 0) {
                    return 1;
                }
                offset = 2;
                break;
            }
            case 3: {
                value = memoryReader.readNext();
                if ((value & 0xFF000000) == 0) {
                    return 0;
                }
                offset = 1;
            }
        }
        while (((value = memoryReader.readNext()) & 0xFF) != 0) {
            if ((value & 0xFF00) == 0) {
                return offset + 1;
            }
            if ((value & 0xFF0000) == 0) {
                return offset + 2;
            }
            if ((value & 0xFF000000) == 0) {
                return offset + 3;
            }
            offset += 4;
        }
        return offset;
    }

    protected static int getRelocatedAddress(int address1, int address2) {
        int address = (address1 << 16) + (short)address2;
        return address & 0x3FFFFFFF;
    }
}

