/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;
import jpcsp.Memory;

public class SceKernelLwMutexInfo
extends pspAbstractMemoryMappedStructureVariableLength {
    public final String name;
    public final int attr;
    public final int lwMutexUid;
    public final int lwMutexOpaqueWorkAreaAddr;
    public final int initCount;
    public int lockedCount;
    public int numWaitThreads;
    public final int uid;
    public int threadid;

    public SceKernelLwMutexInfo(int workArea, String name, int count, int attr) {
        Memory mem = Memory.getInstance();
        this.lwMutexUid = 0;
        this.lwMutexOpaqueWorkAreaAddr = workArea;
        this.name = name;
        this.attr = attr;
        this.initCount = count;
        this.lockedCount = count;
        this.numWaitThreads = 0;
        this.uid = SceUidManager.getNewUid("ThreadMan-LwMutex");
        mem.write32(this.lwMutexOpaqueWorkAreaAddr, this.uid);
    }

    @Override
    protected void write() {
        super.write();
        this.writeStringNZ(32, this.name);
        this.write32(this.attr);
        this.write32(this.lwMutexUid);
        this.write32(this.lwMutexOpaqueWorkAreaAddr);
        this.write32(this.initCount);
        this.write32(this.lockedCount);
        this.write32(this.numWaitThreads);
    }

    @Override
    public String toString() {
        return String.format("SceKernelLwMutexInfo(uid=%x, name=%s, mutexUid=%x, lwMutexOpaqueWorkAreaAddr=0x%X, initCount=%d, lockedCount=%d, numWaitThreads=%d, attr=0x%X, threadid=0x%X)", this.uid, this.name, this.lwMutexUid, this.lwMutexOpaqueWorkAreaAddr, this.initCount, this.lockedCount, this.numWaitThreads, this.attr, this.threadid);
    }
}

