/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;

public class ScePspDateTime
extends pspAbstractMemoryMappedStructure {
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final int SIZEOF = 16;
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int second;
    public int microsecond;

    public ScePspDateTime() {
        Calendar cal = Calendar.getInstance();
        this.year = cal.get(1);
        this.month = 1 + cal.get(2);
        this.day = cal.get(5);
        this.hour = cal.get(11);
        this.minute = cal.get(12);
        this.second = cal.get(13);
        this.microsecond = cal.get(14) * 1000;
    }

    public ScePspDateTime(int timezone) {
        int minutes;
        Calendar cal = Calendar.getInstance();
        int hours = 0;
        for (minutes = timezone; minutes > 59; minutes -= 60) {
            ++hours;
        }
        String timeString = String.format("UTC+%02d%02d", hours, minutes);
        TimeZone tz = TimeZone.getTimeZone(timeString);
        cal.setTimeZone(tz);
        this.year = cal.get(1);
        this.month = 1 + cal.get(2);
        this.day = cal.get(5);
        this.hour = cal.get(11);
        this.minute = cal.get(12);
        this.second = cal.get(13);
        this.microsecond = cal.get(14) * 1000;
    }

    public ScePspDateTime(int year, int month, int day, int hour, int minute, int second, int microsecond) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.microsecond = microsecond;
    }

    public static ScePspDateTime fromMSDOSTime(long time) {
        long milliseconds = time / 10000L;
        long days = milliseconds / 86400000L;
        long hours = (milliseconds -= days * 86400000L) / 3600000L;
        long minutes = (milliseconds -= hours * 3600000L) / 60000L;
        long seconds = (milliseconds -= minutes * 60000L) / 1000L;
        milliseconds -= seconds * 1000L;
        Calendar cal = Calendar.getInstance();
        cal.set(1980, 0, 1, 0, 0, 0);
        cal.add(5, (int)days);
        cal.add(11, (int)hours);
        cal.add(12, (int)minutes);
        cal.add(13, (int)seconds);
        cal.add(14, (int)milliseconds);
        int year = cal.get(1);
        int month = 1 + cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int microsecond = cal.get(14) * 1000;
        return new ScePspDateTime(year, month, day, hour, minute, second, microsecond);
    }

    public static ScePspDateTime fromFILETIMETime(long time) {
        long milliseconds = time / 10000L;
        long days = milliseconds / 86400000L;
        long hours = (milliseconds -= days * 86400000L) / 3600000L;
        long minutes = (milliseconds -= hours * 3600000L) / 60000L;
        long seconds = (milliseconds -= minutes * 60000L) / 1000L;
        milliseconds -= seconds * 1000L;
        Calendar cal = Calendar.getInstance();
        cal.set(1601, 0, 1, 0, 0, 0);
        cal.add(5, (int)days);
        cal.add(11, (int)hours);
        cal.add(12, (int)minutes);
        cal.add(13, (int)seconds);
        cal.add(14, (int)milliseconds);
        int year = cal.get(1);
        int month = 1 + cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int microsecond = cal.get(14) * 1000;
        return new ScePspDateTime(year, month, day, hour, minute, second, microsecond);
    }

    public static ScePspDateTime fromUnixTime(long time) {
        Calendar cal = Calendar.getInstance();
        Date date = new Date(time);
        cal.setTime(date);
        int year = cal.get(1);
        int month = 1 + cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int microsecond = cal.get(14) * 1000;
        return new ScePspDateTime(year, month, day, hour, minute, second, microsecond);
    }

    public static ScePspDateTime fromMicros(long micros) {
        Calendar cal = Calendar.getInstance(GMT);
        Date date = new Date(micros / 1000L);
        cal.setTime(date);
        int year = cal.get(1);
        int month = 1 + cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int microsecond = (int)(micros % 1000000L);
        return new ScePspDateTime(year, month, day, hour, minute, second, microsecond);
    }

    @Override
    protected void read() {
        this.year = this.read16();
        this.month = this.read16();
        this.day = this.read16();
        this.hour = this.read16();
        this.minute = this.read16();
        this.second = this.read16();
        this.microsecond = this.read32();
    }

    @Override
    protected void write() {
        this.write16((short)this.year);
        this.write16((short)this.month);
        this.write16((short)this.day);
        this.write16((short)this.hour);
        this.write16((short)this.minute);
        this.write16((short)this.second);
        this.write32(this.microsecond);
    }

    @Override
    public int sizeof() {
        return 16;
    }

    @Override
    public String toString() {
        return String.format("%04d-%02d-%02d %02d:%02d:%02d", this.year, this.month, this.day, this.hour, this.minute, this.second);
    }
}

