/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.VFS.ITmpVirtualFileSystem;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.VirtualFileSystemManager;
import jpcsp.HLE.VFS.emulator.EmulatorVirtualFileSystem;
import jpcsp.HLE.VFS.local.TmpLocalVirtualFileSystem;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceIoDirent;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.Processor;
import jpcsp.Resource;
import jpcsp.connector.PGDFileConnector;
import jpcsp.crypto.CryptoEngine;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.hardware.MemoryStick;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.JpcspDialogManager;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

@HLELogging
public class IoFileMgrForUser
extends HLEModule {
    public static Logger log = Modules.getLogger("IoFileMgrForUser");
    private static Logger stdout = Logger.getLogger((String)"stdout");
    private static Logger stderr = Logger.getLogger((String)"stderr");
    public static final int PSP_O_RDONLY = 1;
    public static final int PSP_O_WRONLY = 2;
    public static final int PSP_O_RDWR = 3;
    public static final int PSP_O_NBLOCK = 4;
    public static final int PSP_O_DIROPEN = 8;
    public static final int PSP_O_APPEND = 256;
    public static final int PSP_O_CREAT = 512;
    public static final int PSP_O_TRUNC = 1024;
    public static final int PSP_O_EXCL = 2048;
    public static final int PSP_O_NBUF = 16384;
    public static final int PSP_O_NOWAIT = 32768;
    public static final int PSP_O_PLOCK = 0x2000000;
    public static final int PSP_O_FGAMEDATA = 0x40000000;
    public static final int PSP_O_RETRY_0 = 0;
    public static final int PSP_O_RETRY_1 = 65536;
    public static final int PSP_O_RETRY_2 = 131072;
    public static final int PSP_O_RETRY_3 = 196608;
    public static final int PSP_O_RETRY_4 = 262144;
    public static final int PSP_O_RETRY_5 = 327680;
    public static final int PSP_O_RETRY_6 = 393216;
    public static final int PSP_O_RETRY_7 = 458752;
    public static final int PSP_O_RETRY_8 = 524288;
    public static final int PSP_O_RETRY_9 = 589824;
    public static final int PSP_O_RETRY_10 = 655360;
    public static final int PSP_O_RETRY_11 = 720896;
    public static final int PSP_O_RETRY_12 = 786432;
    public static final int PSP_O_RETRY_13 = 851968;
    public static final int PSP_O_RETRY_14 = 917504;
    public static final int PSP_O_RETRY_15 = 983040;
    public static final int PSP_SEEK_SET = 0;
    public static final int PSP_SEEK_CUR = 1;
    public static final int PSP_SEEK_END = 2;
    public static final int PSP_DEV_TYPE_NONE = 0;
    public static final int PSP_DEV_TYPE_CHARACTER = 1;
    public static final int PSP_DEV_TYPE_BLOCK = 4;
    public static final int PSP_DEV_TYPE_FILESYSTEM = 16;
    public static final int PSP_DEV_TYPE_ALIAS = 32;
    public static final int PSP_DEV_TYPE_MOUNT = 64;
    public static final int STDIN_ID = 0;
    public static final int STDOUT_ID = 1;
    public static final int STDERR_ID = 2;
    private static final int MIN_ID = 3;
    private static final int MAX_ID = 63;
    private static final String idPurpose = "IOFileManager-File";
    private static final boolean useVirtualFileSystem = false;
    protected VirtualFileSystemManager vfsManager;
    private static final String[] modeStrings = new String[]{"r", "r", "rw", "rw"};
    public HashMap<Integer, IoInfo> fileIds;
    public HashMap<Integer, IoInfo> fileUids;
    public HashMap<Integer, IoDirInfo> dirIds;
    private String filepath;
    private UmdIsoReader iso;
    private IoWaitStateChecker ioWaitStateChecker;
    private String host0Path;
    private int defaultAsyncPriority;
    private static final int asyncThreadRegisterArgument = 16;
    private boolean noDelayIoOperation;
    private PGDFileConnector pgdFileConnector;
    private boolean allowExtractPGD;
    private IIoListener[] ioListeners;
    private final String[] umdPrefixes = new String[]{"disc", "umd"};

    @Override
    public String getName() {
        return "IoFileMgrForUser";
    }

    public void registerUmdIso() {
        if (this.vfsManager != null) {
            // empty if block
        }
    }

    @Override
    public void start() {
        if (this.fileIds != null) {
            for (IoInfo info : this.fileIds.values()) {
                try {
                    info.readOnlyFile.close();
                }
                catch (IOException e) {
                    log.error((Object)("pspiofilemgr - error closing file: " + e.getMessage()));
                }
            }
        }
        this.fileIds = new HashMap();
        this.fileUids = new HashMap();
        this.dirIds = new HashMap();
        MemoryStick.setStateMs(1);
        this.defaultAsyncPriority = -1;
        if (this.ioListeners == null) {
            this.ioListeners = new IIoListener[0];
        }
        this.ioWaitStateChecker = new IoWaitStateChecker();
        this.host0Path = null;
        this.noDelayIoOperation = false;
        this.vfsManager = new VirtualFileSystemManager();
        this.vfsManager.register(new TmpLocalVirtualFileSystem());
        this.vfsManager.register("emulator", new EmulatorVirtualFileSystem());
        this.vfsManager.register("kemulator", new EmulatorVirtualFileSystem());
        this.setSettingsListener("emu.extractPGD", new ExtractPGDSettingsListerner());
        super.start();
    }

    public void setHost0Path(String path) {
        this.host0Path = path;
    }

    private void setAllowExtractPGDStatus(boolean status) {
        this.allowExtractPGD = status;
    }

    private boolean getAllowExtractPGDStatus() {
        return this.allowExtractPGD;
    }

    public IoInfo getFileIoInfo(int id) {
        return this.fileIds.get(id);
    }

    private static int getNewUid() {
        return SceUidManager.getNewUid(idPurpose);
    }

    private static void releaseUid(int uid) {
        SceUidManager.releaseUid(uid, idPurpose);
    }

    private static int getNewId() {
        return SceUidManager.getNewId(idPurpose, 3, 63);
    }

    private static void releaseId(int id) {
        SceUidManager.releaseId(id, idPurpose);
    }

    private String removeDotDotInFilename(String fileName) {
        int parentIndex;
        int dotDotIndex;
        while ((dotDotIndex = fileName.indexOf("/..")) >= 0 && (parentIndex = fileName.substring(0, dotDotIndex).lastIndexOf("/")) >= 0) {
            fileName = fileName.substring(0, parentIndex) + fileName.substring(dotDotIndex + 3);
        }
        return fileName;
    }

    private String getAbsoluteFileName(String fileName) {
        if (this.filepath == null || fileName.contains(":")) {
            return fileName;
        }
        String absoluteFileName = this.filepath;
        if (!absoluteFileName.endsWith("/") && !fileName.startsWith("/")) {
            absoluteFileName = absoluteFileName + "/";
        }
        absoluteFileName = absoluteFileName + fileName;
        absoluteFileName = absoluteFileName.replaceFirst("^disc0/", "disc0:");
        absoluteFileName = absoluteFileName.replaceFirst("^ms0/", "ms0:");
        return absoluteFileName;
    }

    public String getDeviceFilePath(String pspfilename) {
        pspfilename = pspfilename.replaceAll("\\\\", "/");
        String device = null;
        String cwd = "";
        String filename = null;
        if (pspfilename.startsWith("flash0:")) {
            if (pspfilename.startsWith("flash0:/")) {
                return pspfilename.replace("flash0:", "flash0");
            }
            return pspfilename.replace("flash0:", "flash0/");
        }
        if (this.host0Path != null && pspfilename.startsWith("host0:") && !pspfilename.startsWith("host0:/")) {
            pspfilename = pspfilename.replace("host0:", this.host0Path);
            pspfilename = this.removeDotDotInFilename(pspfilename);
        }
        if (this.filepath == null) {
            return pspfilename;
        }
        int findcolon = pspfilename.indexOf(":");
        if (findcolon != -1) {
            device = pspfilename.substring(0, findcolon);
            pspfilename = pspfilename.substring(findcolon + 1);
        } else {
            int findslash = this.filepath.indexOf("/");
            if (findslash != -1) {
                device = this.filepath.substring(0, findslash);
                cwd = this.filepath.substring(findslash + 1);
                if (cwd.startsWith("/")) {
                    cwd = cwd.substring(1);
                }
                if (cwd.endsWith("/")) {
                    cwd = cwd.substring(0, cwd.length() - 1);
                }
            } else {
                device = this.filepath;
            }
        }
        if (device.equals("host0")) {
            device = this.iso != null ? "disc0" : "ms0";
        }
        if (device.equals("fatms0")) {
            device = "ms0";
        }
        if (device.startsWith("umd")) {
            pspfilename = "";
        }
        if (pspfilename.startsWith("/")) {
            pspfilename = pspfilename.substring(1);
        }
        if (pspfilename.endsWith("/")) {
            pspfilename = pspfilename.substring(0, pspfilename.length() - 1);
        }
        filename = device.toLowerCase();
        if (cwd.length() > 0) {
            filename = filename + "/" + cwd;
        }
        if (pspfilename.length() > 0) {
            filename = filename + "/" + pspfilename;
        }
        return filename;
    }

    private boolean isUmdPath(String deviceFilePath) {
        for (int i = 0; i < this.umdPrefixes.length; ++i) {
            if (!deviceFilePath.matches("^" + this.umdPrefixes[i] + "[0-9]+.*")) continue;
            return true;
        }
        return false;
    }

    private String trimUmdPrefix(String pcfilename) {
        for (int i = 0; i < this.umdPrefixes.length; ++i) {
            if (pcfilename.matches("^" + this.umdPrefixes[i] + "[0-9]+/.*")) {
                return pcfilename.substring(pcfilename.indexOf("/") + 1);
            }
            if (!pcfilename.matches("^" + this.umdPrefixes[i] + "[0-9]+")) continue;
            return "";
        }
        return pcfilename;
    }

    public void mkdirs(String dir) {
        String pcfilename = this.getDeviceFilePath(dir);
        if (pcfilename != null) {
            File f = new File(pcfilename);
            f.mkdirs();
        }
    }

    private boolean rmdir(File f, boolean recursive) {
        boolean subDirResult = true;
        if (recursive && f.isDirectory()) {
            File[] subFiles = f.listFiles();
            for (int i = 0; subFiles != null && i < subFiles.length; ++i) {
                if (this.rmdir(subFiles[i], recursive)) continue;
                subDirResult = false;
            }
        }
        return f.delete() && subDirResult;
    }

    public boolean rmdir(String dir, boolean recursive) {
        String pcfilename = this.getDeviceFilePath(dir);
        if (pcfilename == null) {
            return false;
        }
        File f = new File(pcfilename);
        return this.rmdir(f, recursive);
    }

    public String[] listFiles(String dir, String pattern) {
        String pcfilename = this.getDeviceFilePath(dir);
        if (pcfilename == null) {
            return null;
        }
        File f = new File(pcfilename);
        return pattern == null ? f.list() : f.list(new PatternFilter(pattern));
    }

    public SceIoStat statFile(String pspfilename) {
        StringBuilder localFileName;
        String pcfilename = this.getDeviceFilePath(pspfilename);
        if (pcfilename == null) {
            return null;
        }
        SceIoStat stat = null;
        String absoluteFileName = this.getAbsoluteFileName(pspfilename);
        IVirtualFileSystem vfs = this.vfsManager.getVirtualFileSystem(absoluteFileName, localFileName = new StringBuilder());
        if (vfs != null) {
            stat = new SceIoStat();
            int result = vfs.ioGetstat(localFileName.toString(), stat);
            if (result < 0) {
                stat = null;
            }
        } else {
            stat = this.stat(pcfilename);
        }
        return stat;
    }

    private SceIoStat stat(String pcfilename) {
        SceIoStat stat = null;
        if (pcfilename != null) {
            if (this.isUmdPath(pcfilename)) {
                if (this.iso == null) {
                    log.error((Object)"stat - no umd mounted");
                    Emulator.getProcessor().cpu._v0 = -2147418093;
                } else if (!Modules.sceUmdUserModule.isUmdActivated()) {
                    log.warn((Object)"stat - umd mounted but not activated");
                    Emulator.getProcessor().cpu._v0 = -2147351775;
                } else {
                    String isofilename = this.trimUmdPrefix(pcfilename);
                    int mode = 4;
                    int attr = 0;
                    long size = 0L;
                    long timestamp = 0L;
                    int startSector = 0;
                    try {
                        UmdIsoFile file = this.iso.getFile(isofilename);
                        attr = 32;
                        size = file.length();
                        timestamp = file.getTimestamp().getTime();
                        startSector = file.getStartSector();
                        mode = mode + mode * 8 + mode * 64;
                        stat = new SceIoStat(mode |= attr << 8, attr, size, ScePspDateTime.fromUnixTime(timestamp), ScePspDateTime.fromUnixTime(0L), ScePspDateTime.fromUnixTime(timestamp));
                        if (startSector > 0) {
                            stat.setReserved(0, startSector);
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        try {
                            if (this.iso.isDirectory(isofilename)) {
                                attr |= 0x10;
                                mode |= 1;
                            }
                            mode = mode + mode * 8 + mode * 64;
                            stat = new SceIoStat(mode |= attr << 8, attr, size, ScePspDateTime.fromUnixTime(timestamp), ScePspDateTime.fromUnixTime(0L), ScePspDateTime.fromUnixTime(timestamp));
                            if (startSector > 0) {
                                stat.setReserved(0, startSector);
                            }
                        }
                        catch (FileNotFoundException dnfe) {
                            log.warn((Object)("stat - '" + isofilename + "' umd file/dir not found"));
                        }
                        catch (IOException e) {
                            log.warn((Object)("stat - umd io error: " + e.getMessage()));
                        }
                    }
                    catch (IOException e) {
                        log.warn((Object)("stat - umd io error: " + e.getMessage()));
                    }
                }
            } else {
                File file = new File(pcfilename);
                if (file.exists()) {
                    int mode = (file.canRead() ? 4 : 0) + (file.canWrite() ? 2 : 0) + (file.canExecute() ? 1 : 0);
                    int attr = 0;
                    long size = file.length();
                    long mtime = file.lastModified();
                    mode = mode + mode * 8 + mode * 64;
                    if (file.isDirectory()) {
                        attr |= 0x10;
                    }
                    if (file.isFile()) {
                        attr |= 0x20;
                    }
                    stat = new SceIoStat(mode |= attr << 8, attr, size, ScePspDateTime.fromUnixTime(mtime), ScePspDateTime.fromUnixTime(0L), ScePspDateTime.fromUnixTime(mtime));
                }
            }
        }
        return stat;
    }

    public SeekableDataInput getFile(String filename, int flags) {
        SeekableDataInput resultFile;
        block15: {
            resultFile = null;
            String pcfilename = this.getDeviceFilePath(filename);
            if (pcfilename != null) {
                if (this.isUmdPath(pcfilename)) {
                    if (this.iso == null) {
                        log.error((Object)"getFile - no umd mounted");
                        return resultFile;
                    }
                    if ((flags & 2) == 2 || (flags & 0x200) == 512 || (flags & 0x400) == 1024) {
                        log.error((Object)"getFile - refusing to open umd media for write");
                        return resultFile;
                    }
                    try {
                        UmdIsoFile file = this.iso.getFile(this.trimUmdPrefix(pcfilename));
                        resultFile = file;
                    }
                    catch (FileNotFoundException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("getFile - umd file not found '" + pcfilename + "' (ok to ignore this message, debug purpose only)"));
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)("getFile - error opening umd media: " + e.getMessage()));
                    }
                } else {
                    File file = new File(pcfilename);
                    if (file.exists() && (flags & 0x200) == 512 && (flags & 0x800) == 2048) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"getFile - file already exists (PSP_O_CREAT + PSP_O_EXCL)");
                        }
                    } else {
                        if (file.exists() && (flags & 0x400) == 1024) {
                            log.warn((Object)"getFile - file already exists, deleting UNIMPLEMENT (PSP_O_TRUNC)");
                        }
                        String mode = this.getMode(flags);
                        try {
                            SeekableRandomFile raf;
                            resultFile = raf = new SeekableRandomFile(pcfilename, mode);
                        }
                        catch (FileNotFoundException e) {
                            if (!log.isDebugEnabled()) break block15;
                            log.debug((Object)("getFile - file not found '" + pcfilename + "' (ok to ignore this message, debug purpose only)"));
                        }
                    }
                }
            }
        }
        return resultFile;
    }

    public SeekableDataInput getFile(int id) {
        IoInfo info = this.fileIds.get(id);
        if (info == null) {
            return null;
        }
        return info.readOnlyFile;
    }

    public String getFileFilename(int id) {
        IoInfo info = this.fileIds.get(id);
        if (info == null) {
            return null;
        }
        return info.filename;
    }

    private String getMode(int flags) {
        return modeStrings[flags & 3];
    }

    private long updateResult(IoInfo info, long result, boolean async, boolean resultIs64bit, IoOperation ioOperation) {
        return this.updateResult(info, result, async, resultIs64bit, ioOperation, null, 0);
    }

    private long updateResult(IoInfo info, long result, boolean async, boolean resultIs64bit, IoOperation ioOperation, IAction asyncAction, int size) {
        if (info != null && result != -2147351767L) {
            if (async) {
                if (!info.asyncPending) {
                    this.startIoAsync(info, result, ioOperation, asyncAction, size);
                    result = 0L;
                }
            } else {
                info.result = -2147351766L;
            }
        }
        return result;
    }

    public static String getWhenceName(int whence) {
        switch (whence) {
            case 0: {
                return "PSP_SEEK_SET";
            }
            case 1: {
                return "PSP_SEEK_CUR";
            }
            case 2: {
                return "PSP_SEEK_END";
            }
        }
        return "UNHANDLED " + whence;
    }

    public void setfilepath(String filepath) {
        filepath = filepath.replaceAll("\\\\", "/");
        log.info((Object)("pspiofilemgr - filepath " + filepath));
        this.filepath = filepath;
    }

    public void setIsoReader(UmdIsoReader iso) {
        this.iso = iso;
        this.registerUmdIso();
    }

    public UmdIsoReader getIsoReader() {
        return this.iso;
    }

    protected void delayIoOperation(IoOperation ioOperation) {
        if (!this.noDelayIoOperation && ioOperation.delayMillis > 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(ioOperation.delayMillis * 1000, false);
        }
    }

    public void hleSetNoDelayIoOperation(boolean noDelayIoOperation) {
        this.noDelayIoOperation = noDelayIoOperation;
    }

    public void hleAsyncThread(Processor processor) {
        CpuState cpu = processor.cpu;
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        int uid = cpu.getRegister(16);
        IoInfo info = this.fileUids.get(uid);
        if (info == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleAsyncThread non-existing uid=%x", uid));
            }
            cpu._v0 = 0;
            threadMan.hleKernelExitDeleteThread();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleAsyncThread id=%x", info.id));
            }
            boolean asyncCompleted = this.doStepAsync(info);
            if (threadMan.getCurrentThread() == info.asyncThread) {
                if (asyncCompleted) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Async IO completed", new Object[0]));
                    }
                    threadMan.hleKernelSleepThread(false);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Async IO not yet completed", new Object[0]));
                    }
                    threadMan.hleKernelDelayThread(info.getAsyncRestMillis() * 1000, false);
                }
            }
        }
    }

    private void triggerAsyncThread(IoInfo info) {
        if (info.asyncThread != null) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            threadMan.hleKernelWakeupThread(info.asyncThread);
        }
    }

    private void startIoAsync(IoInfo info, long result, IoOperation ioOperation, IAction asyncAction, int size) {
        if (info == null) {
            return;
        }
        info.asyncPending = true;
        info.asyncResultPending = false;
        long now = Emulator.getClock().currentTimeMillis();
        info.asyncDoneMillis = now + (long)ioOperation.getDelayMillis(size);
        info.asyncAction = asyncAction;
        info.result = result;
        if (info.asyncThread == null) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            int asyncPriority = info.asyncThreadPriority;
            if (asyncPriority < 0) {
                asyncPriority = threadMan.getCurrentThread().currentPriority;
            }
            int stackSize = 8192;
            if (Emulator.getInstance().getFirmwareVersion() > 150) {
                stackSize = 2048;
            }
            info.asyncThread = threadMan.hleKernelCreateThread("SceIofileAsync", 0x8000040, asyncPriority, stackSize, threadMan.getCurrentThread().attr, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Starting Async IO thread %s", info.asyncThread));
            }
            threadMan.hleKernelStartThread(info.asyncThread, 0, 0, info.asyncThread.gpReg_addr);
            info.asyncThread.cpuContext.setRegister(16, info.uid);
        } else {
            this.triggerAsyncThread(info);
        }
    }

    private boolean doStepAsync(IoInfo info) {
        boolean done = true;
        if (info.asyncAction != null) {
            IAction asyncAction = info.asyncAction;
            info.asyncAction = null;
            asyncAction.execute();
        }
        if (info.asyncPending) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            if (info.getAsyncRestMillis() > 0) {
                done = false;
            } else {
                info.asyncPending = false;
                info.asyncResultPending = true;
                if (info.cbid >= 0) {
                    threadMan.hleKernelNotifyCallback(1, info.cbid, info.notifyArg);
                }
                Iterator<SceKernelThreadInfo> it = threadMan.iterator();
                while (it.hasNext()) {
                    SceKernelThreadInfo thread = it.next();
                    if (thread.waitType != 256 || thread.wait.Io_id != info.id) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("IoFileMgrForUser.doStepAsync - onContextSwitch waking " + Integer.toHexString(thread.uid) + " thread:'" + thread.name + "'"));
                    }
                    Memory mem = Memory.getInstance();
                    if (Memory.isAddressGood(thread.wait.Io_resultAddr)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("IoFileMgrForUser.doStepAsync - storing result 0x" + Long.toHexString(info.result)));
                        }
                        mem.write64(thread.wait.Io_resultAddr, info.result);
                    }
                    info.result = -2147351766L;
                    info.asyncResultPending = false;
                    thread.cpuContext._v0 = 0;
                    threadMan.hleChangeThreadState(thread, 2);
                }
            }
        }
        return done;
    }

    public void unregisterIoListener(IIoListener ioListener) {
        if (this.ioListeners != null) {
            for (int i = 0; i < this.ioListeners.length; ++i) {
                if (this.ioListeners[i] != ioListener) continue;
                IIoListener[] newIoListeners = new IIoListener[this.ioListeners.length - 1];
                System.arraycopy(this.ioListeners, 0, newIoListeners, 0, i);
                System.arraycopy(this.ioListeners, i + 1, newIoListeners, i, this.ioListeners.length - i - 1);
                this.ioListeners = newIoListeners;
                break;
            }
        }
    }

    public void registerIoListener(IIoListener ioListener) {
        if (this.ioListeners == null) {
            this.ioListeners = new IIoListener[1];
            this.ioListeners[0] = ioListener;
        } else {
            for (int i = 0; i < this.ioListeners.length; ++i) {
                if (this.ioListeners[i] != ioListener) continue;
                return;
            }
            IIoListener[] newIoListeners = new IIoListener[this.ioListeners.length + 1];
            System.arraycopy(this.ioListeners, 0, newIoListeners, 0, this.ioListeners.length);
            newIoListeners[this.ioListeners.length] = ioListener;
            this.ioListeners = newIoListeners;
        }
    }

    private IoInfo getInfo(IVirtualFile vFile) {
        for (IoInfo info : this.fileIds.values()) {
            if (info.vFile != vFile) continue;
            return info;
        }
        return null;
    }

    public long getPosition(IVirtualFile vFile) {
        IoInfo info = this.getInfo(vFile);
        if (info == null) {
            return -1L;
        }
        return info.position;
    }

    public void setPosition(IVirtualFile vFile, long position) {
        IoInfo info = this.getInfo(vFile);
        if (info != null) {
            info.position = position;
        }
    }

    public int hleIoWaitAsync(int id, int res_addr, boolean wait, boolean callbacks) {
        IoInfo info;
        if (log.isDebugEnabled()) {
            log.debug((Object)("hleIoWaitAsync(id=" + Integer.toHexString(id) + ",res=0x" + Integer.toHexString(res_addr) + ") wait=" + wait + " callbacks=" + callbacks));
        }
        if ((info = this.fileIds.get(id)) == null) {
            log.warn((Object)("hleIoWaitAsync - unknown id " + Integer.toHexString(id)));
            return -2147351773;
        }
        if (info.result == -2147351766L) {
            log.debug((Object)"hleIoWaitAsync - PSP_ERROR_NO_ASYNC_OP");
            return -2147351766;
        }
        if (info.asyncPending && !wait) {
            log.debug((Object)"hleIoWaitAsync - poll return = 1(busy)");
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleIoWaitAsync info.result=%d", info.result));
            }
            return 1;
        }
        boolean waitForAsync = false;
        if (wait) {
            waitForAsync = true;
        }
        if (!info.asyncPending) {
            log.debug((Object)"hleIoWaitAsync - async already completed, not waiting");
            waitForAsync = false;
        }
        if (info.closePending) {
            log.debug((Object)"hleIoWaitAsync - file marked with closePending, calling hleIoClose, not waiting");
            this.hleIoClose(info.id, false);
            waitForAsync = false;
        }
        if (info.result == -2147418110L) {
            log.debug((Object)"hleIoWaitAsync - file not found, not waiting");
            info.close();
            this.triggerAsyncThread(info);
            waitForAsync = false;
        }
        if (waitForAsync) {
            for (IIoListener ioListener : this.ioListeners) {
                ioListener.sceIoWaitAsync(0, id, res_addr);
            }
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            currentThread.wait.Io_id = info.id;
            currentThread.wait.Io_resultAddr = res_addr;
            threadMan.hleKernelThreadEnterWaitState(256, info.id, this.ioWaitStateChecker, callbacks);
        } else {
            Memory mem = Memory.getInstance();
            if (Memory.isAddressGood(res_addr)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("hleIoWaitAsync - storing result 0x" + Long.toHexString(info.result)));
                }
                mem.write64(res_addr, info.result);
            }
            info.asyncResultPending = false;
            info.result = -2147351766L;
            for (IIoListener ioListener : this.ioListeners) {
                ioListener.sceIoPollAsync(0, id, res_addr);
            }
        }
        return 0;
    }

    public int hleIoOpen(PspString filename, int flags, int permissions, boolean async) {
        return this.hleIoOpen(filename.getAddress(), filename.getString(), flags, permissions, async);
    }

    public int hleIoOpen(int filename_addr, String filename, int flags, int permissions, boolean async) {
        int result;
        IoInfo info;
        String mode;
        block49: {
            if (log.isInfoEnabled()) {
                log.info((Object)("hleIoOpen filename = " + filename + " flags = " + Integer.toHexString(flags) + " permissions = 0" + Integer.toOctalString(permissions)));
            }
            if (log.isDebugEnabled()) {
                if ((flags & 1) == 1) {
                    log.debug((Object)"PSP_O_RDONLY");
                }
                if ((flags & 2) == 2) {
                    log.debug((Object)"PSP_O_WRONLY");
                }
                if ((flags & 4) == 4) {
                    log.debug((Object)"PSP_O_NBLOCK");
                }
                if ((flags & 8) == 8) {
                    log.debug((Object)"PSP_O_DIROPEN");
                }
                if ((flags & 0x100) == 256) {
                    log.debug((Object)"PSP_O_APPEND");
                }
                if ((flags & 0x200) == 512) {
                    log.debug((Object)"PSP_O_CREAT");
                }
                if ((flags & 0x400) == 1024) {
                    log.debug((Object)"PSP_O_TRUNC");
                }
                if ((flags & 0x800) == 2048) {
                    log.debug((Object)"PSP_O_EXCL");
                }
                if ((flags & 0x4000) == 16384) {
                    log.debug((Object)"PSP_O_NBUF");
                }
                if ((flags & 0x8000) == 32768) {
                    log.debug((Object)"PSP_O_NOWAIT");
                }
                if ((flags & 0x2000000) == 0x2000000) {
                    log.debug((Object)"PSP_O_PLOCK");
                }
                if ((flags & 0x40000000) == 0x40000000) {
                    log.debug((Object)"PSP_O_FGAMEDATA");
                }
            }
            if ((mode = this.getMode(flags)) == null) {
                log.error((Object)("hleIoOpen - unhandled flags " + Integer.toHexString(flags)));
                for (IIoListener ioListener : this.ioListeners) {
                    ioListener.sceIoOpen(-1, filename_addr, filename, flags, permissions, mode);
                }
                return -1;
            }
            int retry = flags >> 16 & 0xF;
            if (retry != 0) {
                log.info((Object)("hleIoOpen - retry count is " + retry));
            }
            if ((flags & 1) == 1 && (flags & 0x100) == 256) {
                log.warn((Object)"hleIoOpen - read and append flags both set!");
            }
            info = null;
            try {
                String pcfilename = this.getDeviceFilePath(filename);
                String absoluteFileName = this.getAbsoluteFileName(filename);
                StringBuilder localFileName = new StringBuilder();
                IVirtualFileSystem vfs = this.vfsManager.getVirtualFileSystem(absoluteFileName, localFileName);
                if (vfs != null) {
                    IVirtualFile vFile = vfs.ioOpen(localFileName.toString(), flags, permissions);
                    if (vFile == null) {
                        result = -2147418110;
                    } else {
                        info = new IoInfo(filename, vFile, mode, flags, permissions);
                        info.sectorBlockMode = vFile.isSectorBlockMode();
                        info.result = -2147351766L;
                        result = info.id;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("hleIoOpen assigned id = 0x" + Integer.toHexString(info.id)));
                        }
                    }
                    break block49;
                }
                if (pcfilename != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("hleIoOpen - opening file " + pcfilename));
                    }
                    if (this.isUmdPath(pcfilename)) {
                        if (this.iso == null) {
                            log.error((Object)"hleIoOpen - no umd mounted");
                            result = -2147418093;
                            break block49;
                        }
                        if (!Modules.sceUmdUserModule.isUmdActivated()) {
                            log.warn((Object)"hleIoOpen - umd mounted but not activated");
                            result = -2147351775;
                            break block49;
                        }
                        if ((flags & 2) == 2 || (flags & 0x200) == 512 || (flags & 0x400) == 1024) {
                            log.error((Object)"hleIoOpen - refusing to open umd media for write");
                            result = -2147418082;
                            break block49;
                        }
                        try {
                            String trimmedFileName = this.trimUmdPrefix(pcfilename);
                            if (trimmedFileName != null && trimmedFileName.length() == 0 && filename.length() == 0) {
                                throw new FileNotFoundException(filename);
                            }
                            UmdIsoFile file = this.iso.getFile(trimmedFileName);
                            info = new IoInfo(filename, file, mode, flags, permissions);
                            if (!info.isValidId()) {
                                log.warn((Object)String.format("hleIoOpen - too many open files", new Object[0]));
                                result = -2147351776;
                                async = false;
                            } else {
                                if (trimmedFileName != null && trimmedFileName.length() == 0) {
                                    info.sectorBlockMode = true;
                                }
                                info.result = -2147351766L;
                                result = info.id;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("hleIoOpen assigned id = 0x" + Integer.toHexString(info.id)));
                                }
                            }
                            break block49;
                        }
                        catch (FileNotFoundException e) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"hleIoOpen - umd file not found (ok to ignore this message, debug purpose only)");
                            }
                            result = -2147418110;
                        }
                        catch (IOException e) {
                            log.error((Object)("hleIoOpen - error opening umd media: " + e.getMessage()));
                            result = -1;
                        }
                        break block49;
                    }
                    File file = new File(pcfilename);
                    if (file.exists() && (flags & 0x200) == 512 && (flags & 0x800) == 2048) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"hleIoOpen - file already exists (PSP_O_CREAT + PSP_O_EXCL)");
                        }
                        result = -2147418095;
                    } else {
                        if (!file.exists() && (flags & 0x200) == 512) {
                            String parentDir = new File(pcfilename).getParent();
                            new File(parentDir).mkdirs();
                        }
                        SeekableRandomFile raf = new SeekableRandomFile(pcfilename, mode);
                        info = new IoInfo(filename, raf, mode, flags, permissions);
                        if ((flags & 2) == 2 && (flags & 0x400) == 1024) {
                            info.truncate(0);
                        }
                        info.result = -2147351766L;
                        result = info.id;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("hleIoOpen assigned id = 0x" + Integer.toHexString(info.id)));
                        }
                    }
                    break block49;
                }
                result = -1;
            }
            catch (FileNotFoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"hleIoOpen - file not found (ok to ignore this message, debug purpose only)");
                }
                result = -2147418110;
            }
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoOpen(result, filename_addr, filename, flags, permissions, mode);
        }
        if (async) {
            int realResult = result;
            if (info == null) {
                log.debug((Object)"sceIoOpenAsync - file not found (ok to ignore this message, debug purpose only)");
                info = new IoInfo(Utilities.readStringZ(filename_addr), (SeekableDataInput)null, null, flags, permissions);
                result = info.id;
            }
            this.startIoAsync(info, realResult, IoOperation.open, null, 0);
        }
        return result;
    }

    private int hleIoClose(int id, boolean async) {
        int result;
        if (log.isDebugEnabled()) {
            log.debug((Object)("hleIoClose - id " + Integer.toHexString(id)));
        }
        IoInfo info = this.fileIds.get(id);
        if (async) {
            if (info != null) {
                if (info.asyncPending || info.asyncResultPending) {
                    log.warn((Object)("sceIoCloseAsync - id " + Integer.toHexString(id) + " PSP_ERROR_ASYNC_BUSY"));
                    result = -2147351767;
                } else {
                    info.closePending = true;
                    result = (int)this.updateResult(info, 0L, true, false, IoOperation.close);
                }
            } else {
                result = -2147351773;
            }
        } else {
            try {
                if (info == null) {
                    if (id != 1 && id != 2) {
                        log.warn((Object)("sceIoClose - unknown id " + Integer.toHexString(id)));
                    }
                    result = -2147351773;
                } else {
                    if (info.vFile != null) {
                        info.vFile.ioClose();
                    } else if (info.readOnlyFile != null) {
                        info.readOnlyFile.close();
                    }
                    info.close();
                    this.triggerAsyncThread(info);
                    info.result = 0L;
                    result = 0;
                }
            }
            catch (IOException e) {
                log.error((Object)("pspiofilemgr - error closing file: " + e.getMessage()));
                e.printStackTrace();
                result = -1;
            }
            for (IIoListener ioListener : this.ioListeners) {
                ioListener.sceIoClose(result, id);
            }
        }
        return result;
    }

    private int hleIoWrite(int id, int data_addr, int size, boolean async) {
        int result;
        String message;
        IoInfo info = null;
        if (id == 1) {
            message = Utilities.stripNL(Utilities.readStringNZ(data_addr, size));
            stdout.info((Object)message);
            result = size;
        } else if (id == 2) {
            message = Utilities.stripNL(Utilities.readStringNZ(data_addr, size));
            stderr.info((Object)message);
            result = size;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("hleIoWrite(id=" + Integer.toHexString(id) + ",data=0x" + Integer.toHexString(data_addr) + ",size=0x" + Integer.toHexString(size) + ") async=" + async));
            }
            try {
                int towrite;
                info = this.fileIds.get(id);
                if (info == null) {
                    log.warn((Object)("hleIoWrite - unknown id " + Integer.toHexString(id)));
                    result = -2147351773;
                } else if (info.asyncPending || info.asyncResultPending) {
                    log.warn((Object)("hleIoWrite - id " + Integer.toHexString(id) + " PSP_ERROR_ASYNC_BUSY"));
                    result = -2147351767;
                } else if (data_addr < 0x8000000 && data_addr + size > MemoryMap.END_RAM) {
                    log.warn((Object)("hleIoWrite - id " + Integer.toHexString(id) + " data is outside of ram 0x" + Integer.toHexString(data_addr) + " - 0x" + Integer.toHexString(data_addr + size)));
                    result = -1;
                } else if (info.vFile != null) {
                    if ((info.flags & 0x100) == 256) {
                        info.vFile.ioLseek(info.vFile.length());
                        info.position = info.vFile.length();
                    }
                    TPointer dataAddr = new TPointer(Memory.getInstance(), data_addr);
                    if (info.position > info.vFile.length()) {
                        info.vFile.ioLseek(info.vFile.length());
                        for (towrite = (int)(info.position - info.vFile.length()); towrite > 0 && (result = info.vFile.ioWrite(dataAddr, 1)) >= 0; towrite -= result) {
                        }
                    }
                    if ((result = info.vFile.ioWrite(dataAddr, size)) > 0) {
                        info.position += (long)result;
                    }
                } else {
                    if ((info.flags & 0x100) == 256) {
                        info.msFile.seek(info.msFile.length());
                        info.position = info.msFile.length();
                    }
                    if (info.position > info.readOnlyFile.length()) {
                        byte[] junk = new byte[512];
                        info.msFile.seek(info.msFile.length());
                        for (towrite = (int)(info.position - info.readOnlyFile.length()); towrite >= 512; towrite -= 512) {
                            info.msFile.write(junk, 0, 512);
                        }
                        if (towrite > 0) {
                            info.msFile.write(junk, 0, towrite);
                        }
                    }
                    info.position += (long)size;
                    Utilities.write(info.msFile, data_addr, size);
                    result = size;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                result = -1;
            }
        }
        result = (int)this.updateResult(info, result, async, false, IoOperation.write, null, size);
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoWrite(result, id, data_addr, size, size);
        }
        return result;
    }

    public int hleIoRead(int id, int data_addr, int size, boolean async) {
        int result;
        if (log.isDebugEnabled()) {
            log.debug((Object)("hleIoRead(id=" + Integer.toHexString(id) + ",data=0x" + Integer.toHexString(data_addr) + ",size=0x" + Integer.toHexString(size) + ") async=" + async));
        }
        IoInfo info = null;
        long position = 0L;
        SeekableDataInput dataInput = null;
        IVirtualFile vFile = null;
        int requestedSize = size;
        IOAsyncReadAction asyncAction = null;
        if (id == 0) {
            log.warn((Object)"UNIMPLEMENTED:hleIoRead id = stdin");
            result = 0;
        } else {
            try {
                int oldSize;
                info = this.fileIds.get(id);
                if (info == null) {
                    log.warn((Object)("hleIoRead - unknown id " + Integer.toHexString(id)));
                    result = -2147351773;
                } else if (info.asyncPending || info.asyncResultPending) {
                    log.warn((Object)("hleIoRead - id " + Integer.toHexString(id) + " PSP_ERROR_ASYNC_BUSY"));
                    result = -2147351767;
                } else if (data_addr < 0x8000000 && data_addr + size > MemoryMap.END_RAM) {
                    log.warn((Object)("hleIoRead - id " + Integer.toHexString(id) + " data is outside of ram 0x" + Integer.toHexString(data_addr) + " - 0x" + Integer.toHexString(data_addr + size)));
                    result = -2147352272;
                } else if (info.vFile != null) {
                    if (info.sectorBlockMode) {
                        size *= 2048;
                    }
                    if (info.position + (long)size > info.vFile.length()) {
                        oldSize = size;
                        size = (int)(info.vFile.length() - info.position);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("hleIoRead - clamping size old=%d, new=%d, position=%d, len=%d", oldSize, size, info.position, info.vFile.length()));
                        }
                    }
                    if (async) {
                        asyncAction = new IOAsyncReadAction(info, data_addr, requestedSize, size);
                        result = 0;
                    } else {
                        position = info.position;
                        vFile = info.vFile;
                        result = info.vFile.ioRead(new TPointer(Memory.getInstance(), data_addr), size);
                        if (result >= 0) {
                            size = result;
                            info.position += (long)result;
                        } else {
                            size = 0;
                        }
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("hleIoRead: %s", Utilities.getMemoryDump(data_addr, Math.min(16, size))));
                        }
                        RuntimeContext.invalidateRange(data_addr, size);
                        if (info.sectorBlockMode && result > 0) {
                            result /= 2048;
                        }
                    }
                } else if (info.readOnlyFile == null || info.position >= info.readOnlyFile.length()) {
                    result = 0;
                } else {
                    if (info.sectorBlockMode) {
                        size *= 2048;
                    }
                    if (info.readOnlyFile.getFilePointer() + (long)size > info.readOnlyFile.length()) {
                        oldSize = size;
                        size = (int)(info.readOnlyFile.length() - info.readOnlyFile.getFilePointer());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("hleIoRead - clamping size old=" + oldSize + " new=" + size + " fp=" + info.readOnlyFile.getFilePointer() + " len=" + info.readOnlyFile.length()));
                        }
                    }
                    if (async) {
                        asyncAction = new IOAsyncReadAction(info, data_addr, requestedSize, size);
                        result = 0;
                    } else {
                        position = info.position;
                        dataInput = info.readOnlyFile;
                        Utilities.readFully(info.readOnlyFile, data_addr, size);
                        info.position += (long)size;
                        result = size;
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("hleIoRead: %s", Utilities.getMemoryDump(data_addr, Math.min(16, size))));
                        }
                        RuntimeContext.invalidateRange(data_addr, size);
                        if (info.sectorBlockMode) {
                            result /= 2048;
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                result = -2147352272;
            }
            catch (Exception e) {
                e.printStackTrace();
                result = -2147352272;
                log.error((Object)"hleIoRead: Check other console for exception details. Press Run to continue.");
                Emulator.PauseEmu();
            }
        }
        result = (int)this.updateResult(info, result, async, false, IoOperation.read, asyncAction, size);
        if (asyncAction == null) {
            for (IIoListener ioListener : this.ioListeners) {
                ioListener.sceIoRead(result, id, data_addr, requestedSize, size, position, dataInput, vFile);
            }
        }
        return result;
    }

    private long hleIoLseek(int id, long offset, int whence, boolean resultIs64bit, boolean async) {
        long result;
        IoInfo info = null;
        if (id == 1 || id == 2 || id == 0) {
            log.error((Object)("seek - can't seek on stdio id " + Integer.toHexString(id)));
            result = -1L;
        } else {
            try {
                info = this.fileIds.get(id);
                if (info == null) {
                    log.warn((Object)("seek - unknown id " + Integer.toHexString(id)));
                    result = -2147351773L;
                } else if (info.asyncPending || info.asyncResultPending) {
                    log.warn((Object)("seek - id " + Integer.toHexString(id) + " PSP_ERROR_ASYNC_BUSY"));
                    result = -2147351767L;
                } else if (info.vFile != null) {
                    long newPosition;
                    if (info.sectorBlockMode) {
                        offset *= 2048L;
                    }
                    switch (whence) {
                        case 0: {
                            newPosition = offset;
                            break;
                        }
                        case 1: {
                            newPosition = info.position + offset;
                            break;
                        }
                        case 2: {
                            newPosition = info.vFile.length() + offset;
                            break;
                        }
                        default: {
                            log.error((Object)String.format("seek - unhandled whence %d", whence));
                            newPosition = -1L;
                        }
                    }
                    if (newPosition >= 0L) {
                        info.position = newPosition;
                        if (info.position <= info.vFile.length()) {
                            info.vFile.ioLseek(info.position);
                        }
                        result = info.position;
                        if (info.sectorBlockMode) {
                            result /= 2048L;
                        }
                    } else {
                        result = -2147483137L;
                    }
                } else if (info.readOnlyFile == null) {
                    result = 0L;
                } else {
                    if (info.sectorBlockMode) {
                        offset *= 2048L;
                    }
                    switch (whence) {
                        case 0: {
                            if (offset < 0L) {
                                log.warn((Object)("SEEK_SET id " + Integer.toHexString(id) + " filename:'" + info.filename + "' offset=0x" + Long.toHexString(offset) + " (less than 0!)"));
                                long result2 = -2147483137L;
                                for (IIoListener ioListener : this.ioListeners) {
                                    ioListener.sceIoSeek64(-2147483137L, id, offset, whence);
                                }
                                return result2;
                            }
                            info.position = offset;
                            if (offset >= info.readOnlyFile.length()) break;
                            info.readOnlyFile.seek(offset);
                            break;
                        }
                        case 1: {
                            if (info.position + offset < 0L) {
                                log.warn((Object)("SEEK_CUR id " + Integer.toHexString(id) + " filename:'" + info.filename + "' newposition=0x" + Long.toHexString(info.position + offset) + " (less than 0!)"));
                                long result3 = -2147483137L;
                                for (IIoListener ioListener : this.ioListeners) {
                                    ioListener.sceIoSeek64(-2147483137L, id, offset, whence);
                                }
                                return result3;
                            }
                            info.position += offset;
                            if (info.position >= info.readOnlyFile.length()) break;
                            info.readOnlyFile.seek(info.position);
                            break;
                        }
                        case 2: {
                            if (info.readOnlyFile.length() + offset < 0L) {
                                log.warn((Object)("SEEK_END id " + Integer.toHexString(id) + " filename:'" + info.filename + "' newposition=0x" + Long.toHexString(info.position + offset) + " (less than 0!)"));
                                long result4 = -2147483137L;
                                for (IIoListener ioListener : this.ioListeners) {
                                    ioListener.sceIoSeek64(-2147483137L, id, offset, whence);
                                }
                                return result4;
                            }
                            info.position = info.readOnlyFile.length() + offset;
                            if (info.position >= info.readOnlyFile.length()) break;
                            info.readOnlyFile.seek(info.position);
                            break;
                        }
                        default: {
                            log.error((Object)("seek - unhandled whence " + whence));
                        }
                    }
                    result = info.position;
                    if (info.sectorBlockMode) {
                        result /= 2048L;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                result = -1L;
            }
        }
        result = this.updateResult(info, result, async, resultIs64bit, IoOperation.seek);
        if (resultIs64bit) {
            for (IIoListener ioListener : this.ioListeners) {
                ioListener.sceIoSeek64(result, id, offset, whence);
            }
        } else {
            for (IIoListener ioListener : this.ioListeners) {
                ioListener.sceIoSeek32((int)result, id, (int)offset, whence);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleIoLseek returning %d", result));
        }
        return result;
    }

    public int hleIoIoctl(int id, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen, boolean async) {
        int result;
        int i;
        IoInfo info = null;
        Memory mem = Memory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleIoIoctl(id=%x, cmd=0x%08X, indata=0x%08X, inlen=%d, outdata=0x%08X, outlen=%d, async=%b", id, cmd, indata_addr, inlen, outdata_addr, outlen, async));
            if (Memory.isAddressGood(indata_addr)) {
                for (i = 0; i < inlen; i += 4) {
                    log.debug((Object)String.format("hleIoIoctl indata[%d]=0x%08X", i / 4, mem.read32(indata_addr + i)));
                }
            }
            if (Memory.isAddressGood(outdata_addr)) {
                for (i = 0; i < Math.min(outlen, 256); i += 4) {
                    log.debug((Object)String.format("hleIoIoctl outdata[%d]=0x%08X", i / 4, mem.read32(outdata_addr + i)));
                }
            }
        }
        if ((info = this.fileIds.get(id)) == null) {
            log.warn((Object)("hleIoIoctl - unknown id " + Integer.toHexString(id)));
            result = -2147351773;
        } else if (info.asyncPending || info.asyncResultPending) {
            log.warn((Object)("hleIoIoctl - id " + Integer.toHexString(id) + " PSP_ERROR_ASYNC_BUSY"));
            result = -2147351767;
        } else if (info.vFile != null && cmd != 0x4100001) {
            result = info.vFile.ioIoctl(cmd, new TPointer(mem, indata_addr), inlen, new TPointer(mem, outdata_addr), outlen);
        } else {
            block10 : switch (cmd) {
                case 0x1010005: {
                    if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                        if (info.isUmdFile()) {
                            try {
                                int offset = mem.read32(indata_addr);
                                log.debug((Object)("hleIoIoctl umd file seek set " + offset));
                                info.readOnlyFile.seek(offset);
                                info.position = offset;
                                result = 0;
                            }
                            catch (IOException e) {
                                log.warn((Object)("hleIoIoctl cmd=0x01010005 exception: " + e.getMessage()));
                                result = -2147352272;
                            }
                            break;
                        }
                        log.warn((Object)"hleIoIoctl cmd=0x01010005 only allowed on UMD files");
                        result = -2147483137;
                        break;
                    }
                    log.warn((Object)("hleIoIoctl cmd=0x01010005 " + String.format("0x%08X %d", indata_addr, inlen) + " unsupported parameters"));
                    result = -2147483137;
                    break;
                }
                case 0x1020001: {
                    if (Memory.isAddressGood(outdata_addr) && outlen == 2048) {
                        if (info.isUmdFile() && this.iso != null) {
                            try {
                                byte[] primaryVolumeSector = this.iso.readSector(UmdIsoReader.startSector);
                                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(outdata_addr, outlen, 1);
                                for (int i2 = 0; i2 < outlen; ++i2) {
                                    memoryWriter.writeNext(primaryVolumeSector[i2] & 0xFF);
                                }
                                memoryWriter.flush();
                                result = 0;
                            }
                            catch (IOException e) {
                                log.error((Object)e);
                                result = -2147352272;
                            }
                            break;
                        }
                        log.warn((Object)"hleIoIoctl cmd=0x01020001 only allowed on UMD files");
                        result = -2147483137;
                        break;
                    }
                    log.warn((Object)("hleIoIoctl cmd=0x01020001 " + String.format("0x%08X %d", outdata_addr, outlen) + " unsupported parameters"));
                    result = -2147418090;
                    break;
                }
                case 0x1020002: {
                    if (Memory.isAddressGood(outdata_addr) && outlen <= 2048) {
                        if (info.isUmdFile() && this.iso != null) {
                            try {
                                byte[] primaryVolumeSector = this.iso.readSector(UmdIsoReader.startSector);
                                ByteBuffer primaryVolume = ByteBuffer.wrap(primaryVolumeSector);
                                primaryVolume.position(140);
                                int pathTableLocation = Utilities.readWord(primaryVolume);
                                byte[] pathTableSector = this.iso.readSector(pathTableLocation);
                                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(outdata_addr, outlen, 1);
                                for (int i3 = 0; i3 < outlen; ++i3) {
                                    memoryWriter.writeNext(pathTableSector[i3] & 0xFF);
                                }
                                memoryWriter.flush();
                                result = 0;
                            }
                            catch (IOException e) {
                                log.error((Object)e);
                                result = -2147352272;
                            }
                            break;
                        }
                        log.warn((Object)"hleIoIoctl cmd=0x01020002 only allowed on UMD files");
                        result = -2147483137;
                        break;
                    }
                    log.warn((Object)("hleIoIoctl cmd=0x01020002 " + String.format("0x%08X %d", outdata_addr, outlen) + " unsupported parameters"));
                    result = -2147418090;
                    break;
                }
                case 16908291: {
                    if (Memory.isAddressGood(outdata_addr) && outlen == 4) {
                        if (info.isUmdFile() && this.iso != null) {
                            mem.write32(outdata_addr, 2048);
                            result = 0;
                            break;
                        }
                        log.warn((Object)"hleIoIoctl cmd=0x01020003 only allowed on UMD files");
                        result = -2147483137;
                        break;
                    }
                    log.warn((Object)("hleIoIoctl cmd=0x01020003 " + String.format("0x%08X %d", outdata_addr, outlen) + " unsupported parameters"));
                    result = -2147418090;
                    break;
                }
                case 16908292: {
                    if (Memory.isAddressGood(outdata_addr) && outlen >= 4) {
                        if (info.isUmdFile()) {
                            try {
                                int fPointer = (int)info.readOnlyFile.getFilePointer();
                                mem.write32(outdata_addr, fPointer);
                                log.debug((Object)("hleIoIoctl umd file get file pointer " + fPointer));
                                result = 0;
                            }
                            catch (IOException e) {
                                log.warn((Object)("hleIoIoctl cmd=0x01020004 exception: " + e.getMessage()));
                                result = -2147352272;
                            }
                            break;
                        }
                        log.warn((Object)"hleIoIoctl cmd=0x01020004 only allowed on UMD files");
                        result = -2147483137;
                        break;
                    }
                    log.warn((Object)("hleIoIoctl cmd=0x01020004 " + String.format("0x%08X %d", outdata_addr, outlen) + " unsupported parameters"));
                    result = -2147483137;
                    break;
                }
                case 16908294: {
                    if (Memory.isAddressGood(outdata_addr) && outlen >= 4) {
                        int startSector = 0;
                        if (info.isUmdFile() && info.readOnlyFile instanceof UmdIsoFile) {
                            UmdIsoFile file = (UmdIsoFile)info.readOnlyFile;
                            startSector = file.getStartSector();
                            log.debug((Object)("hleIoIoctl umd file get start sector " + startSector));
                            mem.write32(outdata_addr, startSector);
                            result = 0;
                            break;
                        }
                        log.warn((Object)"hleIoIoctl cmd=0x01020006 only allowed on UMD files and only implemented for UmdIsoFile");
                        result = -2147483137;
                        break;
                    }
                    log.warn((Object)("hleIoIoctl cmd=0x01020006 " + String.format("0x%08X %d", outdata_addr, outlen) + " unsupported parameters"));
                    result = -2147483137;
                    break;
                }
                case 16908295: {
                    if (Memory.isAddressGood(outdata_addr) && outlen >= 8) {
                        if (info.isUmdFile()) {
                            try {
                                long length = info.readOnlyFile.length();
                                mem.write64(outdata_addr, length);
                                log.debug((Object)("hleIoIoctl get file size " + length));
                                result = 0;
                            }
                            catch (IOException e) {
                                log.warn((Object)("hleIoIoctl cmd=0x01020007 exception: " + e.getMessage()));
                                result = -2147352272;
                            }
                            break;
                        }
                        log.warn((Object)"hleIoIoctl cmd=0x01020007 only allowed on UMD files");
                        result = -2147483137;
                        break;
                    }
                    log.warn((Object)("hleIoIoctl cmd=0x01020007 " + String.format("0x%08X %d", outdata_addr, outlen) + " unsupported parameters"));
                    result = -2147483137;
                    break;
                }
                case 16973832: {
                    if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                        int length = mem.read32(indata_addr);
                        if (length > 0) {
                            if (Memory.isAddressGood(outdata_addr) && outlen >= length) {
                                try {
                                    Utilities.readFully(info.readOnlyFile, outdata_addr, length);
                                    info.position += (long)length;
                                    result = length;
                                }
                                catch (IOException e) {
                                    log.error((Object)e);
                                    result = -2147352272;
                                }
                                break;
                            }
                            log.warn((Object)String.format("hleIoIoctl cmd=0x%08X inlen=%d unsupported output parameters 0x%08X %d", cmd, inlen, outdata_addr, outlen));
                            result = -2147483137;
                            break;
                        }
                        log.warn((Object)String.format("hleIoIoctl cmd=0x%08X unsupported input parameters 0x%08X %d, length=%d", cmd, indata_addr, inlen, length));
                        result = -2147483137;
                        break;
                    }
                    log.warn((Object)String.format("hleIoIoctl cmd=0x%08X unsupported input parameters 0x%08X %d", cmd, indata_addr, inlen));
                    result = -2147483137;
                    break;
                }
                case 32702467: {
                    if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                        int numberOfSectors = mem.read32(indata_addr);
                        if (numberOfSectors > 0) {
                            if (Memory.isAddressGood(outdata_addr) && outlen >= numberOfSectors) {
                                try {
                                    int length = numberOfSectors * 2048;
                                    Utilities.readFully(info.readOnlyFile, outdata_addr, length);
                                    info.position += (long)length;
                                    result = length / 2048;
                                }
                                catch (IOException e) {
                                    log.error((Object)e);
                                    result = -2147352272;
                                }
                                break;
                            }
                            log.warn((Object)String.format("hleIoIoctl cmd=0x%08X inlen=%d unsupported output parameters 0x%08X %d", cmd, inlen, outdata_addr, outlen));
                            result = -2147418090;
                            break;
                        }
                        log.warn((Object)String.format("hleIoIoctl cmd=0x%08X unsupported input parameters 0x%08X %d numberOfSectors=%d", cmd, indata_addr, inlen, numberOfSectors));
                        result = -2147418090;
                        break;
                    }
                    log.warn((Object)String.format("hleIoIoctl cmd=0x%08X unsupported input parameters 0x%08X %d", cmd, indata_addr, inlen));
                    result = -2147418090;
                    break;
                }
                case 32571558: {
                    if (Memory.isAddressGood(indata_addr) && inlen >= 16) {
                        if (info.isUmdFile()) {
                            try {
                                long offset = mem.read64(indata_addr);
                                int whence = mem.read32(indata_addr + 12);
                                if (info.sectorBlockMode) {
                                    offset *= 2048L;
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("hleIoIoctl UMD file seek offset " + offset + ", whence " + whence));
                                }
                                switch (whence) {
                                    case 0: {
                                        info.position = offset;
                                        info.readOnlyFile.seek(info.position);
                                        result = 0;
                                        break block10;
                                    }
                                    case 1: {
                                        info.position += offset;
                                        info.readOnlyFile.seek(info.position);
                                        result = 0;
                                        break block10;
                                    }
                                    case 2: {
                                        info.position = info.readOnlyFile.length() + offset;
                                        info.readOnlyFile.seek(info.position);
                                        result = 0;
                                        break block10;
                                    }
                                }
                                log.error((Object)("hleIoIoctl - unhandled whence " + whence));
                                result = -1;
                            }
                            catch (IOException e) {
                                log.warn((Object)("hleIoIoctl cmd=0x01F100A6 exception: " + e.getMessage()));
                                result = -1;
                            }
                            break;
                        }
                        log.warn((Object)"hleIoIoctl cmd=0x01F100A6 only allowed on UMD files");
                        result = -2147483137;
                        break;
                    }
                    log.warn((Object)("hleIoIoctl cmd=0x01F100A6 " + String.format("0x%08X %d", indata_addr, inlen) + " unsupported parameters"));
                    result = -2147483137;
                    break;
                }
                case 0x4100001: {
                    if (Memory.isAddressGood(indata_addr) && inlen == 16) {
                        CryptoEngine crypto = new CryptoEngine();
                        String keyHex = "";
                        if (this.pgdFileConnector == null) {
                            this.pgdFileConnector = new PGDFileConnector();
                        }
                        byte[] keyBuf = new byte[16];
                        for (int i4 = 0; i4 < 16; ++i4) {
                            keyBuf[i4] = (byte)mem.read8(indata_addr + i4);
                            keyHex = keyHex + String.format("%02x", keyBuf[i4] & 0xFF);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("hleIoIoctl get AES key " + keyHex));
                        }
                        if (this.getAllowExtractPGDStatus() && info.readOnlyFile != null) {
                            this.pgdFileConnector.extractPGDFile(info.filename, info.readOnlyFile, keyHex);
                        }
                        IVirtualFile decInput = null;
                        try {
                            int maxAlignedChunkSize = 20208;
                            int pgdHeaderSize = 160;
                            byte[] inBuf = new byte[maxAlignedChunkSize + pgdHeaderSize];
                            byte[] outBuf = new byte[maxAlignedChunkSize + 16];
                            byte[] headerBuf = new byte[64];
                            if (info.vFile != null) {
                                info.vFile.ioRead(inBuf, 0, pgdHeaderSize);
                            } else {
                                info.readOnlyFile.readFully(inBuf, 0, pgdHeaderSize);
                            }
                            if (inBuf[0] != 0 || inBuf[1] != 80 || inBuf[2] != 71 || inBuf[3] != 68) {
                                log.warn((Object)String.format("No PGD header detected %02X %02X %02X %02X ('%c%c%c%c') detected in file '%s'", inBuf[0] & 0xFF, inBuf[1] & 0xFF, inBuf[2] & 0xFF, inBuf[3] & 0xFF, Character.valueOf((char)inBuf[0]), Character.valueOf((char)inBuf[1]), Character.valueOf((char)inBuf[2]), Character.valueOf((char)inBuf[3]), info.filename));
                            } else {
                                long fileLength;
                                System.arraycopy(inBuf, 16, headerBuf, 0, 16);
                                System.arraycopy(inBuf, 48, headerBuf, 16, 48);
                                byte[] headerBufDec = crypto.DecryptPGD(headerBuf, 64, keyBuf);
                                IntBuffer decryptedHeader = ByteBuffer.wrap(headerBufDec).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
                                int dataSize = decryptedHeader.get(5);
                                int chunkSize = decryptedHeader.get(6);
                                int hashOffset = decryptedHeader.get(7);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)String.format("PGD dataSize=%d, chunkSize=%d, hashOffset=%d", dataSize, chunkSize, hashOffset));
                                    if (log.isTraceEnabled()) {
                                        log.trace((Object)String.format("PGD Header: %s", Utilities.getMemoryDump(inBuf, 0, pgdHeaderSize)));
                                        log.trace((Object)String.format("Decrypted PGD Header: %s", Utilities.getMemoryDump(headerBufDec, 0, headerBufDec.length)));
                                    }
                                }
                                long l = fileLength = info.vFile != null ? info.vFile.length() : info.readOnlyFile.length();
                                if (hashOffset < 0 || (long)hashOffset > fileLength || dataSize < 0) {
                                    log.warn((Object)String.format("Incorrect PGD header: dataSize=%d, chunkSize=%d, hashOffset=%d", dataSize, chunkSize, hashOffset));
                                } else {
                                    decInput = this.vfsManager.getTmpVirtualFileSystem().ioOpen(info.filename, info.flags, 0, ITmpVirtualFileSystem.tmpPurposePGD);
                                    if (decInput == null || decInput.length() < (long)dataSize) {
                                        int readLength;
                                        JpcspDialogManager.showError(null, Resource.get("DecryptingPGD"));
                                        decInput = this.vfsManager.getTmpVirtualFileSystem().ioOpen(info.filename, 514, 511, ITmpVirtualFileSystem.tmpPurposePGD);
                                        if (info.vFile != null) {
                                            info.vFile.ioLseek(hashOffset);
                                        } else {
                                            info.readOnlyFile.seek(hashOffset);
                                        }
                                        for (int i5 = 0; i5 < dataSize; i5 += readLength) {
                                            readLength = Math.min(dataSize - i5, maxAlignedChunkSize);
                                            if (info.vFile != null) {
                                                info.vFile.ioRead(inBuf, 160, readLength);
                                            } else {
                                                info.readOnlyFile.readFully(inBuf, 160, readLength);
                                            }
                                            System.arraycopy(headerBufDec, 0, outBuf, 0, 16);
                                            System.arraycopy(inBuf, 160, outBuf, 16, readLength);
                                            byte[] decryptedBytes = i5 == 0 ? crypto.DecryptPGD(outBuf, readLength + 16, keyBuf) : crypto.UpdatePGDCipher(outBuf, readLength + 16);
                                            decInput.ioWrite(decryptedBytes, 0, decryptedBytes.length);
                                        }
                                        crypto.FinishPGDCipher();
                                        decInput.ioClose();
                                        decInput = this.vfsManager.getTmpVirtualFileSystem().ioOpen(info.filename, info.flags, 0, ITmpVirtualFileSystem.tmpPurposePGD);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"Error while decrypting PGD file", (Throwable)e);
                        }
                        try {
                            if (info.vFile != null) {
                                info.vFile.ioLseek(info.position);
                            } else {
                                info.readOnlyFile.seek(info.position);
                            }
                        }
                        catch (IOException e) {
                            log.error((Object)e);
                        }
                        if (decInput != null) {
                            info.vFile = decInput;
                        }
                        result = 0;
                        break;
                    }
                    log.warn((Object)String.format("hleIoIoctl cmd=0x04100001 indata=0x%08X inlen=%d unsupported parameters", indata_addr, inlen));
                    result = -2147483137;
                    break;
                }
                default: {
                    result = -1;
                    log.warn((Object)String.format("hleIoIoctl 0x%08X unknown command, inlen=%d, outlen=%d", cmd, inlen, outlen));
                    if (Memory.isAddressGood(indata_addr)) {
                        for (i = 0; i < inlen; i += 4) {
                            log.warn((Object)String.format("hleIoIoctl indata[%d]=0x%08X", i / 4, mem.read32(indata_addr + i)));
                        }
                    }
                    if (!Memory.isAddressGood(outdata_addr)) break;
                    for (i = 0; i < Math.min(outlen, 256); i += 4) {
                        log.warn((Object)String.format("hleIoIoctl outdata[%d]=0x%08X", i / 4, mem.read32(outdata_addr + i)));
                    }
                }
            }
        }
        result = (int)this.updateResult(info, result, async, false, IoOperation.ioctl);
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoIoctl(result, id, cmd, indata_addr, inlen, outdata_addr, outlen);
        }
        return result;
    }

    @HLEFunction(nid=844229206, version=150, checkInsideInterrupt=true)
    public int sceIoPollAsync(int id, int res_addr) {
        return this.hleIoWaitAsync(id, res_addr, false, false);
    }

    @HLEFunction(nid=-499192781, version=150, checkInsideInterrupt=true)
    public int sceIoWaitAsync(int id, int res_addr) {
        return this.hleIoWaitAsync(id, res_addr, true, false);
    }

    @HLEFunction(nid=903599942, version=150, checkInsideInterrupt=true)
    public int sceIoWaitAsyncCB(int id, int res_addr) {
        return this.hleIoWaitAsync(id, res_addr, true, true);
    }

    @HLEFunction(nid=-888801066, version=150, checkInsideInterrupt=true)
    public int sceIoGetAsyncStat(int id, int poll, int res_addr) {
        return this.hleIoWaitAsync(id, res_addr, poll == 0, false);
    }

    @HLEFunction(nid=-1298959745, version=150, checkInsideInterrupt=true)
    public int sceIoChangeAsyncPriority(int id, int priority) {
        if (priority == -1) {
            priority = Modules.ThreadManForUserModule.getCurrentThread().currentPriority;
        } else if (priority < 0) {
            return -2147352173;
        }
        if (id == -1) {
            this.defaultAsyncPriority = priority;
            return 0;
        }
        IoInfo info = this.fileIds.get(id);
        if (info == null) {
            log.warn((Object)("sceIoChangeAsyncPriority invalid fd=" + id));
            return -2147351773;
        }
        info.asyncThreadPriority = priority;
        if (info.asyncThread != null) {
            Modules.ThreadManForUserModule.hleKernelChangeThreadPriority(info.asyncThread, priority);
        }
        return 0;
    }

    @HLEFunction(nid=-1591081708, version=150, checkInsideInterrupt=true)
    public int sceIoSetAsyncCallback(int id, int cbid, int notifyArg) {
        IoInfo info = this.fileIds.get(id);
        if (info == null) {
            log.warn((Object)("sceIoSetAsyncCallback - unknown id " + Integer.toHexString(id)));
            return -2147351773;
        }
        if (!Modules.ThreadManForUserModule.hleKernelRegisterCallback(1, cbid)) {
            log.warn((Object)("sceIoSetAsyncCallback - not a callback id " + Integer.toHexString(id)));
            return -1;
        }
        info.cbid = cbid;
        info.notifyArg = notifyArg;
        this.triggerAsyncThread(info);
        return 0;
    }

    @HLEFunction(nid=-2129900605, version=150, checkInsideInterrupt=true)
    public int sceIoClose(int id) {
        int result = this.hleIoClose(id, false);
        this.delayIoOperation(IoOperation.close);
        return result;
    }

    @HLEFunction(nid=-10927946, version=150, checkInsideInterrupt=true)
    public int sceIoCloseAsync(int id) {
        return this.hleIoClose(id, true);
    }

    @HLEFunction(nid=278876348, version=150, checkInsideInterrupt=true)
    public int sceIoOpen(PspString filename, int flags, int permissions) {
        int result = this.hleIoOpen(filename, flags, permissions, false);
        this.delayIoOperation(IoOperation.open);
        return result;
    }

    @HLEFunction(nid=-1985308410, version=150, checkInsideInterrupt=true)
    public int sceIoOpenAsync(PspString filename, int flags, int permissions) {
        return this.hleIoOpen(filename, flags, permissions, true);
    }

    @HLEFunction(nid=1784909187, version=150, checkInsideInterrupt=true)
    public int sceIoRead(int id, int data_addr, int size) {
        int result = this.hleIoRead(id, data_addr, size, false);
        this.delayIoOperation(IoOperation.read);
        return result;
    }

    @HLEFunction(nid=-1598707774, version=150, checkInsideInterrupt=true)
    public int sceIoReadAsync(int id, int data_addr, int size) {
        return this.hleIoRead(id, data_addr, size, true);
    }

    @HLEFunction(nid=1122763692, version=150, checkInsideInterrupt=true)
    public int sceIoWrite(int id, int data_addr, int size) {
        int result = this.hleIoWrite(id, data_addr, size, false);
        if (id != 1 && id != 2) {
            this.delayIoOperation(IoOperation.write);
        }
        return result;
    }

    @HLEFunction(nid=262974233, version=150, checkInsideInterrupt=true)
    public int sceIoWriteAsync(int id, int data_addr, int size) {
        return this.hleIoWrite(id, data_addr, size, true);
    }

    @HLEFunction(nid=669722552, version=150, checkInsideInterrupt=true)
    public long sceIoLseek(int id, long offset, int whence) {
        long result = this.hleIoLseek(id, offset, whence, true, false);
        this.delayIoOperation(IoOperation.seek);
        return result;
    }

    @HLEFunction(nid=1907465847, version=150, checkInsideInterrupt=true)
    public int sceIoLseekAsync(int id, long offset, int whence) {
        return (int)this.hleIoLseek(id, offset, whence, true, true);
    }

    @HLEFunction(nid=1754673956, version=150, checkInsideInterrupt=true)
    public int sceIoLseek32(int id, int offset, int whence) {
        int result = (int)this.hleIoLseek(id, offset, whence, false, false);
        this.delayIoOperation(IoOperation.seek);
        return result;
    }

    @HLEFunction(nid=456678799, version=150, checkInsideInterrupt=true)
    public int sceIoLseek32Async(int id, int offset, int whence) {
        return (int)this.hleIoLseek(id, offset, whence, false, true);
    }

    @HLEFunction(nid=1667441737, version=150, checkInsideInterrupt=true)
    public int sceIoIoctl(int id, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        int result = this.hleIoIoctl(id, cmd, indata_addr, inlen, outdata_addr, outlen, false);
        this.delayIoOperation(IoOperation.ioctl);
        return result;
    }

    @HLEFunction(nid=-379977429, version=150, checkInsideInterrupt=true)
    public int sceIoIoctlAsync(int id, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        return this.hleIoIoctl(id, cmd, indata_addr, inlen, outdata_addr, outlen, true);
    }

    @HLEFunction(nid=-1298276452, version=150, checkInsideInterrupt=true)
    public int sceIoDopen(PspString dirname) {
        int result;
        block23: {
            IoDirInfo info;
            StringBuilder localFileName;
            String pcfilename = this.getDeviceFilePath(dirname.getString());
            String absoluteFileName = this.getAbsoluteFileName(dirname.getString());
            IVirtualFileSystem vfs = this.vfsManager.getVirtualFileSystem(absoluteFileName, localFileName = new StringBuilder());
            if (vfs != null) {
                String[] fileNames = vfs.ioDopen(localFileName.toString());
                if (fileNames == null) {
                    result = -2147418110;
                } else {
                    info = new IoDirInfo(localFileName.toString(), fileNames, vfs);
                    result = info.id;
                }
            } else if (pcfilename != null) {
                if (this.isUmdPath(pcfilename)) {
                    String isofilename = this.trimUmdPrefix(pcfilename);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("sceIoDopen - isofilename = " + isofilename));
                    }
                    if (this.iso == null) {
                        log.error((Object)"sceIoDopen - no umd mounted");
                        result = -2147418093;
                    } else if (!Modules.sceUmdUserModule.isUmdActivated()) {
                        log.warn((Object)"sceIoDopen - umd mounted but not activated");
                        result = -2147351775;
                    } else {
                        try {
                            if (this.iso.isDirectory(isofilename)) {
                                String[] filenames = this.iso.listDirectory(isofilename);
                                IoDirInfo info2 = new IoDirInfo(pcfilename, filenames);
                                result = info2.id;
                                break block23;
                            }
                            log.warn((Object)("sceIoDopen '" + isofilename + "' not a umd directory!"));
                            result = -2147418110;
                        }
                        catch (FileNotFoundException e) {
                            log.warn((Object)("sceIoDopen - '" + isofilename + "' umd file not found"));
                            result = -2147418110;
                        }
                        catch (IOException e) {
                            log.warn((Object)("sceIoDopen - umd io error: " + e.getMessage()));
                            result = -2147418110;
                        }
                    }
                } else if (dirname.getString().startsWith("/") && dirname.getString().indexOf(":") != -1) {
                    log.warn((Object)"sceIoDopen apps running outside of ms0 dir are not fully supported, relative child paths should still work");
                    result = -1;
                } else {
                    File f;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("sceIoDopen - pcfilename = " + pcfilename));
                    }
                    if ((f = new File(pcfilename)).isDirectory()) {
                        info = new IoDirInfo(pcfilename, f.list());
                        result = info.id;
                    } else {
                        log.warn((Object)("sceIoDopen '" + pcfilename + "' not a directory! (could be missing)"));
                        result = -2147418110;
                    }
                }
            } else {
                result = -2147418110;
            }
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoDopen(result, dirname.getAddress(), dirname.getString());
        }
        this.delayIoOperation(IoOperation.open);
        return result;
    }

    @HLEFunction(nid=-471138228, version=150, checkInsideInterrupt=true)
    public int sceIoDread(int id, int dirent_addr) {
        int result;
        IoDirInfo info = this.dirIds.get(id);
        if (info == null) {
            log.warn((Object)("sceIoDread unknown id " + Integer.toHexString(id)));
            result = -2147351773;
        } else if (info.hasNext()) {
            SceIoStat stat;
            String filename = info.next();
            SceIoDirent dirent = null;
            if (info.vfs != null) {
                stat = new SceIoStat();
                dirent = new SceIoDirent(stat, filename);
                result = info.vfs.ioDread(info.path, dirent);
            } else {
                stat = this.stat(info.path + "/" + filename);
                if (stat != null) {
                    dirent = new SceIoDirent(stat, filename);
                    result = 1;
                } else {
                    log.warn((Object)("sceIoDread id=" + Integer.toHexString(id) + " stat failed (" + info.path + "/" + filename + ")"));
                    result = -1;
                }
            }
            if (dirent != null && result > 0) {
                if (log.isDebugEnabled()) {
                    String type = (dirent.stat.attr & 0x10) != 0 ? "dir" : "file";
                    log.debug((Object)String.format("sceIoDread id=0x%X #%d %s='%s', dir='%s'", id, info.printableposition, type, info.path, filename));
                }
                dirent.write(Memory.getInstance(), dirent_addr);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceIoDread id=0x%X no more files", id));
            }
            result = 0;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoDread(result, id, dirent_addr);
        }
        this.delayIoOperation(IoOperation.dread);
        return result;
    }

    @HLEFunction(nid=-351722391, version=150, checkInsideInterrupt=true)
    public int sceIoDclose(int id) {
        int result;
        IoDirInfo info = this.dirIds.get(id);
        if (info == null) {
            log.warn((Object)("sceIoDclose - unknown id " + Integer.toHexString(id)));
            result = -2147351773;
        } else if (info.vfs != null) {
            result = info.vfs.ioDclose(info.path);
            info.close();
        } else {
            info.close();
            result = 0;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoDclose(result, id);
        }
        this.delayIoOperation(IoOperation.close);
        return result;
    }

    @HLEFunction(nid=-226845615, version=150, checkInsideInterrupt=true)
    public int sceIoRemove(PspString filename) {
        File file;
        StringBuilder localFileName;
        String pcfilename = this.getDeviceFilePath(filename.getString());
        String absoluteFileName = this.getAbsoluteFileName(filename.getString());
        IVirtualFileSystem vfs = this.vfsManager.getVirtualFileSystem(absoluteFileName, localFileName = new StringBuilder());
        int result = vfs != null ? vfs.ioRemove(localFileName.toString()) : (pcfilename != null ? (this.isUmdPath(pcfilename) ? -1 : ((file = new File(pcfilename)).delete() ? 0 : -1)) : -1);
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoRemove(result, filename.getAddress(), filename.getString());
        }
        this.delayIoOperation(IoOperation.remove);
        return result;
    }

    @HLEFunction(nid=111607812, version=150, checkInsideInterrupt=true)
    public int sceIoMkdir(PspString dirname, int permissions) {
        int result;
        StringBuilder localFileName;
        String pcfilename = this.getDeviceFilePath(dirname.getString());
        String absoluteFileName = this.getAbsoluteFileName(dirname.getString());
        IVirtualFileSystem vfs = this.vfsManager.getVirtualFileSystem(absoluteFileName, localFileName = new StringBuilder());
        if (vfs != null) {
            result = vfs.ioMkdir(localFileName.toString(), permissions);
        } else if (pcfilename != null) {
            File f = new File(pcfilename);
            f.mkdir();
            result = 0;
        } else {
            result = -1;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoMkdir(result, dirname.getAddress(), dirname.getString(), permissions);
        }
        this.delayIoOperation(IoOperation.mkdir);
        return result;
    }

    @HLEFunction(nid=286770783, version=150, checkInsideInterrupt=true)
    public int sceIoRmdir(PspString dirname) {
        int result;
        StringBuilder localFileName;
        String pcfilename = this.getDeviceFilePath(dirname.getString());
        String absoluteFileName = this.getAbsoluteFileName(dirname.getString());
        IVirtualFileSystem vfs = this.vfsManager.getVirtualFileSystem(absoluteFileName, localFileName = new StringBuilder());
        if (vfs != null) {
            result = vfs.ioRmdir(localFileName.toString());
        } else if (pcfilename != null) {
            File f = new File(pcfilename);
            f.delete();
            result = 0;
        } else {
            result = -1;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoRmdir(result, dirname.getAddress(), dirname.getString());
        }
        this.delayIoOperation(IoOperation.remove);
        return result;
    }

    @HLEFunction(nid=1442083197, version=150, checkInsideInterrupt=true)
    public int sceIoChdir(PspString path) {
        int result;
        if (path.getString().equals("..")) {
            int index = this.filepath.lastIndexOf("/");
            if (index != -1) {
                this.filepath = this.filepath.substring(0, index);
            }
            log.info((Object)("pspiofilemgr - filepath " + this.filepath + " (going up one level)"));
            result = 0;
        } else {
            String pcfilename = this.getDeviceFilePath(path.getString());
            if (pcfilename != null) {
                this.filepath = pcfilename;
                log.info((Object)("pspiofilemgr - filepath " + this.filepath));
                result = 0;
            } else {
                result = -1;
            }
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoChdir(result, path.getAddress(), path.getString());
        }
        return result;
    }

    @HLEFunction(nid=-1416215681, version=150, checkInsideInterrupt=true)
    public int sceIoSync(PspString devicename, int flag) {
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoSync(0, devicename.getAddress(), devicename.getString(), flag);
        }
        return 0;
    }

    @HLEFunction(nid=-1393998104, version=150, checkInsideInterrupt=true)
    public int sceIoGetstat(PspString filename, TPointer statAddr) {
        int result;
        StringBuilder localFileName;
        SceIoStat stat = null;
        String absoluteFileName = this.getAbsoluteFileName(filename.getString());
        IVirtualFileSystem vfs = this.vfsManager.getVirtualFileSystem(absoluteFileName, localFileName = new StringBuilder());
        if (vfs != null) {
            stat = new SceIoStat();
            result = vfs.ioGetstat(localFileName.toString(), stat);
        } else {
            String pcfilename = this.getDeviceFilePath(filename.getString());
            stat = this.stat(pcfilename);
            int n = result = stat != null ? 0 : -2147418110;
        }
        if (stat != null && result == 0) {
            stat.write(statAddr);
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoGetStat(result, filename.getAddress(), filename.getString(), statAddr.getAddress());
        }
        return result;
    }

    @HLEFunction(nid=-1196998412, version=150, checkInsideInterrupt=true)
    public int sceIoChstat(PspString filename, int stat_addr, int bits) {
        int result;
        String pcfilename = this.getDeviceFilePath(filename.getString());
        SceIoStat stat = new SceIoStat();
        stat.read(Memory.getInstance(), stat_addr);
        String absoluteFileName = this.getAbsoluteFileName(filename.getString());
        StringBuilder localFileName = new StringBuilder();
        IVirtualFileSystem vfs = this.vfsManager.getVirtualFileSystem(absoluteFileName, localFileName);
        if (vfs != null) {
            result = vfs.ioChstat(localFileName.toString(), stat, bits);
        } else if (pcfilename != null) {
            if (this.isUmdPath(pcfilename)) {
                result = -1;
            } else {
                File file = new File(pcfilename);
                int mode = stat.mode;
                boolean successful = true;
                if ((bits & 1) != 0 && !file.setExecutable((mode & 1) != 0)) {
                    successful = false;
                }
                if ((bits & 2) != 0 && !file.setWritable((mode & 2) != 0)) {
                    successful = false;
                }
                if ((bits & 4) != 0 && !file.setReadable((mode & 4) != 0)) {
                    successful = false;
                }
                if ((bits & 0x40) != 0 && !file.setExecutable((mode & 0x40) != 0, true)) {
                    successful = false;
                }
                if ((bits & 0x80) != 0 && !file.setWritable((mode & 0x80) != 0, true)) {
                    successful = false;
                }
                if ((bits & 0x100) != 0 && !file.setReadable((mode & 0x100) != 0, true)) {
                    successful = false;
                }
                result = successful ? 0 : -1;
            }
        } else {
            result = -1;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoChstat(result, filename.getAddress(), filename.getString(), stat_addr, bits);
        }
        return result;
    }

    @HLEFunction(nid=2005992352, version=150, checkInsideInterrupt=true)
    public int sceIoRename(PspString pspOldFileName, PspString pspNewFileName) {
        int result;
        StringBuilder localOldFileName;
        int prefixOffset;
        String oldFileName = pspOldFileName.getString();
        String newFileName = pspNewFileName.getString();
        if (!newFileName.contains("/") && (prefixOffset = oldFileName.lastIndexOf("/")) >= 0) {
            newFileName = oldFileName.substring(0, prefixOffset + 1) + newFileName;
        }
        String oldpcfilename = this.getDeviceFilePath(oldFileName);
        String newpcfilename = this.getDeviceFilePath(newFileName);
        String absoluteOldFileName = this.getAbsoluteFileName(oldFileName);
        IVirtualFileSystem oldVfs = this.vfsManager.getVirtualFileSystem(absoluteOldFileName, localOldFileName = new StringBuilder());
        if (oldVfs != null) {
            StringBuilder localNewFileName;
            String absoluteNewFileName = this.getAbsoluteFileName(newFileName);
            IVirtualFileSystem newVfs = this.vfsManager.getVirtualFileSystem(absoluteNewFileName, localNewFileName = new StringBuilder());
            if (oldVfs != newVfs) {
                log.error((Object)String.format("sceIoRename - renaming across devices not allowed '%s' - '%s'", oldFileName, newFileName));
                result = -2147418093;
            } else {
                result = oldVfs.ioRename(localOldFileName.toString(), localNewFileName.toString());
            }
        } else if (oldpcfilename != null) {
            if (this.isUmdPath(oldpcfilename)) {
                result = -1;
            } else {
                File file = new File(oldpcfilename);
                File newfile = new File(newpcfilename);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceIoRename: renaming file '%s' to '%s'", oldpcfilename, newpcfilename));
                }
                if (file.renameTo(newfile)) {
                    result = 0;
                } else {
                    log.warn((Object)String.format("sceIoRename failed: %s(%s) to %s(%s)", oldFileName, oldpcfilename, newFileName, newpcfilename));
                    result = -1;
                }
            }
        } else {
            result = -1;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoRename(result, pspOldFileName.getAddress(), pspOldFileName.getString(), pspNewFileName.getAddress(), pspNewFileName.getString());
        }
        this.delayIoOperation(IoOperation.rename);
        return result;
    }

    @HLEFunction(nid=1425406737, version=150, checkInsideInterrupt=true)
    public int sceIoDevctl(PspString devicename, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        IVirtualFileSystem vfs;
        Memory mem = Processor.memory;
        int result = -1;
        if (log.isDebugEnabled()) {
            int i;
            if (Memory.isAddressGood(indata_addr)) {
                for (i = 0; i < inlen; i += 4) {
                    log.debug((Object)String.format("sceIoDevctl indata[%d]=0x%08X", i / 4, mem.read32(indata_addr + i)));
                }
            }
            if (Memory.isAddressGood(outdata_addr)) {
                for (i = 0; i < outlen; i += 4) {
                    log.debug((Object)String.format("sceIoDevctl outdata[%d]=0x%08X", i / 4, mem.read32(outdata_addr + i)));
                }
            }
        }
        if ((vfs = this.vfsManager.getVirtualFileSystem(devicename.getString(), null)) != null) {
            result = vfs.ioDevctl(devicename.getString(), cmd, new TPointer(mem, indata_addr), inlen, new TPointer(mem, outdata_addr), outlen);
            for (IIoListener ioListener : this.ioListeners) {
                ioListener.sceIoDevctl(result, devicename.getAddress(), devicename.getString(), cmd, indata_addr, inlen, outdata_addr, outlen);
            }
            this.delayIoOperation(IoOperation.ioctl);
            return result;
        }
        boolean needDelayIoOperation = true;
        switch (cmd) {
            case 32636929: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceIoDevctl " + String.format("0x%08X", cmd) + " get disc type"));
                }
                if (Memory.isAddressGood(outdata_addr) && outlen >= 8) {
                    int out = this.iso == null ? 0 : 16;
                    mem.write32(outdata_addr + 4, out);
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 32636930: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceIoDevctl " + String.format("0x%08X", cmd) + " get current LBA"));
                }
                if (Memory.isAddressGood(outdata_addr) && outlen >= 4) {
                    mem.write32(outdata_addr, 0);
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 32571555: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceIoDevctl " + String.format("0x%08X", cmd) + " seek UMD disc"));
                }
                if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                    int sector = mem.read32(indata_addr);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("sector=" + sector));
                    }
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 32571556: {
                int sectorNum;
                int unk2;
                int sector;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceIoDevctl " + String.format("0x%08X", cmd) + " prepare UMD data to cache"));
                }
                if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                    int unk1 = mem.read32(indata_addr);
                    sector = mem.read32(indata_addr + 4);
                    unk2 = mem.read32(indata_addr + 8);
                    sectorNum = mem.read32(indata_addr + 12);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("sector=%d, sectorNum=%d, unk1=%d, unk2=%d", sector, sectorNum, unk1, unk2));
                    }
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 32702629: {
                int sectorNum;
                int unk2;
                int sector;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceIoDevctl " + String.format("0x%08X", cmd) + " prepare UMD data to cache and get status"));
                }
                if (Memory.isAddressGood(indata_addr) && inlen >= 4 && Memory.isAddressGood(outdata_addr) && outlen >= 4) {
                    int unk1 = mem.read32(indata_addr);
                    sector = mem.read32(indata_addr + 4);
                    unk2 = mem.read32(indata_addr + 8);
                    sectorNum = mem.read32(indata_addr + 12);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("sector=%d, sectorNum=%d, unk1=%d, unk2=%d", sector, sectorNum, unk1, unk2));
                    }
                    mem.write32(outdata_addr, 1);
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 33708033: {
                log.debug((Object)("sceIoDevctl " + String.format("0x%08X", cmd) + " check ms driver status"));
                if (!devicename.getString().equals("mscmhc0:")) {
                    result = -2147351771;
                    break;
                }
                if (Memory.isAddressGood(outdata_addr)) {
                    mem.write32(outdata_addr, 4);
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 33642500: {
                int callbackType;
                int cbid;
                log.debug((Object)"sceIoDevctl register memorystick insert/eject callback (mscmhc0)");
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                if (!devicename.getString().equals("mscmhc0:")) {
                    result = -2147351771;
                    break;
                }
                if (Memory.isAddressGood(indata_addr) && inlen == 4) {
                    cbid = mem.read32(indata_addr);
                    callbackType = 2;
                    if (threadMan.hleKernelRegisterCallback(2, cbid)) {
                        threadMan.hleKernelNotifyCallback(2, cbid, MemoryStick.getStateMs());
                        result = 0;
                        break;
                    }
                    result = -2145255294;
                    break;
                }
                result = -2145255295;
                break;
            }
            case 33642501: {
                int cbid;
                log.debug((Object)"sceIoDevctl unregister memorystick insert/eject callback (mscmhc0)");
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                if (!devicename.getString().equals("mscmhc0:")) {
                    result = -2147351771;
                    break;
                }
                if (Memory.isAddressGood(indata_addr) && inlen == 4) {
                    cbid = mem.read32(indata_addr);
                    if (threadMan.hleKernelUnRegisterCallback(2, cbid) != null) {
                        result = 0;
                        break;
                    }
                    result = -2145255295;
                    break;
                }
                result = -1;
                break;
            }
            case 33708038: {
                log.debug((Object)"sceIoDevctl check ms inserted (mscmhc0)");
                if (!devicename.getString().equals("mscmhc0:")) {
                    result = -2147351771;
                    break;
                }
                if (Memory.isAddressGood(outdata_addr)) {
                    mem.write32(outdata_addr, 1);
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 37836833: {
                int callbackType;
                int cbid;
                log.debug((Object)"sceIoDevctl register memorystick insert/eject callback (fatms0)");
                needDelayIoOperation = false;
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                if (!devicename.getString().equals("fatms0:")) {
                    result = -2145255295;
                    break;
                }
                if (Memory.isAddressGood(indata_addr) && inlen == 4) {
                    cbid = mem.read32(indata_addr);
                    callbackType = 3;
                    if (threadMan.hleKernelRegisterCallback(3, cbid)) {
                        threadMan.hleKernelNotifyCallback(3, cbid, MemoryStick.getStateFatMs());
                        result = 0;
                        break;
                    }
                    result = -2147418090;
                    break;
                }
                result = -2147418090;
                break;
            }
            case 37836834: {
                int cbid;
                log.debug((Object)"sceIoDevctl unregister memorystick insert/eject callback (fatms0)");
                needDelayIoOperation = false;
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                if (!devicename.getString().equals("fatms0:")) {
                    result = -2145255295;
                    break;
                }
                if (Memory.isAddressGood(indata_addr) && inlen == 4) {
                    cbid = mem.read32(indata_addr);
                    threadMan.hleKernelUnRegisterCallback(3, cbid);
                    result = 0;
                    break;
                }
                result = -2147418090;
                break;
            }
            case 37836835: {
                log.debug((Object)"sceIoDevctl set assigned device (fatms0)");
                if (!devicename.getString().equals("fatms0:")) {
                    result = -2145255295;
                    break;
                }
                if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                    MemoryStick.setStateFatMs(mem.read32(indata_addr));
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 37902372: {
                log.debug((Object)"sceIoDevctl check write protection (fatms0)");
                if (!devicename.getString().equals("fatms0:") && !devicename.getString().equals("ms0:")) {
                    result = -2145255295;
                    break;
                }
                if (Memory.isAddressGood(outdata_addr)) {
                    mem.write32(outdata_addr, 0);
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 37902360: {
                int maxClusters;
                log.debug((Object)"sceIoDevctl get MS capacity (fatms0)");
                int sectorSize = 512;
                int sectorCount = MemoryStick.getSectorSize() / sectorSize;
                int freeClusters = maxClusters = (int)(MemoryStick.getFreeSize() * 95L / 100L / (long)(sectorSize * sectorCount));
                int maxSectors = maxClusters;
                if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                    int addr = mem.read32(indata_addr);
                    if (Memory.isAddressGood(addr)) {
                        log.debug((Object)"sceIoDevctl refer ms free space");
                        mem.write32(addr, maxClusters);
                        mem.write32(addr + 4, freeClusters);
                        mem.write32(addr + 8, maxSectors);
                        mem.write32(addr + 12, sectorSize);
                        mem.write32(addr + 16, sectorCount);
                        result = 0;
                        break;
                    }
                    log.warn((Object)("sceIoDevctl 0x02425818 bad save address " + String.format("0x%08X", addr)));
                    result = -1;
                    break;
                }
                log.warn((Object)("sceIoDevctl 0x02425818 bad param address " + String.format("0x%08X", indata_addr) + " or size " + inlen));
                result = -1;
                break;
            }
            case 37902371: {
                log.debug((Object)"sceIoDevctl check assigned device (fatms0)");
                if (!devicename.getString().equals("fatms0:")) {
                    result = -2145255295;
                    break;
                }
                if (Memory.isAddressGood(outdata_addr) && outlen >= 4) {
                    mem.write32(outdata_addr, MemoryStick.getStateFatMs());
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 54611969: {
                log.debug((Object)"sceIoDevctl register usb thread");
                if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 54611970: {
                log.debug((Object)"sceIoDevctl unregister usb thread");
                if (Memory.isAddressGood(indata_addr) && inlen >= 4) {
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            default: {
                log.warn((Object)("sceIoDevctl " + String.format("0x%08X", cmd) + " unknown command"));
                if (Memory.isAddressGood(indata_addr)) {
                    for (int i = 0; i < inlen; i += 4) {
                        log.warn((Object)("sceIoDevctl indata[" + i / 4 + "]=0x" + Integer.toHexString(mem.read32(indata_addr + i))));
                    }
                }
                result = -1;
            }
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoDevctl(result, devicename.getAddress(), devicename.getString(), cmd, indata_addr, inlen, outdata_addr, outlen);
        }
        if (needDelayIoOperation) {
            this.delayIoOperation(IoOperation.ioctl);
        }
        return result;
    }

    @HLEFunction(nid=146633588, version=150, checkInsideInterrupt=true)
    public int sceIoGetDevType(int id) {
        int result;
        IoInfo info = this.fileIds.get(id);
        if (info == null) {
            log.warn((Object)("sceIoGetDevType - unknown id " + Integer.toHexString(id)));
            result = -2147351773;
        } else {
            result = 32;
        }
        return result;
    }

    @HLELogging(level="warn")
    @HLEFunction(nid=-1297733439, version=150, checkInsideInterrupt=true)
    public int sceIoAssign(PspString alias, PspString physicalDev, PspString filesystemDev, int mode, int arg_addr, int argSize) {
        int result = 0;
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoAssign(result, alias.getAddress(), alias.getString(), physicalDev.getAddress(), physicalDev.getString(), filesystemDev.getAddress(), filesystemDev.getString(), mode, arg_addr, argSize);
        }
        return result;
    }

    @HLELogging(level="warn")
    @HLEFunction(nid=1829283953, version=150, checkInsideInterrupt=true)
    public int sceIoUnassign(PspString alias) {
        return 0;
    }

    @HLEFunction(nid=-390306447, version=150, checkInsideInterrupt=true)
    public int sceIoCancel(int id) {
        int result;
        IoInfo info = this.fileIds.get(id);
        if (info == null) {
            log.warn((Object)("sceIoCancel - unknown id " + Integer.toHexString(id)));
            result = -2147351773;
        } else {
            info.closePending = true;
            result = 0;
        }
        for (IIoListener ioListener : this.ioListeners) {
            ioListener.sceIoCancel(result, id);
        }
        return result;
    }

    @HLEFunction(nid=1546379980, version=150, checkInsideInterrupt=true)
    public int sceIoGetFdList(@CanBeNull TPointer32 outAddr, int outSize, @CanBeNull TPointer32 fdNumAddr) {
        int count = 0;
        if (outAddr.isNotNull() && outSize > 0) {
            int offset = 0;
            for (Integer fd : this.fileIds.keySet()) {
                if (offset >= outSize) break;
                outAddr.setValue(offset, fd);
                offset += 4;
            }
            count = offset / 4;
        }
        fdNumAddr.setValue(this.fileIds.size());
        return count;
    }

    static /* synthetic */ int access$000(IoFileMgrForUser x0) {
        return x0.defaultAsyncPriority;
    }

    private class ExtractPGDSettingsListerner
    extends AbstractBoolSettingsListener {
        private ExtractPGDSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            IoFileMgrForUser.this.setAllowExtractPGDStatus(value);
        }
    }

    private class IOAsyncReadAction
    implements IAction {
        private IoInfo info;
        private int address;
        private int size;
        private int requestedSize;

        public IOAsyncReadAction(IoInfo info, int address, int requestedSize, int size) {
            this.info = info;
            this.address = address;
            this.requestedSize = requestedSize;
            this.size = size;
        }

        @Override
        public void execute() {
            long position = this.info.position;
            int result = 0;
            if (this.info.vFile != null) {
                result = this.info.vFile.ioRead(new TPointer(Memory.getInstance(), this.address), this.size);
                if (result >= 0) {
                    this.info.position += (long)result;
                    this.size = result;
                    if (this.info.sectorBlockMode) {
                        result /= 2048;
                    }
                } else {
                    this.size = 0;
                }
            } else {
                try {
                    Utilities.readFully(this.info.readOnlyFile, this.address, this.size);
                    this.info.position += (long)this.size;
                    result = this.size;
                    if (this.info.sectorBlockMode) {
                        result /= 2048;
                    }
                }
                catch (IOException e) {
                    log.error((Object)e);
                    result = -2147352272;
                }
            }
            this.info.result = result;
            RuntimeContext.invalidateRange(this.address, this.size);
            for (IIoListener ioListener : IoFileMgrForUser.this.ioListeners) {
                ioListener.sceIoRead(result, this.info.id, this.address, this.requestedSize, this.size, position, this.info.readOnlyFile, this.info.vFile);
            }
        }
    }

    private class IoWaitStateChecker
    implements IWaitStateChecker {
        private IoWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            IoInfo info = IoFileMgrForUser.this.fileIds.get(wait.Io_id);
            if (info == null) {
                return false;
            }
            return info.asyncPending;
        }
    }

    public static interface IIoListener {
        public void sceIoSync(int var1, int var2, String var3, int var4);

        public void sceIoPollAsync(int var1, int var2, int var3);

        public void sceIoWaitAsync(int var1, int var2, int var3);

        public void sceIoOpen(int var1, int var2, String var3, int var4, int var5, String var6);

        public void sceIoClose(int var1, int var2);

        public void sceIoWrite(int var1, int var2, int var3, int var4, int var5);

        public void sceIoRead(int var1, int var2, int var3, int var4, int var5, long var6, SeekableDataInput var8, IVirtualFile var9);

        public void sceIoCancel(int var1, int var2);

        public void sceIoSeek32(int var1, int var2, int var3, int var4);

        public void sceIoSeek64(long var1, int var3, long var4, int var6);

        public void sceIoMkdir(int var1, int var2, String var3, int var4);

        public void sceIoRmdir(int var1, int var2, String var3);

        public void sceIoChdir(int var1, int var2, String var3);

        public void sceIoDopen(int var1, int var2, String var3);

        public void sceIoDread(int var1, int var2, int var3);

        public void sceIoDclose(int var1, int var2);

        public void sceIoDevctl(int var1, int var2, String var3, int var4, int var5, int var6, int var7, int var8);

        public void sceIoIoctl(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public void sceIoAssign(int var1, int var2, String var3, int var4, String var5, int var6, String var7, int var8, int var9, int var10);

        public void sceIoGetStat(int var1, int var2, String var3, int var4);

        public void sceIoRemove(int var1, int var2, String var3);

        public void sceIoChstat(int var1, int var2, String var3, int var4, int var5);

        public void sceIoRename(int var1, int var2, String var3, int var4, String var5);
    }

    private static class PatternFilter
    implements FilenameFilter {
        private Pattern pattern;

        public PatternFilter(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.pattern.matcher(name).matches();
        }
    }

    public class IoDirInfo {
        final String path;
        final String[] filenames;
        int position;
        int printableposition;
        final int id;
        final IVirtualFileSystem vfs;

        public IoDirInfo(String path, String[] filenames) {
            this.vfs = null;
            this.id = IoFileMgrForUser.getNewId();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            this.path = path;
            this.filenames = filenames;
            this.init();
        }

        public IoDirInfo(String path, String[] filenames, IVirtualFileSystem vfs) {
            this.vfs = vfs;
            this.id = IoFileMgrForUser.getNewId();
            this.path = path;
            this.filenames = filenames;
            this.init();
        }

        private void init() {
            this.position = 0;
            this.printableposition = 0;
            if (this.filenames != null) {
                if (this.filenames.length > this.position && this.filenames[this.position].equals(".")) {
                    ++this.position;
                }
                if (this.filenames.length > this.position && this.filenames[this.position].equals("\u0001")) {
                    ++this.position;
                }
            }
            IoFileMgrForUser.this.dirIds.put(this.id, this);
        }

        public boolean hasNext() {
            return this.position < this.filenames.length;
        }

        public String next() {
            String filename = null;
            if (this.position < this.filenames.length) {
                filename = this.filenames[this.position];
                ++this.position;
                ++this.printableposition;
            }
            return filename;
        }

        public IoDirInfo close() {
            IoDirInfo info = IoFileMgrForUser.this.dirIds.remove(this.id);
            if (info != null) {
                IoFileMgrForUser.releaseId(this.id);
            }
            return info;
        }
    }

    public class IoInfo {
        public final int flags;
        public final int permissions;
        public final String filename;
        public final SeekableRandomFile msFile;
        public SeekableDataInput readOnlyFile;
        public IVirtualFile vFile;
        public final String mode;
        public long position;
        public boolean sectorBlockMode;
        public final int id;
        public final int uid;
        public long result;
        public boolean closePending = false;
        public boolean asyncPending;
        public boolean asyncResultPending;
        public long asyncDoneMillis;
        public int asyncThreadPriority = IoFileMgrForUser.access$000(IoFileMgrForUser.this);
        public SceKernelThreadInfo asyncThread;
        public IAction asyncAction;
        public int cbid = -1;
        public int notifyArg = 0;

        public IoInfo(String filename, SeekableRandomFile f, String mode, int flags, int permissions) {
            this.vFile = null;
            this.filename = filename;
            this.msFile = f;
            this.readOnlyFile = f;
            this.mode = mode;
            this.flags = flags;
            this.permissions = permissions;
            this.sectorBlockMode = false;
            this.id = IoFileMgrForUser.getNewId();
            if (this.isValidId()) {
                this.uid = IoFileMgrForUser.getNewUid();
                IoFileMgrForUser.this.fileIds.put(this.id, this);
                IoFileMgrForUser.this.fileUids.put(this.uid, this);
            } else {
                this.uid = -1;
            }
        }

        public IoInfo(String filename, SeekableDataInput f, String mode, int flags, int permissions) {
            this.vFile = null;
            this.filename = filename;
            this.msFile = null;
            this.readOnlyFile = f;
            this.mode = mode;
            this.flags = flags;
            this.permissions = permissions;
            this.sectorBlockMode = false;
            this.id = IoFileMgrForUser.getNewId();
            if (this.isValidId()) {
                this.uid = IoFileMgrForUser.getNewUid();
                IoFileMgrForUser.this.fileIds.put(this.id, this);
                IoFileMgrForUser.this.fileUids.put(this.uid, this);
            } else {
                this.uid = -1;
            }
        }

        public IoInfo(String filename, IVirtualFile f, String mode, int flags, int permissions) {
            this.vFile = f;
            this.filename = filename;
            this.msFile = null;
            this.readOnlyFile = null;
            this.mode = mode;
            this.flags = flags;
            this.permissions = permissions;
            this.sectorBlockMode = false;
            this.id = IoFileMgrForUser.getNewId();
            if (this.isValidId()) {
                this.uid = IoFileMgrForUser.getNewUid();
                IoFileMgrForUser.this.fileIds.put(this.id, this);
                IoFileMgrForUser.this.fileUids.put(this.uid, this);
            } else {
                this.uid = -1;
            }
        }

        public boolean isValidId() {
            return this.id != Integer.MIN_VALUE;
        }

        public boolean isUmdFile() {
            return this.msFile == null;
        }

        public int getAsyncRestMillis() {
            long now = Emulator.getClock().currentTimeMillis();
            if (now >= this.asyncDoneMillis) {
                return 0;
            }
            return (int)(this.asyncDoneMillis - now);
        }

        public void truncate(int length) {
            try {
                if (this.msFile != null) {
                    this.msFile.setLength(length);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public IoInfo close() {
            IoInfo info = IoFileMgrForUser.this.fileIds.remove(this.id);
            if (info != null) {
                IoFileMgrForUser.this.fileUids.remove(this.uid);
                IoFileMgrForUser.releaseId(this.id);
                IoFileMgrForUser.releaseUid(this.uid);
            }
            return info;
        }

        public String toString() {
            return String.format("id=0x%X, fileName='%s'", this.id, this.filename);
        }
    }

    protected static enum IoOperation {
        open(5),
        close(1),
        seek(1),
        ioctl(2),
        remove,
        rename,
        mkdir,
        dread,
        read(4, 65536),
        write(5, 65536);

        private int delayMillis;
        private int sizeUnit;

        private IoOperation() {
            this.delayMillis = 0;
        }

        private IoOperation(int delayMillis) {
            this.delayMillis = delayMillis;
            this.sizeUnit = 0;
        }

        private IoOperation(int delayMillis, int sizeUnit) {
            this.delayMillis = delayMillis;
            this.sizeUnit = sizeUnit;
        }

        int getDelayMillis() {
            return this.delayMillis;
        }

        int getDelayMillis(int size) {
            if (this.sizeUnit == 0 || size <= 0) {
                return this.getDelayMillis();
            }
            return Math.max((int)((long)this.delayMillis * (long)size / (long)this.sizeUnit), this.delayMillis);
        }
    }
}

