/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Debugger.DumpDebugState;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.StringInfo;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.TPointer64;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.managers.SystemTimeManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelAlarmInfo;
import jpcsp.HLE.kernel.types.SceKernelCallbackInfo;
import jpcsp.HLE.kernel.types.SceKernelSystemStatus;
import jpcsp.HLE.kernel.types.SceKernelThreadEventHandlerInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceKernelVTimerInfo;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.hardware.Interrupts;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.scheduler.Scheduler;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ThreadManForUser
extends HLEModule {
    public static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelThreadInfo> threadMap;
    private HashMap<Integer, SceKernelThreadEventHandlerInfo> threadEventHandlerMap;
    private HashMap<Integer, Integer> threadEventMap;
    private LinkedList<SceKernelThreadInfo> readyThreads;
    private SceKernelThreadInfo currentThread;
    private SceKernelThreadInfo idle0;
    private SceKernelThreadInfo idle1;
    public Statistics statistics;
    private boolean dispatchThreadEnabled;
    private static final int SCE_KERNEL_DISPATCHTHREAD_STATE_DISABLED = 0;
    private static final int SCE_KERNEL_DISPATCHTHREAD_STATE_ENABLED = 1;
    protected static final int THREAD_DELAY_MINIMUM_MICROS = 200;
    protected static final int CALLBACKID_REGISTER = 16;
    protected CallbackManager callbackManager = new CallbackManager();
    protected static final int IDLE_THREAD_ADDRESS = 0x8000000;
    public static final int THREAD_EXIT_HANDLER_ADDRESS = 0x8000020;
    public static final int CALLBACK_EXIT_HANDLER_ADDRESS = 0x8000030;
    public static final int ASYNC_LOOP_ADDRESS = 0x8000040;
    public static final int NET_APCTL_LOOP_ADDRESS = 0x8000060;
    public static final int NET_ADHOC_MATCHING_EVENT_LOOP_ADDRESS = 0x8000080;
    public static final int NET_ADHOC_MATCHING_INPUT_LOOP_ADDRESS = 0x80000A0;
    public static final int NET_ADHOC_CTL_LOOP_ADDRESS = 0x80000C0;
    private HashMap<Integer, SceKernelCallbackInfo> callbackMap;
    private boolean USE_THREAD_BANLIST = false;
    private static final boolean LOG_CONTEXT_SWITCHING = true;
    private static final boolean LOG_INSTRUCTIONS = false;
    public boolean exitCalled = false;
    public static final int SCE_KERNEL_TMID_Thread = 1;
    public static final int SCE_KERNEL_TMID_Semaphore = 2;
    public static final int SCE_KERNEL_TMID_EventFlag = 3;
    public static final int SCE_KERNEL_TMID_Mbox = 4;
    public static final int SCE_KERNEL_TMID_Vpl = 5;
    public static final int SCE_KERNEL_TMID_Fpl = 6;
    public static final int SCE_KERNEL_TMID_Mpipe = 7;
    public static final int SCE_KERNEL_TMID_Callback = 8;
    public static final int SCE_KERNEL_TMID_ThreadEventHandler = 9;
    public static final int SCE_KERNEL_TMID_Alarm = 10;
    public static final int SCE_KERNEL_TMID_VTimer = 11;
    public static final int SCE_KERNEL_TMID_Mutex = 12;
    public static final int SCE_KERNEL_TMID_LwMutex = 13;
    public static final int SCE_KERNEL_TMID_SleepThread = 64;
    public static final int SCE_KERNEL_TMID_DelayThread = 65;
    public static final int SCE_KERNEL_TMID_SuspendThread = 66;
    public static final int SCE_KERNEL_TMID_DormantThread = 67;
    protected static final int INTR_NUMBER = 15;
    protected Map<Integer, SceKernelAlarmInfo> alarms;
    protected Map<Integer, SceKernelVTimerInfo> vtimers;
    protected boolean needThreadReschedule;
    protected WaitThreadEndWaitStateChecker waitThreadEndWaitStateChecker;
    protected TimeoutThreadWaitStateChecker timeoutThreadWaitStateChecker;
    protected SleepThreadWaitStateChecker sleepThreadWaitStateChecker;
    private final String[] threadNameBanList = new String[]{"bgm thread", "sgx-psp-freq-thr", "sgx-psp-pcm-th", "ss playthread", "spcbgm", "scemainsamplebgmmp3", "se thread"};

    @Override
    public String getName() {
        return "ThreadManForUser";
    }

    @Override
    public void start() {
        this.threadMap = new HashMap();
        this.threadEventMap = new HashMap();
        this.threadEventHandlerMap = new HashMap();
        this.readyThreads = new LinkedList();
        this.statistics = new Statistics();
        this.callbackMap = new HashMap();
        this.callbackManager.Initialize();
        this.installIdleThreads();
        this.installThreadExitHandler();
        this.installCallbackExitHandler();
        this.installAsyncLoopHandler();
        this.installNetApctlLoopHandler();
        this.installNetAdhocMatchingEventLoopHandler();
        this.installNetAdhocMatchingInputLoopHandler();
        this.installNetAdhocCtlLoopHandler();
        this.alarms = new HashMap<Integer, SceKernelAlarmInfo>();
        this.vtimers = new HashMap<Integer, SceKernelVTimerInfo>();
        this.dispatchThreadEnabled = true;
        this.needThreadReschedule = true;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean.isThreadCpuTimeSupported()) {
            threadMXBean.setThreadCpuTimeEnabled(true);
        }
        this.waitThreadEndWaitStateChecker = new WaitThreadEndWaitStateChecker();
        this.timeoutThreadWaitStateChecker = new TimeoutThreadWaitStateChecker();
        this.sleepThreadWaitStateChecker = new SleepThreadWaitStateChecker();
        this.setSettingsListener("emu.ignoreaudiothreads", new EnableThreadBanningSettingsListerner());
        super.start();
    }

    @Override
    public void stop() {
        this.alarms = null;
        this.vtimers = null;
        for (SceKernelThreadInfo thread : this.threadMap.values()) {
            this.terminateThread(thread);
        }
        super.stop();
    }

    public Iterator<SceKernelThreadInfo> iterator() {
        return this.threadMap.values().iterator();
    }

    public Iterator<SceKernelThreadInfo> iteratorByPriority() {
        Collection<SceKernelThreadInfo> c = this.threadMap.values();
        LinkedList<SceKernelThreadInfo> list = new LinkedList<SceKernelThreadInfo>(c);
        Collections.sort(list, this.idle0);
        return list.iterator();
    }

    public void Initialise(SceModule module, int entry_addr, int attr, String pspfilename, int moduleid, int gp, boolean fromSyscall) {
        int rootStackSize;
        int n = rootStackSize = fromSyscall ? 16384 : 262144;
        if (module != null && module.module_start_thread_stacksize > 0) {
            rootStackSize = module.module_start_thread_stacksize;
        }
        int rootInitPriority = 32;
        if (module != null && module.module_start_thread_priority > 0) {
            rootInitPriority = module.module_start_thread_priority;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Creating root thread: entry=0x%08X, priority=%d, stackSize=0x%X, attr=0x%X", entry_addr, rootInitPriority, rootStackSize, attr));
        }
        this.currentThread = new SceKernelThreadInfo("root", entry_addr, rootInitPriority, rootStackSize, attr);
        this.currentThread.moduleid = moduleid;
        this.threadMap.put(this.currentThread.uid, this.currentThread);
        if (!this.currentThread.isKernelMode()) {
            this.currentThread.attr |= Integer.MIN_VALUE;
        }
        this.hleKernelSetThreadArguments(this.currentThread, pspfilename);
        this.currentThread.cpuContext._gp = gp;
        this.idle0.cpuContext._gp = gp;
        this.idle1.cpuContext._gp = gp;
        this.currentThread.status = 2;
        this.currentThread.status = 1;
        this.currentThread.restoreContext();
    }

    public void hleKernelSetThreadArguments(SceKernelThreadInfo thread, String argument) {
        int address = this.prepareThreadArguments(thread, argument.length() + 1);
        Utilities.writeStringZ(Memory.getInstance(), address, argument);
    }

    public void hleKernelSetThreadArguments(SceKernelThreadInfo thread, byte[] argument, int argumentSize) {
        int address = this.prepareThreadArguments(thread, argumentSize);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, argumentSize, 1);
        for (int i = 0; i < argumentSize; ++i) {
            memoryWriter.writeNext(argument[i] & 0xFF);
        }
        memoryWriter.flush();
    }

    public void hleKernelSetThreadArguments(SceKernelThreadInfo thread, int argumentAddr, int argumentSize) {
        int address = this.prepareThreadArguments(thread, argumentAddr == 0 ? -1 : argumentSize);
        if (argumentAddr != 0) {
            Memory.getInstance().memcpy(address, argumentAddr, argumentSize);
        }
    }

    private int prepareThreadArguments(SceKernelThreadInfo thread, int argumentSize) {
        int address = thread.getStackAddr() + thread.stackSize - 256 - (argumentSize + 15 & 0xFFFFFFF0);
        if (argumentSize < 0) {
            thread.cpuContext._a0 = 0;
            thread.cpuContext._a1 = 0;
        } else {
            thread.cpuContext._a0 = argumentSize;
            thread.cpuContext._a1 = address;
        }
        thread.cpuContext._sp = address - 64;
        return address;
    }

    private void installIdleThreads() {
        Memory mem = Memory.getInstance();
        int instruction_addiu = 0x24040000;
        int instruction_lui = 1008666624;
        int instruction_jr = 65011720;
        int instruction_syscall = 0xC | (this.getHleFunctionByName("sceKernelDelayThread").getSyscallCode() & 0xFFFFF) << 6;
        SysMemUserForUser.SysMemInfo info = Modules.SysMemUserForUserModule.malloc(1, "ThreadMan-RootMem", 2, 16384, 0x8800000);
        int reservedMem = info.addr;
        mem.write32(0x8000000, instruction_addiu);
        mem.write32(0x8000004, instruction_lui);
        mem.write32(0x8000008, instruction_jr);
        mem.write32(0x800000C, instruction_syscall);
        this.idle0 = new SceKernelThreadInfo("idle0", -2013265920, 127, 0, 4096);
        this.idle0.setSystemStack(reservedMem, 8192);
        this.idle0.reset();
        this.idle0.exitStatus = -2147352156;
        this.threadMap.put(this.idle0.uid, this.idle0);
        this.hleChangeThreadState(this.idle0, 2);
        this.idle1 = new SceKernelThreadInfo("idle1", -2013265920, 127, 0, 4096);
        this.idle1.setSystemStack(reservedMem + 8192, 8192);
        this.idle1.reset();
        this.idle1.exitStatus = -2147352156;
        this.threadMap.put(this.idle1.uid, this.idle1);
        this.hleChangeThreadState(this.idle1, 2);
    }

    private void installThreadExitHandler() {
        Memory mem = Memory.getInstance();
        int instruction_syscall = 0xC | (this.getHleFunctionByName("hleKernelExitThread").getSyscallCode() & 0xFFFFF) << 6;
        int instruction_jr = 65011720;
        mem.write32(0x8000020, instruction_syscall);
        mem.write32(134217764, instruction_jr);
    }

    private void installCallbackExitHandler() {
        Memory mem = Memory.getInstance();
        int instruction_syscall = 0xC | (this.getHleFunctionByName("hleKernelExitCallback").getSyscallCode() & 0xFFFFF) << 6;
        int instruction_jr = 65011720;
        mem.write32(0x8000030, instruction_syscall);
        mem.write32(134217780, instruction_jr);
    }

    private void installLoopHandler(String hleFunctionName, int address) {
        Memory mem = Memory.getInstance();
        int instruction_syscall = 0xC | (this.getHleFunctionByName(hleFunctionName).getSyscallCode() & 0xFFFFF) << 6;
        int instruction_b = 268500990;
        int instruction_nop = 0;
        int instruction_jr = 65011720;
        mem.write32(address + 0, instruction_syscall);
        mem.write32(address + 4, instruction_b);
        mem.write32(address + 8, instruction_nop);
        mem.write32(address + 12, instruction_jr);
        mem.write32(address + 16, instruction_nop);
    }

    private void installAsyncLoopHandler() {
        this.installLoopHandler("hleKernelAsyncLoop", 0x8000040);
    }

    @HLEFunction(nid=-1, version=150)
    public void hleKernelAsyncLoop(Processor processor) {
        Modules.IoFileMgrForUserModule.hleAsyncThread(processor);
    }

    private void installNetApctlLoopHandler() {
        this.installLoopHandler("hleKernelNetApctlLoop", 0x8000060);
    }

    @HLEFunction(nid=-1, version=150)
    public void hleKernelNetApctlLoop(Processor processor) {
        Modules.sceNetApctlModule.hleNetApctlThread(processor);
    }

    private void installNetAdhocMatchingEventLoopHandler() {
        this.installLoopHandler("hleKernelNetAdhocMatchingEventLoop", 0x8000080);
    }

    @HLEFunction(nid=-1, version=150)
    public void hleKernelNetAdhocMatchingEventLoop(Processor processor) {
        Modules.sceNetAdhocMatchingModule.hleNetAdhocMatchingEventThread(processor);
    }

    private void installNetAdhocMatchingInputLoopHandler() {
        this.installLoopHandler("hleKernelNetAdhocMatchingInputLoop", 0x80000A0);
    }

    @HLEFunction(nid=-1, version=150)
    public void hleKernelNetAdhocMatchingInputLoop(Processor processor) {
        Modules.sceNetAdhocMatchingModule.hleNetAdhocMatchingInputThread(processor);
    }

    private void installNetAdhocCtlLoopHandler() {
        this.installLoopHandler("hleKernelNetAdhocctlLoop", 0x80000C0);
    }

    @HLEFunction(nid=-1, version=150)
    public void hleKernelNetAdhocctlLoop(Processor processor) {
        Modules.sceNetAdhocctlModule.hleNetAdhocctlThread(processor);
    }

    public void exit() {
        this.exitCalled = true;
        if (this.threadMap != null) {
            this.deleteAllThreads();
            log.info((Object)"----------------------------- ThreadMan exit -----------------------------");
        }
    }

    public void step() {
        if (this.currentThread != null) {
            ++this.currentThread.runClocks;
        } else if (!this.exitCalled) {
            log.error((Object)"No ready threads!");
        }
    }

    private void internalContextSwitch(SceKernelThreadInfo newThread) {
        if (this.currentThread != null) {
            if (this.currentThread.status == 1) {
                this.hleChangeThreadState(this.currentThread, 2);
            }
            this.currentThread.saveContext();
        }
        if (newThread != null) {
            this.hleChangeThreadState(newThread, 1);
            newThread.restoreContext();
            if (log.isDebugEnabled() && !this.isIdleThread(newThread)) {
                log.debug((Object)("---------------------------------------- SceUID=" + Integer.toHexString(newThread.uid) + " name:'" + newThread.name + "'"));
            }
        } else if (!this.exitCalled) {
            DumpDebugState.dumpDebugState();
            log.info((Object)("No ready threads - pausing emulator. caller:" + this.getCallingFunction()));
            Emulator.PauseEmuWithStatus(-1);
        }
        this.currentThread = newThread;
        RuntimeContext.update();
    }

    private boolean contextSwitch(SceKernelThreadInfo newThread) {
        if (IntrManager.getInstance().isInsideInterrupt()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Inside an interrupt, not context switching to " + newThread));
            }
            return false;
        }
        if (Interrupts.isInterruptsDisabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Interrupts are disabled, not context switching to " + newThread));
            }
            return false;
        }
        if (!this.dispatchThreadEnabled) {
            log.info((Object)("DispatchThread disabled, not context switching to " + newThread));
            return false;
        }
        this.internalContextSwitch(newThread);
        this.checkThreadCallbacks(this.currentThread);
        this.executePendingCallbacks(this.currentThread);
        return true;
    }

    private void executePendingCallbacks(SceKernelThreadInfo thread) {
        if (!thread.pendingCallbacks.isEmpty() && RuntimeContext.canExecuteCallback(thread)) {
            Callback callback = thread.pendingCallbacks.poll();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Executing pending callback '%s' for thread '%s'", callback, thread));
            }
            callback.execute(thread);
        }
    }

    public void checkPendingCallbacks() {
        this.executePendingCallbacks(this.currentThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SceKernelThreadInfo nextThread() {
        SceKernelThreadInfo found = null;
        LinkedList<SceKernelThreadInfo> linkedList = this.readyThreads;
        synchronized (linkedList) {
            for (SceKernelThreadInfo thread : this.readyThreads) {
                if (found != null && thread.currentPriority >= found.currentPriority) continue;
                found = thread;
            }
        }
        return found;
    }

    public void hleRescheduleCurrentThread() {
        if (this.needThreadReschedule) {
            SceKernelThreadInfo newThread = this.nextThread();
            if (newThread != null && (this.currentThread == null || this.currentThread.status != 1 || this.currentThread.currentPriority > newThread.currentPriority)) {
                if (Modules.log.isDebugEnabled()) {
                    log.debug((Object)("Context switching to '" + newThread + "' after reschedule"));
                }
                if (this.contextSwitch(newThread)) {
                    this.needThreadReschedule = false;
                }
            } else {
                this.needThreadReschedule = false;
            }
        }
    }

    public void hleRescheduleCurrentThread(boolean doCallbacks) {
        SceKernelThreadInfo thread = this.currentThread;
        if (doCallbacks) {
            if (thread != null) {
                thread.doCallbacks = doCallbacks;
            }
            this.checkCallbacks();
        }
        this.hleRescheduleCurrentThread();
        if (this.currentThread == thread && doCallbacks && thread.isRunning()) {
            thread.doCallbacks = false;
        }
    }

    public int getCurrentThreadID() {
        if (this.currentThread == null) {
            return -1;
        }
        return this.currentThread.uid;
    }

    public SceKernelThreadInfo getCurrentThread() {
        return this.currentThread;
    }

    public boolean isIdleThread(SceKernelThreadInfo thread) {
        return thread == this.idle0 || thread == this.idle1;
    }

    public boolean isKernelMode() {
        return this.currentThread.isKernelMode();
    }

    public String getThreadName(int uid) {
        SceKernelThreadInfo thread = this.threadMap.get(uid);
        if (thread == null) {
            return "NOT A THREAD";
        }
        return thread.name;
    }

    public boolean isThreadBlocked(SceKernelThreadInfo thread) {
        return thread.isWaitingForType(258);
    }

    public boolean isDispatchThreadEnabled() {
        return this.dispatchThreadEnabled;
    }

    public void hleBlockCurrentThread() {
        this.hleBlockCurrentThread(null);
    }

    public SceKernelCallbackInfo hleKernelReferCallbackStatus(int uid) {
        return this.callbackMap.get(uid);
    }

    public void hleKernelThreadEnterWaitState(int waitType, int waitId, IWaitStateChecker waitStateChecker, int timeoutAddr, boolean callbacks) {
        this.hleKernelThreadEnterWaitState(this.currentThread, waitType, waitId, waitStateChecker, timeoutAddr, callbacks);
    }

    public void hleKernelThreadEnterWaitState(SceKernelThreadInfo thread, int waitType, int waitId, IWaitStateChecker waitStateChecker, int timeoutAddr, boolean callbacks) {
        int micros = 0;
        boolean forever = true;
        if (Memory.isAddressGood(timeoutAddr)) {
            micros = Memory.getInstance().read32(timeoutAddr);
            forever = false;
        }
        this.hleKernelThreadEnterWaitState(thread, waitType, waitId, waitStateChecker, micros, forever, callbacks);
    }

    public void hleKernelThreadEnterWaitState(int waitType, int waitId, IWaitStateChecker waitStateChecker, boolean callbacks) {
        this.hleKernelThreadEnterWaitState(this.currentThread, waitType, waitId, waitStateChecker, 0, true, callbacks);
    }

    public void hleKernelThreadEnterWaitState(SceKernelThreadInfo thread, int waitType, int waitId, IWaitStateChecker waitStateChecker, int micros, boolean forever, boolean callbacks) {
        thread.waitType = waitType;
        thread.waitId = waitId;
        thread.wait.waitStateChecker = waitStateChecker;
        this.hleKernelThreadWait(thread, micros, forever);
        this.hleChangeThreadState(thread, 4);
        this.hleRescheduleCurrentThread(callbacks);
    }

    private void hleBlockThread(SceKernelThreadInfo thread, boolean doCallbacks, IAction onUnblockAction, IWaitStateChecker waitStateChecker) {
        if (!thread.isWaiting()) {
            thread.doCallbacks = doCallbacks;
            thread.wait.onUnblockAction = onUnblockAction;
            thread.waitType = 258;
            thread.waitId = 0;
            thread.wait.waitStateChecker = waitStateChecker;
            this.hleChangeThreadState(thread, thread.isSuspended() ? 12 : 4);
        }
    }

    public void hleBlockCurrentThread(boolean doCallbacks, IAction onUnblockAction, IWaitStateChecker waitStateChecker) {
        if (Modules.log.isDebugEnabled()) {
            log.debug((Object)("-------------------- block SceUID=" + Integer.toHexString(this.currentThread.uid) + " name:'" + this.currentThread.name + "' caller:" + this.getCallingFunction()));
        }
        this.hleBlockThread(this.currentThread, doCallbacks, onUnblockAction, waitStateChecker);
        this.hleRescheduleCurrentThread(doCallbacks);
    }

    public void hleBlockCurrentThread(IAction onUnblockAction) {
        this.hleBlockCurrentThread(false, onUnblockAction, null);
    }

    public void hleBlockCurrentThread(IAction onUnblockAction, IWaitStateChecker waitStateChecker) {
        this.hleBlockCurrentThread(false, onUnblockAction, waitStateChecker);
    }

    public void hleBlockCurrentThreadCB(IAction onUnblockAction, IWaitStateChecker waitStateChecker) {
        this.hleBlockCurrentThread(true, onUnblockAction, waitStateChecker);
    }

    public SceKernelThreadInfo getThreadById(int uid) {
        return this.threadMap.get(uid);
    }

    public SceKernelThreadInfo getThreadByName(String name) {
        for (SceKernelThreadInfo thread : this.threadMap.values()) {
            if (!name.equals(thread.name)) continue;
            return thread;
        }
        return null;
    }

    public void hleUnblockThread(int uid) {
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-thread", false)) {
            SceKernelThreadInfo thread = this.threadMap.get(uid);
            this.hleChangeThreadState(thread, 2);
            if (thread != null && Modules.log.isDebugEnabled()) {
                log.debug((Object)("-------------------- unblock SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' caller:" + this.getCallingFunction()));
            }
        }
    }

    private String getCallingFunction() {
        String msg = "";
        StackTraceElement[] lines = new Exception().getStackTrace();
        if (lines.length >= 3) {
            msg = lines[2].toString();
            msg = msg.substring(0, msg.indexOf("("));
            String[] parts = msg.split("\\.");
            msg = "'" + parts[parts.length - 2] + "." + parts[parts.length - 1] + "'";
        } else {
            StackTraceElement e;
            String line;
            StackTraceElement[] arr$ = lines;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(line = (e = arr$[i$]).toString()).startsWith("jpcsp.Allegrex") && !line.startsWith("jpcsp.Processor"); ++i$) {
                msg = msg + "\n" + line;
            }
        }
        return msg;
    }

    public void hleThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (thread.waitType != 0) {
            this.onWaitTimeout(thread);
            this.hleChangeThreadState(thread, 2);
        }
    }

    private void onWaitTimeout(SceKernelThreadInfo thread) {
        switch (thread.waitType) {
            case 9: {
                if (!thread.wait.ThreadEnd_returnExitStatus) break;
                thread.cpuContext._v0 = -2147352152;
                break;
            }
            case 4: {
                Managers.eventFlags.onThreadWaitTimeout(thread);
                break;
            }
            case 3: {
                Managers.semas.onThreadWaitTimeout(thread);
                break;
            }
            case 257: {
                Modules.sceUmdUserModule.onThreadWaitTimeout(thread);
                break;
            }
            case 12: {
                Managers.mutex.onThreadWaitTimeout(thread);
                break;
            }
            case 13: {
                Managers.lwmutex.onThreadWaitTimeout(thread);
                break;
            }
            case 8: {
                Managers.msgPipes.onThreadWaitTimeout(thread);
                break;
            }
            case 5: {
                Managers.mbx.onThreadWaitTimeout(thread);
                break;
            }
            case 7: {
                Managers.fpl.onThreadWaitTimeout(thread);
                break;
            }
            case 6: {
                Managers.vpl.onThreadWaitTimeout(thread);
            }
        }
    }

    private void hleThreadWaitRelease(SceKernelThreadInfo thread) {
        if (thread.isSuspended()) {
            this.hleChangeThreadState(thread, 8);
        } else if (thread.waitType != 0) {
            this.onWaitReleased(thread);
            this.hleChangeThreadState(thread, 2);
        }
    }

    private void onWaitReleased(SceKernelThreadInfo thread) {
        switch (thread.waitType) {
            case 9: {
                if (!thread.wait.ThreadEnd_returnExitStatus) break;
                thread.cpuContext._v0 = -2147352150;
                break;
            }
            case 4: {
                Managers.eventFlags.onThreadWaitReleased(thread);
                break;
            }
            case 3: {
                Managers.semas.onThreadWaitReleased(thread);
                break;
            }
            case 257: {
                Modules.sceUmdUserModule.onThreadWaitReleased(thread);
                break;
            }
            case 12: {
                Managers.mutex.onThreadWaitReleased(thread);
                break;
            }
            case 13: {
                Managers.lwmutex.onThreadWaitReleased(thread);
                break;
            }
            case 8: {
                Managers.msgPipes.onThreadWaitReleased(thread);
                break;
            }
            case 5: {
                Managers.mbx.onThreadWaitReleased(thread);
                break;
            }
            case 7: {
                Managers.fpl.onThreadWaitReleased(thread);
                break;
            }
            case 6: {
                Managers.vpl.onThreadWaitReleased(thread);
                break;
            }
            case 258: {
                thread.cpuContext._v0 = -2147352150;
            }
        }
    }

    private void deleteAllThreads() {
        LinkedList<SceKernelThreadInfo> threadsToBeDeleted = new LinkedList<SceKernelThreadInfo>(this.threadMap.values());
        for (SceKernelThreadInfo thread : threadsToBeDeleted) {
            this.hleDeleteThread(thread);
        }
    }

    public void hleDeleteThread(SceKernelThreadInfo thread) {
        if (!this.threadMap.containsKey(thread.uid)) {
            log.debug((Object)String.format("Thread %s already deleted", thread.toString()));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("really deleting thread:'%s'", thread.name));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("thread:'%s' freeing stack 0x%08X", thread.name, thread.getStackAddr()));
        }
        thread.freeStack();
        Managers.eventFlags.onThreadDeleted(thread);
        Managers.semas.onThreadDeleted(thread);
        Managers.mutex.onThreadDeleted(thread);
        Managers.lwmutex.onThreadDeleted(thread);
        Managers.msgPipes.onThreadDeleted(thread);
        Managers.mbx.onThreadDeleted(thread);
        Managers.fpl.onThreadDeleted(thread);
        Managers.vpl.onThreadDeleted(thread);
        Modules.sceUmdUserModule.onThreadDeleted(thread);
        RuntimeContext.onThreadDeleted(thread);
        this.cancelThreadWait(thread);
        this.threadMap.remove(thread.uid);
        SceUidManager.releaseUid(thread.uid, "ThreadMan-thread");
        this.statistics.addThreadStatistics(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromReadyThreads(SceKernelThreadInfo thread) {
        LinkedList<SceKernelThreadInfo> linkedList = this.readyThreads;
        synchronized (linkedList) {
            this.readyThreads.remove(thread);
            this.needThreadReschedule = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToReadyThreads(SceKernelThreadInfo thread, boolean addFirst) {
        LinkedList<SceKernelThreadInfo> linkedList = this.readyThreads;
        synchronized (linkedList) {
            if (addFirst) {
                this.readyThreads.addFirst(thread);
            } else {
                this.readyThreads.addLast(thread);
            }
            this.needThreadReschedule = true;
        }
    }

    private void setToBeDeletedThread(SceKernelThreadInfo thread) {
        thread.doDelete = true;
        if (thread.isStopped() && thread.doDeleteAction == null) {
            thread.doDeleteAction = new DeleteThreadAction(thread);
            Scheduler.getInstance().addAction(thread.doDeleteAction);
        }
    }

    private void triggerThreadEvent(SceKernelThreadInfo thread, SceKernelThreadInfo contextThread, int event) {
        int handlerUid;
        SceKernelThreadEventHandlerInfo handler;
        if (this.threadEventMap.containsKey(thread.uid) && (handler = this.threadEventHandlerMap.get(handlerUid = this.threadEventMap.get(thread.uid).intValue())).hasEventMask(event)) {
            handler.triggerThreadEventHandler(contextThread, event);
        }
    }

    public void hleKernelChangeThreadPriority(SceKernelThreadInfo thread, int newPriority) {
        if (thread == null) {
            return;
        }
        thread.currentPriority = newPriority;
        if (thread.isRunning()) {
            this.hleChangeThreadState(thread, 2);
        }
        if (thread.isReady()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"hleKernelChangeThreadPriority rescheduling ready thread");
            }
            this.removeFromReadyThreads(thread);
            this.addToReadyThreads(thread, false);
            this.needThreadReschedule = true;
            this.hleRescheduleCurrentThread();
        }
    }

    public void hleChangeThreadState(SceKernelThreadInfo thread, int newStatus) {
        if (thread == null) {
            return;
        }
        if (thread.status == newStatus) {
            return;
        }
        if (!this.dispatchThreadEnabled && thread == this.currentThread && newStatus != 1) {
            log.info((Object)("DispatchThread disabled, not changing thread state of " + thread + " to " + newStatus));
            return;
        }
        boolean addReadyThreadsFirst = false;
        if (thread.status == 4 && newStatus != 12) {
            if (thread.wait.waitTimeoutAction != null) {
                Scheduler.getInstance().removeAction(thread.wait.microTimeTimeout, thread.wait.waitTimeoutAction);
                thread.wait.waitTimeoutAction = null;
            }
            if (thread.waitType == 258 && thread.wait.onUnblockAction != null) {
                thread.wait.onUnblockAction.execute();
                thread.wait.onUnblockAction = null;
            }
            thread.doCallbacks = false;
        } else if (thread.isStopped()) {
            if (thread.doDeleteAction != null) {
                Scheduler.getInstance().removeAction(0L, thread.doDeleteAction);
                thread.doDeleteAction = null;
            }
        } else if (thread.isReady()) {
            this.removeFromReadyThreads(thread);
        } else if (thread.isSuspended()) {
            thread.doCallbacks = false;
        } else if (thread.isRunning()) {
            this.needThreadReschedule = true;
            addReadyThreadsFirst = true;
        }
        thread.status = newStatus;
        if (thread.status == 4) {
            if (thread.wait.waitTimeoutAction != null) {
                Scheduler.getInstance().addAction(thread.wait.microTimeTimeout, thread.wait.waitTimeoutAction);
            }
            if (thread.waitType == 0) {
                log.warn((Object)("changeThreadState thread '" + thread.name + "' => PSP_THREAD_WAITING. waitType should NOT be PSP_WAIT_NONE. caller:" + this.getCallingFunction()));
            }
        } else if (thread.isStopped()) {
            if (thread.name.equals("root") || thread.name.equals("SceModmgrStart") || thread.name.equals("SceModmgrStop")) {
                thread.doDelete = true;
            }
            if (thread.doDelete && thread.doDeleteAction == null) {
                thread.doDeleteAction = new DeleteThreadAction(thread);
                Scheduler.getInstance().addAction(0L, thread.doDeleteAction);
            }
            this.onThreadStopped(thread);
        } else if (thread.isReady()) {
            this.addToReadyThreads(thread, addReadyThreadsFirst);
            thread.waitType = 0;
            thread.wait.waitTimeoutAction = null;
            thread.wait.waitStateChecker = null;
            thread.doCallbacks = false;
        } else if (thread.isRunning() && thread.waitType != 0 && !this.isIdleThread(thread)) {
            log.error((Object)("changeThreadState thread '" + thread.name + "' => PSP_THREAD_RUNNING. waitType should be PSP_WAIT_NONE. caller:" + this.getCallingFunction()));
        }
    }

    private void cancelThreadWait(SceKernelThreadInfo thread) {
        thread.wait.onUnblockAction = null;
        thread.wait.waitStateChecker = null;
        thread.waitType = 0;
        if (thread.wait.waitTimeoutAction != null) {
            Scheduler.getInstance().removeAction(thread.wait.microTimeTimeout, thread.wait.waitTimeoutAction);
            thread.wait.waitTimeoutAction = null;
        }
    }

    private void terminateThread(SceKernelThreadInfo thread) {
        this.hleChangeThreadState(thread, 16);
        this.cancelThreadWait(thread);
        RuntimeContext.onThreadExit(thread);
        if (thread == this.currentThread) {
            this.hleRescheduleCurrentThread();
        }
    }

    private void onThreadStopped(SceKernelThreadInfo stoppedThread) {
        for (SceKernelThreadInfo thread : this.threadMap.values()) {
            if (!thread.isWaitingForType(9) || thread.wait.ThreadEnd_id != stoppedThread.uid) continue;
            this.hleThreadWaitRelease(thread);
            if (!thread.wait.ThreadEnd_returnExitStatus) continue;
            thread.cpuContext._v0 = stoppedThread.exitStatus;
        }
    }

    @HLEFunction(nid=-1, version=150)
    public void hleKernelExitCallback(Processor processor) {
        CpuState cpu = processor.cpu;
        int callbackId = cpu.getRegister(16);
        Callback callback = this.callbackManager.remove(callbackId);
        if (callback != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("End of callback " + callback));
            }
            cpu.setRegister(16, callback.getSavedIdRegister());
            cpu._ra = callback.getSavedRa();
            cpu.pc = callback.getSavedPc();
            IAction afterAction = callback.getAfterAction();
            if (afterAction != null) {
                afterAction.execute();
            }
            if (callback.isReturnVoid()) {
                cpu._v0 = callback.getSavedV0();
                cpu._v1 = callback.getSavedV1();
            }
        }
    }

    public void callAddress(int address, IAction afterAction, boolean returnVoid) {
        this.callAddress(null, address, afterAction, returnVoid, null);
    }

    private void callAddress(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid, int[] parameters) {
        if (thread != null) {
            int status = thread.status;
            int waitType = thread.waitType;
            int waitId = thread.waitId;
            ThreadWaitInfo threadWaitInfo = new ThreadWaitInfo();
            threadWaitInfo.copy(thread.wait);
            boolean doCallbacks = thread.doCallbacks;
            thread.waitType = 0;
            afterAction = new AfterCallAction(thread, status, waitType, waitId, threadWaitInfo, doCallbacks, afterAction);
            this.hleChangeThreadState(thread, 2);
        }
        int callbackId = this.callbackManager.getNewCallbackId();
        Callback callback = new Callback(callbackId, address, parameters, afterAction, returnVoid);
        this.callbackManager.addCallback(callback);
        boolean callbackCalled = false;
        if ((thread == null || thread == this.currentThread) && RuntimeContext.canExecuteCallback(thread)) {
            thread = this.currentThread;
            this.hleChangeThreadState(thread, 1);
            callback.execute(thread);
            callbackCalled = true;
        }
        if (!callbackCalled) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Pushing pending callback '%s' for thread '%s'", callback, thread));
            }
            thread.pendingCallbacks.add(callback);
        }
    }

    public void executeCallback(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Execute callback 0x%08X, afterAction=%s, returnVoid=%b", address, afterAction, returnVoid));
        }
        this.callAddress(thread, address, afterAction, returnVoid, null);
    }

    public void executeCallback(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid, int registerA0) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Execute callback 0x%08X($a0=0x%08X), afterAction=%s, returnVoid=%b", address, registerA0, afterAction, returnVoid));
        }
        this.callAddress(thread, address, afterAction, returnVoid, new int[]{registerA0});
    }

    public void executeCallback(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid, int registerA0, int registerA1) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Execute callback 0x%08X($a0=0x%08X, $a1=0x%08X), afterAction=%s, returnVoid=%b", address, registerA0, registerA1, afterAction, returnVoid));
        }
        this.callAddress(thread, address, afterAction, returnVoid, new int[]{registerA0, registerA1});
    }

    public void executeCallback(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid, int registerA0, int registerA1, int registerA2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Execute callback 0x%08X($a0=0x%08X, $a1=0x%08X, $a2=0x%08X), afterAction=%s, returnVoid=%b", address, registerA0, registerA1, registerA2, afterAction, returnVoid));
        }
        this.callAddress(thread, address, afterAction, returnVoid, new int[]{registerA0, registerA1, registerA2});
    }

    public void executeCallback(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid, int registerA0, int registerA1, int registerA2, int registerA3) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Execute callback 0x%08X($a0=0x%08X, $a1=0x%08X, $a2=0x%08X, $a3=0x%08X), afterAction=%s, returnVoid=%b", address, registerA0, registerA1, registerA2, registerA3, afterAction, returnVoid));
        }
        this.callAddress(thread, address, afterAction, returnVoid, new int[]{registerA0, registerA1, registerA2, registerA3});
    }

    public void executeCallback(SceKernelThreadInfo thread, int address, IAction afterAction, boolean returnVoid, int registerA0, int registerA1, int registerA2, int registerA3, int registerT0) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Execute callback 0x%08X($a0=0x%08X, $a1=0x%08X, $a2=0x%08X, $a3=0x%08X, $t0=0x%08X), afterAction=%s, returnVoid=%b", address, registerA0, registerA1, registerA2, registerA3, registerT0, afterAction, returnVoid));
        }
        this.callAddress(thread, address, afterAction, returnVoid, new int[]{registerA0, registerA1, registerA2, registerA3, registerT0});
    }

    @HLEFunction(nid=-1, version=150)
    public void hleKernelExitThread(int exitStatus) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Thread exit detected SceUID=%x name='%s' return:0x%08X", this.currentThread.uid, this.currentThread.name, exitStatus));
        }
        this.sceKernelExitThread(exitStatus);
    }

    public int hleKernelExitDeleteThread() {
        int exitStatus = Emulator.getProcessor().cpu._v0;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelExitDeleteThread SceUID=%x name='%s' return:0x%08X", this.currentThread.uid, this.currentThread.name, exitStatus));
        }
        return this.sceKernelExitDeleteThread(exitStatus);
    }

    public int checkThreadID(int uid) {
        if (uid == 0) {
            log.warn((Object)"checkThreadID illegal thread uid=0");
            throw new SceKernelErrorException(-2147352169);
        }
        return this.checkThreadIDAllow0(uid);
    }

    public int checkThreadIDAllow0(int uid) {
        if (uid == 0) {
            uid = this.currentThread.uid;
        }
        if (!this.threadMap.containsKey(uid)) {
            log.warn((Object)String.format("checkThreadID not found thread 0x%08X", uid));
            throw new SceKernelErrorException(-2147352168);
        }
        if (!SceUidManager.checkUidPurpose(uid, "ThreadMan-thread", true)) {
            throw new SceKernelErrorException(-2147352168);
        }
        return uid;
    }

    public int checkVTimerID(int uid) {
        if (!this.vtimers.containsKey(uid)) {
            throw new SceKernelErrorException(-2147352130);
        }
        return uid;
    }

    public SceKernelThreadInfo hleKernelCreateThread(String name, int entry_addr, int initPriority, int stackSize, int attr, int option_addr) {
        if (option_addr != 0) {
            Modules.log.warn((Object)("hleKernelCreateThread unhandled SceKernelThreadOptParam: option_addr=0x" + Integer.toHexString(option_addr)));
        }
        SceKernelThreadInfo thread = new SceKernelThreadInfo(name, entry_addr, initPriority, stackSize, attr);
        this.threadMap.put(thread.uid, thread);
        if (this.currentThread != null) {
            thread.moduleid = this.currentThread.moduleid;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelCreateThread SceUID=0x%X, name='%s', PC=0x%08X, attr=0x%X, priority=0x%X, stackSize=0x%X", thread.uid, thread.name, thread.cpuContext.pc, attr, initPriority, stackSize));
        }
        return thread;
    }

    private void setThreadBanningEnabled(boolean enabled) {
        this.USE_THREAD_BANLIST = enabled;
        log.info((Object)("Audio threads disabled: " + this.USE_THREAD_BANLIST));
    }

    private boolean isBannedThread(SceKernelThreadInfo thread) {
        if (this.USE_THREAD_BANLIST) {
            String name = thread.name.toLowerCase();
            if (name.contains("snd") || name.contains("sound") || name.contains("at3") || name.contains("atrac") || name.contains("sas") || name.contains("wave") || name.contains("audio") || name.contains("mpeg") || name.contains("fmod") || name.contains("mp3")) {
                return true;
            }
            for (String threadName : this.threadNameBanList) {
                if (!name.equals(threadName)) continue;
                return true;
            }
        }
        return false;
    }

    public void hleKernelStartThread(SceKernelThreadInfo thread, int userDataLength, int userDataAddr, int gp) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelStartThread SceUID=0x%X, name='%s', dataLen=0x%X, data=0x%08X, gp=0x%08X", thread.uid, thread.name, userDataLength, userDataAddr, gp));
        }
        thread.reset();
        this.hleKernelSetThreadArguments(thread, userDataAddr, userDataLength);
        thread.cpuContext._gp = gp;
        this.hleChangeThreadState(thread, 2);
        if (thread.currentPriority < this.currentThread.currentPriority) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"hleKernelStartThread switching in thread immediately");
            }
            this.hleRescheduleCurrentThread();
        }
    }

    public int hleKernelSleepThread(boolean doCallbacks) {
        if (this.currentThread.wakeupCount > 0) {
            --this.currentThread.wakeupCount;
        } else {
            this.hleKernelThreadEnterWaitState(1, 0, this.sleepThreadWaitStateChecker, doCallbacks);
        }
        return 0;
    }

    public void hleKernelWakeupThread(SceKernelThreadInfo thread) {
        if (!thread.isWaiting() || thread.waitType != 1) {
            ++thread.wakeupCount;
            if (log.isDebugEnabled()) {
                log.debug((Object)("sceKernelWakeupThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' not sleeping/waiting (status=0x" + Integer.toHexString(thread.status) + "), incrementing wakeupCount to " + thread.wakeupCount));
            }
        } else if (this.isBannedThread(thread)) {
            log.warn((Object)("sceKernelWakeupThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' banned, not waking up"));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("sceKernelWakeupThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "'"));
            }
            this.hleThreadWaitRelease(thread);
            this.hleRescheduleCurrentThread();
        }
    }

    public int hleKernelWaitThreadEnd(SceKernelThreadInfo waitingThread, int uid, int timeoutAddr, boolean callbacks, boolean returnExitStatus) {
        SceKernelThreadInfo thread;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelWaitThreadEnd SceUID=0x%X, callbacks=%b", uid, callbacks));
        }
        if ((thread = this.threadMap.get(uid)) == null) {
            log.warn((Object)String.format("hleKernelWaitThreadEnd unknown thread 0x%X", uid));
            return -2147352168;
        }
        if (this.isBannedThread(thread)) {
            log.warn((Object)String.format("hleKernelWaitThreadEnd %s banned, not waiting", thread.toString()));
            this.hleRescheduleCurrentThread();
        } else if (thread.isStopped()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelWaitThreadEnd %s thread already stopped, not waiting", thread.toString()));
            }
            this.hleRescheduleCurrentThread();
        } else {
            waitingThread.wait.ThreadEnd_id = uid;
            waitingThread.wait.ThreadEnd_returnExitStatus = returnExitStatus;
            this.hleKernelThreadEnterWaitState(waitingThread, 9, uid, this.waitThreadEndWaitStateChecker, timeoutAddr, callbacks);
        }
        return 0;
    }

    public void hleKernelThreadWait(SceKernelThreadInfo thread, int micros, boolean forever) {
        thread.wait.forever = forever;
        thread.wait.micros = micros;
        if (forever) {
            thread.wait.microTimeTimeout = 0L;
            thread.wait.waitTimeoutAction = null;
        } else {
            long longMicros = (long)micros & 0xFFFFFFFFL;
            thread.wait.microTimeTimeout = Emulator.getClock().microTime() + longMicros;
            thread.wait.waitTimeoutAction = new TimeoutThreadAction(thread);
            thread.wait.waitStateChecker = this.timeoutThreadWaitStateChecker;
        }
        if (Modules.log.isDebugEnabled() && !this.isIdleThread(thread)) {
            log.debug((Object)("-------------------- hleKernelThreadWait micros=" + micros + " forever:" + forever + " thread:'" + thread.name + "' caller:" + this.getCallingFunction()));
        }
    }

    public void hleKernelDelayThread(int micros, boolean doCallbacks) {
        this.currentThread.waitType = 2;
        if (micros < 200) {
            micros = 200;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("hleKernelDelayThread micros=" + micros + ", callbacks=" + doCallbacks));
        }
        this.hleKernelThreadWait(this.currentThread, micros, false);
        this.hleChangeThreadState(this.currentThread, 4);
        this.hleRescheduleCurrentThread(doCallbacks);
    }

    public SceKernelCallbackInfo hleKernelCreateCallback(String name, int func_addr, int user_arg_addr) {
        SceKernelCallbackInfo callback = new SceKernelCallbackInfo(name, this.currentThread.uid, func_addr, user_arg_addr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelCreateCallback %s", callback));
        }
        this.callbackMap.put(callback.uid, callback);
        return callback;
    }

    public boolean hleKernelDeleteCallback(int uid) {
        boolean removed;
        SceKernelCallbackInfo callback = this.callbackMap.remove(uid);
        boolean bl = removed = callback != null;
        if (removed) {
            SceKernelThreadInfo thread;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelDeleteCallback %s", callback));
            }
            if ((thread = this.getThreadById(callback.threadId)) != null) {
                thread.deleteCallback(callback);
            }
        } else {
            log.warn((Object)String.format("hleKernelDeleteCallback not a callback uid 0x%X", uid));
        }
        return removed;
    }

    protected int getThreadCurrentStackSize(Processor processor) {
        int size = processor.cpu._sp - this.currentThread.getStackAddr();
        if (size < 0) {
            size = 0;
        }
        return size;
    }

    private boolean userCurrentThreadTryingToSwitchToKernelMode(int newAttr) {
        return this.currentThread.isUserMode() && !SceKernelThreadInfo.isUserMode(newAttr);
    }

    private boolean userThreadCalledKernelCurrentThread(SceKernelThreadInfo thread) {
        return !this.isIdleThread(thread) && (!thread.isKernelMode() || this.currentThread.isKernelMode());
    }

    private int getDispatchThreadState() {
        return this.dispatchThreadEnabled ? 1 : 0;
    }

    public boolean hleKernelRegisterCallback(int callbackType, int cbid) {
        SceKernelCallbackInfo callback = this.callbackMap.get(cbid);
        if (callback == null) {
            log.warn((Object)("hleKernelRegisterCallback(type=" + callbackType + ") unknown uid " + Integer.toHexString(cbid)));
            return false;
        }
        SceKernelThreadInfo thread = this.getThreadById(callback.threadId);
        if (thread == null) {
            log.warn((Object)("hleKernelRegisterCallback(type=" + callbackType + ") unknown thread uid " + Integer.toHexString(callback.threadId)));
            return false;
        }
        SceKernelThreadInfo.RegisteredCallbacks registeredCallbacks = thread.getRegisteredCallbacks(callbackType);
        return registeredCallbacks.addCallback(callback);
    }

    public SceKernelCallbackInfo hleKernelUnRegisterCallback(int callbackType, int cbid) {
        SceKernelCallbackInfo callback = null;
        for (SceKernelThreadInfo thread : this.threadMap.values()) {
            SceKernelThreadInfo.RegisteredCallbacks registeredCallbacks = thread.getRegisteredCallbacks(callbackType);
            callback = registeredCallbacks.getCallbackByUid(cbid);
            if (callback == null) continue;
            if (registeredCallbacks.isCallbackReady(callback)) {
                log.warn((Object)("hleKernelUnRegisterCallback(type=" + callbackType + ") removing pending callback"));
            }
            registeredCallbacks.removeCallback(callback);
            break;
        }
        if (callback == null) {
            log.warn((Object)("hleKernelUnRegisterCallback(type=" + callbackType + ") cbid=" + Integer.toHexString(cbid) + " no matching callbacks found"));
        }
        return callback;
    }

    public void hleKernelNotifyCallback(int callbackType, int notifyArg) {
        this.hleKernelNotifyCallback(callbackType, -1, notifyArg);
    }

    private void notifyCallback(SceKernelThreadInfo thread, SceKernelCallbackInfo callback, int callbackType, int notifyArg) {
        if (callback.notifyCount != 0) {
            log.warn((Object)("hleKernelNotifyCallback(type=" + callbackType + ") thread:'" + thread.name + "' overwriting previous notifyArg 0x" + Integer.toHexString(callback.notifyArg) + " -> 0x" + Integer.toHexString(notifyArg) + ", newCount=" + (callback.notifyCount + 1)));
        }
        ++callback.notifyCount;
        callback.notifyArg = notifyArg;
        thread.getRegisteredCallbacks(callbackType).setCallbackReady(callback);
    }

    public void hleKernelNotifyCallback(int callbackType, int cbid, int notifyArg) {
        boolean pushed = false;
        for (SceKernelThreadInfo thread : this.threadMap.values()) {
            SceKernelThreadInfo.RegisteredCallbacks registeredCallbacks = thread.getRegisteredCallbacks(callbackType);
            if (!registeredCallbacks.hasCallbacks()) continue;
            if (cbid != -1) {
                SceKernelCallbackInfo callback = registeredCallbacks.getCallbackByUid(cbid);
                if (callback == null) continue;
                this.notifyCallback(thread, callback, callbackType, notifyArg);
            } else {
                int numberOfCallbacks = registeredCallbacks.getNumberOfCallbacks();
                for (int i = 0; i < numberOfCallbacks; ++i) {
                    SceKernelCallbackInfo callback = registeredCallbacks.getCallbackByIndex(i);
                    this.notifyCallback(thread, callback, callbackType, notifyArg);
                }
            }
            pushed = true;
        }
        if (pushed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("hleKernelNotifyCallback(type=" + callbackType + ") calling checkCallbacks"));
            }
            this.checkCallbacks();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelNotifyCallback(type=%d) no registered callbacks to push", callbackType));
        }
    }

    private boolean checkThreadCallbacks(SceKernelThreadInfo thread) {
        boolean handled = false;
        if (thread == null || !thread.doCallbacks) {
            return handled;
        }
        for (int callbackType = 0; callbackType < 7; ++callbackType) {
            SceKernelThreadInfo.RegisteredCallbacks registeredCallbacks = thread.getRegisteredCallbacks(callbackType);
            SceKernelCallbackInfo callback = registeredCallbacks.getNextReadyCallback();
            if (callback == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Entering callback type %d %s for thread %s (current thread is %s)", callbackType, callback.toString(), thread.toString(), this.currentThread.toString()));
            }
            CheckCallbackReturnValue checkCallbackReturnValue = new CheckCallbackReturnValue(thread, callback.uid);
            callback.startContext(thread, checkCallbackReturnValue);
            handled = true;
            break;
        }
        return handled;
    }

    public void cancelAlarm(SceKernelAlarmInfo sceKernelAlarmInfo) {
        Scheduler.getInstance().removeAction(sceKernelAlarmInfo.schedule, sceKernelAlarmInfo.alarmInterruptAction);
        sceKernelAlarmInfo.schedule = 0L;
    }

    public void rescheduleAlarm(SceKernelAlarmInfo sceKernelAlarmInfo, int delay) {
        if (delay < 0) {
            delay = 100;
        }
        sceKernelAlarmInfo.schedule += (long)delay;
        this.scheduleAlarm(sceKernelAlarmInfo);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("New Schedule for Alarm uid=%x: %d", sceKernelAlarmInfo.uid, sceKernelAlarmInfo.schedule));
        }
    }

    private void scheduleAlarm(SceKernelAlarmInfo sceKernelAlarmInfo) {
        Scheduler.getInstance().addAction(sceKernelAlarmInfo.schedule, sceKernelAlarmInfo.alarmInterruptAction);
    }

    protected int hleKernelSetAlarm(long delayUsec, TPointer handlerAddress, int handlerArgument) {
        long now = Scheduler.getNow();
        long schedule = now + delayUsec;
        SceKernelAlarmInfo sceKernelAlarmInfo = new SceKernelAlarmInfo(schedule, handlerAddress.getAddress(), handlerArgument);
        this.alarms.put(sceKernelAlarmInfo.uid, sceKernelAlarmInfo);
        this.scheduleAlarm(sceKernelAlarmInfo);
        return sceKernelAlarmInfo.uid;
    }

    protected long getSystemTime() {
        return SystemTimeManager.getSystemTime();
    }

    protected long getVTimerRunningTime(SceKernelVTimerInfo sceKernelVTimerInfo) {
        if (sceKernelVTimerInfo.active != 1) {
            return 0L;
        }
        return this.getSystemTime() - sceKernelVTimerInfo.base;
    }

    public long getVTimerTime(SceKernelVTimerInfo sceKernelVTimerInfo) {
        return sceKernelVTimerInfo.current + this.getVTimerRunningTime(sceKernelVTimerInfo);
    }

    protected long getVTimerScheduleForScheduler(SceKernelVTimerInfo sceKernelVTimerInfo) {
        return sceKernelVTimerInfo.base + sceKernelVTimerInfo.schedule;
    }

    protected void setVTimer(SceKernelVTimerInfo sceKernelVTimerInfo, long time) {
        sceKernelVTimerInfo.current = time - this.getVTimerRunningTime(sceKernelVTimerInfo);
    }

    protected void startVTimer(SceKernelVTimerInfo sceKernelVTimerInfo) {
        sceKernelVTimerInfo.active = 1;
        sceKernelVTimerInfo.base = this.getSystemTime();
        if (sceKernelVTimerInfo.schedule != 0L && sceKernelVTimerInfo.handlerAddress != 0) {
            this.scheduleVTimer(sceKernelVTimerInfo, sceKernelVTimerInfo.schedule);
        }
    }

    protected void stopVTimer(SceKernelVTimerInfo sceKernelVTimerInfo) {
        sceKernelVTimerInfo.current += this.getVTimerRunningTime(sceKernelVTimerInfo);
        sceKernelVTimerInfo.active = 0;
    }

    protected void scheduleVTimer(SceKernelVTimerInfo sceKernelVTimerInfo, long schedule) {
        Scheduler.getInstance().removeAction(this.getVTimerScheduleForScheduler(sceKernelVTimerInfo), sceKernelVTimerInfo.vtimerInterruptAction);
        sceKernelVTimerInfo.schedule = schedule;
        if (sceKernelVTimerInfo.active == 1 && sceKernelVTimerInfo.handlerAddress != 0) {
            Scheduler scheduler = Scheduler.getInstance();
            scheduler.addAction(this.getVTimerScheduleForScheduler(sceKernelVTimerInfo), sceKernelVTimerInfo.vtimerInterruptAction);
        }
    }

    public void cancelVTimer(SceKernelVTimerInfo sceKernelVTimerInfo) {
        Scheduler.getInstance().removeAction(this.getVTimerScheduleForScheduler(sceKernelVTimerInfo), sceKernelVTimerInfo.vtimerInterruptAction);
        sceKernelVTimerInfo.schedule = 0L;
        sceKernelVTimerInfo.handlerAddress = 0;
        sceKernelVTimerInfo.handlerArgument = 0;
    }

    public void rescheduleVTimer(SceKernelVTimerInfo sceKernelVTimerInfo, int delay) {
        if (delay < 0) {
            delay = 100;
        }
        sceKernelVTimerInfo.schedule += (long)delay;
        this.scheduleVTimer(sceKernelVTimerInfo, sceKernelVTimerInfo.schedule);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("New Schedule for VTimer uid=%x: %d", sceKernelVTimerInfo.uid, sceKernelVTimerInfo.schedule));
        }
    }

    public void checkCallbacks() {
        boolean handled;
        if (log.isTraceEnabled()) {
            log.trace((Object)("checkCallbacks current thread is '" + this.currentThread.name + "' doCallbacks:" + this.currentThread.doCallbacks + " caller:" + this.getCallingFunction()));
        }
        SceKernelThreadInfo checkCurrentThread = this.currentThread;
        block0: do {
            handled = false;
            for (SceKernelThreadInfo thread : this.threadMap.values()) {
                if (!thread.doCallbacks || !this.checkThreadCallbacks(thread)) continue;
                handled = true;
                continue block0;
            }
        } while (handled && checkCurrentThread == this.currentThread);
    }

    @HLEFunction(nid=1855890256, version=150)
    public int _sceKernelReturnFromCallback() {
        log.warn((Object)"Unimplemented _sceKernelReturnFromCallback");
        return 0;
    }

    @HLEFunction(nid=202403411, version=150, checkInsideInterrupt=true)
    public int sceKernelRegisterThreadEventHandler(@StringInfo(maxLength=32) String name, int thid, int mask, int handler_func, int common_addr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelRegisterThreadEventHandler name=" + name + ", thid=0x" + Integer.toHexString(thid) + ", mask=0x" + Integer.toHexString(mask) + ", handler_func=0x" + Integer.toHexString(handler_func) + ", common_addr=0x" + Integer.toHexString(common_addr)));
        }
        if (this.threadMap.containsKey(thid)) {
            SceKernelThreadEventHandlerInfo handler = new SceKernelThreadEventHandlerInfo(name, thid, mask, handler_func, common_addr);
            this.threadEventHandlerMap.put(handler.uid, handler);
            this.threadEventMap.put(thid, handler.uid);
            return handler.uid;
        }
        SceKernelThreadEventHandlerInfo handler = new SceKernelThreadEventHandlerInfo(name, thid, mask, handler_func, common_addr);
        if (thid == 0) {
            this.threadEventHandlerMap.put(handler.uid, handler);
            this.threadEventMap.put(this.getCurrentThread().uid, handler.uid);
            return handler.uid;
        }
        if (thid == -16) {
            this.threadEventHandlerMap.put(handler.uid, handler);
            for (SceKernelThreadInfo thread : this.threadMap.values()) {
                if (!thread.isUserMode()) continue;
                this.threadEventMap.put(thread.uid, handler.uid);
            }
            return handler.uid;
        }
        if (thid == -8 && this.isKernelMode()) {
            this.threadEventHandlerMap.put(handler.uid, handler);
            for (SceKernelThreadInfo thread : this.threadMap.values()) {
                if (!thread.isKernelMode()) continue;
                this.threadEventMap.put(thread.uid, handler.uid);
            }
            return handler.uid;
        }
        if (thid == -1 && this.isKernelMode()) {
            this.threadEventHandlerMap.put(handler.uid, handler);
            for (SceKernelThreadInfo thread : this.threadMap.values()) {
                this.threadEventMap.put(thread.uid, handler.uid);
            }
            return handler.uid;
        }
        return -2147352168;
    }

    @HLEFunction(nid=1928577349, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelReleaseThreadEventHandler(int uid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelReleaseThreadEventHandler uid=0x" + Integer.toHexString(uid)));
        }
        if (!this.threadEventHandlerMap.containsKey(uid)) {
            return -2147352160;
        }
        SceKernelThreadEventHandlerInfo handler = this.threadEventHandlerMap.remove(uid);
        handler.release();
        return 0;
    }

    @HLEFunction(nid=916384619, version=150)
    public int sceKernelReferThreadEventHandlerStatus(int uid, TPointer statusPointer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelReferThreadEventHandlerStatus uid=0x" + Integer.toHexString(uid) + ", status_addr=0x" + Integer.toHexString(statusPointer.getAddress())));
        }
        if (!this.threadEventHandlerMap.containsKey(uid)) {
            return -2147352160;
        }
        this.threadEventHandlerMap.get(uid).write(statusPointer.getMemory(), statusPointer.getAddress());
        return 0;
    }

    @HLEFunction(nid=-400773233, version=150, checkInsideInterrupt=true)
    public int sceKernelCreateCallback(@StringInfo(maxLength=32) String name, int func_addr, int user_arg_addr) {
        SceKernelCallbackInfo callback = this.hleKernelCreateCallback(name, func_addr, user_arg_addr);
        return callback.uid;
    }

    @HLEFunction(nid=-306554812, version=150, checkInsideInterrupt=true)
    public int sceKernelDeleteCallback(int uid) {
        if (!this.hleKernelDeleteCallback(uid)) {
            return -2147352159;
        }
        return 0;
    }

    @HLEFunction(nid=-1055151932, version=150)
    public int sceKernelNotifyCallback(int uid, int arg) {
        SceKernelCallbackInfo callback;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelNotifyCallback uid=0x" + Integer.toHexString(uid) + ", arg=0x" + Integer.toHexString(arg)));
        }
        if ((callback = this.callbackMap.get(uid)) == null) {
            return -2147352159;
        }
        boolean foundCallback = false;
        for (int i = 0; i < 7; ++i) {
            SceKernelThreadInfo.RegisteredCallbacks registeredCallbacks = this.getCurrentThread().getRegisteredCallbacks(i);
            if (!registeredCallbacks.hasCallback(callback)) continue;
            this.hleKernelNotifyCallback(i, uid, arg);
            foundCallback = true;
            break;
        }
        if (!foundCallback && this.hleKernelRegisterCallback(6, uid)) {
            this.hleKernelNotifyCallback(6, uid, arg);
        }
        return 0;
    }

    @HLEFunction(nid=-1170189866, version=150)
    public int sceKernelCancelCallback(int uid) {
        SceKernelCallbackInfo callback;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCancelCallback uid=0x" + Integer.toHexString(uid)));
        }
        if ((callback = this.callbackMap.get(uid)) == null) {
            return -2147352159;
        }
        callback.notifyArg = 0;
        return 0;
    }

    @HLEFunction(nid=708658431, version=150)
    public int sceKernelGetCallbackCount(int uid) {
        SceKernelCallbackInfo callback;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelGetCallbackCount uid=0x" + Integer.toHexString(uid)));
        }
        if ((callback = this.callbackMap.get(uid)) == null) {
            return -2147352159;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetCallbackCount returning count=%d", callback.notifyCount));
        }
        return callback.notifyCount;
    }

    @HLEFunction(nid=882732396, version=150, checkInsideInterrupt=true)
    public int sceKernelCheckCallback() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelCheckCallback(void)");
        }
        SceKernelThreadInfo thread = this.currentThread;
        boolean doCallbacks = thread.doCallbacks;
        thread.doCallbacks = true;
        int result = this.checkThreadCallbacks(thread) ? 1 : 0;
        thread.doCallbacks = doCallbacks;
        return result;
    }

    @HLEFunction(nid=1930352828, version=150)
    public int sceKernelReferCallbackStatus(int uid, TPointer infoPointer) {
        SceKernelCallbackInfo info;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelReferCallbackStatus SceUID=" + Integer.toHexString(uid) + " info=" + Integer.toHexString(infoPointer.getAddress())));
        }
        if ((info = this.hleKernelReferCallbackStatus(uid)) == null) {
            log.warn((Object)("sceKernelReferCallbackStatus unknown uid 0x" + Integer.toHexString(uid)));
            return -2147352159;
        }
        if (!infoPointer.isAddressGood()) {
            log.warn((Object)("sceKernelReferCallbackStatus bad info address 0x" + Integer.toHexString(infoPointer.getAddress())));
            return -2147352365;
        }
        info.write(infoPointer.getMemory(), infoPointer.getAddress());
        return 0;
    }

    @HLEFunction(nid=-1697770722, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelSleepThread() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelSleepThread SceUID=" + Integer.toHexString(this.currentThread.uid) + " name:'" + this.currentThread.name + "'"));
        }
        return this.hleKernelSleepThread(false);
    }

    @HLEFunction(nid=-2105381008, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelSleepThreadCB() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelSleepThreadCB SceUID=" + Integer.toHexString(this.currentThread.uid) + " name:'" + this.currentThread.name + "'"));
        }
        int result = this.hleKernelSleepThread(true);
        this.checkCallbacks();
        return result;
    }

    @HLEFunction(nid=-711021265, version=150)
    public int sceKernelWakeupThread(@CheckArgument(value="checkThreadID") int uid) {
        SceKernelThreadInfo thread = this.threadMap.get(uid);
        if (thread == null) {
            log.warn((Object)("sceKernelWakeupThread SceUID=" + Integer.toHexString(uid) + " unknown thread"));
            return -2147352168;
        }
        this.hleKernelWakeupThread(thread);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEFunction(nid=-53498586, version=150)
    public int sceKernelCancelWakeupThread(@CheckArgument(value="checkThreadIDAllow0") int uid) {
        SceKernelThreadInfo thread = this.getThread(uid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelCancelWakeupThread SceUID=" + Integer.toHexString(uid) + ") wakeupCount=" + thread.wakeupCount));
        }
        try {
            int n = thread.wakeupCount;
            return n;
        }
        finally {
            thread.wakeupCount = 0;
        }
    }

    @HLEFunction(nid=-1723534561, version=150)
    public int sceKernelSuspendThread(@CheckArgument(value="checkThreadID") int uid) {
        SceKernelThreadInfo thread = this.getThreadCurrentIsInvalid(uid);
        if (thread.isSuspended()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelSuspendThread thread already suspended: thread=%s", thread.toString()));
            }
            return -2147352157;
        }
        if (thread.isStopped()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelSuspendThread thread already stopped: thread=%s", thread.toString()));
            }
            return -2147352158;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelSuspendThread SceUID=" + Integer.toHexString(uid)));
        }
        if (thread.isWaiting()) {
            this.hleChangeThreadState(thread, 12);
        } else {
            this.hleChangeThreadState(thread, 8);
        }
        return 0;
    }

    @HLEFunction(nid=1964338831, version=150)
    public int sceKernelResumeThread(@CheckArgument(value="checkThreadID") int uid) {
        SceKernelThreadInfo thread = this.getThread(uid);
        if (!thread.isSuspended()) {
            log.warn((Object)("sceKernelResumeThread SceUID=" + Integer.toHexString(uid) + " not suspended (status=" + thread.status + ")"));
            return -2147352155;
        }
        if (this.isBannedThread(thread)) {
            log.warn((Object)("sceKernelResumeThread SceUID=" + Integer.toHexString(uid) + " name:'" + thread.name + "' banned, not resuming"));
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelResumeThread SceUID=" + Integer.toHexString(uid) + " name:'" + thread.name + "'"));
        }
        if (thread.isWaiting()) {
            this.hleChangeThreadState(thread, 4);
        } else {
            this.hleChangeThreadState(thread, 2);
        }
        return 0;
    }

    @HLEFunction(nid=663490037, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelWaitThreadEnd(@CheckArgument(value="checkThreadID") int uid, int timeout_addr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelWaitThreadEnd redirecting to hleKernelWaitThreadEnd(callbacks=false)");
        }
        return this.hleKernelWaitThreadEnd(this.currentThread, uid, timeout_addr, false, true);
    }

    @HLEFunction(nid=-2079424205, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelWaitThreadEndCB(@CheckArgument(value="checkThreadID") int uid, int timeout_addr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelWaitThreadEndCB redirecting to hleKernelWaitThreadEnd(callbacks=true)");
        }
        int result = this.hleKernelWaitThreadEnd(this.currentThread, uid, timeout_addr, true, true);
        this.checkCallbacks();
        return result;
    }

    @HLEFunction(nid=-827462841, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelDelayThread(int micros) {
        this.hleKernelDelayThread(micros, false);
    }

    @HLEFunction(nid=1759157814, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelDelayThreadCB(int micros) {
        this.hleKernelDelayThread(micros, true);
    }

    @HLEFunction(nid=-1122878050, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelDelaySysClockThread(TPointer64 sysclocksPointer) {
        if (!sysclocksPointer.isAddressGood()) {
            return -1;
        }
        long sysclocks = sysclocksPointer.getValue();
        int micros = SystemTimeManager.hleSysClock2USec32(sysclocks);
        this.hleKernelDelayThread(micros, false);
        return 0;
    }

    @HLEFunction(nid=293726563, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelDelaySysClockThreadCB(int sysclocks_addr) {
        Memory mem = Memory.getInstance();
        if (!Memory.isAddressGood(sysclocks_addr)) {
            log.warn((Object)("sceKernelDelaySysClockThreadCB invalid sysclocks address 0x" + Integer.toHexString(sysclocks_addr)));
            return -1;
        }
        long sysclocks = mem.read64(sysclocks_addr);
        int micros = SystemTimeManager.hleSysClock2USec32(sysclocks);
        this.hleKernelDelayThread(micros, true);
        return 0;
    }

    @HLEFunction(nid=-690336863, version=150, checkInsideInterrupt=true)
    public int sceKernelCreateSema(int name_addr, int attr, int initVal, int maxVal, int option) {
        return Managers.semas.sceKernelCreateSema(name_addr, attr, initVal, maxVal, option);
    }

    @HLEFunction(nid=683034780, version=150, checkInsideInterrupt=true)
    public int sceKernelDeleteSema(int semaid) {
        return Managers.semas.sceKernelDeleteSema(semaid);
    }

    @HLEFunction(nid=1062463040, version=150)
    public int sceKernelSignalSema(int semaid, int signal) {
        return Managers.semas.sceKernelSignalSema(semaid, signal);
    }

    @HLEFunction(nid=1312428293, version=150, checkInsideInterrupt=true)
    public int sceKernelWaitSema(int semaid, int signal, int timeout_addr) {
        return Managers.semas.sceKernelWaitSema(semaid, signal, timeout_addr);
    }

    @HLEFunction(nid=1830890412, version=150, checkInsideInterrupt=true)
    public int sceKernelWaitSemaCB(int semaid, int signal, int timeout_addr) {
        return Managers.semas.sceKernelWaitSemaCB(semaid, signal, timeout_addr);
    }

    @HLEFunction(nid=1488058679, version=150)
    public int sceKernelPollSema(int semaid, int signal) {
        return Managers.semas.sceKernelPollSema(semaid, signal);
    }

    @HLEFunction(nid=-1879180894, version=150)
    public int sceKernelCancelSema(int semaid, int newcount, int numWaitThreadAddr) {
        return Managers.semas.sceKernelCancelSema(semaid, newcount, numWaitThreadAddr);
    }

    @HLEFunction(nid=-1133515835, version=150)
    public int sceKernelReferSemaStatus(int semaid, int addr) {
        return Managers.semas.sceKernelReferSemaStatus(semaid, addr);
    }

    @HLEFunction(nid=1438779904, version=150, checkInsideInterrupt=true)
    public int sceKernelCreateEventFlag(int name_addr, int attr, int initPattern, int option) {
        return Managers.eventFlags.sceKernelCreateEventFlag(name_addr, attr, initPattern, option);
    }

    @HLEFunction(nid=-274838416, version=150, checkInsideInterrupt=true)
    public int sceKernelDeleteEventFlag(int uid) {
        return Managers.eventFlags.sceKernelDeleteEventFlag(uid);
    }

    @HLEFunction(nid=531716658, version=150)
    public int sceKernelSetEventFlag(int uid, int bitsToSet) {
        return Managers.eventFlags.sceKernelSetEventFlag(uid, bitsToSet);
    }

    @HLEFunction(nid=-2128394524, version=150)
    public int sceKernelClearEventFlag(int uid, int bitsToKeep) {
        return Managers.eventFlags.sceKernelClearEventFlag(uid, bitsToKeep);
    }

    @HLEFunction(nid=1076875042, version=150, checkInsideInterrupt=true)
    public int sceKernelWaitEventFlag(int uid, int bits, int wait, int outBits_addr, int timeout_addr) {
        return Managers.eventFlags.sceKernelWaitEventFlag(uid, bits, wait, outBits_addr, timeout_addr);
    }

    @HLEFunction(nid=848057450, version=150, checkInsideInterrupt=true)
    public int sceKernelWaitEventFlagCB(int uid, int bits, int wait, int outBits_addr, int timeout_addr) {
        return Managers.eventFlags.sceKernelWaitEventFlagCB(uid, bits, wait, outBits_addr, timeout_addr);
    }

    @HLEFunction(nid=821905648, version=150)
    public int sceKernelPollEventFlag(int uid, int bits, int wait, int outBits_addr) {
        return Managers.eventFlags.sceKernelPollEventFlag(uid, bits, wait, outBits_addr);
    }

    @HLEFunction(nid=-853527918, version=150)
    public int sceKernelCancelEventFlag(int uid, int newPattern, int numWaitThreadAddr) {
        return Managers.eventFlags.sceKernelCancelEventFlag(uid, newPattern, numWaitThreadAddr);
    }

    @HLEFunction(nid=-1502936800, version=150)
    public int sceKernelReferEventFlagStatus(int uid, int addr) {
        return Managers.eventFlags.sceKernelReferEventFlagStatus(uid, addr);
    }

    @HLEFunction(nid=-2128272867, version=150, checkInsideInterrupt=true)
    public void sceKernelCreateMbx(int name_addr, int attr, int opt_addr) {
        Managers.mbx.sceKernelCreateMbx(name_addr, attr, opt_addr);
    }

    @HLEFunction(nid=-2044372262, version=150, checkInsideInterrupt=true)
    public void sceKernelDeleteMbx(int uid) {
        Managers.mbx.sceKernelDeleteMbx(uid);
    }

    @HLEFunction(nid=-374143458, version=150)
    public void sceKernelSendMbx(int uid, int msg_addr) {
        Managers.mbx.sceKernelSendMbx(uid, msg_addr);
    }

    @HLEFunction(nid=405144948, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelReceiveMbx(int uid, int addr_msg_addr, int timeout_addr) {
        Managers.mbx.sceKernelReceiveMbx(uid, addr_msg_addr, timeout_addr);
    }

    @HLEFunction(nid=-208116862, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public void sceKernelReceiveMbxCB(int uid, int addr_msg_addr, int timeout_addr) {
        Managers.mbx.sceKernelReceiveMbxCB(uid, addr_msg_addr, timeout_addr);
    }

    @HLEFunction(nid=226586986, version=150)
    public void sceKernelPollMbx(int uid, int addr_msg_addr) {
        Managers.mbx.sceKernelPollMbx(uid, addr_msg_addr);
    }

    @HLEFunction(nid=-2016092874, version=150)
    public void sceKernelCancelReceiveMbx(int uid, int pnum_addr) {
        Managers.mbx.sceKernelCancelReceiveMbx(uid, pnum_addr);
    }

    @HLEFunction(nid=-1461139386, version=150)
    public void sceKernelReferMbxStatus(int uid, int info_addr) {
        Managers.mbx.sceKernelReferMbxStatus(uid, info_addr);
    }

    @HLEFunction(nid=2081276576, version=150, checkInsideInterrupt=true)
    public int sceKernelCreateMsgPipe(int name_addr, int partitionid, int attr, int size, int opt_addr) {
        return Managers.msgPipes.sceKernelCreateMsgPipe(name_addr, partitionid, attr, size, opt_addr);
    }

    @HLEFunction(nid=-256386532, version=150, checkInsideInterrupt=true)
    public int sceKernelDeleteMsgPipe(int uid) {
        return Managers.msgPipes.sceKernelDeleteMsgPipe(uid);
    }

    @HLEFunction(nid=-2022850643, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelSendMsgPipe(int uid, int msg_addr, int size, int waitMode, int resultSize_addr, int timeout_addr) {
        return Managers.msgPipes.sceKernelSendMsgPipe(uid, msg_addr, size, waitMode, resultSize_addr, timeout_addr);
    }

    @HLEFunction(nid=2084696770, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelSendMsgPipeCB(int uid, int msg_addr, int size, int waitMode, int resultSize_addr, int timeout_addr) {
        return Managers.msgPipes.sceKernelSendMsgPipeCB(uid, msg_addr, size, waitMode, resultSize_addr, timeout_addr);
    }

    @HLEFunction(nid=-2008244336, version=150)
    public int sceKernelTrySendMsgPipe(int uid, int msg_addr, int size, int waitMode, int resultSize_addr) {
        return Managers.msgPipes.sceKernelTrySendMsgPipe(uid, msg_addr, size, waitMode, resultSize_addr);
    }

    @HLEFunction(nid=1954716534, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelReceiveMsgPipe(int uid, int msg_addr, int size, int waitMode, int resultSize_addr, int timeout_addr) {
        return Managers.msgPipes.sceKernelReceiveMsgPipe(uid, msg_addr, size, waitMode, resultSize_addr, timeout_addr);
    }

    @HLEFunction(nid=-67475075, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelReceiveMsgPipeCB(int uid, int msg_addr, int size, int waitMode, int resultSize_addr, int timeout_addr) {
        return Managers.msgPipes.sceKernelReceiveMsgPipeCB(uid, msg_addr, size, waitMode, resultSize_addr, timeout_addr);
    }

    @HLEFunction(nid=-548271729, version=150)
    public int sceKernelTryReceiveMsgPipe(int uid, int msg_addr, int size, int waitMode, int resultSize_addr) {
        return Managers.msgPipes.sceKernelTryReceiveMsgPipe(uid, msg_addr, size, waitMode, resultSize_addr);
    }

    @HLEFunction(nid=882607693, version=150)
    public int sceKernelCancelMsgPipe(int uid, int send_addr, int recv_addr) {
        return Managers.msgPipes.sceKernelCancelMsgPipe(uid, send_addr, recv_addr);
    }

    @HLEFunction(nid=868106276, version=150)
    public int sceKernelReferMsgPipeStatus(int uid, int info_addr) {
        return Managers.msgPipes.sceKernelReferMsgPipeStatus(uid, info_addr);
    }

    @HLEFunction(nid=1455438261, version=150, checkInsideInterrupt=true)
    public int sceKernelCreateVpl(int name_addr, int partitionid, int attr, int size, int opt_addr) {
        return Managers.vpl.sceKernelCreateVpl(name_addr, partitionid, attr, size, opt_addr);
    }

    @HLEFunction(nid=-1984703348, version=150, checkInsideInterrupt=true)
    public int sceKernelDeleteVpl(int uid) {
        return Managers.vpl.sceKernelDeleteVpl(uid);
    }

    @HLEFunction(nid=-1093503947, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelAllocateVpl(int uid, int size, int data_addr, int timeout_addr) {
        return Managers.vpl.sceKernelAllocateVpl(uid, size, data_addr, timeout_addr);
    }

    @HLEFunction(nid=-334862017, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelAllocateVplCB(int uid, int size, int data_addr, int timeout_addr) {
        return Managers.vpl.sceKernelAllocateVplCB(uid, size, data_addr, timeout_addr);
    }

    @HLEFunction(nid=-1355360504, version=150)
    public int sceKernelTryAllocateVpl(int uid, int size, int data_addr) {
        return Managers.vpl.sceKernelTryAllocateVpl(uid, size, data_addr);
    }

    @HLEFunction(nid=-1221137921, version=150, checkInsideInterrupt=true)
    public int sceKernelFreeVpl(int uid, int data_addr) {
        return Managers.vpl.sceKernelFreeVpl(uid, data_addr);
    }

    @HLEFunction(nid=490150794, version=150)
    public int sceKernelCancelVpl(int uid, int numWaitThreadAddr) {
        return Managers.vpl.sceKernelCancelVpl(uid, numWaitThreadAddr);
    }

    @HLEFunction(nid=964756069, version=150)
    public int sceKernelReferVplStatus(int uid, int info_addr) {
        return Managers.vpl.sceKernelReferVplStatus(uid, info_addr);
    }

    @HLEFunction(nid=-1065634704, version=150, checkInsideInterrupt=true)
    public int sceKernelCreateFpl(int name_addr, int partitionid, int attr, int blocksize, int blocks, int opt_addr) {
        return Managers.fpl.sceKernelCreateFpl(name_addr, partitionid, attr, blocksize, blocks, opt_addr);
    }

    @HLEFunction(nid=-317452064, version=150, checkInsideInterrupt=true)
    public int sceKernelDeleteFpl(int uid) {
        return Managers.fpl.sceKernelDeleteFpl(uid);
    }

    @HLEFunction(nid=-646321729, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelAllocateFpl(int uid, int data_addr, int timeout_addr) {
        return Managers.fpl.sceKernelAllocateFpl(uid, data_addr, timeout_addr);
    }

    @HLEFunction(nid=-416797514, version=150, checkInsideInterrupt=true, checkDispatchThreadEnabled=true)
    public int sceKernelAllocateFplCB(int uid, int data_addr, int timeout_addr) {
        return Managers.fpl.sceKernelAllocateFplCB(uid, data_addr, timeout_addr);
    }

    @HLEFunction(nid=1648027237, version=150)
    public int sceKernelTryAllocateFpl(int uid, int data_addr) {
        return Managers.fpl.sceKernelTryAllocateFpl(uid, data_addr);
    }

    @HLEFunction(nid=-163493263, version=150, checkInsideInterrupt=true)
    public int sceKernelFreeFpl(int uid, int data_addr) {
        return Managers.fpl.sceKernelFreeFpl(uid, data_addr);
    }

    @HLEFunction(nid=-1465231073, version=150)
    public int sceKernelCancelFpl(int uid, int numWaitThreadAddr) {
        return Managers.fpl.sceKernelCancelFpl(uid, numWaitThreadAddr);
    }

    @HLEFunction(nid=-669409716, version=150)
    public int sceKernelReferFplStatus(int uid, int info_addr) {
        return Managers.fpl.sceKernelReferFplStatus(uid, info_addr);
    }

    @HLEFunction(nid=244480749, version=150)
    public int _sceKernelReturnFromTimerHandler() {
        log.warn((Object)"Unimplemented _sceKernelReturnFromTimerHandler");
        return 0;
    }

    @HLEFunction(nid=286125210, version=150)
    public int sceKernelUSec2SysClock(int usec, TPointer64 sysClockAddr) {
        return Managers.systime.sceKernelUSec2SysClock(usec, sysClockAddr);
    }

    @HLEFunction(nid=-926083700, version=150)
    public long sceKernelUSec2SysClockWide(int usec) {
        return Managers.systime.sceKernelUSec2SysClockWide(usec);
    }

    @HLEFunction(nid=-1167355166, version=150)
    public int sceKernelSysClock2USec(TPointer64 sysClockAddr, @CanBeNull TPointer32 secAddr, @CanBeNull TPointer32 microSecAddr) {
        return Managers.systime.sceKernelSysClock2USec(sysClockAddr, secAddr, microSecAddr);
    }

    @HLEFunction(nid=-513696388, version=150)
    public int sceKernelSysClock2USecWide(long sysClock, @CanBeNull TPointer32 secAddr, @CanBeNull TPointer32 microSecAddr) {
        return Managers.systime.sceKernelSysClock2USecWide(sysClock, secAddr, microSecAddr);
    }

    @HLEFunction(nid=-613183691, version=150)
    public int sceKernelGetSystemTime(TPointer64 time_addr) {
        return Managers.systime.sceKernelGetSystemTime(time_addr);
    }

    @HLEFunction(nid=-2101586057, version=150)
    public long sceKernelGetSystemTimeWide() {
        return Managers.systime.sceKernelGetSystemTimeWide();
    }

    @HLEFunction(nid=916379037, version=150)
    public int sceKernelGetSystemTimeLow() {
        return Managers.systime.sceKernelGetSystemTimeLow();
    }

    @HLEFunction(nid=1716697290, version=150)
    public int sceKernelSetAlarm(int delayUsec, TPointer handlerAddress, int handlerArgument) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelSetAlarm delayUsec=%d, handlerAddress=%s, handlerArgument=0x%08X)", delayUsec, handlerAddress, handlerArgument));
        }
        return this.hleKernelSetAlarm(delayUsec, handlerAddress, handlerArgument);
    }

    @HLEFunction(nid=-1295888046, version=150)
    public int sceKernelSetSysClockAlarm(TPointer64 delaySysclockAddr, TPointer handlerAddress, int handlerArgument) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelSetSysClockAlarm delaySysclockAddr=%s, handlerAddress=%s, handlerArgument=0x%08X)", delaySysclockAddr, handlerAddress, handlerArgument));
        }
        long delaySysclock = delaySysclockAddr.getValue();
        long delayUsec = SystemTimeManager.hleSysClock2USec(delaySysclock);
        return this.hleKernelSetAlarm(delayUsec, handlerAddress, handlerArgument);
    }

    @HLEFunction(nid=2120595865, version=150)
    public int sceKernelCancelAlarm(int alarmUid) {
        SceKernelAlarmInfo sceKernelAlarmInfo;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelCancelAlarm uid=0x%X", alarmUid));
        }
        if ((sceKernelAlarmInfo = this.alarms.get(alarmUid)) == null) {
            log.warn((Object)String.format("sceKernelCancelAlarm unknown uid=0x%x", alarmUid));
            return -2147352161;
        }
        this.cancelAlarm(sceKernelAlarmInfo);
        return 0;
    }

    @HLEFunction(nid=-626789020, version=150)
    public int sceKernelReferAlarmStatus(int alarmUid, TPointer infoAddr) {
        SceKernelAlarmInfo sceKernelAlarmInfo;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelReferAlarmStatus uid=0x%X, infoAddr=%s", alarmUid, infoAddr));
        }
        if ((sceKernelAlarmInfo = this.alarms.get(alarmUid)) == null) {
            log.warn((Object)String.format("sceKernelReferAlarmStatus unknown uid=0x%x", alarmUid));
            return -2147352161;
        }
        sceKernelAlarmInfo.write(Memory.getInstance(), infoAddr.getAddress());
        return 0;
    }

    @HLEFunction(nid=553645408, version=150, checkInsideInterrupt=true)
    public int sceKernelCreateVTimer(PspString name, @CanBeNull TPointer optAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelCreateVTimer name=%s, optAddr=%s", name, optAddr));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = new SceKernelVTimerInfo(name.getString());
        this.vtimers.put(sceKernelVTimerInfo.uid, sceKernelVTimerInfo);
        return sceKernelVTimerInfo.uid;
    }

    @HLEFunction(nid=848272978, version=150, checkInsideInterrupt=true)
    public int sceKernelDeleteVTimer(@CheckArgument(value="checkVTimerID") int vtimerUid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelDeleteVTimer uid=0x%X", vtimerUid));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = this.vtimers.remove(vtimerUid);
        sceKernelVTimerInfo.delete();
        return 0;
    }

    @HLEFunction(nid=-1280992912, version=150)
    public int sceKernelGetVTimerBase(@CheckArgument(value="checkVTimerID") int vtimerUid, TPointer64 baseAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetVTimerBase uid=0x%X, baseAddr=%s", vtimerUid, baseAddr));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = this.vtimers.get(vtimerUid);
        baseAddr.setValue(sceKernelVTimerInfo.base);
        return 0;
    }

    @HLEFunction(nid=-1212052617, version=150)
    public long sceKernelGetVTimerBaseWide(@CheckArgument(value="checkVTimerID") int vtimerUid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetVTimerBaseWide uid=0x%X", vtimerUid));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = this.vtimers.get(vtimerUid);
        return sceKernelVTimerInfo.base;
    }

    @HLEFunction(nid=55218719, version=150)
    public int sceKernelGetVTimerTime(@CheckArgument(value="checkVTimerID") int vtimerUid, TPointer64 timeAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetVTimerTime uid=0x%X, timeAddr=%s", vtimerUid, timeAddr));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = this.vtimers.get(vtimerUid);
        long time = this.getVTimerTime(sceKernelVTimerInfo);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetVTimerTime returning %d", time));
        }
        timeAddr.setValue(time);
        return 0;
    }

    @HLEFunction(nid=-1061945390, version=150)
    public long sceKernelGetVTimerTimeWide(@CheckArgument(value="checkVTimerID") int vtimerUid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetVTimerTimeWide uid=0x%X", vtimerUid));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = this.vtimers.get(vtimerUid);
        long time = this.getVTimerTime(sceKernelVTimerInfo);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetVTimerTimeWide returning %d", time));
        }
        return time;
    }

    @HLEFunction(nid=1412093488, version=150, checkInsideInterrupt=true)
    public int sceKernelSetVTimerTime(@CheckArgument(value="checkVTimerID") int vtimerUid, TPointer64 timeAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelSetVTimerTime uid=0x%X, timeAddr=%s", vtimerUid, timeAddr));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = this.vtimers.get(vtimerUid);
        long time = timeAddr.getValue();
        this.setVTimer(sceKernelVTimerInfo, time);
        return 0;
    }

    @HLEFunction(nid=-77322813, version=150, checkInsideInterrupt=true)
    public int sceKernelSetVTimerTimeWide(@CheckArgument(value="checkVTimerID") int vtimerUid, long time) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelSetVTimerTime uid=0x%X, time=%d", vtimerUid, time));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = this.vtimers.get(vtimerUid);
        this.setVTimer(sceKernelVTimerInfo, time);
        return 0;
    }

    @HLEFunction(nid=-963800009, version=150)
    public int sceKernelStartVTimer(@CheckArgument(value="checkVTimerID") int vtimerUid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelStartVTimer uid=0x%X", vtimerUid));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = this.vtimers.get(vtimerUid);
        if (sceKernelVTimerInfo.active == 1) {
            return 1;
        }
        this.startVTimer(sceKernelVTimerInfo);
        return 0;
    }

    @HLEFunction(nid=-793842041, version=150)
    public int sceKernelStopVTimer(@CheckArgument(value="checkVTimerID") int vtimerUid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelStopVTimer uid=0x%X", vtimerUid));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = this.vtimers.get(vtimerUid);
        if (sceKernelVTimerInfo.active == 0) {
            return 0;
        }
        this.stopVTimer(sceKernelVTimerInfo);
        return 1;
    }

    @HLEFunction(nid=-659383890, version=150)
    public int sceKernelSetVTimerHandler(@CheckArgument(value="checkVTimerID") int vtimerUid, TPointer64 scheduleAddr, @CanBeNull TPointer handlerAddress, int handlerArgument) {
        if (log.isDebugEnabled()) {
            log.warn((Object)String.format("sceKernelSetVTimerHandler uid=0x%X, scheduleAddr=%s, handlerAddress=%s, handlerArgument=0x%08X", vtimerUid, scheduleAddr, handlerAddress, handlerArgument));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = this.vtimers.get(vtimerUid);
        long schedule = scheduleAddr.getValue();
        sceKernelVTimerInfo.handlerAddress = handlerAddress.getAddress();
        sceKernelVTimerInfo.handlerArgument = handlerArgument;
        this.scheduleVTimer(sceKernelVTimerInfo, schedule);
        return 0;
    }

    @HLEFunction(nid=1404047002, version=150)
    public int sceKernelSetVTimerHandlerWide(@CheckArgument(value="checkVTimerID") int vtimerUid, long schedule, TPointer handlerAddress, int handlerArgument) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelSetVTimerHandlerWide uid=0x%X, schedule=%d, handlerAddress=%s, handlerArgument=0x%08X", vtimerUid, schedule, handlerAddress, handlerArgument));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = this.vtimers.get(vtimerUid);
        sceKernelVTimerInfo.handlerAddress = handlerAddress.getAddress();
        sceKernelVTimerInfo.handlerArgument = handlerArgument;
        this.scheduleVTimer(sceKernelVTimerInfo, schedule);
        return 0;
    }

    @HLEFunction(nid=-757721617, version=150)
    public int sceKernelCancelVTimerHandler(@CheckArgument(value="checkVTimerID") int vtimerUid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelCancelVTimerHandler uid=0x%X", vtimerUid));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = this.vtimers.get(vtimerUid);
        this.cancelVTimer(sceKernelVTimerInfo);
        return 0;
    }

    @HLEFunction(nid=1597161130, version=150)
    public int sceKernelReferVTimerStatus(@CheckArgument(value="checkVTimerID") int vtimerUid, TPointer infoAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelReferVTimerStatus uid=0x%X, infoAddr=%s", vtimerUid, infoAddr));
        }
        SceKernelVTimerInfo sceKernelVTimerInfo = this.vtimers.get(vtimerUid);
        sceKernelVTimerInfo.write(Memory.getInstance(), infoAddr.getAddress());
        return 0;
    }

    @HLEFunction(nid=1148030438, version=150)
    public int sceKernelCreateThread(@StringInfo(maxLength=32) String name, int entry_addr, int initPriority, int stackSize, int attr, int option_addr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelCreateThread redirecting to hleKernelCreateThread");
        }
        SceKernelThreadInfo thread = this.hleKernelCreateThread(name, entry_addr, initPriority, stackSize, attr, option_addr);
        if (thread.stackSize > 0 && thread.getStackAddr() == 0) {
            log.warn((Object)"sceKernelCreateThread not enough memory to create the stack");
            this.hleDeleteThread(thread);
            return -2147352176;
        }
        if (this.currentThread.isKernelMode() && !SceKernelThreadInfo.isUserMode(thread.attr)) {
            log.debug((Object)"sceKernelCreateThread inheriting kernel mode");
            thread.attr |= 0x1000;
        }
        if (this.currentThread.isUserMode()) {
            if (!SceKernelThreadInfo.isUserMode(thread.attr)) {
                log.debug((Object)"sceKernelCreateThread inheriting user mode");
            }
            thread.attr |= Integer.MIN_VALUE;
            thread.attr &= 0xFFFFEFFF;
        }
        this.triggerThreadEvent(thread, this.currentThread, 1);
        return thread.uid;
    }

    @HLEFunction(nid=-1616888621, version=150, checkInsideInterrupt=true)
    public int sceKernelDeleteThread(@CheckArgument(value="checkThreadIDAllow0") int uid) {
        SceKernelThreadInfo thread = this.threadMap.get(uid);
        if (!thread.isStopped()) {
            return -2147352156;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelDeleteThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "'"));
        }
        this.setToBeDeletedThread(thread);
        this.triggerThreadEvent(thread, this.currentThread, 8);
        return 0;
    }

    @HLEFunction(nid=-193624995, version=150, checkInsideInterrupt=true)
    public int sceKernelStartThread(@CheckArgument(value="checkThreadID") int uid, int len, int data_addr) {
        SceKernelThreadInfo thread = this.threadMap.get(uid);
        if (this.isBannedThread(thread)) {
            log.warn((Object)("sceKernelStartThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' banned, not starting"));
            this.hleRescheduleCurrentThread();
            return 0;
        }
        if (!thread.isStopped()) {
            return -2147352156;
        }
        SceKernelThreadInfo callingThread = this.currentThread;
        log.debug((Object)"sceKernelStartThread redirecting to hleKernelStartThread");
        this.hleKernelStartThread(thread, len, data_addr, thread.gpReg_addr);
        thread.exitStatus = -2147352156;
        this.triggerThreadEvent(thread, callingThread, 2);
        return 0;
    }

    @HLEFunction(nid=1395282478, version=150)
    public int _sceKernelExitThread(int exitStatus) {
        return this.sceKernelExitThread(exitStatus);
    }

    @HLEFunction(nid=-1435252427, version=150, checkInsideInterrupt=true)
    public int sceKernelExitThread(int exitStatus) {
        SceKernelThreadInfo thread = this.currentThread;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelExitThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' exitStatus:0x" + Integer.toHexString(exitStatus)));
        }
        if (exitStatus < 0) {
            thread.setExitStatus(-2147352366);
        } else {
            thread.setExitStatus(exitStatus);
        }
        this.triggerThreadEvent(thread, this.currentThread, 4);
        this.hleChangeThreadState(thread, 16);
        RuntimeContext.onThreadExit(thread);
        this.hleRescheduleCurrentThread();
        return 0;
    }

    @HLEFunction(nid=-2137202021, version=150, checkInsideInterrupt=true)
    public int sceKernelExitDeleteThread(int exitStatus) {
        SceKernelThreadInfo thread = this.currentThread;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelExitDeleteThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "' exitStatus:0x" + Integer.toHexString(exitStatus)));
        }
        thread.setExitStatus(exitStatus);
        this.triggerThreadEvent(thread, this.currentThread, 4);
        this.triggerThreadEvent(thread, this.currentThread, 8);
        this.hleChangeThreadState(thread, 16);
        RuntimeContext.onThreadExit(thread);
        this.setToBeDeletedThread(thread);
        this.hleRescheduleCurrentThread();
        return 0;
    }

    @HLEFunction(nid=1633944506, version=150)
    public int sceKernelTerminateThread(@CheckArgument(value="checkThreadID") int uid) {
        SceKernelThreadInfo thread = this.getThreadCurrentIsInvalid(uid);
        log.debug((Object)("sceKernelTerminateThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "'"));
        this.triggerThreadEvent(thread, this.currentThread, 4);
        this.terminateThread(thread);
        thread.setExitStatus(-2147352148);
        return 0;
    }

    @HLEFunction(nid=943684556, version=150, checkInsideInterrupt=true)
    public int sceKernelTerminateDeleteThread(@CheckArgument(value="checkThreadID") int uid) {
        SceKernelThreadInfo thread = this.getThreadCurrentIsInvalid(uid);
        log.debug((Object)("sceKernelTerminateDeleteThread SceUID=" + Integer.toHexString(thread.uid) + " name:'" + thread.name + "'"));
        this.triggerThreadEvent(thread, this.currentThread, 4);
        this.triggerThreadEvent(thread, this.currentThread, 8);
        this.terminateThread(thread);
        this.setToBeDeletedThread(thread);
        return 0;
    }

    @HLEFunction(nid=987073420, version=150, checkInsideInterrupt=true)
    public int sceKernelSuspendDispatchThread() {
        int state = this.getDispatchThreadState();
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelSuspendDispatchThread() state=" + state));
        }
        if (Interrupts.isInterruptsDisabled()) {
            return -2147352474;
        }
        this.dispatchThreadEnabled = false;
        return state;
    }

    @HLEFunction(nid=669134530, version=150, checkInsideInterrupt=true)
    public int sceKernelResumeDispatchThread(int state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelResumeDispatchThread(state=" + state + ")"));
        }
        boolean isInterruptsDisabled = Interrupts.isInterruptsDisabled();
        if (state == 1) {
            this.dispatchThreadEnabled = true;
            this.hleRescheduleCurrentThread();
        }
        if (isInterruptsDisabled) {
            return -2147352474;
        }
        return 0;
    }

    @HLEFunction(nid=-361460175, version=150)
    public int sceKernelChangeCurrentThreadAttr(int removeAttr, int addAttr) {
        int newAttr;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelChangeCurrentThreadAttr removeAttr:0x" + Integer.toHexString(removeAttr) + " addAttr:0x" + Integer.toHexString(addAttr) + " oldAttr:0x" + Integer.toHexString(this.currentThread.attr)));
        }
        if (this.userCurrentThreadTryingToSwitchToKernelMode(newAttr = this.currentThread.attr & ~removeAttr | addAttr)) {
            log.debug((Object)"sceKernelChangeCurrentThreadAttr forcing user mode");
            newAttr |= Integer.MIN_VALUE;
            newAttr &= 0xFFFFEFFF;
        }
        this.currentThread.attr = newAttr;
        return 0;
    }

    @HLEFunction(nid=1908185201, version=150)
    public int sceKernelChangeThreadPriority(@CheckArgument(value="checkThreadIDAllow0") int uid, @CheckArgument(value="checkThreadPriority") int priority) {
        SceUidManager.checkUidPurpose(uid, "ThreadMan-thread", true);
        SceKernelThreadInfo thread = this.getThread(uid);
        if (thread.isStopped()) {
            log.warn((Object)("sceKernelChangeThreadPriority SceUID=" + Integer.toHexString(uid) + " newPriority:0x" + Integer.toHexString(priority) + " oldPriority:0x" + Integer.toHexString(thread.currentPriority) + " thread is stopped, ignoring"));
            thread.currentPriority = thread.initPriority;
            return -2147352158;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelChangeThreadPriority SceUID=" + Integer.toHexString(uid) + " newPriority:0x" + Integer.toHexString(priority) + " oldPriority:0x" + Integer.toHexString(thread.currentPriority)));
        }
        this.hleKernelChangeThreadPriority(thread, priority);
        return 0;
    }

    public int checkThreadPriority(int priority) {
        if (priority == 0) {
            priority = this.currentThread.currentPriority;
        }
        if (this.currentThread.isUserMode() && (priority < 8 || priority >= 120)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("checkThreadPriority priority:0x%x is outside of valid range in user mode", priority));
            }
            throw new SceKernelErrorException(-2147352173);
        }
        if (this.currentThread.isKernelMode() && (priority < 1 || priority >= 127)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("checkThreadPriority priority:0x%x is outside of valid range in kernel mode", priority));
            }
            throw new SceKernelErrorException(-2147352173);
        }
        return priority;
    }

    protected SceKernelThreadInfo getThreadCurrentIsInvalid(int uid) {
        SceKernelThreadInfo thread = this.getThread(uid);
        if (thread == this.currentThread) {
            throw new SceKernelErrorException(-2147352169);
        }
        return thread;
    }

    protected SceKernelThreadInfo getThread(int uid) {
        return this.threadMap.get(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEFunction(nid=-1859955545, version=150)
    public int sceKernelRotateThreadReadyQueue(@CheckArgument(value="checkThreadPriority") int priority) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelRotateThreadReadyQueue priority=" + priority));
        }
        LinkedList<SceKernelThreadInfo> linkedList = this.readyThreads;
        synchronized (linkedList) {
            for (SceKernelThreadInfo thread : this.readyThreads) {
                if (thread.currentPriority != priority) continue;
                if (priority == this.currentThread.currentPriority) {
                    thread = this.currentThread;
                    this.hleChangeThreadState(thread, 2);
                }
                this.removeFromReadyThreads(thread);
                this.addToReadyThreads(thread, false);
                this.hleRescheduleCurrentThread();
                break;
            }
        }
        return 0;
    }

    @HLEFunction(nid=741662803, version=150)
    public int sceKernelReleaseWaitThread(@CheckArgument(value="checkThreadID") int uid) {
        SceKernelThreadInfo thread = this.getThreadCurrentIsInvalid(uid);
        if (!thread.isWaiting()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelReleaseWaitThread(0x%X): thread not waiting: %s", uid, thread));
            }
            return -2147352154;
        }
        if (thread.waitType >= 256) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelReleaseWaitThread(0x%X): thread waiting in privileged status: waitType=0x%X", uid, thread.waitType));
            }
            return -2147352367;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelReleaseWaitThread(0x%X): releasing waiting thread: %s", uid, thread));
        }
        this.hleThreadWaitRelease(thread);
        this.hleRescheduleCurrentThread();
        return 0;
    }

    @HLEFunction(nid=691750328, version=150, checkInsideInterrupt=true)
    public int sceKernelGetThreadId() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelGetThreadId returning uid=0x" + Integer.toHexString(this.currentThread.uid)));
        }
        return this.currentThread.uid;
    }

    @HLEFunction(nid=-1800773138, version=150, checkInsideInterrupt=true)
    public int sceKernelGetThreadCurrentPriority() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelGetThreadCurrentPriority returning currentPriority=" + this.currentThread.currentPriority));
        }
        return this.currentThread.currentPriority;
    }

    @HLEFunction(nid=991444518, version=150)
    public int sceKernelGetThreadExitStatus(@CheckArgument(value="checkThreadID") int uid) {
        SceKernelThreadInfo thread = this.getThread(uid);
        if (!thread.isStopped()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelGetThreadExitStatus not stopped uid=0x%x", uid));
            }
            return -2147352156;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelGetThreadExitStatus uid=0x" + Integer.toHexString(uid) + " exitStatus=0x" + Integer.toHexString(thread.exitStatus)));
        }
        return thread.exitStatus;
    }

    @HLEFunction(nid=-784605547, version=150, checkInsideInterrupt=true)
    public int sceKernelCheckThreadStack(Processor processor) {
        int size = this.getThreadCurrentStackSize(processor);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelCheckThreadStack returning size=0x%X", size));
        }
        return size;
    }

    @HLEFunction(nid=1376296097, version=150, checkInsideInterrupt=true)
    public int sceKernelGetThreadStackFreeSize(@CheckArgument(value="checkThreadIDAllow0") int uid) {
        SceKernelThreadInfo thread = this.getThread(uid);
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(thread.getStackAddr(), thread.stackSize, 4);
        int unusedStackSize = thread.stackSize;
        for (int i = 0; i < thread.stackSize; i += 4) {
            int stackValue = memoryReader.readNext();
            if (stackValue == -1) continue;
            unusedStackSize = i;
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetThreadStackFreeSize returning size=0x%X", unusedStackSize));
        }
        return unusedStackSize;
    }

    @HLEFunction(nid=398551118, version=150)
    public int sceKernelReferThreadStatus(@CheckArgument(value="checkThreadIDAllow0") int uid, TPointer ptr) {
        SceKernelThreadInfo thread = this.getThread(uid);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelReferThreadStatus thread=%s, addr=%s", thread, ptr));
        }
        thread.write(ptr);
        return 0;
    }

    @HLEFunction(nid=-3970540, version=150, checkInsideInterrupt=true)
    public int sceKernelReferThreadRunStatus(@CheckArgument(value="checkThreadIDAllow0") int uid, TPointer ptr) {
        SceKernelThreadInfo thread = this.getThread(uid);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelReferThreadRunStatus thread=%s, addr=%s", thread, ptr));
        }
        thread.writeRunStatus(ptr.getMemory(), ptr.getAddress());
        return 0;
    }

    @HLEFunction(nid=1652453178, version=150)
    public int sceKernelReferSystemStatus(TPointer statusPtr) {
        SceKernelSystemStatus status = new SceKernelSystemStatus();
        status.read(statusPtr.getMemory(), statusPtr.getAddress());
        status.status = 0;
        status.write(statusPtr.getMemory(), statusPtr.getAddress());
        return 0;
    }

    @HLEFunction(nid=-1807654608, version=150, checkInsideInterrupt=true)
    public int sceKernelGetThreadmanIdList(int type, TPointer32 readBufPtr, int readBufSize, TPointer32 idCountPtr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelGetThreadmanIdList type=" + type + " readbuf:0x" + Integer.toHexString(readBufPtr.getAddress()) + " readbufsize:" + readBufSize + " idcount:0x" + Integer.toHexString(idCountPtr.getAddress())));
        }
        if (type != 1) {
            log.warn((Object)("UNIMPLEMENTED:sceKernelGetThreadmanIdList type=" + type));
            idCountPtr.setValue(0);
            return 0;
        }
        int saveCount = 0;
        int fullCount = 0;
        for (SceKernelThreadInfo thread : this.threadMap.values()) {
            if (!this.userThreadCalledKernelCurrentThread(thread)) continue;
            if (saveCount < readBufSize) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceKernelGetThreadmanIdList adding thread '" + thread.name + "'"));
                }
                readBufPtr.setValue(saveCount << 2, thread.uid);
                ++saveCount;
            } else {
                log.warn((Object)("sceKernelGetThreadmanIdList NOT adding thread '" + thread.name + "' (no more space)"));
            }
            ++fullCount;
        }
        idCountPtr.setValue(fullCount);
        return 0;
    }

    @HLEFunction(nid=1473209053, version=150)
    public int sceKernelGetThreadmanIdType(int uid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelGetThreadmanIdType uid=0x" + uid));
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-thread", false)) {
            return 1;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-sema", false)) {
            return 2;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-eventflag", false)) {
            return 3;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-Mbx", false)) {
            return 4;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-Vpl", false)) {
            return 5;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-Fpl", false)) {
            return 6;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-MsgPipe", false)) {
            return 7;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-callback", false)) {
            return 8;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-ThreadEventHandler", false)) {
            return 9;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-Alarm", false)) {
            return 10;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-VTimer", false)) {
            return 11;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-Mutex", false)) {
            return 12;
        }
        if (SceUidManager.checkUidPurpose(uid, "ThreadMan-LwMutex", false)) {
            return 13;
        }
        return -2147352366;
    }

    @HLEFunction(nid=1691636750, version=150)
    public int sceKernelReferThreadProfiler() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelReferThreadProfiler");
        }
        return 0;
    }

    @HLEFunction(nid=-2112310051, version=150)
    public int sceKernelReferGlobalProfiler() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceKernelReferGlobalProfiler");
        }
        return 0;
    }

    private class CheckCallbackReturnValue
    implements IAction {
        private SceKernelThreadInfo thread;
        private int callbackUid;

        public CheckCallbackReturnValue(SceKernelThreadInfo thread, int callbackUid) {
            this.thread = thread;
            this.callbackUid = callbackUid;
        }

        @Override
        public void execute() {
            int callbackReturnValue = this.thread.cpuContext._v0;
            if (callbackReturnValue != 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Callback uid=0x%X has returned value 0x%08X: deleting the callback", this.callbackUid, callbackReturnValue));
                }
                ThreadManForUser.this.hleKernelDeleteCallback(this.callbackUid);
            }
        }
    }

    public static class SleepThreadWaitStateChecker
    implements IWaitStateChecker {
        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            if (thread.wakeupCount > 0) {
                --thread.wakeupCount;
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }

    public class WaitThreadEndWaitStateChecker
    implements IWaitStateChecker {
        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelThreadInfo threadEnd = ThreadManForUser.this.getThreadById(wait.ThreadEnd_id);
            if (threadEnd == null) {
                thread.cpuContext._v0 = -2147352168;
                return false;
            }
            if (threadEnd.isStopped()) {
                thread.cpuContext._v0 = threadEnd.exitStatus;
                return false;
            }
            return true;
        }
    }

    public class DeleteThreadAction
    implements IAction {
        private SceKernelThreadInfo thread;

        public DeleteThreadAction(SceKernelThreadInfo thread) {
            this.thread = thread;
        }

        @Override
        public void execute() {
            ThreadManForUser.this.hleDeleteThread(this.thread);
        }
    }

    public class TimeoutThreadWaitStateChecker
    implements IWaitStateChecker {
        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            if (wait.forever) {
                return true;
            }
            if (wait.microTimeTimeout <= Emulator.getClock().microTime()) {
                ThreadManForUser.this.hleThreadWaitTimeout(thread);
                return false;
            }
            if (wait.waitTimeoutAction == null) {
                wait.waitTimeoutAction = new TimeoutThreadAction(thread);
            }
            return true;
        }
    }

    public class TimeoutThreadAction
    implements IAction {
        private SceKernelThreadInfo thread;

        public TimeoutThreadAction(SceKernelThreadInfo thread) {
            this.thread = thread;
        }

        @Override
        public void execute() {
            ThreadManForUser.this.hleThreadWaitTimeout(this.thread);
        }
    }

    private class AfterCallAction
    implements IAction {
        SceKernelThreadInfo thread;
        int status;
        int waitType;
        int waitId;
        ThreadWaitInfo threadWaitInfo;
        boolean doCallback;
        IAction afterAction;

        public AfterCallAction(SceKernelThreadInfo thread, int status, int waitType, int waitId, ThreadWaitInfo threadWaitInfo, boolean doCallback, IAction afterAction) {
            this.thread = thread;
            this.status = status;
            this.waitType = waitType;
            this.waitId = waitId;
            this.threadWaitInfo = threadWaitInfo;
            this.doCallback = doCallback;
            this.afterAction = afterAction;
        }

        @Override
        public void execute() {
            boolean restoreWaitState = true;
            if (this.threadWaitInfo.waitStateChecker != null && !this.threadWaitInfo.waitStateChecker.continueWaitState(this.thread, this.threadWaitInfo)) {
                restoreWaitState = false;
            }
            if (restoreWaitState) {
                if (this.status == 1) {
                    this.doCallback = false;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("AfterCallAction: restoring wait state for thread '%s' to %s, %s, doCallbacks %b", this.thread.toString(), SceKernelThreadInfo.getStatusName(this.status), SceKernelThreadInfo.getWaitName(this.waitType, this.threadWaitInfo, this.status), this.doCallback));
                }
                this.thread.waitType = this.waitType;
                this.thread.waitId = this.waitId;
                this.thread.wait.copy(this.threadWaitInfo);
                ThreadManForUser.this.hleChangeThreadState(this.thread, this.status);
            } else if (this.thread.status != 2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AfterCallAction: set thread to READY state: " + this.thread.toString()));
                }
                ThreadManForUser.this.hleChangeThreadState(this.thread, 2);
                this.doCallback = false;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AfterCallAction: leaving thread in READY state: " + this.thread.toString()));
                }
                this.doCallback = false;
            }
            this.thread.doCallbacks = this.doCallback;
            ThreadManForUser.this.hleRescheduleCurrentThread();
            if (this.afterAction != null) {
                this.afterAction.execute();
            }
        }
    }

    public static class Callback {
        private int id;
        private int address;
        private int[] parameters;
        private int savedIdRegister;
        private int savedRa;
        private int savedPc;
        private int savedV0;
        private int savedV1;
        private IAction afterAction;
        private boolean returnVoid;

        public Callback(int id, int address, int[] parameters, IAction afterAction, boolean returnVoid) {
            this.id = id;
            this.address = address;
            this.parameters = parameters;
            this.afterAction = afterAction;
            this.returnVoid = returnVoid;
        }

        public IAction getAfterAction() {
            return this.afterAction;
        }

        public int getId() {
            return this.id;
        }

        public int getSavedIdRegister() {
            return this.savedIdRegister;
        }

        public int getSavedRa() {
            return this.savedRa;
        }

        public int getSavedPc() {
            return this.savedPc;
        }

        public int getSavedV0() {
            return this.savedV0;
        }

        public int getSavedV1() {
            return this.savedV1;
        }

        public boolean isReturnVoid() {
            return this.returnVoid;
        }

        public void execute(SceKernelThreadInfo thread) {
            CpuState cpu = thread.cpuContext;
            this.savedIdRegister = cpu.getRegister(16);
            this.savedRa = cpu._ra;
            this.savedPc = cpu.pc;
            this.savedV0 = cpu._v0;
            this.savedV1 = cpu._v1;
            if (this.parameters != null) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    cpu.setRegister(4 + i, this.parameters[i]);
                }
            }
            cpu.setRegister(16, this.id);
            cpu._ra = 0x8000030;
            cpu.pc = this.address;
            RuntimeContext.executeCallback();
        }

        public String toString() {
            return String.format("Callback address=0x%08X,id=%d,returnVoid=%b", this.address, this.getId(), this.isReturnVoid());
        }
    }

    public static class CallbackManager {
        private Map<Integer, Callback> callbacks;
        private int currentCallbackId;

        public void Initialize() {
            this.callbacks = new HashMap<Integer, Callback>();
            this.currentCallbackId = 1;
        }

        public void addCallback(Callback callback) {
            this.callbacks.put(callback.getId(), callback);
        }

        public Callback remove(int id) {
            Callback callback = this.callbacks.remove(id);
            return callback;
        }

        public int getNewCallbackId() {
            return this.currentCallbackId++;
        }
    }

    public static class Statistics {
        private ArrayList<ThreadStatistics> threads = new ArrayList();
        public long allCycles = 0L;
        public long startTimeMillis = System.currentTimeMillis();
        public long endTimeMillis;
        public long allCpuMillis = 0L;

        public void exit() {
            this.endTimeMillis = System.currentTimeMillis();
        }

        public long getDurationMillis() {
            return this.endTimeMillis - this.startTimeMillis;
        }

        private void addThreadStatistics(SceKernelThreadInfo thread) {
        }

        private static class ThreadStatistics
        implements Comparable<ThreadStatistics> {
            public String name;
            public long runClocks;

            private ThreadStatistics() {
            }

            @Override
            public int compareTo(ThreadStatistics o) {
                return -new Long(this.runClocks).compareTo(o.runClocks);
            }

            public String getQuotedName() {
                return "'" + this.name + "'";
            }
        }
    }

    private class EnableThreadBanningSettingsListerner
    extends AbstractBoolSettingsListener {
        private EnableThreadBanningSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            ThreadManForUser.this.setThreadBanningEnabled(value);
        }
    }
}

