/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.hardware;

import jpcsp.hardware.Battery;

public class BatteryDrainThread
extends Thread {
    private static BatteryDrainThread instance = null;
    private long sleepMillis;

    public static void initialize() {
        if (instance == null) {
            long secondsForOnePercentDrain = Battery.getLifeTime() * 60 / 100;
            instance = new BatteryDrainThread(secondsForOnePercentDrain * 1000L);
            instance.setDaemon(true);
            instance.setName("Battery Drain");
            instance.start();
        }
    }

    public BatteryDrainThread(long sleepMillis) {
        this.sleepMillis = sleepMillis;
    }

    @Override
    public void run() {
        while (true) {
            try {
                BatteryDrainThread.sleep(this.sleepMillis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            int powerPercent = Battery.getCurrentPowerPercent();
            if (Battery.isCharging()) {
                if (powerPercent < 100) {
                    ++powerPercent;
                }
            } else if (powerPercent > 0) {
                --powerPercent;
            }
            Battery.setCurrentPowerPercent(powerPercent);
        }
    }
}

