# Mods for Xenoblade Chronicles X
### Battle mods

- **Enemy Statistics mod**: Apply a global percent modificator on all enemies stats (HP, Melee Attack, Melee Accuracy, Ranged Attack, Ranged Accuracy, Potential and Evasion).
- **Escape distance reducer**: Reduce escape distance needed to lose aggro from enemies.
- **Ground Damage multiplicator**: Increase the ground damage dealt by your team (skells not impacted).
- **Overdrive unlocked**: Overdrive is unlocked and can be used before Chapter 3.
- **Soul Challenges - AutoBattles**: The Soul Challenges QTE are hidden and automatically successful (only affect ground battles, not the QTE on Skell binding and destroying).
- **Soul Challenges - Difficulty**: The Soul Challenge's difficulty (the time left for doing the QTE) does not increase over time during a battle.
- **Soul Challenges - Skell restored**: When your Skell is destroyed during battle, it is restored automatically (you may need to fast travel).

### BLADE mods
- **DLC quests unlocked**: DLC Support quests are unlocked and accessible as soon as you become a BLADE member.
- **Gain Reward Tickets from DLC or Time Attack missions**: Add Exchange Tickets in reward for completing Blade missions.
    > There are 2 presets:
	> 1. Adds (exp) tickets to Time Attack missions
    > 2. Adds (money/100) tickets to DLC missions
- **Lv60 skells unlocked (+cheat)**: Unlock the post-game skells and equipment as soon as you become a BLADE member (it also considers you have a Skell Flight License). The "Cheat" preset ignores all requirements for crafting, and also the level requirement to use a Skell. Yes, that means you can get an Ares 90 for free, right after Chapter 2!
- **More Reward Tickets**: Increase the amount of Tickets you get from Squad tasks and missions. Presets with "uncapped" means they ignore the max amount of Tickets you can have.
- **Offline Global Nemesis missions**: Global Nemesis (both Telethia Plume and Yggralith Zero) are available anytime in the BLADE console. You still need medals to start the battle.
- **Offline Squad tasks and missions**: Squad tasks and missions become available for offline play! When the game starts, a Squad quest is randomly selected (with "Random" preset) and the timer is stopped.
    > Other presets allow to choose a specific tasks list.  (c ) stands for collectible and (t) for Tyrant.
    > When "Random" preset is selected, you can randomly change the active mission by opening the main menu and select "Social entry" > "Select Squad" command.

### Collectibles mods
- **Catch range mod**: Increase the distance from which you catch a collectible.
   > By default, you'll get them just when you're close enough to see the blue gem (distance increased by 40.0). There are 3 kind of distances in the game, each with a value of "Range" and "Height": "Inner" (which means when you are at foot), "Doll" (when you have a Skell at land) and "Flight" (which I believe is when you flight, generally in a Skell). All values are editable in the file patches.txt. Also note that the rarity of items is untouched.
- **Ignore 100th**: Ignore a collectible if you already have 99 of them.
  > This is for endgame situation in which you have plenty of money, many collectibles and doesn't want to be spammed with selling messages when you walk around in the world.

### Equipment mods
- **Armors can have 3 augment slots**: Using L' shop, you can have a maximum of 3 augment slots on any of your **equipped** ground or skell armor.
- **Unlimited augment upgrades**: Allow you to upgrade up to **15 times** all the augments inside a piece of equipment (as long as you have the resources of course). The "Cheat" preset ignores all requirements.
- **Unlock all augments**: All augments are known in the BLADE shop. As usual, the "Cheat" preset ignores all requirements for crafing (useful for build testing).

### Experience mods
- **Battle Points X**: Increase the battle points gained.
- **BLADE Points X**: Increase the Blade points gained.
- **Class Exp Points X**: Increase the class experience points gained.
- **Friend Points X**: Increase the friend points gained during Soul Voice activation in battles.
- **Inner Exp Points X**: Increase the experience points gained.

### FrontierNav Probes mods
- **Miranium income frequency**: Increase the frequency of the FrontierNav Miranium income.
- **Miranium income quantity**: Increase the quantity of Miranium gained using FrontierNav.
- **Money income frequency/quantity**: same as Miranium, but for money.
- **Resources income frequency/quantity**: same as Miranium, but for resources obtained using FrontierNav Probes.

### Graphics mods
- **Camera distance mod**: Change the default zoom.
- **NPC info bubbles distance mod**: Increase the distance from which NPC's yellow speech bubbles are seen.
    > I made this mod to get rid of the frustration not being able to get information from NLA people unless I get very close to each one of them.

### HUD mods
- **Change time anywhere**: Allow to change time of the day from the eManual entry of the main menu.

### Loot mods
- **Equipment - Alternate random augments**: change the way augments are selected during loot generation.
	> In vanilla, augments have a default percent chance to be selected. For example, augment "Melee Accuracy Up" has 100%, while "Critical Chance Up" has only 5%.
	> This mod applies following rule: everything above 80% is capped at 80%, and everything else is set to 20%.
- **Equipment - Always best quality**: Equipment looted is always at best quality ("Prime" for ground gear and "Intergalactic" for Skells gear), with "X6X" variants and has always 3 augments and 3 extra free slots.
- **Equipment - Force count**: Force the number of equipments looted in silver or gold treasures.
- **Equipment - Force type**: Force the type of equipment looted.
    > This mod is designed to make end-game equipment farming easier. **Doesn't work for Skells weapons!**
- **Equipment - Ignore broken**: Get rid of those broken equipments!
- **Materials - Drop ratio mod**: Set a minimum drop ratio for materials.
- **Treasure Quality**: Select the treasure quality you want to loot (bronze, silver, gold or no chest at all if you just want to kill a lot of monsters quickly without loot).    
    > You can choose between regular and "FORCED" presets. Difference between them is a bit tricky to explain, but here's how the game selects the chest quality:    
    > 1 - Calculate luck for gold chest, if success exit with gold quality, else process next step    
    > 2 - Calculate luck for silver chest, if success exit with silver quality, else process next step    
    > 3 - Calculate luck for bronze chest, if success exit with bronze quality, else process next step    
    > 4 - Bad luck, exit with no chest    
    > Regular presets of this mod only change the last step. So even if you select the "Gold quality" preset, you'll still get a silver chest if the game succeeded the step 2.    
    > FORCED presets bypass the entire process, so that you'll be guaranteed to get gold chests, but the downtime is that **it can break some quests** which require you to loot key items that appear only in bronze or silver treasures!    
    > **My advice**: only use "FORCED" presets for end-game farming.

### Max mods
- **Max Items**: Increase the maximum of items you can get to 999.
- **Max Money**: Increase the maximum of money you can have to 999 999 999.
- **Max Reward Tickets**: Increase the maximum amount of Tickets you can get. At BLADE level 1 to 9, the max is multiplied by 10. At BLADE level 10, the max becomes 99999.
> Those mods must stay enabled or you will lose the extra items and money (let's say you have 320 000 000 money, if you load your game without the mod, you'll only have 99 999 999 money left).

### Music mods
- **No Overdrive music**: Disables the Overdrive music (after some time using Overdrive a lot during battles, I missed the other musics, especially the one from tyrants).
- **No Skell Flight music**: Disables the flight music (at the beginning the music is awesome, but after some time I wanted to listen to the field musics again).

### Physics mods
- **Jump to the Moon!**: Increases the horizontal and vertical velocity of the jump (vanilla values are 1.0 for both).
	> Horizontal velocity is the distance you reach when jumping.
	> Vertical Velocity is the height of the jump (works while idle, walking and sprinting)
- **Run Forrest, run!**: Increases the speed of sprinting.

### Weather mods
- **Force weather**: Force selected weather. Just select a preset and unload/reload the pack.

### Requirements
Since Cemu 1.18, cemuhook is no longer required. Just make sure your game version is **1.0.1E** or **1.0.2U**.
