﻿import { GetProductionItems, GetCityBuildReccomendations } from '/base-standard/ui/production-chooser/production-chooser-helpers.js';

class AutoRepairMod {
    constructor() {
        this.turnActiveFlag = false;
        this.init();
    }
    
    init() {
        console.warn("MOD: Auto Repair Execution Initialized.");
        engine.on('LocalPlayerTurnBegin', this.onLocalPlayerTurnBegin, this); 
        engine.on('PlayerTurnActivated', this.onPlayerTurnActivated, this);
    }

    onLocalPlayerTurnBegin() {
        this.turnActiveFlag = true;
    }

    onPlayerTurnActivated() {	      	  	
        if (!this.turnActiveFlag) return;
        this.turnActiveFlag = false;

        const player = Players.get(GameContext.localPlayerID);
        if (!player) return;

        // ターン開始時の所持金を取得し、収入分を加算する
        let playerGoldBalance = Players.Treasury.get(GameContext.localPlayerID)?.goldBalance ?? 0;
        const turnGoldIncome = Players.Treasury.get(GameContext.localPlayerID)?.goldIncome ?? 0;
        playerGoldBalance += turnGoldIncome;

        player.Cities.getCityIds().forEach(cityId => {
        	const city = Cities.get(cityId);
            if (!city) {
                console.error("[ERROR]AutoRepair: Failed to retrieve city data. CityID: " + JSON.stringify(cityId));
                return;
            }

			// 修理可能な建造物を取得
            const results = Game.CityOperations.canStartQuery(cityId, CityOperationTypes.BUILD, CityQueryType.Constructible);
            for (let i = 0; i < results.length; i++) {
                const { index, result } = results[i];
                
                if (!result.RepairDamaged) continue;

                const constructible = GameInfo.Constructibles.lookup(index);
                if (!constructible) {
                    console.error("[ERROR]AutoRepair: Constructible not found for index: " + index);
                    return;
                }

                // 建造物リストを取得し、修理可能なものを検索
                const recommendations = GetCityBuildReccomendations(city);
                const productionItems = GetProductionItems(city, recommendations, playerGoldBalance, true, false, null);

                if (!productionItems) {
                    console.error("[ERROR]AutoRepair: Failed to retrieve production items for city: " + city.name);
                    return;
                }

                const item = productionItems.buildings.find(p => p.type === constructible.ConstructibleType);
                if (!item) {
                    console.error("[ERROR]AutoRepair: Repairable item not found for constructible: " + constructible.Name);
                    return;
                }

                // 修理に必要なコストを取得
                const cost = item.cost ?? item["cost"] ?? 0;
                if (typeof cost === "undefined") {
                    console.error("[ERROR]AutoRepair: Item cost is undefined. Cannot proceed with repair.");
                    return;
                }

                // 所持金が足りない場合は次の修理を試す
                if (playerGoldBalance < cost) {
                    console.error("[ERROR]AutoRepair: Not enough gold for " + item.name + ". Required: " + cost + ", Available: " + playerGoldBalance);
                    continue;  // `continue` に変更して次の修理を試行
                }

                // 修理を実行する前に所持金を減算
                playerGoldBalance -= cost;
                
                // 修理リクエストの作成
                const typeInfo = GameInfo.Types.lookup(item.type);
                if (typeInfo) {
                    let args = { ConstructibleType: typeInfo.Hash };

                    // 修理が特定のプロットで行われる場合、X, Y 座標をセット
                    if (result.Plots) {
                        const loc = GameplayMap.getLocationFromIndex(result.Plots[0]);
                        args.X = loc.x;
                        args.Y = loc.y;
                    }

                    // 修理のリクエストを送信
                    try {
                        const requestResult = Game.CityCommands.sendRequest(cityId, CityCommandTypes.PURCHASE, args);

                        if (!requestResult) {
                            console.error("[ERROR]AutoRepair: sendRequest() returned undefined. CityID: " + JSON.stringify(cityId));
                            return;
                        }
                    } catch (error) {
                        console.error("[ERROR]AutoRepair: Error during sendRequest(). " + error);
                        return;
                    }
                }
            }
        });
    }
}

// **インスタンスを作成**
window.AutoRepairMod = new AutoRepairMod();
