﻿import { Construct } from '/base-standard/ui/production-chooser/production-chooser-helpers.js';

class RepeatProjectMod {
    constructor() {
        this.projectCities = {}; // 都市ごとのプロジェクト情報を保持
        this.RP_TurnActiveFlag = false; // 自分のターンかどうかを判定するフラグ
        this.init();
    }
    
    init() {
        console.warn("MOD: Repeat Project Execution Initialized.");

        engine.on('LocalPlayerTurnBegin', this.onLocalPlayerTurnBegin, this); 
        engine.on('PlayerTurnActivated', this.onPlayerTurnActivated, this);
        engine.on('LocalPlayerTurnEnd', this.onLocalPlayerTurnEnd, this);
    }

    /**
     * 自分のターン開始時にフラグを設定
     */
    onLocalPlayerTurnBegin() {
        this.RP_TurnActiveFlag = true;
    }

    /**
     * ターン終了時に現在実行中のプロジェクトを記録
     */
    onLocalPlayerTurnEnd() {
        this.RP_TurnActiveFlag = false;

        const player = Players.get(GameContext.localPlayerID);
        if (!player) return;

        this.projectCities = {}; // 記録リセット

        player.Cities.getCityIds().forEach(cityId => {
            const city = Cities.get(cityId);
            if (!city || city.isTown) return;

            const cityBuildQueue = city.BuildQueue;
            const queueItems = cityBuildQueue.getQueue();

            if (queueItems.length === 0) return;

            for (const item of queueItems) {
                if (cityBuildQueue.getProductionKindName(item.kind) !== "PROJECT") continue;

                this.projectCities[`${cityId.owner},${cityId.id}`] = item.type;
                break; // **最初に見つかったプロジェクトのみ保存**
            }
        });
    }

    /**
     * `PlayerTurnActivated` のタイミングでプロジェクトを再実行
     */
    onPlayerTurnActivated() {
        if (!this.RP_TurnActiveFlag) return;

        const player = Players.get(GameContext.localPlayerID);
        if (!player) return;

        player.Cities.getCityIds().forEach(cityId => {
            const city = Cities.get(cityId);
            if (!city || city.isTown) return;

            const cityKey = `${cityId.owner},${cityId.id}`;
            const projectType = this.projectCities[cityKey];

            if (!projectType) return;

            const cityBuildQueue = city.BuildQueue;
            if (cityBuildQueue.getQueue().length > 0) return; // **キューが空でないならスキップ**

            const projectItem = { type: projectType };
            const success = Construct(city, projectItem, false);

            if (!success) {
                console.warn(`ERROR: Failed to restart project "${cityBuildQueue.getProductionTypeName(projectType, "PROJECT")}" in city "${city.name}" (ID: ${cityKey}).`);
            }
        });
    }
}

// **インスタンスを作成**
window.RepeatProjectMod = new RepeatProjectMod();
