/*
 * Decompiled with CFR 0.152.
 */
package com.xortroll.emuiibo.emuiigen;

import com.xortroll.emuiibo.emuiigen.AmiiboAPIEntry;
import com.xortroll.emuiibo.emuiigen.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/xortroll/emuiibo/emuiigen/AmiiboAPI;", "", "()V", "Companion", "emuiigen"})
public final class AmiiboAPI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String Url = "https://www.amiiboapi.com/api/amiibo/";

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/xortroll/emuiibo/emuiigen/AmiiboAPI$Companion;", "", "()V", "Url", "", "getUrl", "()Ljava/lang/String;", "parseApiJson", "", "", "Lcom/xortroll/emuiibo/emuiigen/AmiiboAPIEntry;", "json_data", "Lorg/json/JSONObject;", "readApi", "emuiigen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getUrl() {
            return Url;
        }

        @Nullable
        public final Map<String, List<AmiiboAPIEntry>> parseApiJson(@NotNull JSONObject json_data) {
            Intrinsics.checkNotNullParameter(json_data, "json_data");
            JSONArray json_entries = json_data.getJSONArray("amiibo");
            Map entry_map = new LinkedHashMap();
            int n = json_entries.length();
            for (int i = 0; i < n; ++i) {
                Object it;
                JSONObject jSONObject = json_entries.getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue(jSONObject, "getJSONObject(...)");
                AmiiboAPIEntry entry = AmiiboAPIEntry.Companion.fromJson(jSONObject);
                List list = (List)entry_map.get(entry.getSeries_name());
                List<Object> series = list != null ? CollectionsKt.toMutableList(list) : null;
                List<Object> list2 = series;
                if (list2 != null) {
                    it = list2;
                    boolean bl = false;
                    series.add(entry);
                    List list3 = entry_map.put(entry.getSeries_name(), series);
                    list2 = list3;
                    if (list3 != null) continue;
                }
                it = this;
                boolean bl = false;
                AmiiboAPIEntry[] amiiboAPIEntryArray = new AmiiboAPIEntry[]{entry};
                list2 = entry_map.put(entry.getSeries_name(), CollectionsKt.mutableListOf(amiiboAPIEntryArray));
            }
            for (List bass : entry_map.values()) {
                CollectionsKt.sortWith(bass, new Comparator(){

                    public final int compare(T a, T b) {
                        AmiiboAPIEntry p0 = (AmiiboAPIEntry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)p0.getAmiibo_name());
                        p0 = (AmiiboAPIEntry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)p0.getAmiibo_name()));
                    }
                });
            }
            return entry_map;
        }

        @Nullable
        public final Map<String, List<AmiiboAPIEntry>> readApi() {
            String cur_path = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getAbsolutePath();
            String[] stringArray = new String[]{"api.json"};
            String local_api_json_path = ((Object)Paths.get(cur_path, stringArray)).toString();
            try {
                String raw_json = Utils.Companion.netDownloadString(this.getUrl());
                JSONObject json_data = new JSONObject(raw_json);
                try {
                    FileWriter json_data_w = new FileWriter(local_api_json_path);
                    json_data_w.write(json_data.toString(4));
                    json_data_w.flush();
                    json_data_w.close();
                }
                catch (Exception ex) {
                    System.out.println("Exception saving AmiiboAPI as local JSON: " + ex);
                }
                return this.parseApiJson(json_data);
            }
            catch (Exception ex) {
                System.out.println("Exception reading AmiiboAPI: " + ex);
                try {
                    FileInputStream json_data_strm = new FileInputStream(local_api_json_path);
                    String json_data_raw = IOUtils.toString(json_data_strm);
                    JSONObject json_data = new JSONObject(json_data_raw);
                    return this.parseApiJson(json_data);
                }
                catch (Exception ex2) {
                    System.out.println("Exception reading local API JSON: " + ex2);
                    return null;
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

