/*
 * Decompiled with CFR 0.152.
 */
package com.xortroll.emuiibo.emuiigen.ui;

import com.xortroll.emuiibo.emuiigen.ui.MainController;
import java.util.Arrays;
import java.util.Properties;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/xortroll/emuiibo/emuiigen/ui/MainApplication;", "Ljavafx/application/Application;", "()V", "controller", "Lcom/xortroll/emuiibo/emuiigen/ui/MainController;", "start", "", "stage", "Ljavafx/stage/Stage;", "Companion", "emuiigen"})
public final class MainApplication
extends Application {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private MainController controller;
    @NotNull
    private static final String Description = "emuiibo's virtual amiibo PC utility";
    public static String Version;
    public static HostServices HostServices;

    @Override
    public void start(@NotNull Stage stage) {
        Intrinsics.checkNotNullParameter(stage, "stage");
        HostServices hostServices = this.getHostServices();
        Intrinsics.checkNotNullExpressionValue(hostServices, "getHostServices(...)");
        Companion.setHostServices(hostServices);
        ClassLoader this_loader = this.getClass().getClassLoader();
        FXMLLoader fxml_loader = new FXMLLoader(this_loader.getResource("main.fxml"));
        Pane base = (Pane)fxml_loader.load();
        Object t = fxml_loader.getController();
        Intrinsics.checkNotNull(t, "null cannot be cast to non-null type com.xortroll.emuiibo.emuiigen.ui.MainController");
        this.controller = (MainController)t;
        Properties main_props = new Properties();
        main_props.load(this_loader.getResourceAsStream("main.properties"));
        String string = main_props.getProperty("version");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        Companion.setVersion(string);
        double width = base.getPrefWidth();
        double height = base.getPrefHeight();
        stage.setTitle("emuiigen v" + Companion.getVersion() + " - " + Description);
        stage.getIcons().add(new Image(this_loader.getResource("icon.png").toExternalForm()));
        stage.setScene(new Scene(base, width, height));
        stage.getScene().getStylesheets().add(this_loader.getResource("main.css").toExternalForm());
        stage.setMinWidth(width);
        stage.setMinHeight(height);
        stage.setResizable(false);
        MainController mainController = this.controller;
        if (mainController == null) {
            Intrinsics.throwUninitializedPropertyAccessException("controller");
            mainController = null;
        }
        mainController.prepare(stage);
        stage.show();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0006\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/xortroll/emuiibo/emuiigen/ui/MainApplication$Companion;", "", "()V", "Description", "", "getDescription", "()Ljava/lang/String;", "HostServices", "Ljavafx/application/HostServices;", "getHostServices", "()Ljavafx/application/HostServices;", "setHostServices", "(Ljavafx/application/HostServices;)V", "Version", "getVersion", "setVersion", "(Ljava/lang/String;)V", "main", "", "args", "", "([Ljava/lang/String;)V", "emuiigen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDescription() {
            return Description;
        }

        @NotNull
        public final String getVersion() {
            String string = Version;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("Version");
            return null;
        }

        public final void setVersion(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            Version = string;
        }

        @NotNull
        public final HostServices getHostServices() {
            HostServices hostServices = HostServices;
            if (hostServices != null) {
                return hostServices;
            }
            Intrinsics.throwUninitializedPropertyAccessException("HostServices");
            return null;
        }

        public final void setHostServices(@NotNull HostServices hostServices) {
            Intrinsics.checkNotNullParameter(hostServices, "<set-?>");
            HostServices = hostServices;
        }

        public final void main(@NotNull String[] args2) {
            Intrinsics.checkNotNullParameter(args2, "args");
            Application.launch(MainApplication.class, Arrays.copyOf(args2, args2.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

