/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java.javax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.usb.UsbException;
import javax.usb.UsbHub;
import javax.usb.UsbPlatformException;
import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import org.usb4java.javax.AbstractDevice;
import org.usb4java.javax.Config;
import org.usb4java.javax.DeviceId;
import org.usb4java.javax.DeviceNotFoundException;
import org.usb4java.javax.ExceptionUtils;
import org.usb4java.javax.Hub;
import org.usb4java.javax.NonHub;
import org.usb4java.javax.Port;
import org.usb4java.javax.RootHub;
import org.usb4java.javax.ScanException;
import org.usb4java.javax.UsbPorts;
import org.usb4java.javax.descriptors.SimpleUsbDeviceDescriptor;

final class DeviceManager {
    private final RootHub rootHub;
    private final Context context;
    private boolean scanned = false;
    private final int scanInterval;
    private final Map<DeviceId, AbstractDevice> devices = Collections.synchronizedMap(new HashMap());

    DeviceManager(RootHub rootHub, Config config) throws UsbException {
        int usbdkResult;
        if (rootHub == null) {
            throw new IllegalArgumentException("rootHub must be set");
        }
        this.scanInterval = config.getScanInterval();
        this.rootHub = rootHub;
        this.context = new Context();
        int result = LibUsb.init(this.context);
        if (result != 0) {
            throw ExceptionUtils.createPlatformException("Unable to initialize libusb", result);
        }
        if (config.isUseUSBDK() && (usbdkResult = LibUsb.setOption(this.context, 1)) != 0 && usbdkResult != -12) {
            throw ExceptionUtils.createPlatformException("Unable to set USE_USBDK option", usbdkResult);
        }
    }

    public void dispose() {
        LibUsb.exit(this.context);
    }

    private DeviceId createId(Device device) throws UsbPlatformException {
        if (device == null) {
            throw new IllegalArgumentException("device must be set");
        }
        int busNumber = LibUsb.getBusNumber(device);
        int addressNumber = LibUsb.getDeviceAddress(device);
        int portNumber = LibUsb.getPortNumber(device);
        DeviceDescriptor deviceDescriptor = new DeviceDescriptor();
        int result = LibUsb.getDeviceDescriptor(device, deviceDescriptor);
        if (result < 0) {
            throw ExceptionUtils.createPlatformException("Unable to get device descriptor for device " + addressNumber + " at bus " + busNumber, result);
        }
        return new DeviceId(busNumber, addressNumber, portNumber, new SimpleUsbDeviceDescriptor(deviceDescriptor));
    }

    private void scanRemovedDevices(UsbPorts<Port, AbstractDevice> ports) {
        for (AbstractDevice device : ports.getAttachedUsbDevices()) {
            if (device.isUsbHub()) {
                this.scanRemovedDevices((Hub)device);
            }
            if (this.devices.containsKey(device.getId())) continue;
            ports.disconnectUsbDevice(device);
        }
    }

    private void scanNewDevices(UsbPorts<Port, AbstractDevice> ports, DeviceId hubId) {
        for (AbstractDevice device : this.devices.values()) {
            DeviceId parentId = device.getParentId();
            if (!this.devices.containsKey(parentId)) {
                parentId = null;
            }
            if (!DeviceId.equals(parentId, hubId)) continue;
            if (!ports.isUsbDeviceAttached(device)) {
                ports.connectUsbDevice(device);
            }
            if (!device.isUsbHub()) continue;
            this.scanNewDevices((Hub)device, device.getId());
        }
    }

    public void scan(UsbHub hub) {
        try {
            this.updateDeviceList();
        }
        catch (UsbException e) {
            throw new ScanException("Unable to scan for USB devices: " + e, e);
        }
        if (hub.isRootUsbHub()) {
            RootHub rootHub = (RootHub)hub;
            this.scanRemovedDevices(rootHub);
            this.scanNewDevices(rootHub, null);
        } else {
            Hub nonRootHub = (Hub)hub;
            this.scanRemovedDevices(nonRootHub);
            this.scanNewDevices(nonRootHub, nonRootHub.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeviceList() throws UsbPlatformException {
        ArrayList<DeviceId> current = new ArrayList<DeviceId>();
        DeviceList devices = new DeviceList();
        int result = LibUsb.getDeviceList(this.context, devices);
        if (result < 0) {
            throw ExceptionUtils.createPlatformException("Unable to get USB device list", result);
        }
        try {
            for (Device libUsbDevice : devices) {
                try {
                    DeviceId id = this.createId(libUsbDevice);
                    AbstractDevice device = this.devices.get(id);
                    if (device == null) {
                        Device parent = LibUsb.getParent(libUsbDevice);
                        DeviceId parentId = parent == null ? null : this.createId(parent);
                        int speed = LibUsb.getDeviceSpeed(libUsbDevice);
                        boolean isHub = id.getDeviceDescriptor().bDeviceClass() == 9;
                        device = isHub ? new Hub(this, id, parentId, speed, libUsbDevice) : new NonHub(this, id, parentId, speed, libUsbDevice);
                        this.devices.put(id, device);
                    }
                    current.add(id);
                }
                catch (UsbPlatformException e) {}
            }
            this.devices.keySet().retainAll(current);
        }
        finally {
            LibUsb.freeDeviceList(devices, true);
        }
    }

    public synchronized void scan() {
        this.scan(this.rootHub);
        this.scanned = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device getLibUsbDevice(DeviceId id) throws UsbPlatformException {
        if (id == null) {
            throw new IllegalArgumentException("id must be set");
        }
        DeviceList devices = new DeviceList();
        int result = LibUsb.getDeviceList(this.context, devices);
        if (result < 0) {
            throw ExceptionUtils.createPlatformException("Unable to get USB device list", result);
        }
        try {
            for (Device device : devices) {
                try {
                    if (!id.equals(this.createId(device))) continue;
                    LibUsb.refDevice(device);
                    Device device2 = device;
                    return device2;
                }
                catch (UsbPlatformException e) {}
            }
        }
        finally {
            LibUsb.freeDeviceList(devices, true);
        }
        throw new DeviceNotFoundException(id);
    }

    public void releaseDevice(Device device) {
        if (device == null) {
            throw new IllegalArgumentException("device must be set");
        }
        LibUsb.unrefDevice(device);
    }

    public void start() {
        final int scanInterval = this.scanInterval;
        if (scanInterval == 0) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(scanInterval);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    DeviceManager.this.scan();
                }
            }
        });
        thread.setDaemon(true);
        thread.setName("usb4java Device Scanner");
        thread.start();
    }

    public void firstScan() {
        if (!this.scanned) {
            this.scan();
        }
    }
}

