/*
 * Decompiled with CFR 0.152.
 */
package xortroll.goldleaf.quark;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public class Config {
    public static Path ConfigPath;
    private Properties inner_cfg;
    private File cfg_file;

    public Config() throws Exception {
        if (ConfigPath == null) {
            Path quarkConfigDirPath;
            String configHome = System.getenv("XDG_CONFIG_HOME");
            if (configHome == null || configHome.trim().length() == 0) {
                configHome = System.getProperty("user.home") + File.separator + ".config";
            }
            if (Files.notExists(quarkConfigDirPath = Paths.get(configHome, "quark"), new LinkOption[0])) {
                Files.createDirectories(quarkConfigDirPath, new FileAttribute[0]);
            }
            ConfigPath = quarkConfigDirPath.resolve("quark-config.cfg");
        }
        this.inner_cfg = new Properties();
        this.reloadConfigFile();
    }

    public void reloadConfigFile() throws Exception {
        this.cfg_file = ConfigPath.toFile();
        if (this.cfg_file.isFile()) {
            this.inner_cfg.load(new FileInputStream(this.cfg_file));
        } else {
            this.cfg_file.createNewFile();
        }
    }

    public void save() throws Exception {
        this.inner_cfg.store(new FileOutputStream(this.cfg_file), null);
    }

    public Properties getContent() {
        return this.inner_cfg;
    }
}

