/*
 * Decompiled with CFR 0.152.
 */
package xortroll.goldleaf.quark.ui;

import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import xortroll.goldleaf.quark.Config;
import xortroll.goldleaf.quark.Version;
import xortroll.goldleaf.quark.ui.MainController;
import xortroll.goldleaf.quark.usb.USBInterface;
import xortroll.goldleaf.quark.usb.cf.Command;
import xortroll.goldleaf.quark.usb.cf.CommandFramework;
import xortroll.goldleaf.quark.usb.cmd.CommandBlock;

public class MainApplication
extends Application {
    public static final Version CurrentVersion = new Version(1, 1, 0);
    private static Config special_path_cfg;
    private static Object special_path_cfg_lock;
    private static Stage stage;
    private static Object file_selected_lock;
    private static boolean file_selected;
    private static String selected_file;
    private MainController controller;
    private Scene scene;
    private USBInterface usb_intf = null;
    private Object dialog_wait_lock = new Object();
    private boolean is_dialog_finished = false;

    private void die() {
        if (this.usb_intf != null) {
            this.usb_intf.finalize();
        }
        Platform.exit();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showOkDialogFromTask(String subtitle, String message, boolean terminate) {
        this.is_dialog_finished = false;
        Platform.runLater(() -> {
            Dialog dialog = new Dialog();
            dialog.setTitle("Quark - " + subtitle);
            dialog.setContentText(message);
            ButtonType type = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
            dialog.getDialogPane().getButtonTypes().add(type);
            dialog.showAndWait();
            if (terminate) {
                this.die();
            }
            Object object = this.dialog_wait_lock;
            synchronized (object) {
                this.is_dialog_finished = true;
            }
        });
        while (true) {
            Object object = this.dialog_wait_lock;
            synchronized (object) {
                if (this.is_dialog_finished) {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private USBInterface showUsbFailReconnectDialogFromTask(String message, boolean initial_start_silent) {
        boolean skip_dialog = initial_start_silent;
        String show_message = message;
        while (true) {
            if (!skip_dialog) {
                this.is_dialog_finished = false;
                String dialog_msg = show_message;
                Platform.runLater(() -> {
                    Dialog dialog = new Dialog();
                    dialog.setTitle("Quark - USB connection");
                    dialog.setContentText(dialog_msg);
                    dialog.getDialogPane().getButtonTypes().add(new ButtonType("Reconnect", ButtonBar.ButtonData.YES));
                    dialog.getDialogPane().getButtonTypes().add(new ButtonType("Exit", ButtonBar.ButtonData.NO));
                    dialog.showAndWait().ifPresent(ret_type -> {
                        if (ret_type.getButtonData() == ButtonBar.ButtonData.NO) {
                            this.die();
                        }
                    });
                    Object object = this.dialog_wait_lock;
                    synchronized (object) {
                        this.is_dialog_finished = true;
                    }
                });
                while (true) {
                    Object object = this.dialog_wait_lock;
                    synchronized (object) {
                        if (this.is_dialog_finished) {
                            break;
                        }
                    }
                }
            }
            skip_dialog = false;
            Optional<USBInterface> maybe_intf = USBInterface.createInterface(0);
            if (maybe_intf.isPresent()) {
                USBInterface usb_intf = maybe_intf.get();
                Version product_version = usb_intf.getProductVersion();
                boolean is_dev_version = usb_intf.isDevVersion();
                if (product_version == null) {
                    show_message = "The connection found doesn't seem to be Goldleaf";
                } else if (product_version.olderThan(CurrentVersion)) {
                    show_message = "The Goldleaf Quark connected to is outdated.\nPlease update to v" + CurrentVersion.toString() + " or higher.";
                } else {
                    if (is_dev_version) {
                        this.showOkDialogFromTask("Development version", "The connected Goldleaf (v" + product_version.toString() + ") is a development build.\nThis build might be unstable. Use it at your own risk!", false);
                    }
                    return usb_intf;
                }
                usb_intf.finalize();
                continue;
            }
            show_message = "Unable to connect via USB.";
        }
    }

    @Override
    public void start(Stage primaryStage) throws Exception {
        ClassLoader this_loader = this.getClass().getClassLoader();
        FXMLLoader loader = new FXMLLoader(this_loader.getResource("Main.fxml"));
        Pane base = (Pane)loader.load();
        special_path_cfg = new Config();
        special_path_cfg_lock = new Object();
        double width = base.getPrefWidth();
        double height = base.getPrefHeight();
        this.scene = new Scene(base, width, height);
        this.scene.getStylesheets().add(this_loader.getResource("Main.css").toExternalForm());
        this.controller = (MainController)loader.getController();
        stage = primaryStage;
        stage.getIcons().add(new Image(this_loader.getResource("Icon.png").toExternalForm()));
        stage.setTitle("Quark v" + CurrentVersion.toString() + " - Goldleaf's USB client");
        stage.setScene(this.scene);
        stage.setMinWidth(width);
        stage.setMinHeight(height);
        Task<Void> usb_task = new Task<Void>(){

            @Override
            protected Void call() throws Exception {
                USBInterface usb_intf = MainApplication.this.showUsbFailReconnectDialogFromTask("", true);
                this.updateMessage("Connected to Goldleaf v" + usb_intf.getProductVersion().toString() + (usb_intf.isDevVersion() ? " (dev build)" : "") + " - Processing USB input...");
                while (true) {
                    CommandBlock block;
                    if (!(block = new CommandBlock(usb_intf)).isValid()) {
                        usb_intf.finalize();
                        usb_intf = MainApplication.this.showUsbFailReconnectDialogFromTask("Unable to receive data from Goldleaf.", false);
                        this.updateMessage("Reconnected! Processing USB input from Goldleaf...");
                    }
                    int cmd_id = block.validateCommand();
                    boolean handled = false;
                    for (Command cmd : CommandFramework.AvailableCommands) {
                        if (cmd.getId() != cmd_id) continue;
                        cmd.handle(block);
                        handled = true;
                        break;
                    }
                    if (handled) continue;
                    usb_intf = MainApplication.this.showUsbFailReconnectDialogFromTask("An invalid command was received from Goldleaf.", false);
                    this.updateMessage("Reconnected! Processing USB input from Goldleaf...");
                }
            }
        };
        this.controller.prepare(usb_task);
        stage.show();
        Thread usb_thread = new Thread(usb_task);
        usb_thread.setDaemon(true);
        usb_thread.start();
    }

    public static Stage getStage() {
        return stage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSpecialPathCount() {
        Object object = special_path_cfg_lock;
        synchronized (object) {
            return special_path_cfg.getContent().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSpecialPath(int idx) {
        Object object = special_path_cfg_lock;
        synchronized (object) {
            Properties special_path_cnt = special_path_cfg.getContent();
            if (idx < special_path_cnt.size()) {
                int tmp_idx = 0;
                Enumeration<?> enums = special_path_cnt.propertyNames();
                while (enums.hasMoreElements()) {
                    String key = (String)enums.nextElement();
                    String value = special_path_cnt.getProperty(key);
                    if (tmp_idx == idx) {
                        return new String[]{key, value};
                    }
                    ++tmp_idx;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String selectFile() {
        Object object = file_selected_lock;
        synchronized (object) {
            file_selected = false;
            selected_file = null;
        }
        Platform.runLater(() -> {
            Object object = file_selected_lock;
            synchronized (object) {
                File tmp_file = new FileChooser().showOpenDialog(stage);
                if (tmp_file != null) {
                    selected_file = tmp_file.toString();
                }
                file_selected = true;
            }
        });
        while (true) {
            object = file_selected_lock;
            synchronized (object) {
                if (file_selected) {
                    break;
                }
            }
        }
        return selected_file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSpecialPath(String name, String path) throws Exception {
        Object object = special_path_cfg_lock;
        synchronized (object) {
            Properties special_path_cnt = special_path_cfg.getContent();
            special_path_cnt.setProperty(name, path);
            special_path_cfg.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSpecialPaths(List<String> names) throws Exception {
        Object object = special_path_cfg_lock;
        synchronized (object) {
            Properties special_path_cnt = special_path_cfg.getContent();
            for (String name : names) {
                special_path_cnt.remove(name);
            }
            special_path_cfg.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forEachSpecialPath(BiConsumer<? super Object, ? super Object> fn) throws Exception {
        Object object = special_path_cfg_lock;
        synchronized (object) {
            Properties special_path_cnt = special_path_cfg.getContent();
            special_path_cnt.forEach(fn);
        }
    }

    public static void run(String[] args) {
        Application.launch(args);
    }

    static {
        file_selected_lock = new Object();
        file_selected = false;
        selected_file = null;
    }
}

