/*
 * Decompiled with CFR 0.152.
 */
package xortroll.goldleaf.quark.ui;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.Pane;
import javafx.stage.DirectoryChooser;
import xortroll.goldleaf.quark.ui.MainApplication;

public class MainController {
    @FXML
    private Label USBStatusLabel;
    @FXML
    private Pane MainPane;
    @FXML
    private Button NewPathButton;
    @FXML
    private Button PathRemoveButton;
    @FXML
    private TextArea LogArea;
    @FXML
    private ListView<String> PathList;
    @FXML
    private ToggleButton ShowLogsToggle;
    private List<String> special_path_names;

    private void refreshConfig() throws Exception {
        this.PathList.getItems().clear();
        this.special_path_names.clear();
        MainApplication.forEachSpecialPath((name, path) -> {
            this.special_path_names.add((String)name);
            this.PathList.getItems().add(name + " (" + path + ")");
        });
    }

    public void prepare(Task<Void> usb_task) {
        this.special_path_names = new ArrayList<String>();
        try {
            this.refreshConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.NewPathButton.setOnAction(event -> {
            DirectoryChooser chooser = new DirectoryChooser();
            File dir = chooser.showDialog(MainApplication.getStage());
            if (dir != null) {
                TextInputDialog dialog = new TextInputDialog(dir.getName());
                dialog.setTitle("Quark - Add special path");
                dialog.setHeaderText("Set the special path's name\n(leave the box empty to cancel)");
                Optional result = dialog.showAndWait();
                if (result.isPresent()) {
                    String special_path_name = (String)result.get();
                    String special_path = dir.toString();
                    try {
                        MainApplication.addSpecialPath(special_path_name, special_path);
                        this.refreshConfig();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.PathRemoveButton.setOnAction(event -> {
            ObservableList<Integer> selected_path_idxs = this.PathList.getSelectionModel().getSelectedIndices();
            ArrayList<String> names_to_remove = new ArrayList<String>();
            selected_path_idxs.forEach(idx -> names_to_remove.add(this.special_path_names.get((int)idx)));
            try {
                MainApplication.removeSpecialPaths(names_to_remove);
                this.refreshConfig();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.ShowLogsToggle.setSelected(true);
        this.LogArea.visibleProperty().bind(this.ShowLogsToggle.selectedProperty());
        System.setOut(new PrintStream(new UILogger(this.LogArea)));
        this.USBStatusLabel.textProperty().bind(usb_task.messageProperty());
    }

    public class UILogger
    extends OutputStream {
        private TextArea area;

        public UILogger(TextArea area) {
            this.area = area;
        }

        public void writeString(String data) {
            Platform.runLater(() -> this.area.appendText(data));
        }

        @Override
        public void write(int b) throws IOException {
            this.writeString(String.valueOf((char)b));
        }
    }
}

