/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.FabricLoader;
import org.apache.commons.io.FileUtils;

public class CSBConfig
implements ModInitializer {
    public static boolean enabled;
    public static float red;
    public static float green;
    public static float blue;
    public static float alpha;
    public static float thickness;
    public static float blinkAlpha;
    public static float blinkSpeed;
    public static boolean disableDepthBuffer;
    public static boolean adjustBoundingBoxByLinkedBlocks;
    public static BreakAnimationType breakAnimation;
    public static boolean rainbow;
    public static File configFile;

    public void onInitialize() {
        try {
            CSBConfig.loadConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadConfig() throws IOException {
        configFile.getParentFile().mkdirs();
        String content = configFile.exists() ? FileUtils.readFileToString((File)configFile, (String)"utf-8") : "{}";
        JsonElement jsonElement = new JsonParser().parse(content);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        enabled = jsonObject.has("enabled") ? jsonObject.get("enabled").getAsBoolean() : true;
        red = jsonObject.has("colourRed") ? (float)jsonObject.get("colourRed").getAsInt() / 255.0f : 0.0f;
        green = jsonObject.has("colourGreen") ? (float)jsonObject.get("colourGreen").getAsInt() / 255.0f : 0.0f;
        blue = jsonObject.has("colourBlue") ? (float)jsonObject.get("colourBlue").getAsInt() / 255.0f : 0.0f;
        alpha = jsonObject.has("alpha") ? (float)jsonObject.get("alpha").getAsInt() / 255.0f : 1.0f;
        thickness = jsonObject.has("thickness") ? (float)jsonObject.get("thickness").getAsInt() : 4.0f;
        blinkSpeed = jsonObject.has("blinkSpeed") ? (float)jsonObject.get("blinkSpeed").getAsInt() / 100.0f : 0.2f;
        blinkAlpha = jsonObject.has("blinkAlpha") ? (float)jsonObject.get("blinkAlpha").getAsInt() / 255.0f : 0.390625f;
        disableDepthBuffer = jsonObject.has("disableDepthBuffer") ? jsonObject.get("disableDepthBuffer").getAsBoolean() : false;
        breakAnimation = jsonObject.has("breakAnimation") ? BreakAnimationType.getById(jsonObject.get("breakAnimation").getAsInt()) : BreakAnimationType.NONE;
        rainbow = jsonObject.has("rainbow") ? jsonObject.get("rainbow").getAsBoolean() : false;
        adjustBoundingBoxByLinkedBlocks = jsonObject.has("adjustBoundingBoxByLinkedBlocks") ? jsonObject.get("adjustBoundingBoxByLinkedBlocks").getAsBoolean() : false;
        CSBConfig.saveConfig();
    }

    public static void saveConfig() throws FileNotFoundException {
        JsonObject object = new JsonObject();
        object.addProperty("enabled", Boolean.valueOf(enabled));
        object.addProperty("colourRed", (Number)((int)(red * 255.0f)));
        object.addProperty("colourGreen", (Number)((int)(green * 255.0f)));
        object.addProperty("colourBlue", (Number)((int)(blue * 255.0f)));
        object.addProperty("alpha", (Number)((int)(alpha * 255.0f)));
        object.addProperty("thickness", (Number)((int)thickness));
        object.addProperty("blinkSpeed", (Number)((int)(blinkSpeed * 100.0f)));
        object.addProperty("blinkAlpha", (Number)((int)(blinkAlpha * 255.0f)));
        object.addProperty("disableDepthBuffer", Boolean.valueOf(disableDepthBuffer));
        object.addProperty("breakAnimation", (Number)breakAnimation.getId());
        object.addProperty("rainbow", Boolean.valueOf(rainbow));
        object.addProperty("adjustBoundingBoxByLinkedBlocks", Boolean.valueOf(adjustBoundingBoxByLinkedBlocks));
        if (configFile.exists()) {
            configFile.delete();
        }
        PrintWriter writer = new PrintWriter(configFile);
        writer.print(CSBConfig.objectToString(object));
        writer.close();
    }

    private static String objectToString(JsonObject object) {
        try {
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setLenient(true);
            jsonWriter.setIndent("\t");
            Streams.write((JsonElement)object, (JsonWriter)jsonWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void reset(boolean mc) throws FileNotFoundException {
        CSBConfig.setEnabled(true);
        CSBConfig.setRed(0.0f);
        CSBConfig.setGreen(0.0f);
        CSBConfig.setBlue(0.0f);
        CSBConfig.setAlpha(mc ? 0.4f : 1.0f);
        CSBConfig.setThickness(mc ? 2.0f : 4.0f);
        CSBConfig.setBlinkAlpha(mc ? 0.0f : 0.390625f);
        CSBConfig.setBlinkSpeed(0.2f);
        disableDepthBuffer = false;
        CSBConfig.setBreakAnimation(BreakAnimationType.NONE);
        CSBConfig.setIsRainbow(false);
        CSBConfig.setAdjustBoundingBoxByLinkedBlocks(false);
        CSBConfig.saveConfig();
    }

    public static boolean isAdjustBoundingBoxByLinkedBlocks() {
        return adjustBoundingBoxByLinkedBlocks;
    }

    public static void setAdjustBoundingBoxByLinkedBlocks(boolean adjustBoundingBoxByLinkedBlocks) {
        CSBConfig.adjustBoundingBoxByLinkedBlocks = adjustBoundingBoxByLinkedBlocks;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static float getRed() {
        return CSBConfig.between(red, 0.0f, 1.0f);
    }

    public static float getGreen() {
        return CSBConfig.between(green, 0.0f, 1.0f);
    }

    public static float getBlue() {
        return CSBConfig.between(blue, 0.0f, 1.0f);
    }

    public static float getAlpha() {
        return CSBConfig.between(alpha, 0.0f, 1.0f);
    }

    public static float getThickness() {
        return CSBConfig.between(thickness, 0.1f, 7.0f);
    }

    public static float getBlinkAlpha() {
        return CSBConfig.between(blinkAlpha, 0.0f, 1.0f);
    }

    public static float getBlinkSpeed() {
        return CSBConfig.between(blinkSpeed, 0.0f, 1.0f);
    }

    public static void setEnabled(boolean enabled) {
        CSBConfig.enabled = enabled;
    }

    public static void setRed(float r) {
        red = CSBConfig.between(r, 0.0f, 1.0f);
    }

    public static void setGreen(float g) {
        green = CSBConfig.between(g, 0.0f, 1.0f);
    }

    public static void setBlue(float b) {
        blue = CSBConfig.between(b, 0.0f, 1.0f);
    }

    public static void setAlpha(float a) {
        alpha = CSBConfig.between(a, 0.0f, 1.0f);
    }

    public static void setThickness(float t) {
        thickness = CSBConfig.between(t, 0.1f, 7.0f);
    }

    public static void setBlinkAlpha(float ba) {
        blinkAlpha = CSBConfig.between(ba, 0.0f, 1.0f);
    }

    public static void setBlinkSpeed(float s) {
        blinkSpeed = CSBConfig.between(s, 0.0f, 1.0f);
    }

    public static void setBreakAnimation(BreakAnimationType type) {
        breakAnimation = type;
    }

    public static void setIsRainbow(boolean b) {
        rainbow = b;
    }

    public static boolean usingRainbow() {
        return rainbow;
    }

    public static int getRedInt() {
        return Math.round(CSBConfig.getRed() * 256.0f);
    }

    public static int getGreenInt() {
        return Math.round(CSBConfig.getGreen() * 256.0f);
    }

    public static int getBlueInt() {
        return Math.round(CSBConfig.getBlue() * 256.0f);
    }

    public static int getAlphaInt() {
        return Math.round(CSBConfig.getAlpha() * 256.0f);
    }

    public static int getThicknessInt() {
        return Math.round(CSBConfig.getThickness());
    }

    public static int getBlinkAlphaInt() {
        return Math.round(CSBConfig.getBlinkAlpha() * 256.0f);
    }

    public static int getBlinkSpeedInt() {
        return Math.round(CSBConfig.getBlinkSpeed() * 100.0f);
    }

    private static float between(float i, float x, float y) {
        if (i < x) {
            i = x;
        }
        if (i > y) {
            i = y;
        }
        return i;
    }

    private static int between(int i, int x, int y) {
        if (i < x) {
            i = x;
        }
        if (i > y) {
            i = y;
        }
        return i;
    }

    static {
        configFile = new File(FabricLoader.INSTANCE.getGameDirectory(), "config" + File.separator + "CSB" + File.separator + "config.json");
    }

    public static enum BreakAnimationType {
        NONE(0, "None"),
        SHRINK(1, "Shrink"),
        DOWN(2, "Down"),
        UP(4, "Up"),
        ALPHA(3, "Alpha");

        private int id;
        private String text;

        private BreakAnimationType(int id, String text) {
            this.id = id;
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public int getId() {
            return this.id;
        }

        public static int getLargestAnimationIndex() {
            return 4;
        }

        public static BreakAnimationType getById(int id) {
            for (BreakAnimationType type : BreakAnimationType.values()) {
                if (type.getId() != id) continue;
                return type;
            }
            return null;
        }
    }
}

