/*
 * Decompiled with CFR 0.152.
 */
package com.github.draylar.ping;

import com.github.draylar.ping.config.PingConfigGson;
import com.github.draylar.ping.config.PingConfigHolder;
import com.google.gson.Gson;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.fabricmc.api.ModInitializer;

public class Ping
implements ModInitializer {
    public void onInitialize() {
        this.checkConfigFolder();
        if (!PingConfigHolder.configInstance.playPingSound && !PingConfigHolder.configInstance.highlightTriggers) {
            System.out.println("[Ping] You seriously disabled both the ping sound and highlight triggers? Really?");
        }
    }

    public void checkConfigFolder() {
        Path pingConfigPath = Paths.get(System.getProperty("user.dir") + "\\config\\ping", new String[0]);
        if (pingConfigPath.toFile().isDirectory()) {
            this.checkConfigFile(pingConfigPath);
        } else {
            pingConfigPath.toFile().mkdirs();
            this.checkConfigFile(pingConfigPath);
        }
    }

    public void checkConfigFile(Path path) {
        Path jsonPath = Paths.get(path + "\\ping.json", new String[0]);
        if (!jsonPath.toFile().exists()) {
            this.createNewFile(jsonPath);
            this.setBlankConfig(jsonPath, true);
        }
        try {
            String input = new String(Files.readAllBytes(jsonPath));
            Gson gson = new Gson();
            PingConfigHolder.configInstance = (PingConfigGson)gson.fromJson(input, PingConfigGson.class);
            if (PingConfigHolder.configInstance.pingSound == null) {
                System.out.println("[Ping] Json is invalid! Try to fix from the error, or remove config file. Rolling with defaults!");
                this.setBlankConfig(jsonPath, false);
            }
        }
        catch (Exception e) {
            System.out.println("[Ping] Json is invalid! Try to fix from the error, or remove config file. Rolling with defaults!");
            e.printStackTrace();
            this.setBlankConfig(jsonPath, false);
        }
    }

    private void setBlankConfig(Path jsonPath, boolean writeConfig) {
        PingConfigGson pc = new PingConfigGson();
        pc.textFormatName = "GOLD";
        pc.triggerStrings = new String[]{"example_filter_1", "example_filter_2"};
        pc.highlightTriggers = true;
        pc.playPingSound = true;
        pc.pingSound = "entity.experience_orb.pickup";
        PingConfigHolder.configInstance = pc;
        if (writeConfig) {
            this.writeConfigToPath(jsonPath, pc);
        }
    }

    private void writeConfigToPath(Path jsonPath, PingConfigGson config) {
        try {
            Gson gson = new Gson();
            Files.write(jsonPath, gson.toJson((Object)config).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createNewFile(Path path) {
        try {
            path.toFile().createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

