/*
 * Decompiled with CFR 0.152.
 */
package ftblag.customtooltip.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import ftblag.customtooltip.gson.CTTGson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class CTTGsonParser {
    public static CTTGson.ToolTips cfg;
    public static Map<class_1792, List<String>> tooltips;
    private static Gson gson;

    public static void parseFile(File file) {
        if (!file.exists()) {
            try {
                CTTGsonParser.createDefault(file);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            cfg = (CTTGson.ToolTips)gson.fromJson((Reader)new BufferedReader(new FileReader(file)), CTTGson.ToolTips.class);
        }
        catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
            CTTGsonParser.crashReport("Failed to load cfg!", e);
        }
        try {
            for (CTTGson.ToolTip tooltip : CTTGsonParser.cfg.tooltips) {
                String[] name = tooltip.item.split(":");
                tooltips.put((class_1792)class_2378.field_11142.method_10223(new class_2960(name[0], name[1])), tooltip.tooltip);
            }
        }
        catch (Exception e) {
            CTTGsonParser.crashReport("Failed to parse cfg!", e);
        }
    }

    private static void createDefault(File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        } else {
            file.delete();
            file.createNewFile();
        }
        CTTGson.ToolTips cfg = new CTTGson.ToolTips(Arrays.asList(new CTTGson.ToolTip("minecraft:apple", Arrays.asList("Its apple!", "With custom tooltip!")), new CTTGson.ToolTip("minecraft:stone", Arrays.asList("Its stone!", "With custom tooltip!")), new CTTGson.ToolTip("minecraft:cobblestone", Arrays.asList("Its stone!", "With custom tooltip!"))));
        try (BufferedWriter fw = new BufferedWriter(new FileWriter(file));){
            fw.write(gson.toJson((Object)cfg));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static void crashReport(String message, Throwable throwable) {
        throw new class_148(new class_128(message, throwable));
    }

    static {
        tooltips = new HashMap<class_1792, List<String>>();
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

