/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.wastelands;

import com.ezrol.terry.minecraft.wastelands.EzWastelandBlock;
import com.ezrol.terry.minecraft.wastelands.api.RegionCore;
import com.ezrol.terry.minecraft.wastelands.world.WastelandChunkGenerator;
import com.ezrol.terry.minecraft.wastelands.world.WastelandChunkGeneratorConfig;
import com.ezrol.terry.minecraft.wastelands.world.WastelandsLevelType;
import com.ezrol.terry.minecraft.wastelands.world.elements.Domes;
import com.ezrol.terry.minecraft.wastelands.world.elements.RandomOptions;
import com.ezrol.terry.minecraft.wastelands.world.elements.Shallows;
import com.ezrol.terry.minecraft.wastelands.world.elements.Spires;
import com.ezrol.terry.minecraft.wastelands.world.elements.TerrainVariation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.server.ServerStartCallback;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1821;
import net.minecraft.class_1937;
import net.minecraft.class_1942;
import net.minecraft.class_1966;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2798;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EzwastelandsFabric
implements ModInitializer {
    public static class_1942 WASTELANDS_LEVEL_TYPE = null;
    public static class_2798<WastelandChunkGeneratorConfig, WastelandChunkGenerator> WASTELANDS;
    public static class_2248 WastelandsBlock;

    public void onInitialize() {
        WASTELANDS_LEVEL_TYPE = WastelandsLevelType.getType();
        createWastelandGenerator factory = new createWastelandGenerator();
        WASTELANDS = factory.getChunkGeneratorType(WastelandChunkGeneratorConfig::new);
        class_2378.method_10226((class_2378)class_2378.field_11149, (String)"ezwastelands:wastelands", WASTELANDS);
        WastelandsBlock = new EzWastelandBlock();
        class_2378.method_10226((class_2378)class_2378.field_11146, (String)"ezwastelands:ezwastelandblock", (Object)WastelandsBlock);
        class_1747 itm = new class_1747(WastelandsBlock, new class_1792.class_1793().method_7892(class_1761.field_7931));
        class_2378.method_10226((class_2378)class_2378.field_11142, (String)"ezwastelands:ezwastelandblock", (Object)itm);
        ServerStartCallback.EVENT.register((Object)new ServerStartCallback(){

            public void onStartServer(MinecraftServer server) {
                for (class_2960 id : class_2378.field_11149.method_10235()) {
                    System.out.println(id);
                }
                for (class_1792 i : class_2378.field_11142) {
                    if (!(i instanceof class_1821)) continue;
                    ((SetEffectiveTool)i).ezAddToEfectiveToolList(WastelandsBlock);
                }
            }
        });
        new Spires();
        new Domes();
        new Shallows();
        new TerrainVariation();
        new RandomOptions();
        RegionCore.registerPreset(new class_2960("ezwastelands:presets/list.txt"));
    }

    public static interface SetEffectiveTool {
        public void ezAddToEfectiveToolList(class_2248 var1);
    }

    private class createWastelandGenerator
    implements InvocationHandler {
        private Object factoryProxy;
        private Class factoryClass;

        createWastelandGenerator() {
            String dev_name = "net.minecraft.world.gen.chunk.ChunkGeneratorFactory";
            String prod_name = "net.minecraft.class_2801";
            try {
                this.factoryClass = Class.forName(dev_name);
            }
            catch (ClassNotFoundException e1) {
                try {
                    this.factoryClass = Class.forName(prod_name);
                }
                catch (ClassNotFoundException e2) {
                    throw new RuntimeException("Unable to find " + dev_name);
                }
            }
            this.factoryProxy = Proxy.newProxyInstance(this.factoryClass.getClassLoader(), new Class[]{this.factoryClass}, (InvocationHandler)this);
        }

        public WastelandChunkGenerator createProxy(class_1937 w, class_1966 biomesource, WastelandChunkGeneratorConfig gensettings) {
            return new WastelandChunkGenerator(w, biomesource, gensettings);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args.length == 3 && args[0] instanceof class_1937 && args[1] instanceof class_1966 && args[2] instanceof WastelandChunkGeneratorConfig) {
                return this.createProxy((class_1937)args[0], (class_1966)args[1], (WastelandChunkGeneratorConfig)((Object)args[2]));
            }
            throw new UnsupportedOperationException("Unknown Method: " + method.toString());
        }

        public class_2798 getChunkGeneratorType(Supplier<WastelandChunkGeneratorConfig> supplier) {
            Constructor<?>[] initlst = class_2798.class.getDeclaredConstructors();
            Logger log = LogManager.getLogger((String)"ChunkGenErr");
            for (Constructor<?> init : initlst) {
                init.setAccessible(true);
                if (init.getParameterCount() != 3) continue;
                try {
                    return (class_2798)init.newInstance(this.factoryProxy, true, supplier);
                }
                catch (Exception e) {
                    log.error("Error in calling Chunk Generator Type", (Throwable)e);
                }
            }
            log.error("Unable to find constructor for ChunkGeneratorType");
            return null;
        }
    }
}

