/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.wastelands.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.util.List;

public class Param {
    protected ParamTypes type;
    private String name;
    private String comment;

    public Param(String name) {
        this.comment = "";
        this.name = name;
        this.type = ParamTypes.NUL;
    }

    public Param(String name, String comment) {
        this.comment = comment;
        this.name = name;
        this.type = ParamTypes.NUL;
    }

    public static Param lookUp(List<Param> lst, String name) {
        for (Param entry : lst) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public ParamTypes getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean importJson(JsonElement e) {
        return e.isJsonNull();
    }

    public JsonElement exportJson() {
        return JsonNull.INSTANCE;
    }

    public static class IntegerParam
    extends Param {
        private int defvalue;
        private int value;
        private int min;
        private int max;

        public IntegerParam(String name, String comment, int def) {
            super(name, comment);
            this.type = ParamTypes.INTEGER;
            this.defvalue = def;
            this.min = Integer.MIN_VALUE;
            this.max = Integer.MAX_VALUE;
            this.value = def;
        }

        public IntegerParam(String name, String comment, int def, int min, int max) {
            super(name, comment);
            this.type = ParamTypes.INTEGER;
            this.defvalue = def;
            this.min = min;
            this.max = max;
            this.value = def;
        }

        public int validate(int v) {
            if (v < this.min) {
                return this.defvalue;
            }
            if (v > this.max) {
                return this.defvalue;
            }
            return v;
        }

        public int getDefault() {
            return this.defvalue;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public void set(int v) {
            this.value = this.validate(v);
        }

        public int get() {
            return this.value;
        }

        @Override
        public boolean importJson(JsonElement e) {
            if (e.isJsonPrimitive()) {
                try {
                    this.set(e.getAsInt());
                    return true;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public JsonElement exportJson() {
            return new JsonPrimitive((Number)this.value);
        }
    }

    public static class FloatParam
    extends Param {
        private float defvalue;
        private float value;
        private float min;
        private float max;

        public FloatParam(String name, String comment, float def) {
            super(name, comment);
            this.type = ParamTypes.FLOAT;
            this.defvalue = def;
            this.min = Float.MIN_VALUE;
            this.max = Float.MAX_VALUE;
            this.value = def;
        }

        public FloatParam(String name, String comment, float def, float min, float max) {
            super(name, comment);
            this.type = ParamTypes.FLOAT;
            this.defvalue = def;
            this.min = min;
            this.max = max;
            this.value = def;
        }

        public float validate(float v) {
            if (v < this.min) {
                return this.defvalue;
            }
            if (v > this.max) {
                return this.defvalue;
            }
            return v;
        }

        public float getDefault() {
            return this.defvalue;
        }

        public float getMin() {
            return this.min;
        }

        public float getMax() {
            return this.max;
        }

        public void set(float v) {
            this.value = this.validate(v);
        }

        public float get() {
            return this.value;
        }

        @Override
        public boolean importJson(JsonElement e) {
            if (e.isJsonPrimitive()) {
                try {
                    this.set(e.getAsFloat());
                    return true;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public JsonElement exportJson() {
            return new JsonPrimitive((Number)Float.valueOf(this.value));
        }
    }

    public static class BooleanParam
    extends Param {
        private boolean defvalue;
        private boolean value;

        public BooleanParam(String name, String comment, boolean def) {
            super(name, comment);
            this.type = ParamTypes.BOOLEAN;
            this.defvalue = def;
            this.value = def;
        }

        public boolean validate(boolean v) {
            return v;
        }

        public boolean getDefault() {
            return this.defvalue;
        }

        public void set(boolean v) {
            this.value = this.validate(v);
        }

        public boolean get() {
            return this.value;
        }

        @Override
        public boolean importJson(JsonElement e) {
            if (e.isJsonPrimitive()) {
                try {
                    this.set(e.getAsBoolean());
                    return true;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public JsonElement exportJson() {
            return new JsonPrimitive(Boolean.valueOf(this.value));
        }
    }

    public static class StringParam
    extends Param {
        private String defvalue;
        private String value;

        public StringParam(String name, String comment, String def) {
            super(name, comment);
            this.type = ParamTypes.STRING;
            this.defvalue = def;
            this.value = def;
        }

        public String validate(String v) {
            if (v == null || v.equals("")) {
                return this.defvalue;
            }
            return v;
        }

        public String getDefault() {
            return this.defvalue;
        }

        public void set(String v) {
            this.value = this.validate(v);
        }

        public String get() {
            return this.value;
        }

        @Override
        public boolean importJson(JsonElement e) {
            if (e.isJsonPrimitive()) {
                try {
                    this.set(e.getAsString());
                    return true;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public JsonElement exportJson() {
            return new JsonPrimitive(this.value);
        }
    }

    public static enum ParamTypes {
        INTEGER,
        FLOAT,
        BOOLEAN,
        STRING,
        NUL;

    }
}

