/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.wastelands.api;

import com.ezrol.terry.minecraft.wastelands.api.IRegionElement;
import com.ezrol.terry.minecraft.wastelands.api.Param;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.class_1311;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3485;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegionCore {
    public static final int WASTELAND_HEIGHT = 52;
    private static LinkedList<IRegionElement> mainFeatures = new LinkedList();
    private static LinkedList<IRegionElement> overrideFeatures = new LinkedList();
    private static Logger log = LogManager.getLogger((String)"RegionCore");
    private static LinkedList<class_2960> presets = new LinkedList();
    private static LinkedList<class_2975> features = new LinkedList();
    private Map<String, List<Param>> elementParams = new HashMap<String, List<Param>>(mainFeatures.size() + overrideFeatures.size());
    private int cachedX = 0;
    private int cachedZ = 0;
    private Map<String, List<Object>> cachedElements = null;
    private class_1937 ourWorld;
    private class_2794 chunkgen;

    public class_2794 getChunkGen() {
        return this.chunkgen;
    }

    public RegionCore(String properties, class_1937 w, class_2794 gen) {
        this.ourWorld = w;
        this.chunkgen = gen;
        FeatureIterator i = new FeatureIterator();
        while (i.hasNext()) {
            IRegionElement element = (IRegionElement)i.next();
            this.elementParams.put(element.getElementName(), element.getParamTemplate());
        }
        if (properties != null && !properties.equals("")) {
            this.importJson(properties);
        }
    }

    public static void register(IRegionElement element) {
        RegionCore.register(element, false);
    }

    public static void register(IRegionElement element, boolean isOverride) {
        if (isOverride) {
            overrideFeatures.add(element);
        } else {
            mainFeatures.add(element);
        }
    }

    public static void register(IRegionElement element, boolean isOverride, class_2975[] features) {
        RegionCore.register(element, isOverride);
        RegionCore.features.addAll(Arrays.asList(features));
    }

    public static List<class_2975> getFeatureLst() {
        return Collections.unmodifiableList(features);
    }

    public static void registerPreset(class_2960 p) {
        presets.add(p);
    }

    public static List<class_2960> getPresetLocations() {
        return Collections.unmodifiableList(presets);
    }

    public Map<String, List<Param>> getCurrentParamMap() {
        return this.elementParams;
    }

    public boolean isStructuresEnabled() {
        return this.ourWorld != null && this.chunkgen != null && this.ourWorld.method_8401().method_220();
    }

    public List<Param> getElementParams(IRegionElement e) {
        return this.elementParams.get(e.getElementName());
    }

    public Param lookupParam(IRegionElement e, String name) {
        List<Param> eParam = this.getElementParams(e);
        if (eParam != null) {
            return Param.lookUp(eParam, name);
        }
        return null;
    }

    private Random regionRandom(int x, int z, long seed) {
        long localSeed = ((long)(x >>= 6) << 26) + ((long)(z >>= 6) << 2);
        localSeed ^= seed;
        Random r = new Random(localSeed += 2791L);
        r.nextInt();
        r.nextInt();
        return r;
    }

    private synchronized Map<String, List<Object>> getRegionElements(int x, int z, long seed) {
        if (this.cachedElements != null && this.cachedX == x >> 6 && this.cachedZ == z >> 6) {
            return this.cachedElements;
        }
        this.cachedElements = new HashMap<String, List<Object>>(mainFeatures.size() + overrideFeatures.size());
        for (int localX = -128; localX <= 128; localX += 64) {
            for (int localZ = -128; localZ <= 128; localZ += 64) {
                Random rand = this.regionRandom(localX + x, localZ + z, seed);
                FeatureIterator i = new FeatureIterator();
                while (i.hasNext()) {
                    IRegionElement element = (IRegionElement)i.next();
                    String elementName = element.getElementName();
                    List<Object> current = this.cachedElements.containsKey(elementName) ? this.cachedElements.get(elementName) : new ArrayList<Object>();
                    current.addAll(element.calcElements(rand, localX + x >> 6, localZ + z >> 6, this));
                    this.cachedElements.put(elementName, current);
                }
            }
        }
        this.cachedX = x >> 6;
        this.cachedZ = z >> 6;
        return this.cachedElements;
    }

    public class_1937 getWorld() {
        return this.ourWorld;
    }

    public List<Object> getRegionElements(int x, int z, IRegionElement e) {
        Map<String, List<Object>> worldElements = this.getRegionElements(x, z, this.ourWorld.method_8412());
        return worldElements.get(e.getElementName());
    }

    public int addElementHeight(int x, int z) {
        return RegionCore.forEachElement((e, h) -> e.addElementHeight((int)h, x, z, this, this.getRegionElements(x, z, (IRegionElement)e)), 52);
    }

    public void postPointFill(class_2791 chunk, int height, int x, int z) {
        RegionCore.forEachElement((e, nop) -> {
            e.postFill(chunk, height, x, z, this);
            return nop;
        }, null);
    }

    public void additionalTriggers(String event, class_1923 chunkCord, class_2791 chunk, class_3485 resources) {
        RegionCore.forEachElement((e, nop) -> {
            e.additionalTriggers(event, chunkCord, chunk, resources, this);
            return nop;
        }, null);
    }

    public boolean hasStructure(String name) {
        return RegionCore.forEachElement((e, found) -> found != false || e.hasStructure(name, this), false);
    }

    public class_2338 getNearestStructure(String name, class_2338 curPos, int tries, boolean findUnexplored) {
        return RegionCore.forEachElement((e, p) -> {
            class_2338 pos = e.getNearestStructure(name, curPos, tries, findUnexplored, this);
            if (pos == null) {
                return p;
            }
            if (p == null) {
                return pos;
            }
            if (curPos.method_10262((class_2382)p) > curPos.method_10262((class_2382)pos)) {
                return pos;
            }
            return p;
        }, null);
    }

    public String getJson() {
        JsonObject root = new JsonObject();
        for (String key : this.elementParams.keySet()) {
            List<Param> element = this.elementParams.get(key);
            JsonObject elementObj = new JsonObject();
            for (Param p : element) {
                elementObj.add(p.getName(), p.exportJson());
            }
            root.add(key, (JsonElement)elementObj);
        }
        String json = root.toString();
        json = json.replace("\n", "");
        return json;
    }

    private void importJson(String json) {
        JsonParser parser = new JsonParser();
        JsonElement tree = null;
        try {
            tree = parser.parse(json);
            if (!tree.isJsonObject()) {
                tree = null;
            }
        }
        catch (JsonSyntaxException e) {
            log.error("Error reading world json, using default");
            log.error(e.toString());
        }
        if (tree != null) {
            FeatureIterator i = new FeatureIterator();
            while (i.hasNext()) {
                IRegionElement element = (IRegionElement)i.next();
                String elementName = element.getElementName();
                if (!((JsonObject)tree).has(elementName)) {
                    log.warn(String.format("Missing params for \"%s,\" using defaults", elementName));
                    continue;
                }
                JsonElement configParams = ((JsonObject)tree).get(elementName);
                if (!configParams.isJsonObject()) {
                    log.error("Expected JsonObject for " + elementName);
                    continue;
                }
                for (Param p : this.elementParams.get(elementName)) {
                    JsonElement configParam = ((JsonObject)configParams).get(p.getName());
                    if (configParam == null) continue;
                    p.importJson(configParam);
                }
            }
        }
    }

    public List<class_1959.class_1964> getSpawnable(List<class_1959.class_1964> spawnableList, class_1311 creatureType, class_2338 pos) {
        return RegionCore.forEachElement((e, lst) -> e.getSpawnable((List<class_1959.class_1964>)lst, creatureType, pos, this), new ArrayList<class_1959.class_1964>(spawnableList));
    }

    public int getWorldHeight(int x, int starth, int z) {
        return RegionCore.forEachElement((e, h) -> e.getWorldHeight((int)h, x, z, this), starth);
    }

    private static <RVAL> RVAL forEachElement(BiFunction<IRegionElement, RVAL, RVAL> op, RVAL initial) {
        RVAL current = initial;
        FeatureIterator itr = new FeatureIterator();
        while (itr.hasNext()) {
            current = op.apply((IRegionElement)itr.next(), current);
        }
        return current;
    }

    static /* synthetic */ LinkedList access$100() {
        return mainFeatures;
    }

    private static class FeatureIterator
    implements Iterator<IRegionElement> {
        private boolean main = true;
        private Iterator<IRegionElement> par = RegionCore.access$100().iterator();

        private FeatureIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.par.hasNext()) {
                return true;
            }
            if (this.main) {
                this.main = false;
                this.par = overrideFeatures.iterator();
                return this.par.hasNext();
            }
            return false;
        }

        @Override
        public IRegionElement next() {
            if (this.main) {
                try {
                    return this.par.next();
                }
                catch (NoSuchElementException e) {
                    this.main = false;
                    this.par = overrideFeatures.iterator();
                }
            }
            return this.par.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

