/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.wastelands.gui;

import com.ezrol.terry.minecraft.wastelands.api.RegionCore;
import com.ezrol.terry.minecraft.wastelands.gui.WastelandCustomization;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_358;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WastelandPresets
extends class_437 {
    private static final int CANCEL_BTN_ID = 80;
    private static final int SELECT_BTN_ID = 81;
    private static final int PRESET_INPUT_BOX = 82;
    private static final Logger log = LogManager.getLogger((String)"WastelandPreset");
    private WastelandCustomization parent;
    private String currentJson = "";
    private String title = "Presets";
    private class_342 presetInput = null;
    private PresetSlotList listGUI;

    public WastelandPresets(WastelandCustomization par, String json) {
        this.parent = par;
        this.currentJson = json;
    }

    private String readpresetline(BufferedReader stream) throws IOException {
        String line;
        while (true) {
            if ((line = stream.readLine()) == null) {
                return null;
            }
            line = line.trim();
            log.info("checking line: '" + line + "'");
            if (line.equals("")) {
                log.info("line is empty");
                continue;
            }
            if (!line.startsWith("#")) break;
            log.info("line is comment");
        }
        log.info("line accepted");
        return line;
    }

    private void insertPresets(class_2960 r) {
        BufferedReader presetdata;
        class_3300 resourceManager = this.field_2563.method_1478();
        try {
            class_3298 presetlist = resourceManager.method_14486(r);
            presetdata = new BufferedReader(new InputStreamReader(presetlist.method_14482(), "UTF-8"));
        }
        catch (IOException e) {
            log.error("Could not find resource for presets");
            return;
        }
        try {
            while (true) {
                String title = this.readpresetline(presetdata);
                String icon = this.readpresetline(presetdata);
                String preset = this.readpresetline(presetdata);
                if (title == null) break;
                if (icon == null || preset == null) {
                    log.error("Invalid preset: " + title);
                    break;
                }
                log.info("reading preset: " + title);
                log.info("  icon = " + icon);
                log.info("  preset = " + preset);
                this.listGUI.addItemToList(new WastelandPresetEntry(class_1074.method_4662((String)title, (Object[])new Object[0]), new class_2960(icon), preset));
            }
        }
        catch (IOException e) {
            log.error("Error reading in presets");
        }
    }

    public void method_2224() {
        this.field_2564.clear();
        this.field_2563.field_1774.method_1462(true);
        this.title = class_1074.method_4662((String)"config.ezwastelands.presets.title", (Object[])new Object[0]);
        this.presetInput = new class_342(82, this.field_2554, 50, 40, this.field_2561 - 100, 20);
        this.presetInput.method_1880(2048);
        this.presetInput.method_1852(this.currentJson);
        this.presetInput.method_1863(this::setEntryValue);
        this.field_2557.add(this.presetInput);
        this.listGUI = new PresetSlotList(this.field_2563, this.field_2561, this.field_2559, 80, this.field_2559 - 32, 36);
        this.field_2557.add(this.listGUI);
        for (class_2960 p : RegionCore.getPresetLocations()) {
            this.insertPresets(p);
        }
        this.method_2219(new SimpleButton(81, this.field_2561 / 2 - 155, this.field_2559 - 28, 150, 20, class_1074.method_4662((String)"config.ezwastelands.BTNSelect", (Object[])new Object[0])));
        this.method_2219(new SimpleButton(80, this.field_2561 / 2 + 5, this.field_2559 - 28, 150, 20, class_1074.method_4662((String)"config.ezwastelands.BTNCancel", (Object[])new Object[0])));
        this.method_1973((class_364)this.listGUI);
    }

    public boolean method_16890() {
        return false;
    }

    public void method_2214(int mouseX, int mouseY, float partialTicks) {
        this.method_2240();
        this.listGUI.method_1930(mouseX, mouseY, partialTicks);
        this.method_1789(this.field_2554, this.title, this.field_2561 / 2, 8, 0xFFFFFF);
        this.presetInput.method_1857(mouseX, mouseY, partialTicks);
        super.method_2214(mouseX, mouseY, partialTicks);
    }

    protected void actionPerformed(class_339 button) {
        if (button.field_2077 == 81) {
            this.parent.updateFromJson(this.currentJson);
            this.field_2563.method_1507((class_437)this.parent);
        } else if (button.field_2077 == 80) {
            this.field_2563.method_1507((class_437)this.parent);
        }
    }

    public void setEntryValue(int id, String value) {
        if (id == 82) {
            this.currentJson = value;
            if (!this.listGUI.selectedJson.equals(value)) {
                this.listGUI.selected = -1;
                this.listGUI.selectedJson = "";
            }
        }
    }

    private class PresetSlotList
    extends class_358 {
        private int selected;
        private List<WastelandPresetEntry> selectionList;
        private String selectedJson;

        private PresetSlotList(class_310 mc, int width, int height, int topOff, int bottomOff, int slotHight) {
            super(mc, width, height, topOff, bottomOff, slotHight);
            this.selectionList = new LinkedList<WastelandPresetEntry>();
            this.selectedJson = "";
            this.selected = -1;
        }

        protected int method_1947() {
            return this.selectionList.size();
        }

        protected void addItemToList(WastelandPresetEntry entry) {
            this.selectionList.add(entry);
            if (entry.json.equals(WastelandPresets.this.currentJson)) {
                this.selected = this.selectionList.size() - 1;
                this.selectedJson = entry.json;
            }
        }

        protected boolean method_1937(int entry, int unk1, double unk2, double unk3) {
            WastelandPresets.this.method_1973((class_364)WastelandPresets.this.listGUI);
            if (entry < 0 || entry == this.selected) {
                return false;
            }
            this.selected = entry;
            if (this.selected < this.method_1947()) {
                this.selectedJson = this.selectionList.get((int)this.selected).json;
                WastelandPresets.this.currentJson = this.selectedJson;
                WastelandPresets.this.presetInput.method_1852(WastelandPresets.this.currentJson);
                return true;
            }
            return false;
        }

        protected boolean method_1955(int slotIndex) {
            return slotIndex == this.selected;
        }

        protected void method_1936() {
        }

        private void blitIcon(int xPos, int yPos, class_2960 icon) {
            this.method_1783((xPos += 5) - 1, xPos + 32, yPos - 1, -2039584);
            this.method_1783(xPos - 1, xPos + 32, yPos + 32, -6250336);
            this.method_1787(xPos - 1, yPos - 1, yPos + 32, -2039584);
            this.method_1787(xPos + 32, yPos - 1, yPos + 32, -6250336);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_2164.method_1531().method_4618(icon);
            try {
                class_289 tessellator = class_289.method_1348();
                class_287 bufferbuilder = tessellator.method_1349();
                bufferbuilder.method_1328(7, class_290.field_1585);
                bufferbuilder.method_1315((double)(xPos + 0), (double)(yPos + 32), 0.0).method_1312(0.0, 1.0).method_1344();
                bufferbuilder.method_1315((double)(xPos + 32), (double)(yPos + 32), 0.0).method_1312(1.0, 1.0).method_1344();
                bufferbuilder.method_1315((double)(xPos + 32), (double)(yPos + 0), 0.0).method_1312(1.0, 0.0).method_1344();
                bufferbuilder.method_1315((double)(xPos + 0), (double)(yPos + 0), 0.0).method_1312(0.0, 0.0).method_1344();
                tessellator.method_1350();
            }
            catch (Exception e) {
                log.error("Unable to draw icon: ", (Throwable)e);
            }
        }

        protected void method_1935(int entryID, int insideLeft, int yPos, int insideSlotHeight, int mouseXIn, int mouseYIn, float partialTicks) {
            this.drawSlot(entryID, insideLeft, yPos, insideSlotHeight);
        }

        private void drawSlot(int entryID, int insideLeft, int yPos, int insideSlotHeight) {
            int fontcolor = 0xFFFFFF;
            WastelandPresetEntry entry = this.selectionList.get(entryID);
            this.blitIcon(insideLeft + 1, yPos, entry.texture);
            if (this.selected == entryID) {
                fontcolor = 0xFFFFCC;
            }
            WastelandPresets.this.field_2554.method_1729(entry.title, (float)(insideLeft + 33 + 10), (float)(yPos + (insideSlotHeight / 2 - 4)), fontcolor);
        }
    }

    private class WastelandPresetEntry {
        String json;
        String title;
        class_2960 texture;

        private WastelandPresetEntry(String title, class_2960 icon, String json) {
            this.json = json;
            this.title = title;
            this.texture = icon;
        }
    }

    private class SimpleButton
    extends class_339 {
        public SimpleButton(int id, int x, int y, int width, int height, String text) {
            super(id, x, y, width, height, text);
        }

        public void method_1826(double double_1, double double_2) {
            super.method_1826(double_1, double_2);
            WastelandPresets.this.actionPerformed(this);
        }
    }
}

