/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.wastelands.mixin;

import com.ezrol.terry.minecraft.wastelands.EzwastelandsFabric;
import com.ezrol.terry.minecraft.wastelands.api.RegionCore;
import com.ezrol.terry.minecraft.wastelands.world.WastelandChunkGenerator;
import com.ezrol.terry.minecraft.wastelands.world.WastelandChunkGeneratorConfig;
import com.ezrol.terry.minecraft.wastelands.world.WastelandsBiomeSource;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_1942;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1969;
import net.minecraft.class_1972;
import net.minecraft.class_1991;
import net.minecraft.class_1992;
import net.minecraft.class_2084;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2798;
import net.minecraft.class_2869;
import net.minecraft.class_2874;
import net.minecraft.class_2878;
import net.minecraft.class_2888;
import net.minecraft.class_2906;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2878.class})
public abstract class CommonMixinOverworldDimension
extends class_2869 {
    private static final Logger LOGGER = LogManager.getLogger((String)"ChunkGenType");

    public CommonMixinOverworldDimension(class_1937 world_1, class_2874 dimensionType_1) {
        super(world_1, dimensionType_1);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/gen/chunk/ChunkGeneratorType;createSettings()Lnet/minecraft/world/gen/chunk/ChunkGeneratorConfig;")}, method={"createChunkGenerator"}, cancellable=true)
    public void createChunkGenerator(CallbackInfoReturnable ci) {
        class_1942 type = this.field_13058.method_8401().method_153();
        class_2798<WastelandChunkGeneratorConfig, WastelandChunkGenerator> ezwastelands = EzwastelandsFabric.WASTELANDS;
        if (type == EzwastelandsFabric.WASTELANDS_LEVEL_TYPE) {
            LOGGER.info("Use wastelands generator");
            class_2487 opts = this.field_13058.method_8401().method_169();
            WastelandChunkGeneratorConfig settings = new WastelandChunkGeneratorConfig(opts);
            class_2084 biomeSrcCfg = ((class_2084)class_1969.field_9402.method_8774()).method_9004(new class_2906()).method_9002(this.field_13058.method_8401());
            settings.initBuffet(false);
            ci.setReturnValue((Object)ezwastelands.create(this.field_13058, (class_1966)new WastelandsBiomeSource(biomeSrcCfg, settings), (class_2888)settings));
        }
        if (type == class_1942.field_9275) {
            JsonElement rootElement = (JsonElement)Dynamic.convert((DynamicOps)class_2509.field_11560, (DynamicOps)JsonOps.INSTANCE, (Object)this.field_13058.method_8401().method_169());
            JsonObject rootObj = rootElement.getAsJsonObject();
            String generator = "unknown";
            LOGGER.info("testing:  " + rootObj.toString());
            try {
                generator = rootObj.getAsJsonObject("chunk_generator").getAsJsonPrimitive("type").getAsString();
            }
            catch (Exception e) {
                return;
            }
            if (generator.equals("ezwastelands:wastelands")) {
                String json = "{\"terrainvariation\":{\"amplification\":30,\"variation\":1},\"randopts\":{\"oceans\":false,\"oceanblock\":\"minecraft:water\",\"globaloffset\":0,\"villages\":false,\"villagechance\":10.0,\"strongholds\":false},\"domes\":{\"lgmincount\":3,\"lgmaxcount\":4,\"lgradius\":34,\"lgheight\":7,\"midmincount\":2,\"midmaxcount\":3,\"midradius\":23,\"midheight\":8,\"smmincount\":1,\"smmaxcount\":2,\"smradius\":18,\"smheight\":9},\"shallows\":{\"mincount\":4,\"maxcount\":5,\"radius\":42,\"depth\":5},\"spire\":{\"count\":2,\"size\":6}}";
                class_2487 tags = WastelandChunkGeneratorConfig.CoreConfigToCompound(new RegionCore(json, null, null));
                WastelandChunkGeneratorConfig settings = new WastelandChunkGeneratorConfig(tags);
                settings.initBuffet(true);
                class_1959 singlebiome = class_1972.field_9470;
                try {
                    String biomename = rootObj.getAsJsonObject("biome_source").getAsJsonObject().getAsJsonObject("options").getAsJsonArray("biomes").get(0).getAsString();
                    singlebiome = (class_1959)class_2378.field_11153.method_10223(new class_2960(biomename));
                }
                catch (Exception e) {
                    LOGGER.error("Unable to parse biome from Buffet typo");
                }
                class_1991 fixedCfg = new class_1991();
                fixedCfg.method_8782(singlebiome);
                ci.setReturnValue((Object)ezwastelands.create(this.field_13058, (class_1966)new class_1992(fixedCfg), (class_2888)settings));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getTopSpawningBlockPosition"}, cancellable=true)
    public void playerSpawnTopBlock(int blockx, int blockz, boolean force, CallbackInfoReturnable ci) {
        class_1942 type = this.field_13058.method_8401().method_153();
        if (type == EzwastelandsFabric.WASTELANDS_LEVEL_TYPE) {
            WastelandChunkGenerator gen = (WastelandChunkGenerator)this.field_13058.method_8398().method_12129();
            ci.setReturnValue((Object)gen.verifySpawn(blockx, blockz, force));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public float method_12455() {
        class_1942 type = this.field_13058.method_8401().method_153();
        if (type == EzwastelandsFabric.WASTELANDS_LEVEL_TYPE) {
            return 200.0f;
        }
        return super.method_12455();
    }
}

