/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.wastelands.world;

import com.ezrol.terry.minecraft.wastelands.EzwastelandsFabric;
import com.ezrol.terry.minecraft.wastelands.api.RegionCore;
import com.ezrol.terry.minecraft.wastelands.world.WastelandChunkGeneratorConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1311;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2888;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2975;
import net.minecraft.class_3233;
import net.minecraft.class_3485;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WastelandChunkGenerator
extends class_2794<WastelandChunkGeneratorConfig> {
    private RegionCore core;
    private static Logger log = LogManager.getLogger((String)"WastelandChunkGenerator");

    public WastelandChunkGenerator(class_1937 world, class_1966 biomeGen, WastelandChunkGeneratorConfig config) {
        super((class_1936)world, biomeGen, (class_2888)config);
        this.core = new RegionCore(config.getGeneratorJson(), world, this);
        config.assignCore(this.core);
    }

    public class_2338 verifySpawn(int blockx, int blockz, boolean scan) {
        class_2338.class_2339 pos = new class_2338.class_2339(blockx, 0, blockz);
        pos.method_10099(this.core.addElementHeight(blockx, blockz));
        int scanstart = Math.min(pos.method_10264(), 52);
        if (scan && pos.method_10264() <= 52) {
            return null;
        }
        class_2791 chunk = this.core.getWorld().method_8392(blockx >> 4, blockz >> 4);
        class_2248 block = chunk.method_8320((class_2338)pos).method_11614();
        if (block != EzwastelandsFabric.WastelandsBlock) {
            log.info("no wasteland block");
            if (scan) {
                return null;
            }
        }
        pos.method_10099(scanstart);
        block = chunk.method_8320((class_2338)pos).method_11614();
        while (block != class_2246.field_10124) {
            if (block == class_2246.field_10164) {
                return null;
            }
            if (pos.method_10264() == 255) {
                return null;
            }
            pos.method_10099(1 + pos.method_10264());
            block = chunk.method_8320((class_2338)pos).method_11614();
        }
        return pos;
    }

    public void method_12108(class_2791 chunk, class_2893.class_2894 carver) {
        if (((WastelandChunkGeneratorConfig)this.field_16567).buffetGen()) {
            super.method_12108(chunk, carver);
        }
    }

    public class_2338 method_12103(class_1937 world_1, String name, class_2338 pos, int tries, boolean unexplored) {
        class_2338 b = this.core.getNearestStructure(name, pos, tries, unexplored);
        if (b == null && ((WastelandChunkGeneratorConfig)this.field_16567).buffetGen()) {
            b = super.method_12103(world_1, name, pos, tries, unexplored);
        }
        return b;
    }

    private Random chunkBasedRNG(class_1923 p, long seed) {
        long x = p.field_9181;
        long z = p.field_9180;
        long localSeed = (x << 32) + z * 31L;
        localSeed ^= seed;
        Random r = new Random(localSeed += 5147L);
        r.nextInt();
        r.nextInt();
        return r;
    }

    public void method_12102(class_3233 region) {
        class_1923 pos = new class_1923(region.method_14336(), region.method_14339());
        int blockx = pos.field_9181 * 16;
        int blockz = pos.field_9180 * 16;
        class_2338 chunkCorner = new class_2338(blockx, 0, blockz);
        Random rng = this.chunkBasedRNG(pos, region.method_8412());
        for (class_2975 configuredFeature : RegionCore.getFeatureLst()) {
            configuredFeature.method_12862((class_1936)region, (class_2794)this, rng, chunkCorner);
        }
        class_2791 c = region.method_8392(pos.field_9181, pos.field_9180);
        this.core.additionalTriggers("featuresgen", c.method_12004(), c, null);
        if (((WastelandChunkGeneratorConfig)this.field_16567).buffetGen()) {
            super.method_12102(region);
        }
    }

    public void method_12107(class_3233 region) {
        super.method_12107(region);
    }

    public void method_16129(class_2791 chunk, class_2794<?> chunkGenerator, class_3485 resources) {
        this.core.additionalTriggers("structure_start", chunk.method_12004(), chunk, resources);
        if (((WastelandChunkGeneratorConfig)this.field_16567).buffetGen()) {
            super.method_16129(chunk, chunkGenerator, resources);
        }
    }

    public List<class_1959.class_1964> method_12113(class_1311 entityCategory_1, class_2338 blockPos_1) {
        return this.core.getSpawnable(super.method_12113(entityCategory_1, blockPos_1), entityCategory_1, blockPos_1);
    }

    public void method_12110(class_2791 chunk) {
        this.core.additionalTriggers("surfacecleanup", chunk.method_12004(), chunk, null);
    }

    public void method_12088(class_1936 iWorld, class_2791 chunk) {
        class_1923 pos = chunk.method_12004();
        int p_x = pos.field_9181;
        int p_z = pos.field_9180;
        class_2680 bedrock = class_2246.field_9987.method_9564();
        class_2680 wastelandblock = EzwastelandsFabric.WastelandsBlock.method_9564();
        class_2902 heights = chunk.method_12032(class_2902.class_2903.field_13194);
        class_2902 heights_ocean = chunk.method_12032(class_2902.class_2903.field_13195);
        boolean buffetgen = ((WastelandChunkGeneratorConfig)this.field_16567).buffetGen();
        class_2680 blocksubsurface = wastelandblock;
        class_2680 blocktop = wastelandblock;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height = this.core.addElementHeight(x + p_x * 16, z + p_z * 16);
                if (buffetgen) {
                    class_1959 curBiome = chunk.method_16552(new class_2338(x, height, z));
                    blocksubsurface = curBiome.method_8722().method_15336();
                    blocktop = curBiome.method_8722().method_15337();
                }
                for (int y = 0; y < 256; ++y) {
                    class_2680 block = null;
                    if (y <= 1) {
                        block = bedrock;
                    }
                    if (y == 1 && (p_x + x + (p_z + z)) % 3 == 0) {
                        block = wastelandblock;
                    }
                    if (y > 1 && y <= height) {
                        block = wastelandblock;
                        if (buffetgen) {
                            if (y > height - 3) {
                                block = blocksubsurface;
                            }
                            if (y == height) {
                                block = blocktop;
                            }
                        }
                    }
                    if (block == null) continue;
                    chunk.method_12010(new class_2338(x, y, z), block, false);
                }
                heights.method_12597(x, height, z, wastelandblock);
                heights_ocean.method_12597(x, height, z, wastelandblock);
                this.core.postPointFill(chunk, height, x + p_x * 16, z + p_z * 16);
            }
        }
        this.core.additionalTriggers("chunkcleanup", pos, chunk, null);
    }

    public int method_16397(int x, int z, class_2902.class_2903 type) {
        int h = this.core.addElementHeight(x, z) + 1;
        return this.core.getWorldHeight(x, h, z);
    }

    public int method_16398() {
        return 52;
    }

    public int method_12100() {
        class_2791 chunk = this.field_12760.method_8392(0, 0);
        return chunk.method_12005(class_2902.class_2903.field_13197, 8, 8);
    }
}

