/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.wastelands.world.elements;

import com.ezrol.terry.minecraft.wastelands.api.AbstractElement;
import com.ezrol.terry.minecraft.wastelands.api.Param;
import com.ezrol.terry.minecraft.wastelands.api.RegionCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Domes
extends AbstractElement {
    @Override
    public int addElementHeight(int currentoffset, int x, int z, RegionCore core, List<Object> elements) {
        for (Object obj : elements) {
            float distz;
            poi dome = (poi)obj;
            float distx = x - dome.x;
            float dist = (float)Math.sqrt(distx * distx + (distz = (float)(z - dome.z)) * distz);
            if (!(dist < (float)dome.radius)) continue;
            if ((double)dist < 0.09) {
                currentoffset += dome.height;
                continue;
            }
            currentoffset += (int)((double)(-1.0f * (dist - (float)dome.radius) / (float)dome.radius * (float)dome.height) + 0.5);
        }
        return currentoffset;
    }

    @Override
    public String getElementName() {
        return "domes";
    }

    @Override
    public List<Param> getParamTemplate() {
        ArrayList<Param> lst = new ArrayList<Param>();
        lst.add(new Param.IntegerParam("lgmincount", "config.ezwastelands.domes.lgmincount.help", 3, 0, 24));
        lst.add(new Param.IntegerParam("lgmaxcount", "config.ezwastelands.domes.lgmaxcount.help", 4, 0, 24));
        lst.add(new Param.IntegerParam("lgradius", "config.ezwastelands.domes.lgradius.help", 34, 5, 64));
        lst.add(new Param.IntegerParam("lgheight", "config.ezwastelands.domes.lgheight.help", 7, 3, 16));
        lst.add(new Param.IntegerParam("midmincount", "config.ezwastelands.domes.midmincount.help", 2, 0, 24));
        lst.add(new Param.IntegerParam("midmaxcount", "config.ezwastelands.domes.midmaxcount.help", 3, 0, 24));
        lst.add(new Param.IntegerParam("midradius", "config.ezwastelands.domes.midradius.help", 23, 4, 48));
        lst.add(new Param.IntegerParam("midheight", "config.ezwastelands.domes.midheight.help", 8, 3, 16));
        lst.add(new Param.IntegerParam("smmincount", "config.ezwastelands.domes.smmincount.help", 1, 0, 24));
        lst.add(new Param.IntegerParam("smmaxcount", "config.ezwastelands.domes.smmaxcount.help", 2, 0, 24));
        lst.add(new Param.IntegerParam("smradius", "config.ezwastelands.domes.smradius.help", 18, 3, 32));
        lst.add(new Param.IntegerParam("smheight", "config.ezwastelands.domes.smheight.help", 9, 3, 16));
        return lst;
    }

    private void appendDomes(List<Object> lst, Random r, int x, int z, int minradius, int maxradius, int height, int count) {
        for (int i = 0; i < count; ++i) {
            poi dome = new poi();
            dome.x = r.nextInt(64) + (x << 6);
            dome.z = r.nextInt(64) + (z << 6);
            if (maxradius <= minradius) {
                dome.radius = minradius;
            } else {
                dome.radius = r.nextInt(maxradius - minradius) + minradius;
            }
            dome.height = r.nextInt(height);
            lst.add(dome);
        }
    }

    @Override
    public List<Object> calcElements(Random r, int x, int z, RegionCore core) {
        ArrayList<Object> elements = new ArrayList<Object>();
        int i = ((Param.IntegerParam)core.lookupParam(this, "lgmincount")).get();
        int cnt = ((Param.IntegerParam)core.lookupParam(this, "lgmaxcount")).get();
        if (cnt > i) {
            cnt = i + r.nextInt(cnt - i);
        }
        this.appendDomes(elements, r, x, z, 4, ((Param.IntegerParam)core.lookupParam(this, "lgradius")).get(), ((Param.IntegerParam)core.lookupParam(this, "lgheight")).get(), cnt);
        i = ((Param.IntegerParam)core.lookupParam(this, "midmincount")).get();
        cnt = ((Param.IntegerParam)core.lookupParam(this, "midmaxcount")).get();
        if (cnt > i) {
            cnt = i + r.nextInt(cnt - i);
        }
        this.appendDomes(elements, r, x, z, 3, ((Param.IntegerParam)core.lookupParam(this, "midradius")).get(), ((Param.IntegerParam)core.lookupParam(this, "midheight")).get(), cnt);
        i = ((Param.IntegerParam)core.lookupParam(this, "smmincount")).get();
        cnt = ((Param.IntegerParam)core.lookupParam(this, "smmaxcount")).get();
        if (cnt > i) {
            cnt = i + r.nextInt(cnt - i);
        }
        this.appendDomes(elements, r, x, z, 2, ((Param.IntegerParam)core.lookupParam(this, "smradius")).get(), ((Param.IntegerParam)core.lookupParam(this, "smheight")).get(), cnt);
        return elements;
    }

    private class poi {
        private int x;
        private int z;
        private int radius;
        private int height;

        private poi() {
        }
    }
}

