/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.wastelands.world.elements;

import com.ezrol.terry.minecraft.wastelands.api.IRegionElement;
import com.ezrol.terry.minecraft.wastelands.api.Param;
import com.ezrol.terry.minecraft.wastelands.api.RegionCore;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1311;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_2998;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3195;
import net.minecraft.class_3211;
import net.minecraft.class_3284;
import net.minecraft.class_3341;
import net.minecraft.class_3420;
import net.minecraft.class_3449;
import net.minecraft.class_3485;
import net.minecraft.class_3812;
import net.minecraft.class_3813;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RandomOptions
implements IRegionElement {
    private static Logger log = LogManager.getLogger((String)"Random Element");
    public static final WastelandVillage WASTELAND_VILLAGE = (WastelandVillage)((Object)class_2378.method_10226((class_2378)class_2378.field_11138, (String)"ezwastelands:wasteland_village", (Object)((Object)new WastelandVillage(WastelandVillage::WastelandVillageConfig))));

    public RandomOptions() {
        class_2378.method_10226((class_2378)class_2378.field_16644, (String)("ezwastelands:" + WASTELAND_VILLAGE.method_14019().toLowerCase()), (Object)((Object)WASTELAND_VILLAGE));
        class_3031.field_13557.put((Object)WASTELAND_VILLAGE.method_14019(), (Object)WASTELAND_VILLAGE);
        class_2975[] lst = new class_2975[]{class_1959.method_8699((class_3031)class_3031.field_13565, (class_3037)class_3037.field_13603, (class_3284)class_3284.field_14250, (class_2998)class_2998.field_13436), class_1959.method_8699((class_3031)WASTELAND_VILLAGE, (class_3037)WastelandVillage.WastelandVillageConfig(null), (class_3284)class_3284.field_14250, (class_2998)class_2998.field_13436)};
        RegionCore.register(this, false, lst);
    }

    @Override
    public int addElementHeight(int currentoffset, int x, int z, RegionCore core, List<Object> elements) {
        return currentoffset + (Integer)elements.get(0);
    }

    @Override
    public String getElementName() {
        return "randopts";
    }

    @Override
    public List<Param> getParamTemplate() {
        ArrayList<Param> lst = new ArrayList<Param>();
        lst.add(new Param.BooleanParam("oceans", "config.ezwastelands.randopts.oceans.help", false));
        lst.add(new Param.StringParam("oceanblock", "config.ezwastelands.randopts.oceanblock.help", "minecraft:water"));
        lst.add(new Param.IntegerParam("globaloffset", "config.ezwastelands.randopts.globaloffset.help", 0, -25, 25));
        lst.add(new Param.BooleanParam("villages", "config.ezwastelands.randopts.villages.help", false));
        lst.add(new Param.FloatParam("villagechance", "config.ezwastelands.randopts.villagechance.help", 10.0f, 0.0f, 100.0f));
        lst.add(new Param.BooleanParam("strongholds", "config.ezwastelands.randopts.strongholds.help", false));
        return lst;
    }

    @Override
    public List<Object> calcElements(Random r, int x, int z, RegionCore core) {
        ArrayList<Object> placeholder = new ArrayList<Object>();
        placeholder.add(((Param.IntegerParam)core.lookupParam(this, "globaloffset")).get());
        return placeholder;
    }

    @Override
    public void postFill(class_2791 chunk, int height, int x, int z, RegionCore core) {
        class_2338.class_2339 position = new class_2338.class_2339(x & 0xF, 0, z & 0xF);
        if (((Param.BooleanParam)core.lookupParam(this, "oceans")).get()) {
            class_2960 oceanBlockName = new class_2960(((Param.StringParam)core.lookupParam(this, "oceanblock")).get());
            class_2680 water = class_2378.field_11146.method_10250(oceanBlockName) ? ((class_2248)class_2378.field_11146.method_10223(oceanBlockName)).method_9564() : class_2246.field_10382.method_9564();
            if (height < 0) {
                height = 0;
            }
            for (int i = height + 1; i <= 52; ++i) {
                position.method_10099(i);
                chunk.method_12010((class_2338)position, water, true);
            }
        }
    }

    private Random chunkBasedRNG(class_1923 p, long seed) {
        long x = p.field_9181;
        long z = p.field_9180;
        long localSeed = (x << 32) + z * 31L;
        localSeed ^= seed;
        Random r = new Random(localSeed += 5147L);
        r.nextInt();
        r.nextInt();
        return r;
    }

    @Override
    public void additionalTriggers(String event, class_1923 cords, class_2791 chunk, class_3485 resources, RegionCore core) {
        boolean genStrongholds = ((Param.BooleanParam)core.lookupParam(this, "strongholds")).get();
        boolean genVillages = ((Param.BooleanParam)core.lookupParam(this, "villages")).get();
        float villageRate = ((Param.FloatParam)core.lookupParam(this, "villagechance")).get();
        class_1937 w = core.getWorld();
        if (event.equals("structure_start")) {
            class_3449 newstruct;
            class_1959 biome;
            class_3449 struct;
            Random rng = this.chunkBasedRNG(cords, w.method_8412());
            Object feature = class_3420.field_16697;
            class_2794 gen = core.getChunkGen();
            if (core.isStructuresEnabled() && genStrongholds) {
                struct = null;
                if (feature.method_14026(gen, rng, cords.field_9181, cords.field_9180)) {
                    biome = gen.method_12098().method_8758(new class_2338(cords.method_8326() + 9, 0, cords.method_8328() + 9));
                    newstruct = feature.method_14016().create(feature, cords.field_9181, cords.field_9180, biome, class_3341.method_14665(), 0, gen.method_12101());
                    newstruct.method_16655(gen, resources, cords.field_9181, cords.field_9180, biome);
                    class_3449 class_34492 = struct = newstruct.method_16657() ? newstruct : class_3449.field_16713;
                    if (struct != null) {
                        chunk.method_12184(feature.method_14019(), struct);
                    }
                }
            }
            feature = WASTELAND_VILLAGE;
            if (core.isStructuresEnabled() && genVillages) {
                struct = null;
                if (WASTELAND_VILLAGE.canVillageSpawn(cords, villageRate, w.method_8412())) {
                    biome = gen.method_12098().method_8758(new class_2338(cords.method_8326() + 9, 0, cords.method_8328() + 9));
                    newstruct = feature.method_14016().create(feature, cords.field_9181, cords.field_9180, biome, class_3341.method_14665(), 0, gen.method_12101());
                    newstruct.method_16655(gen, resources, cords.field_9181, cords.field_9180, biome);
                    class_3449 class_34493 = struct = newstruct.method_16657() ? newstruct : class_3449.field_16713;
                    if (struct != null) {
                        chunk.method_12184(feature.method_14019(), struct);
                    }
                }
            }
        }
    }

    @Override
    public boolean hasStructure(String name, RegionCore core) {
        log.info("test " + name);
        switch (name.toLowerCase()) {
            case "stronghold": {
                return ((Param.BooleanParam)core.lookupParam(this, "strongholds")).get();
            }
            case "wasteland_village": {
                return ((Param.BooleanParam)core.lookupParam(this, "villages")).get();
            }
        }
        return false;
    }

    @Override
    public class_2338 getNearestStructure(String name, class_2338 curPos, int tries, boolean findUnexplored, RegionCore core) {
        class_1937 w = core.getWorld();
        log.info("find " + name);
        switch (name.toLowerCase()) {
            case "stronghold": {
                if (!((Param.BooleanParam)core.lookupParam(this, "strongholds")).get()) break;
                return class_3420.field_16697.method_14015(core.getWorld(), core.getChunkGen(), curPos, tries, findUnexplored);
            }
            case "wasteland_village": {
                if (!((Param.BooleanParam)core.lookupParam(this, "villages")).get()) break;
                return WASTELAND_VILLAGE.method_14015(core.getWorld(), core.getChunkGen(), curPos, tries, findUnexplored);
            }
        }
        return null;
    }

    @Override
    public int getWorldHeight(int h, int x, int z, RegionCore core) {
        if (((Param.BooleanParam)core.lookupParam(this, "oceans")).get()) {
            return Math.max(53, h);
        }
        return h;
    }

    @Override
    public List<class_1959.class_1964> getSpawnable(List<class_1959.class_1964> lst, class_1311 creatureCategory, class_2338 pos, RegionCore core) {
        return lst;
    }

    private static class WastelandVillage
    extends class_3211 {
        WastelandVillage(Function<Dynamic<?>, ? extends class_3812> fn) {
            super(fn);
        }

        private Random RegionRNG(int regionX, int regionZ, long seed) {
            long localSeed = ((long)regionX << 32) + (long)regionZ * 31L;
            localSeed ^= seed;
            Random r = new Random(localSeed += 5147L);
            r.nextInt();
            r.nextInt();
            return r;
        }

        public static <T> class_3812 WastelandVillageConfig(Dynamic<T> dyn) {
            return new class_3812("village/desert/town_centers", 6);
        }

        public class_3195.class_3774 method_14016() {
            return cityCore::new;
        }

        public boolean method_14026(class_2794<?> chunkGenerator_1, Random random_1, int int_1, int int_2) {
            return false;
        }

        public boolean canVillageSpawn(class_1923 c, float rate, long seed) {
            int region_x = c.field_9181 >> 2;
            int region_z = c.field_9180 >> 2;
            boolean valid = false;
            if (region_x % 2 == 0 || region_z % 2 == 0) {
                return false;
            }
            Random r = this.RegionRNG(region_x, region_z, seed);
            if (r.nextFloat() * 10000.0f <= rate * rate && c.field_9181 == (region_x << 2) + r.nextInt(3) && c.field_9180 == (region_z << 2) + r.nextInt(3)) {
                log.info(String.format("Village to spawn at: %d,%d", c.field_9181 << 4, c.field_9180 << 4));
                valid = true;
            }
            return valid;
        }

        public String method_14019() {
            return "Wasteland_Village";
        }

        public static class cityCore
        extends class_3449 {
            public cityCore(class_3195<?> structureFeature_1, int int_1, int int_2, class_1959 biome_1, class_3341 mutableIntBoundingBox_1, int int_3, long long_1) {
                super(structureFeature_1, int_1, int_2, biome_1, mutableIntBoundingBox_1, int_3, long_1);
            }

            public void method_16655(class_2794<?> gen, class_3485 sm, int x, int z, class_1959 var5) {
                class_2338 blockPos_1 = new class_2338(x * 16, 0, z * 16);
                class_3813.method_16753(gen, (class_3485)sm, (class_2338)blockPos_1, (List)this.field_15325, (class_2919)this.field_16715, (class_3812)WastelandVillage.WastelandVillageConfig(null));
                this.method_14969();
            }
        }
    }
}

