/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.wastelands.world.elements;

import com.ezrol.terry.minecraft.wastelands.api.AbstractElement;
import com.ezrol.terry.minecraft.wastelands.api.Param;
import com.ezrol.terry.minecraft.wastelands.api.RegionCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Shallows
extends AbstractElement {
    private static Logger log = LogManager.getLogger((String)"Shallows");

    @Override
    public int addElementHeight(int currentoffset, int x, int z, RegionCore core, List<Object> elements) {
        for (Object o : elements) {
            float distz;
            poi shallow = (poi)o;
            int offset = 0;
            float distx = x - shallow.x;
            float dist = (float)Math.sqrt(distx * distx + (distz = (float)(z - shallow.z)) * distz);
            if (dist < (float)shallow.radius) {
                offset = (double)dist < 0.09 ? shallow.depth : (int)((double)(-1.0f * (dist - (float)shallow.radius) / (float)shallow.radius * (float)shallow.depth) + 0.5);
            }
            currentoffset -= offset;
        }
        return currentoffset;
    }

    @Override
    public String getElementName() {
        return "shallows";
    }

    @Override
    public List<Param> getParamTemplate() {
        ArrayList<Param> lst = new ArrayList<Param>();
        lst.add(new Param.IntegerParam("mincount", "config.ezwastelands.shallows.mincount.help", 4, 0, 8));
        lst.add(new Param.IntegerParam("maxcount", "config.ezwastelands.shallows.maxcount.help", 5, 0, 16));
        lst.add(new Param.IntegerParam("radius", "config.ezwastelands.shallows.radius.help", 42, 10, 64));
        lst.add(new Param.IntegerParam("depth", "config.ezwastelands.shallows.depth.help", 5, 2, 8));
        return lst;
    }

    @Override
    public List<Object> calcElements(Random r, int x, int z, RegionCore core) {
        ArrayList<Object> elements = new ArrayList<Object>();
        int radius = ((Param.IntegerParam)core.lookupParam(this, "radius")).get();
        int depth = ((Param.IntegerParam)core.lookupParam(this, "depth")).get();
        int i = ((Param.IntegerParam)core.lookupParam(this, "mincount")).get();
        int cnt = ((Param.IntegerParam)core.lookupParam(this, "maxcount")).get();
        if (cnt > i) {
            cnt = i + r.nextInt(cnt - i);
        }
        for (i = 0; i < cnt; ++i) {
            poi shallow = new poi();
            shallow.x = r.nextInt(64) + (x << 6);
            shallow.z = r.nextInt(64) + (z << 6);
            if (radius <= 10) {
                shallow.radius = 10;
            } else {
                shallow.radius = r.nextInt(radius - 10) + 10;
            }
            shallow.depth = r.nextInt(depth);
            elements.add(shallow);
        }
        return elements;
    }

    private class poi {
        private int x;
        private int z;
        private int radius;
        private int depth;

        private poi() {
        }
    }
}

