/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.wastelands.world.elements;

import com.ezrol.terry.minecraft.wastelands.api.AbstractElement;
import com.ezrol.terry.minecraft.wastelands.api.Param;
import com.ezrol.terry.minecraft.wastelands.api.RegionCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Spires
extends AbstractElement {
    private static Logger log = LogManager.getLogger((String)"Spires");

    @Override
    public int addElementHeight(int currentOffset, int x, int z, RegionCore core, List<Object> elements) {
        for (Object s : elements) {
            poi spire = (poi)s;
            if (spire.x != x || spire.z != z) continue;
            currentOffset += spire.size;
        }
        return currentOffset;
    }

    @Override
    public String getElementName() {
        return "spire";
    }

    @Override
    public List<Param> getParamTemplate() {
        ArrayList<Param> lst = new ArrayList<Param>();
        lst.add(new Param.IntegerParam("count", "config.ezwastelands.spire.count.help", 2, 0, 30));
        lst.add(new Param.IntegerParam("size", "config.ezwastelands.spire.size.help", 6, 2, 10));
        return lst;
    }

    @Override
    public List<Object> calcElements(Random r, int x, int z, RegionCore core) {
        int count = ((Param.IntegerParam)core.lookupParam(this, "count")).get();
        int maxSize = ((Param.IntegerParam)core.lookupParam(this, "size")).get();
        ArrayList<Object> elements = new ArrayList<Object>(count * 2);
        for (int i = 0; i < count; ++i) {
            poi spire = new poi();
            do {
                int randX = r.nextInt(64);
                int randZ = r.nextInt(64);
                spire.x = randX + (x << 6);
                spire.z = randZ + (z << 6);
                spire.size = r.nextInt(maxSize);
            } while (elements.contains(spire));
            elements.add(spire);
        }
        return elements;
    }

    private class poi {
        protected int x;
        protected int z;
        protected int size;

        private poi() {
        }

        public boolean equals(Object o) {
            return o != null && o instanceof poi && ((poi)o).x == this.x && ((poi)o).z == this.z;
        }
    }
}

