/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.wastelands.world.elements;

import com.ezrol.terry.minecraft.wastelands.api.AbstractElement;
import com.ezrol.terry.minecraft.wastelands.api.Param;
import com.ezrol.terry.minecraft.wastelands.api.RegionCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TerrainVariation
extends AbstractElement {
    @Override
    public int addElementHeight(int currentoffset, int x, int z, RegionCore core, List<Object> elements) {
        int cnt = elements.size();
        int totalWeight = 0;
        long localVariation = 0L;
        if (cnt == 0) {
            return currentoffset;
        }
        for (Object o : elements) {
            attractors attract = (attractors)o;
            float distx = x - attract.x;
            float distz = z - attract.z;
            float dist = (float)Math.sqrt(distx * distx + distz * distz);
            int weight = 110 - (int)dist;
            if (weight <= 0) continue;
            double power = 1.0;
            weight = (int)Math.pow(weight, power += 0.2 * (double)attract.cntperrgn);
            totalWeight += weight;
            localVariation += (long)weight * (long)attract.height;
        }
        localVariation = totalWeight > 0 ? (localVariation /= (long)totalWeight) : 0L;
        return currentoffset + (int)localVariation;
    }

    @Override
    public String getElementName() {
        return "terrainvariation";
    }

    @Override
    public List<Param> getParamTemplate() {
        ArrayList<Param> lst = new ArrayList<Param>();
        lst.add(new Param.IntegerParam("amplification", "config.ezwastelands.terrainvariation.amplification.help", 30, 0, 48));
        lst.add(new Param.IntegerParam("variation", "config.ezwastelands.terrainvariation.variation.help", 1, 1, 5));
        return lst;
    }

    @Override
    public List<Object> calcElements(Random r, int x, int z, RegionCore core) {
        ArrayList<Object> elements = new ArrayList<Object>();
        int variation = ((Param.IntegerParam)core.lookupParam(this, "variation")).get();
        int amplification = ((Param.IntegerParam)core.lookupParam(this, "amplification")).get();
        if (amplification == 0) {
            return elements;
        }
        for (int i = 0; i < variation; ++i) {
            attractors node = new attractors();
            node.x = r.nextInt(64) + (x << 6);
            node.z = r.nextInt(64) + (z << 6);
            boolean duplicate = false;
            for (Object e : elements) {
                attractors testNode = (attractors)e;
                if (testNode.x != node.x || testNode.z != node.z) continue;
                duplicate = true;
            }
            if (duplicate) {
                --i;
                continue;
            }
            node.height = r.nextInt(amplification);
            node.cntperrgn = variation;
            elements.add(node);
        }
        return elements;
    }

    private class attractors {
        protected int x;
        protected int z;
        protected int height;
        protected int cntperrgn;

        private attractors() {
        }
    }
}

