/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.apache.commons.lang3.tuple.Pair;
import romelo333.notenoughwands.GlobalCoordinate;
import romelo333.notenoughwands.ModItems;
import romelo333.notenoughwands.varia.Tools;

public class ProtectedBlocks {
    private static final String NAME = "NEWProtectedBlocks";
    private Map<GlobalCoordinate, Integer> blocks = new HashMap<GlobalCoordinate, Integer>();
    private Map<Pair<Integer, class_1923>, Set<class_2338>> perDimPerChunkCache = new HashMap<Pair<Integer, class_1923>, Set<class_2338>>();
    private Map<Integer, Integer> counter = new HashMap<Integer, Integer>();
    private int lastId = 1;
    public static int clientSideWorld = Integer.MAX_VALUE;
    public static Map<class_1923, Set<class_2338>> clientSideProtectedBlocks = new HashMap<class_1923, Set<class_2338>>();
    private static ProtectedBlocks instance;

    public ProtectedBlocks(String name) {
    }

    public void clear() {
        this.blocks.clear();
        this.perDimPerChunkCache.clear();
        this.counter.clear();
        this.lastId = -1;
    }

    public static ProtectedBlocks getProtectedBlocks(class_1937 world) {
        if (instance == null) {
            instance = new ProtectedBlocks(NAME);
        }
        return instance;
    }

    public static boolean isProtectedClientSide(class_1937 world, class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        if (!clientSideProtectedBlocks.containsKey(chunkPos)) {
            return false;
        }
        Set<class_2338> positions = clientSideProtectedBlocks.get(chunkPos);
        return positions.contains(pos);
    }

    protected void save() {
    }

    public int getNewId() {
        ++this.lastId;
        this.save();
        return this.lastId - 1;
    }

    private void decrementProtection(Integer oldId) {
        int cnt = this.counter.getOrDefault(oldId, 0);
        this.counter.put(oldId, --cnt);
    }

    private void incrementProtection(Integer newId) {
        int cnt = this.counter.getOrDefault(newId, 0);
        this.counter.put(newId, ++cnt);
    }

    public int getProtectedBlockCount(int id) {
        return this.counter.getOrDefault(id, 0);
    }

    private int getMaxProtectedBlocks(int id) {
        if (id == -1) {
            return ModItems.masterProtectionWand.maximumProtectedBlocks;
        }
        return ModItems.protectionWand.maximumProtectedBlocks;
    }

    public boolean protect(class_1657 player, class_1937 world, class_2338 pos, int id) {
        int max;
        GlobalCoordinate key = new GlobalCoordinate(pos, world.field_9247.method_12460().method_12484());
        if (id != -1 && this.blocks.containsKey(key)) {
            Tools.error(player, "This block is already protected!");
            return false;
        }
        if (this.blocks.containsKey(key)) {
            this.decrementProtection(this.blocks.get(key));
        }
        if ((max = this.getMaxProtectedBlocks(id)) != 0 && this.getProtectedBlockCount(id) >= max) {
            Tools.error(player, "Maximum number of protected blocks reached!");
            return false;
        }
        this.blocks.put(key, id);
        this.clearCache(key);
        this.incrementProtection(id);
        this.save();
        return true;
    }

    public boolean unprotect(class_1657 player, class_1937 world, class_2338 pos, int id) {
        GlobalCoordinate key = new GlobalCoordinate(pos, world.field_9247.method_12460().method_12484());
        if (!this.blocks.containsKey(key)) {
            Tools.error(player, "This block is not protected!");
            return false;
        }
        if (id != -1 && this.blocks.get(key) != id) {
            Tools.error(player, "You have no permission to unprotect this block!");
            return false;
        }
        this.decrementProtection(this.blocks.get(key));
        this.blocks.remove(key);
        this.clearCache(key);
        this.save();
        return true;
    }

    public int clearProtections(class_1937 world, int id) {
        HashSet<GlobalCoordinate> toRemove = new HashSet<GlobalCoordinate>();
        for (Map.Entry<GlobalCoordinate, Integer> entry : this.blocks.entrySet()) {
            if (entry.getValue() != id) continue;
            toRemove.add(entry.getKey());
        }
        int cnt = 0;
        for (GlobalCoordinate coordinate : toRemove) {
            ++cnt;
            this.blocks.remove(coordinate);
            this.clearCache(coordinate);
        }
        this.counter.put(id, 0);
        this.save();
        return cnt;
    }

    public boolean isProtected(class_1937 world, class_2338 pos) {
        return this.blocks.containsKey(new GlobalCoordinate(pos, world.field_9247.method_12460().method_12484()));
    }

    public boolean hasProtections() {
        return !this.blocks.isEmpty();
    }

    public void fetchProtectedBlocks(Set<class_2338> coordinates, class_1937 world, int x, int y, int z, float radius, int id) {
        radius *= radius;
        for (Map.Entry<GlobalCoordinate, Integer> entry : this.blocks.entrySet()) {
            class_2338 c;
            float sqdist;
            GlobalCoordinate block;
            if (entry.getValue() != id && (id != -2 || entry.getValue() == -1) || (block = entry.getKey()).getDimension() != world.field_9247.method_12460().method_12484() || !((sqdist = (float)((x - (c = block.getCoordinate()).method_10263()) * (x - c.method_10263()) + (y - c.method_10264()) * (y - c.method_10264()) + (z - c.method_10260()) * (z - c.method_10260()))) < radius)) continue;
            coordinates.add(c);
        }
    }

    private void clearCache(GlobalCoordinate pos) {
        class_1923 chunkpos = new class_1923(pos.getCoordinate());
        this.perDimPerChunkCache.remove(Pair.of((Object)pos.getDimension(), (Object)chunkpos));
    }

    public Map<class_1923, Set<class_2338>> fetchProtectedBlocks(class_1937 world, class_2338 pos) {
        HashMap<class_1923, Set<class_2338>> result = new HashMap<class_1923, Set<class_2338>>();
        class_1923 chunkpos = new class_1923(pos);
        this.fetchProtectedBlocks(result, world, new class_1923(chunkpos.field_9181 - 1, chunkpos.field_9180 - 1));
        this.fetchProtectedBlocks(result, world, new class_1923(chunkpos.field_9181, chunkpos.field_9180 - 1));
        this.fetchProtectedBlocks(result, world, new class_1923(chunkpos.field_9181 + 1, chunkpos.field_9180 - 1));
        this.fetchProtectedBlocks(result, world, new class_1923(chunkpos.field_9181 - 1, chunkpos.field_9180));
        this.fetchProtectedBlocks(result, world, new class_1923(chunkpos.field_9181, chunkpos.field_9180));
        this.fetchProtectedBlocks(result, world, new class_1923(chunkpos.field_9181 + 1, chunkpos.field_9180));
        this.fetchProtectedBlocks(result, world, new class_1923(chunkpos.field_9181 - 1, chunkpos.field_9180 + 1));
        this.fetchProtectedBlocks(result, world, new class_1923(chunkpos.field_9181, chunkpos.field_9180 + 1));
        this.fetchProtectedBlocks(result, world, new class_1923(chunkpos.field_9181 + 1, chunkpos.field_9180 + 1));
        return result;
    }

    public void fetchProtectedBlocks(Map<class_1923, Set<class_2338>> allresults, class_1937 world, class_1923 chunkpos) {
        Pair key = Pair.of((Object)world.field_9247.method_12460().method_12484(), (Object)chunkpos);
        if (this.perDimPerChunkCache.containsKey(key)) {
            allresults.put(chunkpos, this.perDimPerChunkCache.get(key));
            return;
        }
        HashSet<class_2338> result = new HashSet<class_2338>();
        for (Map.Entry<GlobalCoordinate, Integer> entry : this.blocks.entrySet()) {
            class_1923 bc;
            GlobalCoordinate block = entry.getKey();
            if (block.getDimension() != world.field_9247.method_12460().method_12484() || !(bc = new class_1923(block.getCoordinate())).equals((Object)chunkpos)) continue;
            result.add(block.getCoordinate());
        }
        allresults.put(chunkpos, result);
        this.perDimPerChunkCache.put((Pair<Integer, class_1923>)key, result);
    }

    public void readFromNBT(class_2487 tagCompound) {
        this.lastId = tagCompound.method_10550("lastId");
        this.blocks.clear();
        this.perDimPerChunkCache.clear();
        this.counter.clear();
        class_2499 list = tagCompound.method_10554("blocks", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 tc = list.method_10602(i);
            GlobalCoordinate block = new GlobalCoordinate(new class_2338(tc.method_10550("x"), tc.method_10550("y"), tc.method_10550("z")), tc.method_10550("dim"));
            int id = tc.method_10550("id");
            this.blocks.put(block, id);
            this.incrementProtection(id);
        }
    }

    public class_2487 writeToNBT(class_2487 tagCompound) {
        tagCompound.method_10569("lastId", this.lastId);
        class_2499 list = new class_2499();
        for (Map.Entry<GlobalCoordinate, Integer> entry : this.blocks.entrySet()) {
            GlobalCoordinate block = entry.getKey();
            class_2487 tc = new class_2487();
            tc.method_10569("x", block.getCoordinate().method_10263());
            tc.method_10569("y", block.getCoordinate().method_10264());
            tc.method_10569("z", block.getCoordinate().method_10260());
            tc.method_10569("dim", block.getDimension());
            tc.method_10569("id", entry.getValue().intValue());
            list.add((Object)tc);
        }
        tagCompound.method_10566("blocks", (class_2520)list);
        return tagCompound;
    }
}

