/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.items;

import java.util.List;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3000;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Configuration;
import romelo333.notenoughwands.items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class AccelerationWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_20 = 0;
    public static final int MODE_50 = 1;
    public static final int MODE_100 = 2;
    public static final int MODE_LAST = 2;
    private float fakePlayerFactor = 1.0f;
    private boolean lessEffectiveForFakePlayer = false;
    public static final String[] descriptions = new String[]{"fast", "faster", "fastest"};
    public static final int[] amount = new int[]{20, 50, 100};
    public static final float[] cost = new float[]{1.0f, 2.0f, 5.0f};
    private Random random = new Random();

    public AccelerationWand() {
        super(100);
        this.setup("acceleration_wand").xpUsage(5).loot(2);
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 player, List<class_2561> list, class_1836 b) {
        super.method_7851(stack, player, list, b);
        list.add((class_2561)new class_2585(class_124.field_1060 + "Mode: " + descriptions[this.getMode(stack)]));
        list.add((class_2561)new class_2585("Right click on block to speed up ticks."));
        this.showModeKeyDescription(list, "change speed");
        if ((double)Math.abs(this.fakePlayerFactor - 1.0f) >= 0.01) {
            if (this.fakePlayerFactor < 0.0f) {
                list.add((class_2561)new class_2585(class_124.field_1061 + "Usage in a machine has been disabled in config!"));
            } else if (this.fakePlayerFactor > 1.0f) {
                list.add((class_2561)new class_2585(class_124.field_1054 + "Usage in a machine will cost more!"));
            }
        }
        if ((double)this.fakePlayerFactor >= 0.0 && this.lessEffectiveForFakePlayer) {
            list.add((class_2561)new class_2585(class_124.field_1054 + "Usage in a machine will be less effective!"));
        }
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg, 500, 100000, 200, 200000, 100, 500000);
        this.fakePlayerFactor = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_fakePlayerFactor", this.fakePlayerFactor, "Factor to apply to the cost when this wand is used by a fake player (a machine). Set to -1 to disable its use this way").getDouble();
        this.lessEffectiveForFakePlayer = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_lessEffectiveForFakePlayer", this.lessEffectiveForFakePlayer, "If true this wand will be less effective for fake players").getBoolean();
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 side = context.method_8038();
        class_1799 stack = context.method_8041();
        if (!world.field_9236) {
            class_2680 state = world.method_8320(pos);
            class_2248 block = state.method_11614();
            int mode = this.getMode(stack);
            float cost = AccelerationWand.cost[mode];
            int amount = AccelerationWand.amount[mode];
            if (!this.checkUsage(stack, player, cost)) {
                return class_1269.field_5814;
            }
            class_2586 tileEntity = world.method_8321(pos);
            for (int i = 0; i < amount / (tileEntity == null ? 5 : 1); ++i) {
                if (tileEntity == null) {
                    block.method_9496(state, world, pos, this.random);
                    continue;
                }
                if (!(tileEntity instanceof class_3000)) continue;
                ((class_3000)tileEntity).method_16896();
            }
            this.registerUsage(stack, player, cost);
        }
        return class_1269.field_5812;
    }

    @Override
    public void toggleMode(class_1657 player, class_1799 stack) {
        int mode = this.getMode(stack);
        if (++mode > 2) {
            mode = 0;
        }
        Tools.notify(player, "Switched to " + descriptions[mode] + " mode");
        Tools.getTagCompound(stack).method_10569("mode", mode);
    }

    private int getMode(class_1799 stack) {
        return Tools.getTagCompound(stack).method_10550("mode");
    }
}

