/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.items;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3614;
import net.minecraft.class_3965;
import romelo333.notenoughwands.Configuration;
import romelo333.notenoughwands.items.GenericWand;
import romelo333.notenoughwands.mcjtylib.BlockTools;
import romelo333.notenoughwands.varia.Tools;

public class BuildingWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_9 = 0;
    public static final int MODE_9ROW = 1;
    public static final int MODE_25 = 2;
    public static final int MODE_25ROW = 3;
    public static final int MODE_SINGLE = 4;
    public static final int MODE_LAST = 4;
    public static final String[] descriptions = new String[]{"9 blocks", "9 blocks row", "25 blocks", "25 blocks row", "single"};
    public static final int[] amount = new int[]{9, 9, 25, 25, 1};

    public BuildingWand() {
        super(100);
        this.setup("building_wand").xpUsage(1).loot(3);
    }

    @Override
    protected void initConfig(Configuration cfg) {
        super.initConfig(cfg, 2000, 100000, 500, 200000, 200, 500000);
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 player, List<class_2561> list, class_1836 b) {
        super.method_7851(stack, player, list, b);
        class_2487 compound = stack.method_7969();
        if (compound != null) {
            int cnt = (compound.method_10545("undo1") ? 1 : 0) + (compound.method_10545("undo2") ? 1 : 0);
            list.add((class_2561)new class_2585(class_124.field_1060 + "Has " + cnt + " undo states"));
            int mode = compound.method_10550("mode");
            if (mode == 1 || mode == 3) {
                int submode = this.getSubMode(stack);
                list.add((class_2561)new class_2585(class_124.field_1060 + "Mode: " + descriptions[mode] + (submode == 1 ? " [Rotated]" : "")));
            } else {
                list.add((class_2561)new class_2585(class_124.field_1060 + "Mode: " + descriptions[mode]));
            }
        }
        list.add((class_2561)new class_2585("Right click to extend blocks in that direction."));
        list.add((class_2561)new class_2585("Sneak right click on such a block to undo one of"));
        list.add((class_2561)new class_2585("the last two operations."));
        this.showModeKeyDescription(list, "switch mode");
        this.showSubModeKeyDescription(list, "change orientation");
    }

    @Override
    public void toggleMode(class_1657 player, class_1799 stack) {
        int mode = this.getMode(stack);
        if (++mode > 4) {
            mode = 0;
        }
        Tools.notify(player, "Switched to " + descriptions[mode] + " mode");
        Tools.getTagCompound(stack).method_10569("mode", mode);
    }

    @Override
    public void toggleSubMode(class_1657 player, class_1799 stack) {
        int submode = this.getSubMode(stack);
        submode = submode == 1 ? 0 : 1;
        Tools.notify(player, "Switched orientation");
        Tools.getTagCompound(stack).method_10569("submode", submode);
    }

    private int getMode(class_1799 stack) {
        return Tools.getTagCompound(stack).method_10550("mode");
    }

    private int getSubMode(class_1799 stack) {
        return Tools.getTagCompound(stack).method_10550("submode");
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1799 stack = context.method_8041();
        if (!world.field_9236) {
            if (player.method_5715()) {
                this.undoPlaceBlock(stack, player, world, pos);
            } else {
                this.placeBlock(stack, player, world, pos, context.method_8038());
            }
        }
        return class_1269.field_5812;
    }

    private void placeBlock(class_1799 stack, class_1657 player, class_1937 world, class_2338 pos, class_2350 side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        boolean notenough = false;
        class_2680 blockState = world.method_8320(pos);
        class_2248 block = blockState.method_11614();
        Set<class_2338> coordinates = this.findSuitableBlocks(stack, world, side, pos, block);
        HashSet<class_2338> undo = new HashSet<class_2338>();
        for (class_2338 coordinate : coordinates) {
            if (!this.checkUsage(stack, player, 1.0f)) break;
            class_1799 consumed = Tools.consumeInventoryItem(class_1792.method_7867((class_2248)block), player.field_7514, player);
            if (!consumed.method_7960()) {
                Tools.playSound(world, block.method_9573(blockState).method_10594(), (double)coordinate.method_10263(), (double)coordinate.method_10264(), (double)coordinate.method_10260(), 1.0, 1.0);
                BlockTools.placeStackAt(player, consumed, world, coordinate, null);
                player.field_7512.method_7623();
                this.registerUsage(stack, player, 1.0f);
                undo.add(coordinate);
                continue;
            }
            notenough = true;
        }
        if (notenough) {
            Tools.error(player, "You don't have the right block");
        }
        this.registerUndo(stack, block, world, undo);
    }

    private void registerUndo(class_1799 stack, class_2248 block, class_1937 world, Set<class_2338> undo) {
        class_2487 undoTag = new class_2487();
        undoTag.method_10582("block", class_2378.field_11146.method_10221((Object)block).toString());
        undoTag.method_10569("dimension", world.field_9247.method_12460().method_12484());
        int[] undoX = new int[undo.size()];
        int[] undoY = new int[undo.size()];
        int[] undoZ = new int[undo.size()];
        int idx = 0;
        for (class_2338 coordinate : undo) {
            undoX[idx] = coordinate.method_10263();
            undoY[idx] = coordinate.method_10264();
            undoZ[idx] = coordinate.method_10260();
            ++idx;
        }
        undoTag.method_10539("x", undoX);
        undoTag.method_10539("y", undoY);
        undoTag.method_10539("z", undoZ);
        class_2487 wandTag = Tools.getTagCompound(stack);
        if (wandTag.method_10545("undo1")) {
            wandTag.method_10566("undo2", wandTag.method_10580("undo1"));
        }
        wandTag.method_10566("undo1", (class_2520)undoTag);
    }

    private void undoPlaceBlock(class_1799 stack, class_1657 player, class_1937 world, class_2338 pos) {
        class_2487 wandTag = Tools.getTagCompound(stack);
        class_2487 undoTag1 = (class_2487)wandTag.method_10580("undo1");
        class_2487 undoTag2 = (class_2487)wandTag.method_10580("undo2");
        Set<class_2338> undo1 = this.checkUndo(player, world, undoTag1);
        Set<class_2338> undo2 = this.checkUndo(player, world, undoTag2);
        if (undo1 == null && undo2 == null) {
            Tools.error(player, "Nothing to undo!");
            return;
        }
        if (undo1 != null && undo1.contains(pos)) {
            this.performUndo(stack, player, world, pos, undoTag1, undo1);
            if (wandTag.method_10545("undo2")) {
                wandTag.method_10566("undo1", wandTag.method_10580("undo2"));
                wandTag.method_10551("undo2");
            } else {
                wandTag.method_10551("undo1");
            }
            return;
        }
        if (undo2 != null && undo2.contains(pos)) {
            this.performUndo(stack, player, world, pos, undoTag2, undo2);
            wandTag.method_10551("undo2");
            return;
        }
        Tools.error(player, "Select at least one block of the area you want to undo!");
    }

    private void performUndo(class_1799 stack, class_1657 player, class_1937 world, class_2338 pos, class_2487 undoTag, Set<class_2338> undo) {
        class_2248 block = (class_2248)class_2378.field_11146.method_10223(new class_2960(undoTag.method_10558("block")));
        int cnt = 0;
        for (class_2338 coordinate : undo) {
            class_2680 testState = world.method_8320(coordinate);
            class_2248 testBlock = testState.method_11614();
            if (testBlock != block) continue;
            Tools.playSound(world, block.method_9573(testState).method_10594(), (double)coordinate.method_10263(), (double)coordinate.method_10264(), (double)coordinate.method_10260(), 1.0, 1.0);
            world.method_8652(coordinate, class_2246.field_10124.method_9564(), 3);
            ++cnt;
        }
        if (cnt > 0 && !player.method_7337()) {
            Tools.giveItem(world, player, block, cnt, pos);
            player.field_7512.method_7623();
        }
    }

    private Set<class_2338> checkUndo(class_1657 player, class_1937 world, class_2487 undoTag) {
        if (undoTag == null) {
            return null;
        }
        int dimension = undoTag.method_10550("dimension");
        if (dimension != world.field_9247.method_12460().method_12484()) {
            Tools.error(player, "Select at least one block of the area you want to undo!");
            return null;
        }
        int[] undoX = undoTag.method_10561("x");
        int[] undoY = undoTag.method_10561("y");
        int[] undoZ = undoTag.method_10561("z");
        HashSet<class_2338> undo = new HashSet<class_2338>();
        for (int i = 0; i < undoX.length; ++i) {
            undo.add(new class_2338(undoX[i], undoY[i], undoZ[i]));
        }
        return undo;
    }

    @Override
    public void renderOverlay(class_1657 player, class_1799 wand, float partialTicks) {
        class_3965 blockResult;
        class_239 mouseOver = class_310.method_1551().field_1765;
        if (mouseOver != null && mouseOver.method_17783() == class_239.class_240.field_1332 && (blockResult = (class_3965)mouseOver).method_17780() != null && blockResult.method_17777() != null) {
            class_1937 world = player.method_5770();
            class_2338 blockPos = blockResult.method_17777();
            if (blockPos == null) {
                return;
            }
            class_2680 blockState = world.method_8320(blockPos);
            class_2248 block = blockState.method_11614();
            if (block != null && block.method_9597(blockState) != class_3614.field_15959) {
                if (player.method_5715()) {
                    class_2487 wandTag = Tools.getTagCompound(wand);
                    class_2487 undoTag1 = (class_2487)wandTag.method_10580("undo1");
                    class_2487 undoTag2 = (class_2487)wandTag.method_10580("undo2");
                    Set<class_2338> undo1 = this.checkUndo(player, world, undoTag1);
                    Set<class_2338> undo2 = this.checkUndo(player, world, undoTag2);
                    if (undo1 == null && undo2 == null) {
                        return;
                    }
                    if (undo1 != null && undo1.contains(blockPos)) {
                        Set<class_2338> coordinates = undo1;
                        BuildingWand.renderOutlines(player, coordinates, 240, 30, 0, partialTicks);
                    } else if (undo2 != null && undo2.contains(blockPos)) {
                        Set<class_2338> coordinates = undo2;
                        BuildingWand.renderOutlines(player, coordinates, 240, 30, 0, partialTicks);
                    }
                } else {
                    Set<class_2338> coordinates = this.findSuitableBlocks(wand, world, blockResult.method_17780(), blockPos, block);
                    BuildingWand.renderOutlines(player, coordinates, 50, 250, 180, partialTicks);
                }
            }
        }
    }

    private Set<class_2338> findSuitableBlocks(class_1799 stack, class_1937 world, class_2350 sideHit, class_2338 pos, class_2248 block) {
        HashSet<class_2338> coordinates = new HashSet<class_2338>();
        HashSet<class_2338> done = new HashSet<class_2338>();
        ArrayDeque<class_2338> todo = new ArrayDeque<class_2338>();
        todo.addLast(pos);
        this.findSuitableBlocks(world, coordinates, done, todo, sideHit, block, amount[this.getMode(stack)], this.getMode(stack) == 1 || this.getMode(stack) == 3, this.getSubMode(stack));
        return coordinates;
    }

    private void findSuitableBlocks(class_1937 world, Set<class_2338> coordinates, Set<class_2338> done, Deque<class_2338> todo, class_2350 direction, class_2248 block, int maxAmount, boolean rowMode, int rotated) {
        class_2338 offset;
        class_2338 base;
        class_2350 dirA = null;
        class_2350 dirB = null;
        if (rowMode) {
            base = todo.getFirst();
            offset = base.method_10093(direction);
            dirA = rotated == 1 ? this.dir2(direction) : this.dir1(direction);
            dirB = dirA.method_10153();
            if (!this.isSuitable(world, block, base.method_10093(dirA), offset.method_10093(dirA)) || !this.isSuitable(world, block, base.method_10093(dirB), offset.method_10093(dirB))) {
                dirA = rotated == 1 ? this.dir3(direction) : this.dir2(direction);
                dirB = dirA.method_10153();
                if (!this.isSuitable(world, block, base.method_10093(dirA), offset.method_10093(dirA)) || !this.isSuitable(world, block, base.method_10093(dirB), offset.method_10093(dirB))) {
                    dirA = rotated == 1 ? this.dir1(direction) : this.dir3(direction);
                    dirB = dirA.method_10153();
                }
            }
        }
        while (!todo.isEmpty() && coordinates.size() < maxAmount) {
            base = todo.pollFirst();
            if (done.contains(base)) continue;
            done.add(base);
            offset = base.method_10093(direction);
            if (!this.isSuitable(world, block, base, offset)) continue;
            coordinates.add(offset);
            if (rowMode) {
                todo.addLast(base.method_10093(dirA));
                todo.addLast(base.method_10093(dirB));
                continue;
            }
            todo.addLast(base.method_10093(this.dir1(direction)));
            todo.addLast(base.method_10093(this.dir1(direction).method_10153()));
            todo.addLast(base.method_10093(this.dir2(direction)));
            todo.addLast(base.method_10093(this.dir2(direction).method_10153()));
            todo.addLast(base.method_10093(this.dir1(direction)).method_10093(this.dir2(direction)));
            todo.addLast(base.method_10093(this.dir1(direction)).method_10093(this.dir2(direction).method_10153()));
            todo.addLast(base.method_10093(this.dir1(direction).method_10153()).method_10093(this.dir2(direction)));
            todo.addLast(base.method_10093(this.dir1(direction).method_10153()).method_10093(this.dir2(direction).method_10153()));
        }
    }

    private boolean isSuitable(class_1937 world, class_2248 block, class_2338 base, class_2338 offset) {
        class_2680 baseState;
        class_2680 destState = world.method_8320(offset);
        class_2248 destBlock = destState.method_11614();
        if (destBlock == null) {
            destBlock = class_2246.field_10124;
        }
        return (baseState = world.method_8320(base)).method_11614() == block && destBlock.method_9500(destState);
    }

    private class_2350 dir1(class_2350 direction) {
        switch (direction) {
            case field_11033: 
            case field_11036: {
                return class_2350.field_11034;
            }
            case field_11043: 
            case field_11035: {
                return class_2350.field_11034;
            }
            case field_11039: 
            case field_11034: {
                return class_2350.field_11033;
            }
        }
        return null;
    }

    private class_2350 dir2(class_2350 direction) {
        switch (direction) {
            case field_11033: 
            case field_11036: {
                return class_2350.field_11035;
            }
            case field_11043: 
            case field_11035: {
                return class_2350.field_11033;
            }
            case field_11039: 
            case field_11034: {
                return class_2350.field_11035;
            }
        }
        return null;
    }

    private class_2350 dir3(class_2350 direction) {
        switch (direction) {
            case field_11033: 
            case field_11036: {
                return class_2350.field_11035;
            }
            case field_11043: 
            case field_11035: {
                return class_2350.field_11039;
            }
            case field_11039: 
            case field_11034: {
                return class_2350.field_11035;
            }
        }
        return null;
    }
}

