/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.items;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3218;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Configuration;
import romelo333.notenoughwands.items.BlackListSettings;
import romelo333.notenoughwands.items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class CapturingWand
extends GenericWand {
    private boolean allowPassive = true;
    private boolean allowHostile = true;
    private float difficultyMult = 0.0f;
    private float diffcultyAdd = 1.0f;

    public CapturingWand() {
        super(100);
        this.setup("capturing_wand").xpUsage(10).loot(3);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg, 200, 100000, 100, 200000, 40, 500000);
        this.allowPassive = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_allowPassive", this.allowPassive, "Allow capturing passive mobs").getBoolean();
        this.allowHostile = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_allowHostile", this.allowHostile, "Allow capturing hostile mobs").getBoolean();
        this.difficultyMult = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_difficultyMult", this.difficultyMult, "Multiply the HP of a mob with this number to get the difficulty scale that affects XP/RF usage (a final result of 1.0 means that the default XP/RF is used)").getDouble();
        this.diffcultyAdd = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_diffcultyAdd", this.diffcultyAdd, "Add this to the HP * difficultyMult to get the final difficulty scale that affects XP/RF usage (a final result of 1.0 means that the default XP/RF is used)").getDouble();
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 player, List<class_2561> list, class_1836 b) {
        super.method_7851(stack, player, list, b);
        class_2487 tagCompound = stack.method_7969();
        if (tagCompound != null && tagCompound.method_10545("mob")) {
            String type = tagCompound.method_10558("type");
            String name = null;
            try {
                name = Class.forName(type).getSimpleName();
            }
            catch (ClassNotFoundException e) {
                name = "?";
            }
            list.add((class_2561)new class_2585(class_124.field_1060 + "Captured mob: " + name));
        }
        list.add((class_2561)new class_2585("Left click on creature to capture it."));
        list.add((class_2561)new class_2585("Right click on block to respawn creature."));
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 stack = context.method_8041();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        if (!world.field_9236) {
            class_2487 tagCompound = Tools.getTagCompound(stack);
            if (tagCompound.method_10545("mob")) {
                class_2520 mobCompound = tagCompound.method_10580("mob");
                String type = tagCompound.method_10558("type");
                class_1309 entityLivingBase = this.createEntity(player, world, type);
                if (entityLivingBase == null) {
                    Tools.error(player, "Something went wrong trying to spawn creature!");
                    return class_1269.field_5814;
                }
                entityLivingBase.method_5651((class_2487)mobCompound);
                entityLivingBase.method_5814((double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5);
                tagCompound.method_10551("mob");
                tagCompound.method_10551("type");
                world.method_8649((class_1297)entityLivingBase);
            } else {
                Tools.error(player, "There is no mob captured in this wand!");
            }
        }
        return class_1269.field_5812;
    }

    private class_1309 createEntity(class_1657 player, class_1937 world, String type) {
        class_1309 entityLivingBase;
        try {
            entityLivingBase = (class_1309)Class.forName(type).getConstructor(class_1937.class).newInstance(world);
        }
        catch (Exception e) {
            entityLivingBase = null;
        }
        return entityLivingBase;
    }

    public boolean captureMob(class_1799 stack, class_1657 player, class_1309 entity, class_1268 hand) {
        if (!player.method_5770().field_9236) {
            if (entity != null) {
                if (Tools.getTagCompound(stack).method_10545("mob")) {
                    Tools.error(player, "There is already a mob in this wand!");
                    return true;
                }
                if (entity instanceof class_1657) {
                    Tools.error(player, "I don't think that player would appreciate being captured!");
                    return true;
                }
                if (!this.allowHostile && entity instanceof class_1569) {
                    Tools.error(player, "It is not possible to capture hostile mobs with this wand!");
                    return true;
                }
                if (!this.allowPassive && !(entity instanceof class_1569)) {
                    Tools.error(player, "It is not possible to capture passive mobs with this wand!");
                    return true;
                }
                double cost = BlackListSettings.getBlacklistEntity((class_1297)entity);
                if (cost <= (double)0.001f) {
                    Tools.error(player, "It is illegal to take this entity");
                    return true;
                }
                float difficultyScale = (float)((double)entity.method_6063() * cost * (double)this.difficultyMult + (double)this.diffcultyAdd);
                if (!this.checkUsage(stack, player, difficultyScale)) {
                    return true;
                }
                class_2487 tagCompound = new class_2487();
                entity.method_5647(tagCompound);
                Tools.getTagCompound(stack).method_10566("mob", (class_2520)tagCompound);
                Tools.getTagCompound(stack).method_10582("type", entity.getClass().getCanonicalName());
                ((class_3218)player.method_5770()).method_18217((class_1297)entity);
                this.registerUsage(stack, player, difficultyScale);
            } else {
                Tools.error(player, "Please select a living entity!");
            }
        }
        return true;
    }
}

