/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3614;
import net.minecraft.class_3965;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Configuration;
import romelo333.notenoughwands.items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class DisplacementWand
extends GenericWand {
    private float maxHardness = 50.0f;
    public static final int MODE_FIRST = 0;
    public static final int MODE_3X3 = 0;
    public static final int MODE_5X5 = 1;
    public static final int MODE_7X7 = 2;
    public static final int MODE_SINGLE = 3;
    public static final int MODE_LAST = 3;
    public static final String[] descriptions = new String[]{"3x3", "5x5", "7x7", "single"};
    public static final int[] amount = new int[]{9, 9, 25, 1};

    public DisplacementWand() {
        super(100);
        this.setup("displacement_wand").xpUsage(1).loot(3);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg, 2000, 100000, 500, 200000, 200, 500000);
        this.maxHardness = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_maxHardness", this.maxHardness, "Max hardness this block can move.)").getDouble();
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 player, List<class_2561> list, class_1836 b) {
        super.method_7851(stack, player, list, b);
        list.add((class_2561)new class_2585(class_124.field_1060 + "Mode: " + descriptions[this.getMode(stack)]));
        list.add((class_2561)new class_2585("Right click to push blocks forward."));
        list.add((class_2561)new class_2585("Sneak right click to pull blocks."));
        this.showModeKeyDescription(list, "switch mode");
    }

    @Override
    public void toggleMode(class_1657 player, class_1799 stack) {
        int mode = this.getMode(stack);
        if (++mode > 3) {
            mode = 0;
        }
        Tools.notify(player, "Switched to " + descriptions[mode] + " mode");
        Tools.getTagCompound(stack).method_10569("mode", mode);
    }

    private int getMode(class_1799 stack) {
        return Tools.getTagCompound(stack).method_10550("mode");
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        class_2338 pos = context.method_8037();
        class_2350 side = context.method_8038();
        class_1799 stack = context.method_8041();
        if (!world.field_9236) {
            if (player.method_5715()) {
                this.pullBlocks(stack, player, world, pos, side);
            } else {
                this.pushBlocks(stack, player, world, pos, side);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void pullBlocks(class_1799 stack, class_1657 player, class_1937 world, class_2338 pos, class_2350 side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        Set<class_2338> coordinates = this.findSuitableBlocks(stack, world, side, pos);
        int cnt = this.moveBlocks(player, world, coordinates, side);
        if (cnt > 0) {
            this.registerUsage(stack, player, 1.0f);
        }
    }

    private void pushBlocks(class_1799 stack, class_1657 player, class_1937 world, class_2338 pos, class_2350 side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        Set<class_2338> coordinates = this.findSuitableBlocks(stack, world, side, pos);
        int cnt = this.moveBlocks(player, world, coordinates, side.method_10153());
        if (cnt > 0) {
            this.registerUsage(stack, player, 1.0f);
        }
    }

    private int moveBlocks(class_1657 player, class_1937 world, Set<class_2338> coordinates, class_2350 direction) {
        int cnt = 0;
        for (class_2338 coordinate : coordinates) {
            class_2680 state = world.method_8320(coordinate);
            class_2248 block = state.method_11614();
            class_2338 otherC = coordinate.method_10093(direction);
            class_2680 otherState = world.method_8320(otherC);
            class_2248 otherBlock = otherState.method_11614();
            double cost = GenericWand.checkPickup(player, world, otherC, block, this.maxHardness);
            if (!(cost >= 0.0)) continue;
            ++cnt;
            Tools.playSound(world, block.method_9573(state).method_10594(), (double)coordinate.method_10263(), (double)coordinate.method_10264(), (double)coordinate.method_10260(), 1.0, 1.0);
            class_2586 tileEntity = world.method_8321(coordinate);
            class_2487 tc = null;
            if (tileEntity != null) {
                tc = new class_2487();
                tileEntity.method_11007(tc);
                world.method_8544(coordinate);
            }
            world.method_8652(coordinate, class_2246.field_10124.method_9564(), 3);
            class_2680 blockState = block.method_9564();
            world.method_8652(otherC, blockState, 3);
            if (tc == null) continue;
            tc.method_10569("x", otherC.method_10263());
            tc.method_10569("y", otherC.method_10264());
            tc.method_10569("z", otherC.method_10260());
            tileEntity = class_2586.method_11005((class_2487)tc);
            if (tileEntity == null) continue;
            class_2791 chunk = world.method_16955(otherC);
            ((class_2818)chunk).method_12216(tileEntity);
            tileEntity.method_5431();
            world.method_8413(otherC, blockState, blockState, 3);
        }
        return cnt;
    }

    @Override
    public void renderOverlay(class_1657 player, class_1799 wand, float partialTicks) {
        class_2338 blockPos;
        class_1937 world;
        class_2680 state;
        class_2248 block;
        class_3965 blockHit;
        class_239 mouseOver = class_310.method_1551().field_1765;
        if (mouseOver != null && mouseOver.method_17783() == class_239.class_240.field_1332 && (blockHit = (class_3965)mouseOver).method_17777() != null && blockHit.method_17780() != null && (block = (state = (world = player.method_5770()).method_8320(blockPos = blockHit.method_17777())).method_11614()) != null && block.method_9597(state) != class_3614.field_15959) {
            Set<class_2338> coordinates = this.findSuitableBlocks(wand, world, blockHit.method_17780(), blockPos);
            DisplacementWand.renderOutlines(player, coordinates, 200, 230, 180, partialTicks);
        }
    }

    private Set<class_2338> findSuitableBlocks(class_1799 stack, class_1937 world, class_2350 sideHit, class_2338 pos) {
        HashSet<class_2338> coordinates = new HashSet<class_2338>();
        int mode = this.getMode(stack);
        int dim = 0;
        switch (mode) {
            case 3: {
                coordinates.add(pos);
                return coordinates;
            }
            case 0: {
                dim = 1;
                break;
            }
            case 1: {
                dim = 2;
                break;
            }
            case 2: {
                dim = 3;
            }
        }
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        switch (sideHit) {
            case field_11036: 
            case field_11033: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, dx, y, dz, coordinates);
                    }
                }
                break;
            }
            case field_11035: 
            case field_11043: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dy = y - dim; dy <= y + dim; ++dy) {
                        this.checkAndAddBlock(world, dx, dy, z, coordinates);
                    }
                }
                break;
            }
            case field_11034: 
            case field_11039: {
                for (int dy = y - dim; dy <= y + dim; ++dy) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, x, dy, dz, coordinates);
                    }
                }
                break;
            }
        }
        return coordinates;
    }

    private void checkAndAddBlock(class_1937 world, int x, int y, int z, Set<class_2338> coordinates) {
        class_2338 pos = new class_2338(x, y, z);
        if (!world.method_8623(pos)) {
            coordinates.add(pos);
        }
    }
}

