/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_55;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Configuration;
import romelo333.notenoughwands.KeyBindings;
import romelo333.notenoughwands.ProtectedBlocks;
import romelo333.notenoughwands.items.BlackListSettings;
import romelo333.notenoughwands.items.IEnergyItem;
import romelo333.notenoughwands.mcjtylib.BlockOutlineRenderer;
import romelo333.notenoughwands.varia.Tools;

public class GenericWand
extends class_1792
implements IEnergyItem {
    protected int needsxp = 0;
    protected int needsrf = 0;
    protected int maxrf = 0;
    protected int lootRarity = 10;
    private static List<GenericWand> wands = new ArrayList<GenericWand>();

    public GenericWand(int maxDurability) {
        super(new class_1792.class_1793().method_7889(1).method_7895(maxDurability).method_7892(class_1761.field_7930));
    }

    public static double checkPickup(class_1657 player, class_1937 world, class_2338 pos, class_2248 block, float maxHardness) {
        class_2680 state = world.method_8320(pos);
        float hardness = block.method_9537(state, (class_1922)world, pos);
        if (hardness < 0.0f || hardness > maxHardness) {
            Tools.error(player, "This block is to hard to take!");
            return -1.0;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, pos)) {
            Tools.error(player, "This block is protected. You cannot take it!");
            return -1.0;
        }
        double cost = BlackListSettings.getBlacklistCost(block);
        if (cost <= (double)0.001f) {
            Tools.error(player, "It is illegal to take this block");
            return -1.0;
        }
        return cost;
    }

    public void method_7851(class_1799 stack, class_1937 player, List<class_2561> list, class_1836 b) {
        super.method_7851(stack, player, list, b);
        if (this.needsrf > 0) {
            list.add((class_2561)new class_2585(class_124.field_1060 + "Energy: " + this.getEnergyStored(stack) + " / " + this.getMaxEnergyStored(stack)));
        }
    }

    protected GenericWand setup(String name) {
        class_2378.field_11142.method_10272(new class_2960("notenoughwands", name), (Object)this);
        wands.add(this);
        return this;
    }

    GenericWand xpUsage(int xp) {
        this.needsxp = 0;
        return this;
    }

    GenericWand rfUsage(int maxrf, int rf) {
        this.maxrf = maxrf;
        this.needsrf = rf;
        return this;
    }

    GenericWand loot(int rarity) {
        this.lootRarity = rarity;
        return this;
    }

    protected String getConfigPrefix() {
        return class_2378.field_11142.method_10221((Object)this).method_12832();
    }

    protected void initConfig(Configuration cfg) {
    }

    public void initConfig(Configuration cfg, int easy_usages, int easy_maxrf, int normal_usages, int normal_maxrf, int hard_usages, int hard_maxrf) {
        switch (Config.wandUsage) {
            case DEFAULT: {
                this.needsxp = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_needsxp", this.needsxp, "How much levels this wand should consume on usage").getInt();
                this.needsrf = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_needsrf", this.needsrf, "How much RF this wand should consume on usage").getInt();
                this.maxrf = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_maxrf", this.maxrf, "Maximum RF this wand can hold").getInt();
                break;
            }
            case EASY_RF: {
                this.needsxp = 0;
                this.needsrf = easy_maxrf / easy_usages;
                this.maxrf = easy_maxrf;
                cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_needsxp", this.needsxp, "How much levels this wand should consume on usage").getInt();
                cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_needsrf", this.needsrf, "How much RF this wand should consume on usage").getInt();
                cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_maxrf", this.maxrf, "Maximum RF this wand can hold").getInt();
                break;
            }
            case NORMAL_RF: {
                this.needsxp = 0;
                this.needsrf = normal_maxrf / normal_usages;
                this.maxrf = normal_maxrf;
                cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_needsxp", this.needsxp, "How much levels this wand should consume on usage").getInt();
                cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_needsrf", this.needsrf, "How much RF this wand should consume on usage").getInt();
                cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_maxrf", this.maxrf, "Maximum RF this wand can hold").getInt();
                break;
            }
            case HARD_RF: {
                this.needsxp = 0;
                this.needsrf = hard_maxrf / hard_usages;
                this.maxrf = hard_maxrf;
                cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_needsxp", this.needsxp, "How much levels this wand should consume on usage").getInt();
                cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_needsrf", this.needsrf, "How much RF this wand should consume on usage").getInt();
                cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_maxrf", this.maxrf, "Maximum RF this wand can hold").getInt();
            }
        }
        this.lootRarity = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_lootRarity", this.lootRarity, "How rare should this wand be in chests? Lower is more rare (0 is not in chests)").getInt();
    }

    protected boolean checkUsage(class_1799 stack, class_1657 player, float difficultyScale) {
        int experience;
        if (player.method_7337()) {
            return true;
        }
        if (this.needsxp > 0 && (experience = Tools.getPlayerXP(player) - (int)((float)this.needsxp * difficultyScale)) <= 0) {
            Tools.error(player, "Not enough experience!");
            return false;
        }
        if (this.needsrf > 0 && this.getEnergyStored(stack) < (int)((float)this.needsrf * difficultyScale)) {
            Tools.error(player, "Not enough energy to use this wand!");
            return false;
        }
        return true;
    }

    protected void registerUsage(class_1799 stack, class_1657 player, float difficultyScale) {
        if (player.method_7337()) {
            return;
        }
        if (this.needsxp > 0) {
            Tools.addPlayerXP(player, -((int)((float)this.needsxp * difficultyScale)));
        }
        if (this.needsrf > 0) {
            this.extractEnergy(stack, (int)((float)this.needsrf * difficultyScale), false);
        }
    }

    public void toggleMode(class_1657 player, class_1799 stack) {
    }

    public void toggleSubMode(class_1657 player, class_1799 stack) {
    }

    public static List<GenericWand> getWands() {
        return wands;
    }

    public static void setupConfig(Configuration cfg) {
        for (GenericWand wand : wands) {
            wand.initConfig(cfg);
        }
    }

    public static void setupChestLoot(class_55 main) {
        for (GenericWand wand : wands) {
            wand.setupChestLootInt(main);
        }
    }

    private void setupChestLootInt(class_55 main) {
        if (this.lootRarity > 0) {
            String string = "notenoughwands:" + class_2378.field_11142.method_10221((Object)this).method_12832();
        }
    }

    public void renderOverlay(class_1657 player, class_1799 wand, float partialTicks) {
    }

    protected static void renderOutlines(class_1657 p, Set<class_2338> coordinates, int r, int g, int b, float partialTicks) {
        BlockOutlineRenderer.renderOutlines(p, coordinates, r, g, b, partialTicks);
    }

    protected void showModeKeyDescription(List<class_2561> list, String suffix) {
        String keyDescription = KeyBindings.wandModifier != null ? KeyBindings.wandModifier.method_1428() : "unknown";
        list.add((class_2561)new class_2585("Mode key (" + keyDescription + ") to " + suffix));
    }

    protected void showSubModeKeyDescription(List<class_2561> list, String suffix) {
        String keyDescription = KeyBindings.wandSubMode != null ? KeyBindings.wandSubMode.method_1428() : "unknown";
        list.add((class_2561)new class_2585("Sub-mode key (" + keyDescription + ") to " + suffix));
    }

    @Override
    public int extractEnergy(class_1799 container, int maxExtract, boolean simulate) {
        if (this.maxrf <= 0) {
            return 0;
        }
        if (container.method_7969() == null || !container.method_7969().method_10545("Energy")) {
            return 0;
        }
        int energy = container.method_7969().method_10550("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.needsrf, maxExtract));
        if (!simulate) {
            container.method_7969().method_10569("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int receiveEnergy(class_1799 container, int maxReceive, boolean simulate) {
        if (this.maxrf <= 0) {
            return 0;
        }
        if (container.method_7969() == null) {
            container.method_7980(new class_2487());
        }
        int energy = container.method_7969().method_10550("Energy");
        int energyReceived = Math.min(this.maxrf - energy, Math.min(this.maxrf, maxReceive));
        if (!simulate) {
            container.method_7969().method_10569("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int getEnergyStored(class_1799 container) {
        if (container.method_7969() == null || !container.method_7969().method_10545("Energy")) {
            return 0;
        }
        return container.method_7969().method_10550("Energy");
    }

    @Override
    public int getMaxEnergyStored(class_1799 container) {
        return this.maxrf;
    }
}

