/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.items;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Configuration;
import romelo333.notenoughwands.items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class MovingWand
extends GenericWand {
    private float maxHardness = 50.0f;
    private int placeDistance = 4;

    public MovingWand() {
        super(100);
        this.setup("moving_wand").xpUsage(3).loot(5);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg, 200, 100000, 100, 200000, 50, 500000);
        this.maxHardness = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_maxHardness", this.maxHardness, "Max hardness this block can move.)").getDouble();
        this.placeDistance = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_placeDistance", this.placeDistance, "Distance at which to place blocks in 'in-air' mode").getInt();
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 player, List<class_2561> list, class_1836 b) {
        super.method_7851(stack, player, list, b);
        class_2487 compound = stack.method_7969();
        if (!this.hasBlock(compound)) {
            list.add((class_2561)new class_2585(class_124.field_1061 + "Wand is empty."));
        } else {
            String id = compound.method_10558("block");
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(new class_2960(id));
            String name = Tools.getBlockName(block);
            list.add((class_2561)new class_2585(class_124.field_1060 + "Block: " + name));
        }
        list.add((class_2561)new class_2585("Right click to take a block."));
        list.add((class_2561)new class_2585("Right click again on block to place it down."));
    }

    private boolean hasBlock(class_2487 compound) {
        return compound != null && compound.method_10545("block");
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_2487 compound;
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236 && this.hasBlock(compound = stack.method_7969())) {
            int distance;
            class_243 end;
            class_243 lookVec = player.method_5828(0.0f);
            class_243 start = new class_243(player.field_5987, player.field_6010 + (double)player.method_5751(), player.field_6035);
            class_3965 position = world.method_17742(new class_3959(start, end = start.method_1031(lookVec.field_1352 * (double)(distance = this.placeDistance), lookVec.field_1351 * (double)distance, lookVec.field_1350 * (double)distance), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
            if (position == null) {
                this.place(stack, world, new class_2338(end), null, player);
            }
        }
        return new class_1271(class_1269.field_5812, (Object)stack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 stack = context.method_8041();
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        class_2338 pos = context.method_8037();
        class_2350 side = context.method_8038();
        if (!world.field_9236) {
            class_2487 compound = stack.method_7969();
            if (this.hasBlock(compound)) {
                this.place(stack, world, pos, side, player);
            } else {
                this.pickup(stack, player, world, pos);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void place(class_1799 stack, class_1937 world, class_2338 pos, class_2350 side, class_1657 player) {
        class_2338 pp = side == null ? pos : pos.method_10093(side);
        class_2680 old = world.method_8320(pp);
        if (!world.method_8623(pp)) {
            Tools.error(player, "Something is in the way!");
            return;
        }
        class_2487 tagCompound = stack.method_7969();
        String id = tagCompound.method_10558("block");
        class_2248 block = (class_2248)class_2378.field_11146.method_10223(new class_2960(id));
        class_2680 blockState = block.method_9564();
        world.method_8652(pp, blockState, 3);
        if (tagCompound.method_10545("tedata")) {
            class_2487 tc = (class_2487)tagCompound.method_10580("tedata");
            tc.method_10569("x", pp.method_10263());
            tc.method_10569("y", pp.method_10264());
            tc.method_10569("z", pp.method_10260());
            class_2586 tileEntity = class_2586.method_11005((class_2487)tc);
            if (tileEntity != null) {
                class_2791 chunk = world.method_16955(pp);
                ((class_2818)chunk).method_12216(tileEntity);
                tileEntity.method_5431();
                world.method_8413(pp, blockState, blockState, 3);
            }
        }
        tagCompound.method_10551("block");
        tagCompound.method_10551("tedata");
        tagCompound.method_10551("meta");
        stack.method_7980(tagCompound);
    }

    private void pickup(class_1799 stack, class_1657 player, class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_11614();
        double cost = MovingWand.checkPickup(player, world, pos, block, this.maxHardness);
        if (cost < 0.0) {
            return;
        }
        if (!this.checkUsage(stack, player, (float)cost)) {
            return;
        }
        class_2487 tagCompound = Tools.getTagCompound(stack);
        class_1799 s = block.method_9574((class_1922)world, pos, state);
        String name = s.method_7960() ? Tools.getBlockName(block) : s.method_7964().method_10863();
        if (name == null) {
            Tools.error(player, "You cannot select this block!");
        } else {
            String id = class_2378.field_11146.method_10221((Object)block).toString();
            tagCompound.method_10582("block", id);
            class_2586 tileEntity = world.method_8321(pos);
            if (tileEntity != null) {
                class_2487 tc = new class_2487();
                tileEntity.method_11007(tc);
                world.method_8544(pos);
                tc.method_10551("x");
                tc.method_10551("y");
                tc.method_10551("z");
                tagCompound.method_10566("tedata", (class_2520)tc);
            }
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            Tools.notify(player, "You took: " + name);
            this.registerUsage(stack, player, (float)cost);
        }
    }
}

