/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.items;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import romelo333.notenoughwands.Config;
import romelo333.notenoughwands.Configuration;
import romelo333.notenoughwands.items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class PotionWand
extends GenericWand {
    private boolean allowPassive = true;
    private boolean allowHostile = true;
    private float difficultyMult = 0.0f;
    private float diffcultyAdd = 1.0f;

    public PotionWand() {
        super(100);
        this.setup("potion_wand").xpUsage(10).loot(3);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg, 200, 100000, 100, 200000, 50, 500000);
        this.allowPassive = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_allowPassive", this.allowPassive, "Allow freeze passive mobs").getBoolean();
        this.allowHostile = cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_allowHostile", this.allowHostile, "Allow freeze hostile mobs").getBoolean();
        this.difficultyMult = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_difficultyMult", this.difficultyMult, "Multiply the HP of a mob with this number to get the difficulty scale that affects XP/RF usage (a final result of 1.0 means that the default XP/RF is used)").getDouble();
        this.diffcultyAdd = (float)cfg.get(Config.CATEGORY_WANDS, this.getConfigPrefix() + "_diffcultyAdd", this.diffcultyAdd, "Add this to the HP * difficultyMult to get the final difficulty scale that affects XP/RF usage (a final result of 1.0 means that the default XP/RF is used)").getDouble();
    }

    private String getEffectName(class_1293 potioneffect) {
        String s1 = class_1074.method_4662((String)potioneffect.method_5586(), (Object[])new Object[0]).trim();
        if (potioneffect.method_5578() > 0) {
            s1 = s1 + " " + class_1074.method_4662((String)("potion.potency." + potioneffect.method_5578()), (Object[])new Object[0]).trim();
        }
        if (potioneffect.method_5584() > 20) {
            s1 = s1 + " (" + class_1292.method_5577((class_1293)potioneffect, (float)potioneffect.method_5584()) + ")";
        }
        return s1;
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 player, List<class_2561> list, class_1836 b) {
        super.method_7851(stack, player, list, b);
        list.add((class_2561)new class_2585("Left click on creature to apply effect"));
        class_2487 tagCompound = stack.method_7969();
        if (tagCompound == null) {
            list.add((class_2561)new class_2585(class_124.field_1054 + "No effects. Combine with potion"));
            list.add((class_2561)new class_2585(class_124.field_1054 + "in crafting table to add effect"));
            return;
        }
        class_2499 effects = (class_2499)tagCompound.method_10580("effects");
        if (effects == null || effects.size() == 0) {
            list.add((class_2561)new class_2585(class_124.field_1054 + "No effects. Combine with potion"));
            list.add((class_2561)new class_2585(class_124.field_1054 + "in crafting table to add effect"));
            return;
        }
        list.add((class_2561)new class_2585(class_124.field_1054 + "Combine with empty bottle"));
        list.add((class_2561)new class_2585(class_124.field_1054 + "to clear effects"));
        int mode = this.getMode(stack);
        for (int i = 0; i < effects.size(); ++i) {
            class_2487 effecttag = effects.method_10602(i);
            class_1293 effect = class_1293.method_5583((class_2487)effecttag);
            if (i == mode) {
                list.add((class_2561)new class_2585("    + " + class_124.field_1060 + this.getEffectName(effect)));
                continue;
            }
            list.add((class_2561)new class_2585("    " + class_124.field_1080 + this.getEffectName(effect)));
        }
    }

    @Override
    public void toggleMode(class_1657 player, class_1799 stack) {
        int mode = this.getMode(stack);
        ++mode;
        class_2487 tagCompound = stack.method_7969();
        if (tagCompound == null) {
            return;
        }
        class_2499 effects = (class_2499)tagCompound.method_10580("effects");
        if (effects == null || effects.size() == 0) {
            return;
        }
        if (mode >= effects.size()) {
            mode = 0;
        }
        class_2487 effecttag = effects.method_10602(mode);
        class_1293 effect = class_1293.method_5583((class_2487)effecttag);
        Tools.notify(player, "Switched to " + this.getEffectName(effect) + " mode");
        Tools.getTagCompound(stack).method_10569("mode", mode);
    }

    private int getMode(class_1799 stack) {
        return Tools.getTagCompound(stack).method_10550("mode");
    }

    private void addeffect(class_1309 entity, class_1799 wand, class_1657 player) {
        class_2487 tagCompound = wand.method_7969();
        if (tagCompound == null) {
            Tools.error(player, "There are no effects in this wand!");
            return;
        }
        class_2499 effects = (class_2499)tagCompound.method_10580("effects");
        if (effects == null || effects.size() == 0) {
            Tools.error(player, "There are no effects in this wand!");
            return;
        }
        class_2487 effecttag = effects.method_10602(this.getMode(wand));
        class_1293 effect = class_1293.method_5583((class_2487)effecttag);
        entity.method_6092(effect);
    }

    public boolean method_7847(class_1799 stack, class_1657 player, class_1309 entity, class_1268 hand) {
        if (!player.method_5770().field_9236) {
            if (entity != null) {
                if (!this.allowHostile && entity instanceof class_1569) {
                    Tools.error(player, "It is not possible to add effects to hostile mobs with this wand!");
                    return true;
                }
                if (!this.allowPassive && !(entity instanceof class_1569)) {
                    Tools.error(player, "It is not possible to add effects to passive mobs with this wand!");
                    return true;
                }
                float difficultyScale = entity.method_6063() * this.difficultyMult + this.diffcultyAdd;
                if (!this.checkUsage(stack, player, difficultyScale)) {
                    return true;
                }
                this.addeffect(entity, stack, player);
                this.registerUsage(stack, player, difficultyScale);
            } else {
                Tools.error(player, "Please select a living entity!");
            }
        }
        return true;
    }
}

